# 画面設計書 7-ログイン画面（サーバー）

## 概要

本ドキュメントは、Northwind TradersアプリケーションのASP.NET Core Identityログイン画面（サーバーサイド）の設計仕様を記載したものである。

### 本画面の処理概要

ログイン画面（サーバー）は、ASP.NET Core IdentityのRazor Pagesで実装されたサーバーサイドのログイン画面である。メールアドレスとパスワードでのローカルログイン、および外部認証サービス（OAuth/OpenID Connect）との連携をサポートする。

**業務上の目的・背景**：本画面は、Northwind Tradersアプリケーションの認証基盤としてASP.NET Core Identityを使用し、ユーザー認証を実現する。Angular SPAからリダイレクトされてきたユーザーに対して、実際のログインフォームを提供し、認証処理を行う。

**画面へのアクセス方法**：
- Angular SPAのログイン画面（/authentication/login）からのリダイレクト
- URL `/Identity/Account/Login` に直接アクセス

**主要な操作・処理内容**：
1. メールアドレスとパスワードを入力してログイン
2. 「Remember me?」チェックボックスで永続的ログインを選択
3. 外部認証サービス（Google、Facebook等）でログイン（設定時）
4. 「Forgot your password?」リンクでパスワードリセット画面へ遷移
5. 「Register as a new user」リンクで新規登録画面へ遷移
6. 「Resend email confirmation」ボタンで確認メール再送信

**画面遷移**：
- 遷移元：Angular SPAログイン画面（リダイレクト）
- 遷移先：元の画面（認証成功後、returnUrlに基づく）、新規登録画面、パスワードリセット画面、二要素認証画面、アカウントロックアウト画面

**権限による表示制御**：本画面は公開画面であり、認証不要でアクセス可能（[AllowAnonymous]属性）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | ログイン | 主機能 | SignInManager.PasswordSignInAsync()を使用してメールアドレスとパスワードでのローカルログインを処理する。 |
| 3 | メール確認送信 | 補助機能 | Resend email confirmationボタン押下時にIEmailSender.SendEmailAsync()で確認メールを再送信する。 |

## 画面種別

認証（フォーム）

## URL/ルーティング

| パス | 説明 |
|------|------|
| `/Identity/Account/Login` | ログイン画面 |

## 入出力項目

### 入力（フォーム）

| 項目名 | データ型 | 必須 | バリデーション | 説明 |
|--------|----------|------|---------------|------|
| Email | string | Yes | [Required], [EmailAddress] | メールアドレス |
| Password | string | Yes | [Required], [DataType(Password)] | パスワード |
| RememberMe | boolean | No | - | ログイン状態を維持するかどうか |

### 入力（クエリパラメータ）

| パラメータ名 | データ型 | 説明 |
|-------------|----------|------|
| returnUrl | string | 認証成功後のリダイレクト先URL |

## 表示項目

| 項目名 | 項目種別 | 説明 |
|--------|----------|------|
| ページタイトル | テキスト（h1） | 「Log in」と表示 |
| ローカルログインセクション | フォーム | メールとパスワードの入力フォーム |
| 外部ログインセクション | ボタン群 | 設定済みの外部認証プロバイダーボタン |
| バリデーションサマリー | エラーメッセージ | 入力エラーの一覧 |
| 項目別エラー | エラーメッセージ | 各入力項目のエラー |

## イベント仕様

### 1-ログインフォーム送信（POST）

メールアドレスとパスワードで認証を行う。

**処理フロー**：
1. OnPostAsync()メソッドが呼び出される
2. ModelStateのバリデーションを確認
3. SignInManager.PasswordSignInAsync()を呼び出し
4. 成功の場合、returnUrlへリダイレクト
5. 二要素認証が必要な場合、LoginWith2fa画面へリダイレクト
6. アカウントロックアウトの場合、Lockout画面へリダイレクト
7. 失敗の場合、エラーメッセージを表示

### 2-メール確認再送信（POST: SendVerificationEmail）

確認メールを再送信する。

**処理フロー**：
1. OnPostSendVerificationEmailAsync()メソッドが呼び出される
2. ModelStateのバリデーションを確認
3. UserManager.FindByEmailAsync()でユーザーを検索
4. UserManager.GenerateEmailConfirmationTokenAsync()でトークン生成
5. IEmailSender.SendEmailAsync()で確認メールを送信
6. メッセージを表示してページを再表示

### 3-外部認証プロバイダー選択（POST）

外部認証サービスでログインする。

**処理フロー**：
1. ExternalLoginページへPOSTリクエスト
2. 選択したプロバイダーへリダイレクト
3. 認証完了後、コールバック処理

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログイン | AspNetUsers | SELECT | ユーザー情報の取得・認証 |
| ログイン成功 | AspNetUsers | UPDATE | LastLoginDate等の更新（実装依存） |
| ログイン失敗 | AspNetUsers | UPDATE | AccessFailedCount の増加 |
| アカウントロックアウト | AspNetUsers | UPDATE | LockoutEnd の設定 |

### テーブル別更新項目詳細

#### AspNetUsers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | Email, PasswordHash, etc. | WHERE Email = {入力Email} | ユーザー認証 |
| UPDATE | AccessFailedCount | +1 | ログイン失敗時 |
| UPDATE | LockoutEnd | 現在時刻 + ロックアウト期間 | ロックアウト時 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| エラー | 'Invalid login attempt.' | ログイン失敗時 |
| エラー | (ModelStateエラー) | バリデーション失敗時 |
| 情報 | 'Verification email sent. Please check your email.' | メール再送信時 |
| ログ | 'User logged in.' | ログイン成功時（サーバーログ） |
| ログ | 'User account locked out.' | アカウントロックアウト時（サーバーログ） |

## 例外処理

| 例外状態 | 対処 |
|---------|------|
| ユーザー未発見 | 'Invalid login attempt.'メッセージを表示（セキュリティ上、詳細は表示しない） |
| パスワード不一致 | 'Invalid login attempt.'メッセージを表示 |
| アカウントロックアウト | Lockout画面へリダイレクト |
| 二要素認証必要 | LoginWith2fa画面へリダイレクト |
| メール未確認 | （RequireConfirmedAccount設定による） |

## 備考

- ASP.NET Core Identity のデフォルト実装をベースにカスタマイズ
- パスワード認証失敗時のロックアウト機能あり（lockoutOnFailure: true）
- 外部認証サービスは個別に設定が必要
- Remember Me機能はCookie永続化により実現

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | InputModelクラスの定義を確認（行47-59） |

**読解のコツ**: InputModelはEmail、Password、RememberMeの3つのプロパティを持つ。DataAnnotationsによるバリデーションが定義されている。

#### Step 2: ページモデルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | LoginModelクラスの全体構造を確認 |

**主要処理フロー**:
- **行19-35**: コンストラクタでDI（UserManager、SignInManager、IEmailSender、ILogger）
- **行61-76**: OnGetAsync() - 外部ログインスキーム取得、既存外部Cookieクリア
- **行78-110**: OnPostAsync() - ログイン処理のメインロジック
- **行112-139**: OnPostSendVerificationEmailAsync() - 確認メール再送信

#### Step 3: ビュー（テンプレート）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Login.cshtml | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml` | HTML構造とTag Helpersの使用方法を確認 |

**主要処理フロー**:
- **行9-48**: ローカルログインフォーム
- **行51-79**: 外部ログインセクション
- **行83-85**: バリデーションスクリプトの読み込み

#### Step 4: 依存サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ApplicationUser.cs | `Src/Infrastructure/Identity/ApplicationUser.cs` | IdentityUserを継承したアプリケーションユーザークラス |

### プログラム呼び出し階層図

```
Login.cshtml (View)
    │
    └─ LoginModel (PageModel)
           │
           ├─ OnGetAsync()
           │      │
           │      ├─ SignInManager.GetExternalAuthenticationSchemesAsync()
           │      │
           │      └─ HttpContext.SignOutAsync(ExternalScheme)
           │
           ├─ OnPostAsync()
           │      │
           │      └─ SignInManager.PasswordSignInAsync()
           │             │
           │             ├─ [成功] LocalRedirect(returnUrl)
           │             │
           │             ├─ [二要素認証] RedirectToPage("./LoginWith2fa")
           │             │
           │             ├─ [ロックアウト] RedirectToPage("./Lockout")
           │             │
           │             └─ [失敗] ModelState.AddModelError()
           │
           └─ OnPostSendVerificationEmailAsync()
                  │
                  ├─ UserManager.FindByEmailAsync()
                  │
                  ├─ UserManager.GenerateEmailConfirmationTokenAsync()
                  │
                  └─ IEmailSender.SendEmailAsync()
```

### データフロー図

```
[入力]               [処理]                    [出力]

/Identity/Account/Login (GET)
       ↓
LoginModel.OnGetAsync()
       ↓
GetExternalAuthenticationSchemesAsync()
       ↓
Login.cshtml表示 ───▶ ログインフォーム表示

ログインフォーム送信 (POST)
       ↓
LoginModel.OnPostAsync()
       ↓
ModelState.IsValid チェック
       │
       ├─ [無効] → バリデーションエラー表示
       │
       └─ [有効]
              ↓
       PasswordSignInAsync()
              │
              ├─ [成功] → returnUrl へリダイレクト
              │
              ├─ [二要素認証] → LoginWith2fa へリダイレクト
              │
              ├─ [ロックアウト] → Lockout へリダイレクト
              │
              └─ [失敗] → エラーメッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Login.cshtml | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml` | Razor View | ログイン画面のHTMLテンプレート |
| Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | PageModel | ログイン画面のロジック |
| ApplicationUser.cs | `Src/Infrastructure/Identity/ApplicationUser.cs` | ソース | アプリケーションユーザーエンティティ |
| _ValidationScriptsPartial.cshtml | `Src/WebUI/Pages/Shared/_ValidationScriptsPartial.cshtml` | Partial View | クライアントサイドバリデーション |
| ForgotPassword.cshtml | `Src/WebUI/Areas/Identity/Pages/Account/ForgotPassword.cshtml` | Razor View | パスワードリセット画面 |
| Register.cshtml | `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml` | Razor View | 新規登録画面 |
