# 画面設計書 8-新規登録画面（サーバー）

## 概要

本ドキュメントは、Northwind TradersアプリケーションのASP.NET Core Identity新規登録画面（サーバーサイド）の設計仕様を記載したものである。

### 本画面の処理概要

新規登録画面（サーバー）は、ASP.NET Core IdentityのRazor Pagesで実装されたサーバーサイドのユーザー登録画面である。メールアドレスとパスワードでの新規アカウント作成、および外部認証サービス（OAuth/OpenID Connect）を使用した登録をサポートする。

**業務上の目的・背景**：本画面は、Northwind Tradersアプリケーションの新規ユーザーがアカウントを作成するための機能を提供する。従業員や取引先担当者がシステムを利用するために、最初にアカウント登録を行う際に使用される。

**画面へのアクセス方法**：
- ログイン画面（サーバー）の「Register as a new user」リンクから遷移
- Angular SPAのログイン画面からのリダイレクト
- URL `/Identity/Account/Register` に直接アクセス

**主要な操作・処理内容**：
1. メールアドレス、パスワード、確認用パスワードを入力して登録
2. 外部認証サービス（Google、Facebook等）で登録（設定時）
3. 登録完了後、確認メールを送信

**画面遷移**：
- 遷移元：ログイン画面（サーバー）、Angular SPAログイン画面
- 遷移先：ログイン画面（SPA）（登録成功後）、確認待ち画面（RequireConfirmedAccount設定時）、元の画面（returnUrlに基づく）

**権限による表示制御**：本画面は公開画面であり、認証不要でアクセス可能（[AllowAnonymous]属性）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ユーザー登録 | 主機能 | UserManager.CreateAsync()を使用して新規ユーザーアカウントを作成する。 |
| 3 | メール確認送信 | 補助機能 | ユーザー登録成功後にIEmailSender.SendEmailAsync()でメール確認用メールを送信する。 |

## 画面種別

登録（フォーム）

## URL/ルーティング

| パス | 説明 |
|------|------|
| `/Identity/Account/Register` | 新規登録画面 |

## 入出力項目

### 入力（フォーム）

| 項目名 | データ型 | 必須 | バリデーション | 説明 |
|--------|----------|------|---------------|------|
| Email | string | Yes | [Required], [EmailAddress] | メールアドレス |
| Password | string | Yes | [Required], [StringLength(100, MinimumLength = 6)], [DataType(Password)] | パスワード（6〜100文字） |
| ConfirmPassword | string | Yes | [DataType(Password)], [Compare("Password")] | 確認用パスワード |

### 入力（クエリパラメータ）

| パラメータ名 | データ型 | 説明 |
|-------------|----------|------|
| returnUrl | string | 登録成功後のリダイレクト先URL |

## 表示項目

| 項目名 | 項目種別 | 説明 |
|--------|----------|------|
| ページタイトル | テキスト（h1） | 「Register」と表示 |
| ローカル登録セクション | フォーム | メールとパスワードの入力フォーム |
| 外部登録セクション | ボタン群 | 設定済みの外部認証プロバイダーボタン |
| バリデーションサマリー | エラーメッセージ | 入力エラーの一覧 |
| 項目別エラー | エラーメッセージ | 各入力項目のエラー |

## イベント仕様

### 1-登録フォーム送信（POST）

新規ユーザーアカウントを作成する。

**処理フロー**：
1. OnPostAsync()メソッドが呼び出される
2. ModelStateのバリデーションを確認
3. ApplicationUserインスタンスを作成（UserName = Email, Email = Email）
4. UserManager.CreateAsync()でユーザー作成
5. 成功の場合：
   a. GenerateEmailConfirmationTokenAsync()でトークン生成
   b. IEmailSender.SendEmailAsync()で確認メール送信
   c. RequireConfirmedAccount設定に応じてリダイレクト
6. 失敗の場合、エラーメッセージを表示

### 2-外部認証プロバイダー選択（POST）

外部認証サービスで登録する。

**処理フロー**：
1. ExternalLoginページへPOSTリクエスト
2. 選択したプロバイダーへリダイレクト
3. 認証完了後、コールバック処理でアカウント作成

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 登録 | AspNetUsers | INSERT | 新規ユーザーレコードの作成 |

### テーブル別更新項目詳細

#### AspNetUsers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | Id | GUID自動生成 | ユーザーID |
| INSERT | UserName | 入力Email | ユーザー名 |
| INSERT | NormalizedUserName | 入力Email（大文字） | 正規化ユーザー名 |
| INSERT | Email | 入力Email | メールアドレス |
| INSERT | NormalizedEmail | 入力Email（大文字） | 正規化メールアドレス |
| INSERT | EmailConfirmed | false | メール確認状態 |
| INSERT | PasswordHash | ハッシュ化パスワード | パスワードハッシュ |
| INSERT | SecurityStamp | GUID自動生成 | セキュリティスタンプ |
| INSERT | ConcurrencyStamp | GUID自動生成 | 同時実行スタンプ |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| エラー | 'The {0} must be at least {2} and at max {1} characters long.' | パスワード長エラー時 |
| エラー | 'The password and confirmation password do not match.' | パスワード不一致時 |
| エラー | (IdentityResultエラー) | ユーザー作成失敗時 |
| ログ | 'User created a new account with password.' | 登録成功時（サーバーログ） |

## 例外処理

| 例外状態 | 対処 |
|---------|------|
| メールアドレス重複 | IdentityResult.Errorsにエラーを追加してフォームに表示 |
| パスワード要件未満 | IdentityResult.Errorsにエラーを追加してフォームに表示 |
| バリデーションエラー | ModelState.AddModelError()でエラー表示 |

## 備考

- ASP.NET Core Identity のデフォルト実装をベースにカスタマイズ
- パスワードは最低6文字以上が必要
- UserNameとEmailは同じ値が設定される
- RequireConfirmedAccount設定により、メール確認が必須かどうかを制御
- 外部認証サービスは個別に設定が必要

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Register.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs` | InputModelクラスの定義を確認（行47-64） |

**読解のコツ**: InputModelはEmail、Password、ConfirmPasswordの3つのプロパティを持つ。StringLengthとCompareによるバリデーションが重要。

#### Step 2: ページモデルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Register.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs` | RegisterModelクラスの全体構造を確認 |

**主要処理フロー**:
- **行22-38**: コンストラクタでDI（UserManager、SignInManager、IEmailSender、ILogger）
- **行66-69**: OnGetAsync() - 外部ログインスキーム取得、returnUrl設定
- **行72-113**: OnPostAsync() - ユーザー登録のメインロジック

#### Step 3: ビュー（テンプレート）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Register.cshtml | `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml` | HTML構造とTag Helpersの使用方法を確認 |

**主要処理フロー**:
- **行9-31**: ローカル登録フォーム
- **行33-62**: 外部登録セクション
- **行65-67**: バリデーションスクリプトの読み込み

#### Step 4: ユーザー作成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Register.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs` | OnPostAsync()のユーザー作成処理（行72-113） |

**主要処理フロー**:
- **行78**: ApplicationUserインスタンス作成
- **行79**: UserManager.CreateAsync()でユーザー作成
- **行80-103**: 成功時の確認メール送信とリダイレクト処理
- **行104-108**: 失敗時のエラー追加処理

### プログラム呼び出し階層図

```
Register.cshtml (View)
    │
    └─ RegisterModel (PageModel)
           │
           ├─ OnGetAsync()
           │      │
           │      └─ SignInManager.GetExternalAuthenticationSchemesAsync()
           │
           └─ OnPostAsync()
                  │
                  ├─ new ApplicationUser()
                  │
                  ├─ UserManager.CreateAsync(user, password)
                  │      │
                  │      ├─ [成功]
                  │      │      │
                  │      │      ├─ UserManager.GenerateEmailConfirmationTokenAsync()
                  │      │      │
                  │      │      ├─ IEmailSender.SendEmailAsync()
                  │      │      │
                  │      │      └─ [RequireConfirmedAccount]
                  │      │             │
                  │      │             ├─ [true] RedirectToPage("RegisterConfirmation")
                  │      │             │
                  │      │             └─ [false] SignInAsync() + LocalRedirect()
                  │      │
                  │      └─ [失敗] ModelState.AddModelError()
                  │
                  └─ Page()
```

### データフロー図

```
[入力]               [処理]                    [出力]

/Identity/Account/Register (GET)
       ↓
RegisterModel.OnGetAsync()
       ↓
GetExternalAuthenticationSchemesAsync()
       ↓
Register.cshtml表示 ───▶ 登録フォーム表示

登録フォーム送信 (POST)
       ↓
RegisterModel.OnPostAsync()
       ↓
ModelState.IsValid チェック
       │
       ├─ [無効] → バリデーションエラー表示
       │
       └─ [有効]
              ↓
       new ApplicationUser(UserName=Email, Email=Email)
              ↓
       UserManager.CreateAsync(user, password)
              │
              ├─ [成功]
              │      ↓
              │  GenerateEmailConfirmationTokenAsync()
              │      ↓
              │  SendEmailAsync() ───▶ 確認メール送信
              │      ↓
              │  RequireConfirmedAccount?
              │      │
              │      ├─ [true] → RegisterConfirmation へリダイレクト
              │      │
              │      └─ [false] → SignInAsync() → returnUrl へリダイレクト
              │
              └─ [失敗]
                     ↓
                 ModelState.AddModelError()
                     ↓
                 Register.cshtml再表示 ───▶ エラーメッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Register.cshtml | `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml` | Razor View | 新規登録画面のHTMLテンプレート |
| Register.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs` | PageModel | 新規登録画面のロジック |
| ApplicationUser.cs | `Src/Infrastructure/Identity/ApplicationUser.cs` | ソース | アプリケーションユーザーエンティティ |
| _ValidationScriptsPartial.cshtml | `Src/WebUI/Pages/Shared/_ValidationScriptsPartial.cshtml` | Partial View | クライアントサイドバリデーション |
| Login.cshtml | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml` | Razor View | ログイン画面（遷移元） |
| RegisterConfirmation.cshtml | `Src/WebUI/Areas/Identity/Pages/Account/RegisterConfirmation.cshtml` | Razor View | 登録確認待ち画面 |
