# 画面設計書 9-エラー画面

## 概要

本ドキュメントは、Northwind Tradersアプリケーションのエラー画面の設計仕様を記載したものである。

### 本画面の処理概要

エラー画面は、アプリケーションで予期しない例外が発生した場合に表示されるサーバーサイドのRazor Page画面である。リクエストID（トレース識別子）を表示し、開発環境での詳細なエラー情報の確認方法を案内する。

**業務上の目的・背景**：本画面は、アプリケーション実行中に発生した未処理の例外をユーザーに通知し、サポートへの問い合わせ時に使用できるリクエストIDを提供する。開発者はこのリクエストIDを使用してログを追跡し、問題の原因を特定できる。

**画面へのアクセス方法**：
- アプリケーションで未処理の例外が発生した場合に自動的にリダイレクト
- URL `/Error` に直接アクセス（主にテスト目的）

**主要な操作・処理内容**：
1. エラーメッセージの表示
2. リクエストIDの表示（トレース識別子として使用可能）
3. 開発環境での詳細情報確認方法の案内

**画面遷移**：
- 遷移元：すべての画面（例外発生時）
- 遷移先：なし（エラー終端画面）

**権限による表示制御**：本画面は公開画面であり、認証不要でアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エラーハンドリング | 主機能 | ASP.NET Coreの例外ハンドリングミドルウェアにより、未処理例外発生時にこの画面へリダイレクトする。 |

## 画面種別

表示（情報表示）

## URL/ルーティング

| パス | 説明 |
|------|------|
| `/Error` | エラー画面 |

## 入出力項目

### 入力（フォーム）

なし（入力項目はない）

### 入力（クエリパラメータ）

なし（クエリパラメータは使用しない）

## 表示項目

| 項目名 | 項目種別 | 説明 |
|--------|----------|------|
| ページタイトル | テキスト（h1） | 「Error.」と赤字で表示 |
| エラーメッセージ | テキスト（h2） | 「An error occurred while processing your request.」と赤字で表示 |
| Request ID | コード表示 | Activity.Current?.Id または HttpContext.TraceIdentifier の値を表示（空でない場合のみ） |
| 開発モード案内 | テキスト（h3, p） | 開発環境での詳細エラー表示方法の説明 |

## イベント仕様

### 1-ページ表示（GET）

エラー情報を取得して画面に表示する。

**処理フロー**：
1. OnGet()メソッドが呼び出される
2. Activity.Current?.Id を取得（分散トレースIDがある場合）
3. Activity.Current?.Id が null の場合、HttpContext.TraceIdentifier を使用
4. RequestId プロパティに値を設定
5. ShowRequestId プロパティで表示制御（RequestIdが空でないかチェック）

## データベース更新仕様

### 操作別データベース影響一覧

なし（この画面はデータベース操作を行わない）

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| エラー | 'Error.' | 常時表示（タイトル） |
| エラー | 'An error occurred while processing your request.' | 常時表示（サブタイトル） |
| 情報 | 'Request ID: {RequestId}' | RequestIdが空でない場合 |
| 情報 | 開発モードの案内文 | 常時表示 |

## 例外処理

| 例外状態 | 対処 |
|---------|------|
| 例外発生時 | 本画面自体が例外ハンドラーであるため、追加の例外処理は行わない |

## 備考

- ResponseCache属性により、この画面はキャッシュされない（Duration = 0, NoStore = true）
- 本番環境ではセキュリティ上の理由から詳細なエラー情報は表示しない
- 開発環境では ASPNETCORE_ENVIRONMENT を Development に設定することで詳細情報を確認可能
- リクエストIDはサポート問い合わせやログ追跡に使用できる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ページモデルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Error.cshtml.cs | `Src/WebUI/Pages/Error.cshtml.cs` | ErrorModelクラスの定義を確認（行1-27） |

**読解のコツ**: ErrorModelはRequestIdプロパティを持ち、ShowRequestIdプロパティで表示制御を行う。Activity.CurrentまたはHttpContext.TraceIdentifierからリクエストIDを取得する。

**主要処理フロー**:
- **行8**: ResponseCache属性でキャッシュを無効化
- **行11-16**: コンストラクタでILogger<ErrorModel>を注入
- **行18-20**: RequestIdプロパティとShowRequestId算出プロパティ
- **行22-25**: OnGet()でリクエストIDを取得

#### Step 2: ビュー（テンプレート）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Error.cshtml | `Src/WebUI/Pages/Error.cshtml` | HTML構造とRazor構文を確認（行1-27） |

**主要処理フロー**:
- **行1-5**: ページディレクティブとViewData設定
- **行7-8**: エラータイトルとサブタイトルの表示
- **行10-15**: ShowRequestIdに基づくリクエストID条件表示
- **行17-26**: 開発モードの案内文

### プログラム呼び出し階層図

```
Error.cshtml (View)
    │
    └─ ErrorModel (PageModel)
           │
           └─ OnGet()
                  │
                  ├─ Activity.Current?.Id 取得（分散トレース）
                  │
                  └─ [null の場合] HttpContext.TraceIdentifier 取得
                         │
                         └─ RequestId に設定
```

### データフロー図

```
[入力]               [処理]                    [出力]

/Error (GET)
       ↓
ErrorModel.OnGet()
       ↓
Activity.Current?.Id 確認
       │
       ├─ [存在する] → Activity.Current.Id を使用
       │
       └─ [null] → HttpContext.TraceIdentifier を使用
              ↓
       RequestId 設定
              ↓
       ShowRequestId 算出
       (= !string.IsNullOrEmpty(RequestId))
              ↓
       Error.cshtml 表示
              │
              ├─ エラーメッセージ表示
              │
              ├─ [ShowRequestId = true] → Request ID 表示
              │
              └─ 開発モード案内表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Error.cshtml | `Src/WebUI/Pages/Error.cshtml` | Razor View | エラー画面のHTMLテンプレート |
| Error.cshtml.cs | `Src/WebUI/Pages/Error.cshtml.cs` | PageModel | エラー画面のロジック |
| Startup.cs | `Src/WebUI/Startup.cs` | 設定 | UseExceptionHandler("/Error") で例外ハンドリングを設定 |
| _Layout.cshtml | `Src/WebUI/Pages/Shared/_Layout.cshtml` | レイアウト | 共通レイアウト |
