---
generated_at: 2026-01-07 22:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-ホーム画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/ClientApp/src/app/home/home.component.html`（行1-40）
- E-02: `Src/WebUI/ClientApp/src/app/home/home.component.ts`（行1-7）
- E-03: `Src/WebUI/ClientApp/src/app/app.routing.module.ts`（行10）
- E-04: `Src/WebUI/ClientApp/src/app/app.module.ts`（行8, 30）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行2）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行2）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`（行13, 28-29, 42-43, 55-58）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルートパス（/）でアクセス可能 | E-03, E-05 | ○ |
| C-02 | 静的コンテンツのみを表示 | E-01, E-02, E-06 | ○ |
| C-03 | 認証不要でアクセス可能 | E-03, E-05 | ○ |
| C-04 | タイトル「Northwind Traders」を表示 | E-01（行3） | ○ |
| C-05 | Learn moreボタンがYouTube動画へリンク | E-01（行8） | ○ |
| C-06 | 3カラムのグリッドレイアウト | E-01（行14-39） | ○ |
| C-07 | HomeComponentとして実装 | E-02, E-04 | ○ |
| C-08 | データベース操作なし | E-02, E-06 | ○ |
| C-09 | 商品一覧画面へ遷移可能 | E-07（行28） | ○ |
| C-10 | 顧客一覧画面へ遷移可能 | E-07（行29） | ○ |
| C-11 | ログイン画面へ遷移可能 | E-07（行42-43） | ○ |
| C-12 | ログアウト画面へ遷移可能 | E-07（行55-58） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面は静的コンテンツのみを表示するシンプルな構造であり、ロジックやデータ処理がないため、設計ミスのリスクは極めて低い

## 6) レビュアーチェックリスト（最小）
- [x] URLパス（/）が正しいか確認済み
- [x] 静的コンテンツの内容がソースコードと一致するか確認済み
- [x] 認証要件が画面一覧と一致するか確認済み
- [x] 画面遷移情報が遷移図と一致するか確認済み
