---
generated_at: 2026-01-07 22:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-商品一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/ClientApp/src/app/products/products.component.html`（行1-27）
- E-02: `Src/WebUI/ClientApp/src/app/products/products.component.ts`（行1-16）
- E-03: `Src/WebUI/ClientApp/src/app/app.routing.module.ts`（行12）
- E-04: `Src/WebUI/ClientApp/src/app/northwind-traders-api.ts`（行701-1016、1846-1956）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行3）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行3-4）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`（行14, 31-33, 43-44, 56-57）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパス /products でアクセス可能 | E-03, E-05 | ○ |
| C-02 | 認証不要でアクセス可能 | E-03, E-05 | ○ |
| C-03 | ProductsClient.getAll()で商品一覧を取得 | E-02（行12）, E-04, E-06 | ○ |
| C-04 | 商品ID（productId）を表示 | E-01（行22）, E-04（ProductDto） | ○ |
| C-05 | 商品名（productName）を表示 | E-01（行23）, E-04（ProductDto） | ○ |
| C-06 | Exportボタンが/api/products/downloadへリンク | E-01（行5）, E-06 | ○ |
| C-07 | ProductsListVmビューモデルを使用 | E-02（行2, 9）, E-04（行1846-1892） | ○ |
| C-08 | テーブル形式で一覧表示 | E-01（行13-26） | ○ |
| C-09 | *ngForで商品リストをループ表示 | E-01（行21） | ○ |
| C-10 | エラー時はconsole.errorで出力 | E-02（行14） | ○ |
| C-11 | ホーム画面から遷移可能 | E-07（行28） | ○ |
| C-12 | 顧客一覧画面へ遷移可能 | E-07（行33） | ○ |
| C-13 | ログイン画面へ遷移可能 | E-07（行43-44） | ○ |
| C-14 | ログアウト画面へ遷移可能 | E-07（行56-57） | ○ |
| C-15 | NSwagで自動生成されたAPIクライアント | E-04（行1-8コメント） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面は参照系の処理のみであり、データ更新を行わないため、ビジネスロジック上のリスクは低い

## 6) レビュアーチェックリスト（最小）
- [x] URLパス（/products）が正しいか確認済み
- [x] API呼び出し（ProductsClient.getAll()）がソースコードと一致するか確認済み
- [x] 表示項目（productId, productName）がソースコードと一致するか確認済み
- [x] ExportボタンのURL（/api/products/download）が正しいか確認済み
- [x] 認証要件が画面一覧と一致するか確認済み
