---
generated_at: 2026-01-07 22:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-顧客一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/ClientApp/src/app/customers/customers.component.html`（行1-28）
- E-02: `Src/WebUI/ClientApp/src/app/customers/customers.component.ts`（行1-29）
- E-03: `Src/WebUI/ClientApp/src/app/app.routing.module.ts`（行11）
- E-04: `Src/WebUI/ClientApp/src/api-authorization/authorize.guard.ts`（行1-30）
- E-05: `Src/WebUI/ClientApp/src/app/northwind-traders-api.ts`（行187-472、1230-1388）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行4）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行5-6）
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`（行15, 36-39, 44, 57）
- E-09: `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.ts`（行1-26）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパス /customers でアクセス可能 | E-03, E-06 | ○ |
| C-02 | AuthorizeGuardによる認証保護 | E-03（行11 canActivate）, E-04 | ○ |
| C-03 | CustomersClient.getAll()で顧客一覧を取得 | E-02（行16）, E-05, E-07 | ○ |
| C-04 | 顧客ID（id）を表示 | E-01（行23）, E-05（CustomerLookupDto） | ○ |
| C-05 | 顧客名（name）を表示 | E-01（行24）, E-05（CustomerLookupDto） | ○ |
| C-06 | 行クリックでcustomerDetailメソッド呼び出し | E-01（行22）, E-02（行21-27） | ○ |
| C-07 | CustomersClient.get(id)で詳細取得 | E-02（行22）, E-05, E-07 | ○ |
| C-08 | BsModalServiceでモーダル表示 | E-02（行4, 15, 26） | ○ |
| C-09 | CustomerDetailComponentをモーダルとして表示 | E-02（行3, 26）, E-09 | ○ |
| C-10 | CustomersListVmビューモデルを使用 | E-02（行2, 12）, E-05（行1230-1268） | ○ |
| C-11 | CustomerDetailVmビューモデルを使用 | E-05（行1314-1388）, E-09（行2） | ○ |
| C-12 | テーブル形式で一覧表示 | E-01（行13-27） | ○ |
| C-13 | cursor: pointerスタイルが適用 | E-01（行22） | ○ |
| C-14 | エラー時はconsole.errorで出力 | E-02（行18, 27） | ○ |
| C-15 | 未認証時はログイン画面へリダイレクト | E-04（行22-27）, E-08（行44） | ○ |
| C-16 | 顧客詳細モーダルへ遷移 | E-08（行38） | ○ |
| C-17 | Shareボタン・Exportボタンが存在 | E-01（行5-6） | ○ |
| C-18 | ホーム画面・商品一覧画面から遷移可能 | E-08（行29, 37） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面は参照系の処理のみであり、データ更新を行わないため、ビジネスロジック上のリスクは低い
- 認証ガードが正しく機能していることの確認が重要

## 6) レビュアーチェックリスト（最小）
- [x] URLパス（/customers）が正しいか確認済み
- [x] AuthorizeGuardが適用されているか確認済み
- [x] API呼び出し（CustomersClient.getAll(), get(id)）がソースコードと一致するか確認済み
- [x] 表示項目（id, name）がソースコードと一致するか確認済み
- [x] 行クリック時のモーダル表示が実装されているか確認済み
- [x] 認証要件が画面一覧と一致するか確認済み
