---
generated_at: 2026-01-07 22:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-顧客詳細モーダル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.html`（行1-19）
- E-02: `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.ts`（行1-26）
- E-03: `Src/WebUI/ClientApp/src/app/customers/customers.component.ts`（行21-27）
- E-04: `Src/WebUI/ClientApp/src/app/northwind-traders-api.ts`（行1314-1388）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行5）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行7）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`（行16, 38-39）
- E-08: `Src/WebUI/ClientApp/src/app/app.module.ts`（行46-47）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 顧客一覧画面から起動されるモーダル | E-03, E-05, E-07 | ○ |
| C-02 | CustomerDetailVmを使用して詳細表示 | E-02（行2, 11）, E-04 | ○ |
| C-03 | BsModalRefでモーダル制御 | E-02（行3, 14, 23） | ○ |
| C-04 | ngOnInitでプロパティキーを抽出 | E-02（行16-19） | ○ |
| C-05 | 'id'をフィルタリングして除外 | E-02（行18） | ○ |
| C-06 | closeModalメソッドでBsModalRef.hide()呼び出し | E-02（行22-24） | ○ |
| C-07 | モーダルタイトルに顧客IDを表示 | E-01（行2） | ○ |
| C-08 | xボタンでcloseModal()を呼び出し | E-01（行3） | ○ |
| C-09 | *ngForでdetailKeysをループ表示 | E-01（行9） | ○ |
| C-10 | *ngIfで値がある項目のみ表示 | E-01（行10） | ○ |
| C-11 | camelCaseToTextパイプでラベル変換 | E-01（行11） | ○ |
| C-12 | CloseボタンでcloseModal()を呼び出し | E-01（行18） | ○ |
| C-13 | ChangeDetectionStrategy.OnPushを使用 | E-02（行8） | ○ |
| C-14 | entryComponentsに登録 | E-08（行46-47） | ○ |
| C-15 | 親画面で認証済みが必要 | E-05, E-07（行109） | ○ |
| C-16 | データ取得は親画面で実行済み | E-03（行22-25）, E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本モーダルは参照系の表示のみであり、データ更新を行わないため、ビジネスロジック上のリスクは低い

## 6) レビュアーチェックリスト（最小）
- [x] モーダルが顧客一覧画面から起動されることを確認済み
- [x] CustomerDetailVmのプロパティが正しく列挙されているか確認済み
- [x] closeModalメソッドがモーダルを閉じることを確認済み
- [x] camelCaseToTextパイプが正しく動作することを確認済み
- [x] ChangeDetectionStrategy.OnPushが使用されていることを確認済み
