---
generated_at: 2026-01-07 22:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-ログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/ClientApp/src/api-authorization/login/login.component.html`（行1）
- E-02: `Src/WebUI/ClientApp/src/api-authorization/login/login.component.ts`（行1-133）
- E-03: `Src/WebUI/ClientApp/src/api-authorization/authorize.service.ts`（行1-255）
- E-04: `Src/WebUI/ClientApp/src/api-authorization/api-authorization.constants.ts`（行1-81）
- E-05: `Src/WebUI/ClientApp/src/api-authorization/api-authorization.module.ts`（行14-24）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行6）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行8）
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`（行17, 46-47）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパス /authentication/login でアクセス可能 | E-04（行27）, E-05（行18）, E-06 | ○ |
| C-02 | AuthorizeServiceを使用して認証処理 | E-02（行2, 20）, E-03, E-07 | ○ |
| C-03 | サイレント認証を最初に試行 | E-03（行88-92） | ○ |
| C-04 | ポップアップ認証がデフォルトで無効 | E-03（行56, 97-98） | ○ |
| C-05 | リダイレクト認証にフォールバック | E-03（行112-115） | ○ |
| C-06 | BehaviorSubjectでメッセージを管理 | E-02（行17） | ○ |
| C-07 | ngOnInitでアクションを判定 | E-02（行24-46） | ○ |
| C-08 | login()メソッドでsignInを呼び出し | E-02（行49-51） | ○ |
| C-09 | processLoginCallback()でcompleteSignInを呼び出し | E-02（行73-75） | ○ |
| C-10 | login-failedでエラーメッセージを表示 | E-02（行33-35） | ○ |
| C-11 | redirectToRegister()で登録画面へリダイレクト | E-02（行89-91） | ○ |
| C-12 | redirectToProfile()でプロフィール画面へリダイレクト | E-02（行94-96） | ○ |
| C-13 | returnUrlのバリデーションを実施 | E-02（行106-119） | ○ |
| C-14 | オープンリダイレクト攻撃を防止 | E-02（行110-114） | ○ |
| C-15 | asyncパイプでメッセージを表示 | E-01（行1） | ○ |
| C-16 | LoginActionsで5つのアクションを定義 | E-04（行16-22） | ○ |
| C-17 | IdentityServerへリダイレクト | E-02（行58）, E-08（行46-47） | ○ |
| C-18 | oidc-clientライブラリを使用 | E-03（行2） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 認証処理は重要なセキュリティ機能であり、returnUrlバリデーションの実装が正しいことを確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [x] URLパスが正しくルーティングされているか確認済み
- [x] サイレント→ポップアップ→リダイレクトのフォールバック処理が実装されているか確認済み
- [x] returnUrlのバリデーションによりオープンリダイレクト攻撃が防止されているか確認済み
- [x] BehaviorSubjectでメッセージが正しく管理されているか確認済み
- [x] oidc-clientライブラリが使用されているか確認済み
