---
generated_at: 2026-01-07 22:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-ログアウト画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/ClientApp/src/api-authorization/logout/logout.component.html`（行1）
- E-02: `Src/WebUI/ClientApp/src/api-authorization/logout/logout.component.ts`（行1-117）
- E-03: `Src/WebUI/ClientApp/src/api-authorization/authorize.service.ts`（行162-206）
- E-04: `Src/WebUI/ClientApp/src/api-authorization/api-authorization.constants.ts`（行10-14）
- E-05: `Src/WebUI/ClientApp/src/api-authorization/api-authorization.module.ts`（行21-23）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行7）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行9）
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`（行18, 55-58）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパス /authentication/logout でアクセス可能 | E-04（行32）, E-05（行21）, E-06 | ○ |
| C-02 | AuthorizeServiceを使用してログアウト処理 | E-02（行2, 19）, E-03, E-07 | ○ |
| C-03 | window.history.state.localをチェック | E-02（行28） | ○ |
| C-04 | ページ内操作でない場合は警告メッセージを表示 | E-02（行31-32） | ○ |
| C-05 | isAuthenticated()で認証状態を確認 | E-02（行49-51） | ○ |
| C-06 | signOut()でログアウト処理を実行 | E-02（行53）, E-03（行162-179） | ○ |
| C-07 | ポップアップサインアウトを試行 | E-03（行165） | ○ |
| C-08 | 失敗時はリダイレクトサインアウト | E-03（行170-173） | ○ |
| C-09 | processLogoutCallback()でコールバック処理 | E-02（行74-91） | ○ |
| C-10 | completeSignOut()を呼び出し | E-02（行76）, E-03（行186-206） | ○ |
| C-11 | ログアウト成功メッセージを表示 | E-02（行40, 70） | ○ |
| C-12 | BehaviorSubjectでメッセージを管理 | E-02（行17） | ○ |
| C-13 | LogoutActionsで3つのアクションを定義 | E-04（行10-14） | ○ |
| C-14 | ログアウト後はホーム画面へ遷移 | E-08（行58） | ○ |
| C-15 | asyncパイプでメッセージを表示 | E-01（行1） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ログアウト処理はセキュリティに関わる機能であり、window.history.state.localチェックによるセキュリティ対策が正しく機能していることを確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [x] URLパスが正しくルーティングされているか確認済み
- [x] window.history.state.localチェックによるセキュリティ対策が実装されているか確認済み
- [x] ポップアップ→リダイレクトのフォールバック処理が実装されているか確認済み
- [x] ログアウト完了メッセージが正しく表示されるか確認済み
- [x] ログアウト後のリダイレクト先が正しいか確認済み
