---
generated_at: 2026-01-07 22:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-ログイン画面（サーバー）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml`（行1-85）
- E-02: `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs`（行1-141）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行8）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行10-11）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`（行22, 48-52）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパス /Identity/Account/Login でアクセス可能 | E-01（行1 @page）, E-03 | ○ |
| C-02 | [AllowAnonymous]属性で公開画面 | E-02（行18） | ○ |
| C-03 | InputModelにEmail、Password、RememberMeを定義 | E-02（行47-59） | ○ |
| C-04 | Emailに[Required]と[EmailAddress]バリデーション | E-02（行49-50） | ○ |
| C-05 | Passwordに[Required]と[DataType(Password)]バリデーション | E-02（行52-54） | ○ |
| C-06 | SignInManager.PasswordSignInAsync()でログイン処理 | E-02（行86）, E-04 | ○ |
| C-07 | ログイン成功時にLocalRedirect(returnUrl) | E-02（行88-90） | ○ |
| C-08 | 二要素認証時にLoginWith2faへリダイレクト | E-02（行92-94） | ○ |
| C-09 | ロックアウト時にLockoutへリダイレクト | E-02（行96-99） | ○ |
| C-10 | ログイン失敗時に'Invalid login attempt.'表示 | E-02（行103） | ○ |
| C-11 | OnPostSendVerificationEmailAsync()で確認メール送信 | E-02（行112-139）, E-04 | ○ |
| C-12 | UserManager.FindByEmailAsync()でユーザー検索 | E-02（行119） | ○ |
| C-13 | IEmailSender.SendEmailAsync()でメール送信 | E-02（行132-135） | ○ |
| C-14 | ExternalLoginsで外部認証プロバイダー表示 | E-01（行55-78）, E-02（行40, 73） | ○ |
| C-15 | Forgot passwordリンクが存在 | E-01（行39） | ○ |
| C-16 | Register as new userリンクが存在 | E-01（行42） | ○ |
| C-17 | lockoutOnFailure: trueでロックアウト有効 | E-02（行86） | ○ |
| C-18 | 新規登録画面へ遷移可能 | E-01（行42）, E-05（行48） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 認証処理はセキュリティの中核機能であり、PasswordSignInAsyncの実装が正しいことを確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [x] InputModelのバリデーションが正しく設定されているか確認済み
- [x] PasswordSignInAsyncでlockoutOnFailureがtrueに設定されているか確認済み
- [x] ログイン失敗時のエラーメッセージが適切か確認済み（詳細情報を漏らさない）
- [x] 外部認証プロバイダーの表示が設定に基づいているか確認済み
- [x] 確認メール再送信機能が実装されているか確認済み
