---
generated_at: 2026-01-07 22:35:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-新規登録画面（サーバー）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml`（行1-67）
- E-02: `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs`（行1-115）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行9）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行12-13）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`（行23, 48-52）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパス /Identity/Account/Register でアクセス可能 | E-01（行1 @page）, E-03 | ○ |
| C-02 | [AllowAnonymous]属性で公開画面 | E-02（行20） | ○ |
| C-03 | InputModelにEmail、Password、ConfirmPasswordを定義 | E-02（行47-64） | ○ |
| C-04 | Emailに[Required]と[EmailAddress]バリデーション | E-02（行49-51） | ○ |
| C-05 | Passwordに[StringLength(100, MinimumLength = 6)]バリデーション | E-02（行53-55） | ○ |
| C-06 | ConfirmPasswordに[Compare("Password")]バリデーション | E-02（行60-62） | ○ |
| C-07 | UserManager.CreateAsync()でユーザー作成 | E-02（行79）, E-04 | ○ |
| C-08 | ApplicationUser(UserName=Email, Email=Email)で作成 | E-02（行78） | ○ |
| C-09 | GenerateEmailConfirmationTokenAsync()でトークン生成 | E-02（行84） | ○ |
| C-10 | IEmailSender.SendEmailAsync()で確認メール送信 | E-02（行92-93）, E-04 | ○ |
| C-11 | RequireConfirmedAccount設定でリダイレクト先を分岐 | E-02（行95-102） | ○ |
| C-12 | 失敗時にIdentityResult.Errorsを表示 | E-02（行105-108） | ○ |
| C-13 | ExternalLoginsで外部認証プロバイダー表示 | E-01（行37-60）, E-02（行45, 69） | ○ |
| C-14 | ログイン画面から遷移可能 | E-05（行48） | ○ |
| C-15 | 登録成功後にログイン画面へ遷移 | E-05（行52） | ○ |
| C-16 | パスワード長エラーメッセージが設定済み | E-02（行55） | ○ |
| C-17 | パスワード不一致エラーメッセージが設定済み | E-02（行62） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ユーザー登録処理はセキュリティに関わる機能であり、パスワード要件やメール確認フローが正しく実装されていることを確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [x] InputModelのバリデーションが正しく設定されているか確認済み
- [x] パスワード最低長（6文字）が設定されているか確認済み
- [x] ConfirmPasswordの照合が実装されているか確認済み
- [x] UserManager.CreateAsync()の呼び出しが正しいか確認済み
- [x] 確認メール送信処理が実装されているか確認済み
- [x] RequireConfirmedAccount設定に応じたリダイレクトが実装されているか確認済み
