---
generated_at: 2026-01-07 22:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-エラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Pages/Error.cshtml`（行1-27）
- E-02: `Src/WebUI/Pages/Error.cshtml.cs`（行1-27）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行10）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md`（行25）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパス /Error でアクセス可能 | E-01（行1 @page）, E-03 | ○ |
| C-02 | ViewData["Title"]が"Error"に設定される | E-01（行4） | ○ |
| C-03 | ページタイトルは「Error.」と赤字表示 | E-01（行7）h1.text-danger | ○ |
| C-04 | エラーメッセージは「An error occurred while processing your request.」 | E-01（行8） | ○ |
| C-05 | RequestIdプロパティを持つ | E-02（行18） | ○ |
| C-06 | ShowRequestIdはRequestIdが空でないかをチェック | E-02（行20） | ○ |
| C-07 | Activity.Current?.Idからリクエストを取得 | E-02（行24） | ○ |
| C-08 | Activity.Current?.Idがnullの場合HttpContext.TraceIdentifierを使用 | E-02（行24）?? 演算子 | ○ |
| C-09 | ShowRequestIdがtrueの場合のみRequest ID表示 | E-01（行10-15）@if | ○ |
| C-10 | [ResponseCache]属性でキャッシュ無効化 | E-02（行8）Duration=0, NoStore=true | ○ |
| C-11 | ILogger<ErrorModel>を依存性注入 | E-02（行11, 13-16） | ○ |
| C-12 | 開発モードの案内文を表示 | E-01（行17-26） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 低リスク - エラー画面は情報表示のみで、セキュリティ上重要なのは詳細なエラー情報を本番環境で表示しないことである。現在の実装は開発モードの案内のみを表示し、詳細例外情報は表示していない

## 6) レビュアーチェックリスト（最小）
- [x] RequestIdの取得ロジックが正しいか確認済み
- [x] ResponseCache属性でキャッシュ無効化されているか確認済み
- [x] 本番環境で詳細なエラー情報が表示されないか確認済み
- [x] ShowRequestIdの条件判定が正しいか確認済み
