# 結合テストケース一覧 信頼度レポート

## 概要

本レポートは、NorthwindTraders プロジェクトのコードベースから自動生成された「結合テストケース一覧」の信頼度と生成根拠を説明するものです。

## 信頼度サマリー

| 項目 | 評価 | 信頼度 |
|------|------|--------|
| 全体信頼度 | 高 | 85% |
| APIエンドポイント網羅性 | 高 | 90% |
| 既存テストとの整合性 | 高 | 95% |
| ビジネスロジック網羅性 | 中 | 75% |
| エラーケース網羅性 | 中 | 80% |

## 分析対象ソースコード

### コントローラー（APIエンドポイント）

| ファイルパス | 分析内容 |
|-------------|----------|
| `Src/WebUI/Controllers/CustomersController.cs` | 顧客CRUD APIエンドポイント（GetAll, Get, Create, Update, Delete） |
| `Src/WebUI/Controllers/ProductsController.cs` | 製品CRUD APIエンドポイント + ファイルダウンロード |
| `Src/WebUI/Controllers/CategoriesController.cs` | カテゴリCRUD APIエンドポイント（Upsertパターン） |
| `Src/WebUI/Controllers/EmployeesController.cs` | 従業員CRUD APIエンドポイント（Upsertパターン） |

### アプリケーション層（コマンド/クエリ）

| ドメイン | 分析したファイル |
|---------|-----------------|
| Customers | CreateCustomerCommand, UpdateCustomerCommand, DeleteCustomerCommand, GetCustomersListQuery, GetCustomerDetailQuery |
| Products | CreateProductCommand, UpdateProductCommand, DeleteProductCommand, GetProductsListQuery, GetProductDetailQuery, GetProductsFileQuery |
| Categories | UpsertCategoryCommand, DeleteCategoryCommand, GetCategoriesListQuery |
| Employees | UpsertEmployeeCommand, DeleteEmployeeCommand, GetEmployeesListQuery, GetEmployeeDetailQuery |

### バリデーター

| ファイルパス | 分析内容 |
|-------------|----------|
| `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommandValidator.cs` | 顧客作成時の入力バリデーション |
| `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommandValidator.cs` | 顧客削除時のIDバリデーション |
| `Src/Application/Customers/Queries/GetCustomerDetail/GetCustomerDetailQueryValidator.cs` | 顧客詳細取得時のIDバリデーション |
| `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommandValidator.cs` | 顧客更新時の入力バリデーション |

### 既存テストコード

| ファイルパス | 分析内容 |
|-------------|----------|
| `Tests/WebUI.IntegrationTests/Controllers/Customers/*.cs` | 顧客API結合テスト（5ファイル） |
| `Tests/WebUI.IntegrationTests/Controllers/Products/*.cs` | 製品API結合テスト（5ファイル） |
| `Tests/WebUI.IntegrationTests/Controllers/Categories/*.cs` | カテゴリAPI結合テスト（1ファイル） |
| `Tests/Persistence.IntegrationTests/NorthwindDbContextTests.cs` | DB永続化層結合テスト |
| `Tests/WebUI.IntegrationTests/Common/CustomWebApplicationFactory.cs` | テスト基盤（認証、DB設定） |

## 生成根拠の詳細

### 1. 顧客管理テストケース（IT-CUS-001 ~ IT-CUS-011）

**信頼度: 90%**

#### 根拠
- `CustomersController.cs` の5つのアクションメソッド（GetAll, Get, Create, Update, Delete）を完全にカバー
- 既存の結合テスト（`WebUI.IntegrationTests/Controllers/Customers/`）の内容を参照し、同等以上のテストケースを定義
- `[Authorize]` 属性の存在から認証テストケースを追加
- `NotFoundException` をスローするコードパスからエラーケースを抽出

#### 既存テストとの対応
| 既存テスト | 対応するテストケースID |
|-----------|----------------------|
| `GetAll.ReturnsCustomersListViewModel` | IT-CUS-001 |
| `GetById.GivenId_ReturnsCustomerViewModel` | IT-CUS-003 |
| `GetById.GivenInvalidId_ReturnsNotFoundStatusCode` | IT-CUS-004 |
| `Create.GivenCreateCustomerCommand_ReturnsSuccessStatusCode` | IT-CUS-005 |
| `Update.GivenUpdateCustomerCommand_ReturnsSuccessStatusCode` | IT-CUS-008 |
| `Update.GivenUpdateCustomerCommandWithInvalidId_ReturnsNotFoundStatusCode` | IT-CUS-009 |
| `Delete.GivenId_ReturnsSuccessStatusCode` | IT-CUS-010 |
| `Delete.GivenInvalidId_ReturnsNotFoundStatusCode` | IT-CUS-011 |

### 2. 製品管理テストケース（IT-PRD-001 ~ IT-PRD-012）

**信頼度: 90%**

#### 根拠
- `ProductsController.cs` の6つのアクションメソッドを完全にカバー
- `[AllowAnonymous]` 属性の存在から匿名アクセステストケースを追加
- 既存の結合テスト内容を参照
- 外部キー制約（Supplier, Category）に関するエラーケースを追加

#### 特記事項
- `Download` アクション（GetProductsFileQuery）のテストケースを追加（IT-PRD-012）
- 製品は `[AllowAnonymous]` が付いているため、認証不要のテストケースも定義

### 3. カテゴリ管理テストケース（IT-CAT-001 ~ IT-CAT-007）

**信頼度: 80%**

#### 根拠
- `CategoriesController.cs` の3つのアクションメソッドをカバー
- `UpsertCategoryCommand` のInsert/Update両方のパスをテスト
- `DeleteCategoryCommand` の `NotFoundException` 処理を確認
- 製品との外部キー制約に関するテストケースを追加

#### 不確実性
- 製品が紐づいている場合のカテゴリ削除の挙動については、コードからは `DeleteFailureException` の使用が確認できなかったため、推定に基づく（信頼度低下要因）

### 4. 従業員管理テストケース（IT-EMP-001 ~ IT-EMP-008）

**信頼度: 85%**

#### 根拠
- `EmployeesController.cs` の4つのアクションメソッドをカバー
- `DeleteEmployeeCommand` 内のビジネスロジック（自分自身の削除禁止）を確認
- `BadRequestException` の発生条件からエラーケースを抽出

#### 特記事項
- 従業員削除時の「自分自身削除不可」ルール（IT-EMP-008）は `DeleteEmployeeCommand.cs` の以下のコードから導出:
  ```csharp
  if (entity.UserId == _currentUser.UserId)
  {
      throw new BadRequestException("Employees cannot delete their own account.");
  }
  ```

### 5. データベース統合テストケース（IT-DB-001 ~ IT-DB-003）

**信頼度: 95%**

#### 根拠
- `Persistence.IntegrationTests/NorthwindDbContextTests.cs` の既存テストを直接参照
- `AuditableEntity` の `Created`, `CreatedBy`, `LastModified`, `LastModifiedBy` プロパティの自動設定を確認

### 6. 認証・認可テストケース（IT-AUTH-001 ~ IT-AUTH-004）

**信頼度: 75%**

#### 根拠
- `CustomWebApplicationFactory.cs` の `GetAuthenticatedClientAsync` メソッドを分析
- IdentityServer4 を使用したOAuth2/OIDC認証フローを確認
- `[Authorize]` 属性の存在から保護されたエンドポイントを特定

#### 不確実性
- 具体的なIdentityServer4の設定が別ファイルにある可能性があり、詳細な認証フローは推定に基づく

### 7. バリデーション・エラーハンドリングテストケース

**信頼度: 80%**

#### 根拠
- `Application/Common/Behaviours/RequestValidationBehavior.cs` からバリデーションパイプラインを確認
- `Application/Common/Exceptions/` 配下の例外クラスを分析
- `WebUI/Common/CustomExceptionHandlerMiddleware.cs` の例外ハンドリングを確認

## テストケースカテゴリ別統計

| カテゴリ | テストケース数 | 正常系 | 異常系 | 境界値 |
|---------|--------------|--------|--------|--------|
| 顧客管理 | 11 | 5 | 6 | 0 |
| 製品管理 | 12 | 6 | 5 | 1 |
| カテゴリ管理 | 7 | 4 | 3 | 0 |
| 従業員管理 | 8 | 4 | 4 | 0 |
| データベース統合 | 3 | 3 | 0 | 0 |
| 認証・認可 | 4 | 2 | 2 | 0 |
| イベント処理 | 1 | 1 | 0 | 0 |
| バリデーション | 3 | 0 | 3 | 0 |
| エラーハンドリング | 3 | 0 | 3 | 0 |
| パフォーマンス | 2 | 2 | 0 | 0 |
| **合計** | **54** | **27** | **26** | **1** |

## 制限事項と改善提案

### 制限事項

1. **注文（Order）関連のテストケース未定義**
   - OrderController が存在しないため、注文関連のテストケースは作成していません
   - 将来的に注文機能が追加された場合は、対応するテストケースの追加が必要です

2. **詳細なバリデーションルールの不確実性**
   - 各Validatorの詳細なルール（最大文字数、必須フィールド等）は個別に確認が必要

3. **認証・認可の詳細テスト**
   - ロールベースのアクセス制御テストは未定義（コードからロール定義が確認できなかったため）

4. **パフォーマンステストの閾値**
   - レスポンスタイムの閾値（3秒）は仮設定であり、実際の要件に基づいて調整が必要

### 改善提案

1. **テストデータの拡充**
   - より多様なテストデータシナリオ（大量データ、特殊文字、境界値）の追加を推奨

2. **E2Eテストの追加**
   - 複数のAPIを組み合わせたエンドツーエンドシナリオの追加を推奨

3. **セキュリティテストの強化**
   - SQLインジェクション、XSSなどのセキュリティテストケースの追加を推奨

## 生成日時

- 生成日: 2026-01-07
- 対象プロジェクト: NorthwindTraders
- 分析対象コミット: main ブランチ最新

## 参照ドキュメント

- 既存結合テストコード: `Tests/WebUI.IntegrationTests/`
- 既存永続化テスト: `Tests/Persistence.IntegrationTests/`
- ソリューションファイル: `Northwind.sln`
