# 通知設計書 1-顧客作成通知

## 概要

本ドキュメントは、NorthwindTradersシステムにおける顧客作成通知機能の設計仕様を定義する。顧客が新規作成された際に、MediatRのドメインイベント機構を利用してINotificationServiceを通じた通知メッセージの送信処理を行う。

### 本通知の処理概要

顧客作成通知は、CreateCustomerCommandが正常に実行され、新しい顧客がデータベースに永続化された後に発行されるドメインイベントをトリガーとして動作する通知機能である。

**業務上の目的・背景**：新規顧客の作成は営業活動やCRM管理において重要なイベントである。この通知により、関連部門（営業、カスタマーサポート、経営層など）が新規顧客の獲得を即座に把握でき、迅速なフォローアップや営業戦略の調整が可能となる。また、システム間連携においても、外部システムへの顧客情報の同期トリガーとして機能する可能性がある。

**通知の送信タイミング**：CreateCustomerCommandのHandlerがデータベースへの保存（SaveChangesAsync）を完了した直後に、MediatRのPublishメソッドを通じてCustomerCreatedイベントが発行される。このイベントをCustomerCreatedHandlerがサブスクライブし、通知処理を実行する。

**通知の受信者**：現在の実装では、MessageDtoに具体的な宛先が設定されていないため、受信者の決定ロジックは未実装の状態である。本番運用時には、営業担当者、管理者、または設定に基づく通知先への送信が想定される。

**通知内容の概要**：CustomerCreatedイベントにはCustomerIdのみが含まれる。通知本文には顧客IDが含まれ、必要に応じて顧客詳細情報（会社名、担当者名等）を付加することが可能な設計となっている。

**期待されるアクション**：受信者は新規顧客の情報を確認し、必要に応じて初回コンタクト、ウェルカムメールの送信、担当者の割り当てなどのフォローアップアクションを実施することが期待される。

## 通知種別

アプリ内通知（INotificationService経由）

現在の実装では具体的な送信チャネル（メール、SMS等）は抽象化されており、INotificationServiceの実装クラスによって決定される。デフォルト実装（NotificationService）はスタブ実装となっている。

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（async/await） |
| 優先度 | 中 |
| リトライ | 無（現在の実装） |

### 送信先決定ロジック

現在の実装では、MessageDtoの各プロパティ（From、To、Subject、Body）は初期化時に空の状態であり、送信先決定ロジックは実装されていない。

将来的な拡張では以下の方式が想定される：
- 顧客の担当営業者への通知
- 管理者グループへの通知
- システム設定に基づく通知先リストへの配信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | （未設定） |
| 送信元名称 | （未設定） |
| 件名 | （未設定） |
| 形式 | （未設定） |

### 本文テンプレート

```
（現在の実装では本文テンプレートは未定義）

想定されるテンプレート例：
新しい顧客が登録されました。

顧客ID: {CustomerId}
会社名: {CompanyName}
担当者: {ContactName}

詳細は顧客管理画面からご確認ください。
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| CustomerId | 顧客ID | CustomerCreated.CustomerId | Yes |
| CompanyName | 会社名 | Customer.CompanyName（拡張時） | No |
| ContactName | 担当者名 | Customer.ContactName（拡張時） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ドメインイベント | CustomerCreated | 顧客作成成功時 | CreateCustomerCommand完了後にPublish |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 現在の実装では送信抑止条件は設定されていない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[CreateCustomerCommand受信] --> B[顧客エンティティ作成]
    B --> C[データベース保存]
    C --> D{保存成功?}
    D -->|Yes| E[CustomerCreatedイベント発行]
    D -->|No| F[例外スロー]
    E --> G[CustomerCreatedHandler.Handle]
    G --> H[INotificationService.SendAsync]
    H --> I[終了]
    F --> J[エラー処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 通知処理自体ではDB参照なし |

### テーブル別参照項目詳細

通知処理（CustomerCreatedHandler）では直接のデータベース参照は行わない。CustomerCreatedイベントに含まれるCustomerIdのみを使用する。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 通知処理自体ではDB更新なし |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| なし | - | - | 送信ログ記録機能は未実装 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | INotificationService.SendAsync失敗時 | 現在は例外がスローされる（ハンドリング未実装） |
| テンプレートエラー | - | テンプレート機能未実装のため該当なし |
| 宛先不正 | - | 宛先設定機能未実装のため該当なし |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライ機能なし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間送信可能）

## セキュリティ考慮事項

- CustomerIdのみがイベントに含まれるため、機密情報の漏洩リスクは低い
- 将来的に顧客詳細情報を通知に含める場合は、個人情報保護の観点から暗号化や受信者認証の検討が必要
- INotificationServiceの実装において、送信先の検証や不正な送信の防止機構の実装が推奨される

## 備考

- 現在のNotificationService実装はスタブであり、実際の通知送信は行われない（Task.CompletedTaskを返すのみ）
- 本番運用時には、具体的な通知チャネル（メール、Slack、Teams等）の実装が必要
- MediatRのINotificationHandlerは複数登録可能であり、将来的に複数の通知先への同時配信が可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知処理で使用されるデータ構造とドメインイベントの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MessageDto.cs | `Src/Application/Notifications/Models/MessageDto.cs` | 通知メッセージの構造（From, To, Subject, Body）を理解する |
| 1-2 | CustomerCreated.cs | `Src/Application/Customers/Commands/CreateCustomer/CustomerCreated.cs` | ドメインイベントの定義とCustomerIdプロパティを確認する |
| 1-3 | Customer.cs | `Src/Domain/Entities/Customer.cs` | 顧客エンティティの構造を理解する |

**読解のコツ**: C#のrecord型やクラス定義に注目。MediatRのINotificationインターフェースがドメインイベントを示す。

#### Step 2: エントリーポイントを理解する

顧客作成コマンドの処理開始点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CreateCustomerCommand.cs | `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommand.cs` | コマンドの定義とHandlerの実装を理解する |

**主要処理フロー**:
1. **行44-58**: 顧客エンティティの作成とプロパティのマッピング
2. **行60**: DbContextへの顧客追加（_context.Customers.Add）
3. **行62**: データベースへの永続化（SaveChangesAsync）
4. **行64**: CustomerCreatedイベントの発行（_mediator.Publish）

#### Step 3: 通知ハンドラーを理解する

ドメインイベントを受け取り、通知処理を実行するハンドラーを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CustomerCreated.cs | `Src/Application/Customers/Commands/CreateCustomer/CustomerCreated.cs` | CustomerCreatedHandlerクラスの実装を確認する |

**主要処理フロー**:
- **行13-26**: CustomerCreatedHandlerクラスの定義
- **行15-19**: INotificationServiceの依存性注入
- **行22-25**: Handleメソッドで通知送信を実行

#### Step 4: 通知サービスインターフェースを理解する

通知送信の抽象化インターフェースを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | INotificationService.cs | `Src/Application/Common/Interfaces/INotificationService.cs` | SendAsyncメソッドのシグネチャを確認 |

#### Step 5: 通知サービス実装を理解する

具体的な通知送信の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | NotificationService.cs | `Src/Infrastructure/NotificationService.cs` | スタブ実装であることを理解する |
| 5-2 | DependencyInjection.cs | `Src/Infrastructure/DependencyInjection.cs` | DIコンテナへの登録を確認（行24） |

### プログラム呼び出し階層図

```
CreateCustomerCommand.Handler.Handle
    │
    ├─ INorthwindDbContext.Customers.Add(entity)
    │
    ├─ INorthwindDbContext.SaveChangesAsync()
    │
    └─ IMediator.Publish(CustomerCreated)
           │
           └─ CustomerCreatedHandler.Handle
                  │
                  └─ INotificationService.SendAsync(MessageDto)
                         │
                         └─ NotificationService.SendAsync (スタブ実装)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CreateCustomerCommand ──▶ Handler.Handle
                              │
                              ├──▶ Customer Entity 作成
                              │
                              ├──▶ DB保存
                              │
                              └──▶ CustomerCreated Event
                                        │
                                        ▼
                              CustomerCreatedHandler
                                        │
                                        ▼
                              INotificationService ──▶ 通知送信（現在はスタブ）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CreateCustomerCommand.cs | `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommand.cs` | ソース | 顧客作成コマンドとハンドラー |
| CustomerCreated.cs | `Src/Application/Customers/Commands/CreateCustomer/CustomerCreated.cs` | ソース | ドメインイベントと通知ハンドラー |
| MessageDto.cs | `Src/Application/Notifications/Models/MessageDto.cs` | ソース | 通知メッセージDTO |
| INotificationService.cs | `Src/Application/Common/Interfaces/INotificationService.cs` | ソース | 通知サービスインターフェース |
| NotificationService.cs | `Src/Infrastructure/NotificationService.cs` | ソース | 通知サービス実装（スタブ） |
| DependencyInjection.cs | `Src/Infrastructure/DependencyInjection.cs` | ソース | DIコンテナ設定 |
| Customer.cs | `Src/Domain/Entities/Customer.cs` | ソース | 顧客ドメインエンティティ |
