# 通知設計書 3-確認メール再送信

## 概要

本ドキュメントは、NorthwindTradersシステムにおける確認メール再送信機能の設計仕様を定義する。ログイン画面から、メールアドレス未確認のユーザーがメールアドレス確認用メールの再送信を要求できる機能を提供する。

### 本通知の処理概要

確認メール再送信は、ユーザーがログイン画面において、初回登録時の確認メールを受け取れなかった場合や確認リンクの有効期限が切れた場合に、新しい確認メールを再送信するための機能である。

**業務上の目的・背景**：初回登録時の確認メールが迷惑メールフォルダに振り分けられたり、メール配信の遅延が発生した場合、ユーザーはアカウントの有効化ができない状態に陥る。この再送信機能により、ユーザーは自己解決でアカウント有効化を完了でき、サポート問い合わせの削減とユーザー体験の向上を実現する。また、確認トークンには有効期限があるため、期限切れの場合にも新しいトークンを発行する手段として機能する。

**通知の送信タイミング**：Login画面でユーザーがメールアドレスを入力し、「確認メール再送信」ボタンをクリックした際に、OnPostSendVerificationEmailAsyncメソッドが実行され、確認メールが送信される。

**通知の受信者**：ログイン画面で入力されたメールアドレス（Input.Email）が受信者となる。該当するユーザーが存在する場合のみ、そのメールアドレスに送信される。

**通知内容の概要**：メールには新しい確認リンクが含まれる。リンクをクリックすると/Account/ConfirmEmailページに遷移し、メールアドレスの確認が完了する。内容は初回登録時の確認メールと同一形式である。

**期待されるアクション**：受信者はメール内の確認リンクをクリックし、メールアドレスの所有権を証明する。確認が完了すると、アカウントが有効化され、次回以降のログインが可能となる。

## 通知種別

メール（Email）

ASP.NET Core IdentityのIEmailSenderインターフェースを使用した標準的なメール送信機能。

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（async/await） |
| 優先度 | 高（ユーザー自己解決のためのクリティカル機能） |
| リトライ | IEmailSender実装依存 |

### 送信先決定ロジック

送信先はログイン画面で入力されたメールアドレス（Input.Email）に固定される。
- LoginModel.csの行132でInput.Emailが直接SendEmailAsyncに渡される
- UserManager.FindByEmailAsyncでユーザーの存在確認が行われる

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | IEmailSender実装依存 |
| 送信元名称 | IEmailSender実装依存 |
| 件名 | Confirm your email |
| 形式 | HTML |

### 本文テンプレート

```html
Please confirm your account by <a href='{callbackUrl}'>clicking here</a>.
```

**注記**: callbackUrlはHtmlEncoder.Default.Encodeでエンコードされ、XSS対策が施されている。

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| callbackUrl | メール確認用URL | Url.Page + userId + code | Yes |
| userId | ユーザーID | UserManager.GetUserIdAsync | Yes |
| code | 確認トークン | UserManager.GenerateEmailConfirmationTokenAsync | Yes |

### callbackUrl構築詳細

```csharp
var callbackUrl = Url.Page(
    "/Account/ConfirmEmail",
    pageHandler: null,
    values: new { userId = userId, code = code },
    protocol: Request.Scheme);
```

**注記**: 再送信時はareaパラメータが省略されている点がRegister時と異なる。

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 確認メール再送信ボタンクリック | ユーザーが存在する場合 | Login.cshtml.csのOnPostSendVerificationEmailAsync |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザー不存在 | FindByEmailAsyncがnullを返す場合、メール送信は実行されない（ただしエラーメッセージは送信成功と同様に表示） |
| ModelState無効 | フォームバリデーションエラー時はメール送信に到達しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Login画面: 再送信ボタンクリック] --> B[ModelState検証]
    B -->|無効| C[フォーム再表示]
    B -->|有効| D[UserManager.FindByEmailAsync]
    D --> E{ユーザー存在?}
    E -->|No| F[エラーメッセージ表示のみ]
    E -->|Yes| G[UserManager.GetUserIdAsync]
    G --> H[GenerateEmailConfirmationTokenAsync]
    H --> I[callbackUrl構築]
    I --> J[IEmailSender.SendEmailAsync]
    J --> K[成功メッセージ表示]
    F --> L[終了]
    K --> L
    C --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| AspNetUsers | ユーザー存在確認 | FindByEmailAsyncで使用 |

### テーブル別参照項目詳細

#### AspNetUsers

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Id | ユーザーID取得 | Email = Input.Email |
| Email | ユーザー検索 | WHERE Email = Input.Email |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | メール再送信処理ではDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ユーザー不存在 | 入力メールに対応するユーザーがない | セキュリティ上、送信成功と同じメッセージを表示 |
| メール送信失敗 | IEmailSender実装の送信エラー | 例外がスローされる（ハンドリングなし） |
| トークン生成失敗 | Identity内部エラー | 例外がスローされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | IEmailSender実装依存 |
| リトライ間隔 | IEmailSender実装依存 |
| リトライ対象エラー | IEmailSender実装依存 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | IEmailSender実装依存（アプリケーションレベルでの制限なし） |
| 1日あたり上限 | IEmailSender実装依存（アプリケーションレベルでの制限なし） |

### 配信時間帯

制限なし（24時間送信可能）

## セキュリティ考慮事項

- **ユーザー列挙攻撃対策**: ユーザーが存在しない場合でも「送信成功」メッセージを表示し、メールアドレスの存在有無を外部から判定できないようにしている（行122-123）
- **URLエンコード**: callbackUrlはHtmlEncoder.Default.Encodeで処理され、XSS攻撃を防止
- **トークン有効期限**: 新しいトークンが発行されるため、古いトークンは無効化される可能性がある
- **レート制限なし**: 現在の実装では再送信回数の制限がないため、メールボム攻撃の対策が必要な場合がある
- **HTTPS強制**: Request.Schemeを使用するため、HTTPSで運用時は確認URLもHTTPSとなる

## 備考

- ユーザーが存在しない場合のエラーメッセージは「Verification email sent. Please check your email.」と表示され、送信成功時と同一のメッセージが使用される
- 既にメール確認済みのユーザーに対しても再送信が可能な実装となっている（確認済みチェックなし）
- Register時のcallbackUrl構築とはareaパラメータの有無が異なるが、機能的には同等
- IEmailSenderの具体的な実装はDIコンテナで提供される必要がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ログイン処理で使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | InputModelクラス（行47-59）でフォーム入力構造を理解 |
| 1-2 | ApplicationUser.cs | `Src/Infrastructure/Identity/ApplicationUser.cs` | IdentityUserを継承したユーザーエンティティ |

**読解のコツ**: InputModelはログインとメール再送信で共有されている。Email、Password、RememberMeの3フィールドを持つ。

#### Step 2: エントリーポイントを理解する

確認メール再送信処理の開始点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | OnPostSendVerificationEmailAsyncメソッド（行112-139）が処理開始点 |

**主要処理フロー**:
1. **行114-117**: ModelState検証
2. **行119**: UserManager.FindByEmailAsyncでユーザー検索
3. **行120-123**: ユーザー不存在時のセキュリティ対応
4. **行125**: GetUserIdAsyncでユーザーID取得
5. **行126**: GenerateEmailConfirmationTokenAsyncでトークン生成
6. **行127-131**: callbackUrl構築
7. **行132-135**: SendEmailAsync実行

#### Step 3: セキュリティ対応を理解する

ユーザー列挙攻撃への対策を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | 行120-123でユーザー不存在時も成功メッセージを返す |

**主要処理フロー**:
- **行120**: `if (user == null)` - ユーザー存在チェック
- **行122**: ユーザーが存在しなくても「Verification email sent」を表示

#### Step 4: メール送信を理解する

IEmailSenderを通じたメール送信の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | 行132-135でSendEmailAsync呼び出し |

**主要処理フロー**:
- **行132-135**: `_emailSender.SendEmailAsync(Input.Email, "Confirm your email", ...)` - メール送信

#### Step 5: 依存性注入を理解する

LoginModelのコンストラクタで注入される依存関係を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | コンストラクタ（行26-35）で注入されるサービス |

### プログラム呼び出し階層図

```
LoginModel.OnPostSendVerificationEmailAsync (HTTP POST)
    │
    ├─ ModelState.IsValid チェック
    │
    ├─ UserManager<ApplicationUser>.FindByEmailAsync(Input.Email)
    │      │
    │      └─ AspNetUsers テーブル検索
    │
    ├─ [ユーザー不存在時] エラーメッセージ設定のみ
    │
    ├─ UserManager<ApplicationUser>.GetUserIdAsync(user)
    │
    ├─ UserManager<ApplicationUser>.GenerateEmailConfirmationTokenAsync(user)
    │
    ├─ Url.Page("/Account/ConfirmEmail", ...)
    │
    └─ IEmailSender.SendEmailAsync(email, subject, htmlMessage)
           │
           └─ 実装依存（外部メールサービス等）
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Login Form
  │
  └─ Email ─────────────▶ FindByEmailAsync
                                 │
                                 ▼
                          ユーザー存在確認
                                 │
                     ┌───────────┴───────────┐
                     │                       │
                 [存在しない]            [存在する]
                     │                       │
                     ▼                       ▼
              エラーメッセージ        TokenGeneration ─▶ 確認トークン
              （送信成功と同じ）              │
                     │                       ▼
                     │              URL構築（エンコード）
                     │                       │
                     │                       ▼
                     │              IEmailSender ───▶ 確認メール送信
                     │                                      │
                     └───────────────────────────────────────┘
                                                            │
                                                            ▼
                                                     ユーザーの
                                                     メールボックス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | ソース | ログインページのコードビハインド（再送信機能含む） |
| Login.cshtml | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml` | テンプレート | ログインフォームのRazor View |
| ApplicationUser.cs | `Src/Infrastructure/Identity/ApplicationUser.cs` | ソース | ユーザーエンティティ定義 |
| DependencyInjection.cs | `Src/Infrastructure/DependencyInjection.cs` | ソース | DIコンテナ設定（Identity設定含む） |
