---
generated_at: 2026-01-07 23:45:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **C-44**: パスワードリセット手順の詳細（具体的な画面フローが不明）
  2. **C-45**: サポート連絡先（実際の連絡先情報が未定義）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Docs/code-to-docs/README.md` - システム概要
- E-02: `Docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-03: `Docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-04: `Docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `Docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件一覧
- E-06: `Docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-07: `Docs/code-to-docs/画面設計書/1-ホーム画面.md` - ホーム画面設計書
- E-08: `Docs/code-to-docs/画面設計書/2-商品一覧画面.md` - 商品一覧画面設計書
- E-09: `Docs/code-to-docs/画面設計書/3-顧客一覧画面.md` - 顧客一覧画面設計書
- E-10: `Docs/code-to-docs/画面設計書/5-ログイン画面.md` - ログイン画面設計書
- E-11: `Docs/code-to-docs/画面設計書/7-ログイン画面（サーバー）.md` - サーバー側ログイン画面設計書
- E-12: `Docs/code-to-docs/画面設計書/8-新規登録画面（サーバー）.md` - 新規登録画面設計書
- E-13: `Docs/code-to-docs/API設計書/API設計書.md` - API設計書

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Northwind Tradersは輸入食品を取り扱う業務管理システム | E-01, E-07 | ○ |
| C-02 | 商品管理、顧客管理、従業員管理などの機能を提供 | E-01, E-04 | ○ |
| C-03 | Webブラウザからアクセス可能 | E-01 | ○ |
| C-04 | 商品一覧の参照機能がある | E-02, E-04, E-08 | ○ |
| C-05 | 商品一覧のCSVエクスポート機能がある | E-04, E-06, E-08 | ○ |
| C-06 | 顧客一覧の参照機能がある | E-02, E-04, E-09 | ○ |
| C-07 | 顧客詳細情報の確認機能がある | E-02, E-04, E-09 | ○ |
| C-08 | ユーザー登録機能がある | E-04, E-05, E-12 | ○ |
| C-09 | ログイン・ログアウト機能がある | E-04, E-05, E-10, E-11 | ○ |
| C-10 | 商品一覧は認証不要でアクセス可能 | E-03, E-08 | ○ |
| C-11 | 顧客一覧は認証が必要 | E-03, E-05, E-09 | ○ |
| C-12 | ホーム画面がルートパスで表示される | E-02, E-07 | ○ |
| C-13 | ヘッダーからProducts、Customers、Loginにアクセス可能 | E-03, E-07 | ○ |
| C-14 | Learn moreボタンでYouTube動画へ遷移 | E-07 | ○ |
| C-15 | 商品一覧は/productsパスでアクセス | E-02, E-08 | ○ |
| C-16 | 商品一覧にIdとName列がある | E-08 | ○ |
| C-17 | Exportボタンで/api/products/downloadからCSV取得 | E-06, E-08 | ○ |
| C-18 | 顧客一覧は/customersパスでアクセス | E-02, E-09 | ○ |
| C-19 | 顧客一覧は#とName列を表示 | E-09 | ○ |
| C-20 | 顧客行クリックで詳細モーダルが表示される | E-03, E-09 | ○ |
| C-21 | 顧客詳細モーダルに会社名、担当者名、住所等が表示される | E-09 | ○ |
| C-22 | ログイン画面へはヘッダーのLoginからアクセス | E-03, E-07 | ○ |
| C-23 | ログインにはEmail、Password入力が必要 | E-10, E-11 | ○ |
| C-24 | ログイン失敗でアカウントロックアウトがある | E-04, E-05 | ○ |
| C-25 | ログアウトはヘッダーのLogoutから実行 | E-03 | ○ |
| C-26 | 新規登録でEmail、Password、Confirm Passwordを入力 | E-12 | ○ |
| C-27 | 登録後にメール確認が必要 | E-04, E-05, E-12 | ○ |
| C-28 | ASP.NET Core IdentityとIdentityServerで認証 | E-01, E-10 | ○ |
| C-29 | OAuth2/OIDCプロトコルを使用 | E-10 | ○ |
| C-30 | 商品APIにPOST/PUT/DELETEエンドポイントがある | E-04, E-13 | ○ |
| C-31 | 顧客APIにPOST/PUT/DELETEエンドポイントがある | E-04, E-13 | ○ |
| C-32 | 従業員APIにPOST/DELETEエンドポイントがある | E-04, E-13 | ○ |
| C-33 | カテゴリAPIにPOST/DELETEエンドポイントがある | E-04, E-13 | ○ |
| C-34 | Swagger UIが/apiパスで利用可能 | E-01, E-13 | ○ |
| C-35 | エラー画面でリクエストIDが表示される | E-02 | ○ |
| C-36 | 未認証で顧客一覧にアクセスするとログイン画面にリダイレクト | E-03, E-09 | ○ |
| C-37 | CSVファイルにProductId、ProductName等の列が含まれる | E-08, E-13 | ○ |
| C-38 | 二要素認証機能がある | E-04 | ○ |
| C-39 | Remember me機能がある | E-11 | ○ |
| C-40 | Chrome、Edge、Safari、Firefoxが推奨ブラウザ | E-01 | ○ |
| C-41 | .NET Core、Angular、SQL Serverを使用 | E-01 | ○ |
| C-42 | 顧客IDは5文字の英数字 | E-05 | ○ |
| C-43 | 自分自身の従業員削除は不可 | E-04, E-05 | ○ |
| C-44 | パスワードリセット手順が存在する | **根拠なし** | △ |
| C-45 | サポート連絡先が設定されている | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-44: パスワードリセット手順**
  - 画面設計書にパスワードリセット画面の詳細な記載がない
  - ASP.NET Core Identityの標準機能として存在するが、カスタマイズ内容は不明
  - 候補：`Identity/Account/ForgotPassword.cshtml` の確認 / 管理者への問い合わせ

- **C-45: サポート連絡先**
  - システムドキュメントにサポート窓口の情報が記載されていない
  - 運用体制に依存する情報のため、コードからは抽出不可
  - 候補：運用チームへの確認 / 組織の連絡先情報の追加

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - システム機能に関する主張（C-01〜C-43）
  - 画面設計書、機能一覧、業務要件一覧から十分な根拠が得られている
  - 実際のコード構造とも整合性がある

- **1: 中リスク** - 認証フローの詳細（C-44）
  - パスワードリセット機能は存在するが、詳細フローが未確認
  - エンドユーザーへの案内として不十分な可能性

- **1: 中リスク** - サポート体制（C-45）
  - 運用マニュアルとしてサポート連絡先は必要な情報
  - 実際の運用開始前に情報を補完する必要あり

## 6) レビュアーチェックリスト（最小）
- [ ] 画面の操作手順が実際の動作と一致しているか確認
- [ ] 認証が必要な機能と不要な機能の区分が正しいか確認
- [ ] CSVダウンロードの出力列が実際のファイルと一致しているか確認
- [ ] パスワードリセット手順を実際の画面で確認し、必要に応じて追記
- [ ] サポート連絡先情報を運用チームに確認し、追記
- [ ] 推奨ブラウザでの動作検証
- [ ] エラーメッセージの対処法が実際のシステム動作と一致しているか確認
