# Northwind Traders 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（ホーム画面）](#3-トップページホーム画面)

**【業務フローに沿った機能】**
4. [【STEP1】商品情報の参照](#4-step1商品情報の参照)
5. [【STEP2】顧客情報の参照](#5-step2顧客情報の参照)
6. [【STEP3】データのエクスポート](#6-step3データのエクスポート)
7. [【STEP4】マスタ管理（管理者向け）](#7-step4マスタ管理管理者向け)

**【サポート機能】**
8. [認証機能](#8-認証機能)
9. [エラー対応](#9-エラー対応)

**【運用ガイド】**
10. [日常業務の流れ](#10-日常業務の流れ)
11. [よくある質問と対処法](#11-よくある質問と対処法)
12. [トラブルシューティング](#12-トラブルシューティング)

---

## 1. システム概要

### 1.1 Northwind Tradersとは

Northwind Tradersは、輸入食品を取り扱う架空の会社の業務管理システムです。商品管理、顧客管理、従業員管理などの機能を提供し、日常業務の効率化を支援します。

本システムはWebブラウザからアクセスして利用するWebアプリケーションで、インターネット環境があればどこからでも利用可能です。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **商品管理** | 商品一覧の参照、商品情報の確認、商品一覧のCSVエクスポート |
| **顧客管理** | 顧客一覧の参照、顧客詳細情報の確認 |
| **認証・セキュリティ** | ユーザー登録、ログイン、ログアウト |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
+---------------------------------------------------------------------+
|                        業務フロー                                    |
+---------------------------------------------------------------------+
|                                                                     |
|  【STEP 1】商品情報の参照                                            |
|      取り扱い商品の確認、在庫状況の把握                               |
|      ↓                                                              |
|  【STEP 2】顧客情報の参照（要ログイン）                               |
|      取引先顧客の情報確認、連絡先の把握                               |
|      ↓                                                              |
|  【STEP 3】データのエクスポート                                       |
|      商品一覧をCSV形式でダウンロードして帳票作成・分析に活用            |
|      ↓                                                              |
|  【STEP 4】マスタ管理（管理者向け）                                   |
|      商品・顧客・従業員・カテゴリのマスタ情報をAPIで管理                |
|                                                                     |
+---------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **一般ユーザー** | 商品一覧の参照、商品一覧のCSVエクスポート |
| **認証済みユーザー** | 上記に加え、顧客一覧の参照、顧客詳細の確認 |
| **管理者** | 上記に加え、API経由でのマスタデータ管理（商品・顧客・従業員・カテゴリの登録・更新・削除） |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| 商品一覧表示 | 全商品を一覧形式で表示 | STEP 1 |
| 商品一覧ダウンロード | 商品一覧をCSV形式でエクスポート | STEP 3 |
| 顧客一覧表示 | 全顧客を一覧形式で表示（要認証） | STEP 2 |
| 顧客詳細表示 | 顧客の詳細情報をモーダル表示 | STEP 2 |
| ユーザー登録 | 新規アカウントの作成 | 随時 |
| ログイン・ログアウト | システムへの認証・セッション終了 | 随時 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 一般ユーザー（未認証） | 商品一覧の参照、CSVダウンロードが可能 |
| 認証済みユーザー | 上記に加え、顧客情報の参照が可能 |
| 管理者 | 全機能にアクセス可能（API経由でのマスタ管理含む） |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. ログイン・ログアウト手順

### 2.1 ログイン方法

顧客情報など、認証が必要な機能を利用するにはログインが必要です。

**手順：**

1. ブラウザでNorthwind Tradersのトップページにアクセスします
2. 画面右上のヘッダーメニューから「Login」をクリックします
3. ログイン画面（Identity Server）が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| Email | 登録したメールアドレスを入力 |
| Password | パスワードを入力 |
| Remember me | ログイン状態を保持する場合はチェック |

4. 「Log in」ボタンをクリックします
5. 認証に成功すると、元の画面に戻ります

> **注意**: ログインに複数回失敗すると、セキュリティのためアカウントがロックアウトされる場合があります。

### 2.2 ログアウト方法

1. 画面右上のヘッダーメニューから「Logout」をクリックします
2. ログアウト処理が実行されます
3. ログアウト完了後、ホーム画面に戻ります

### 2.3 新規ユーザー登録

初めてシステムを利用する場合は、新規ユーザー登録が必要です。

**手順：**

1. ログイン画面で「Register as a new user」リンクをクリックします
2. 新規登録画面が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| Email | 有効なメールアドレスを入力 |
| Password | パスワードを入力（大文字、小文字、数字、記号を含む6文字以上） |
| Confirm Password | 確認のため同じパスワードを再入力 |

3. 「Register」ボタンをクリックします
4. 登録したメールアドレスに確認メールが送信されます
5. メール内のリンクをクリックしてアカウントを有効化します

---

## 3. トップページ（ホーム画面）

### 3.1 ホーム画面の概要

ホーム画面は、システムにアクセスした際に最初に表示される画面です。Northwind Tradersの紹介と、各機能へのナビゲーションを提供します。

**アクセス方法：**
- ブラウザでシステムのURL（/）にアクセス
- ヘッダーメニューの「Home」をクリック

### 3.2 画面構成

| 要素 | 説明 |
|------|------|
| ヘッダー | ナビゲーションメニュー（Home、Products、Customers、Login/Logout） |
| ジャンボトロン | 会社紹介とシステム概要、「Learn more」ボタン |
| コンテンツセクション | 3カラムのレイアウトで各種情報を表示 |

### 3.3 利用可能な操作

| 操作 | 説明 |
|------|------|
| 「Products」クリック | 商品一覧画面へ遷移 |
| 「Customers」クリック | 顧客一覧画面へ遷移（要認証） |
| 「Login」クリック | ログイン画面へ遷移 |
| 「Logout」クリック | ログアウト処理を実行 |
| 「Learn more」クリック | 外部サイト（YouTube）へ遷移 |

---

## 4. 【STEP1】商品情報の参照

> **業務フローでの位置**: 日常業務の最初のステップとして、取り扱い商品の確認を行います。

### 4.1 商品一覧の表示

商品一覧画面では、システムに登録されている全商品を一覧形式で確認できます。

**アクセス方法：**
1. ヘッダーメニューから「Products」をクリックします
2. または、URL `/products` に直接アクセスします

> **ポイント**: 商品一覧の参照はログインなしで利用可能です。

### 4.2 画面の見方

商品一覧画面には以下の情報が表示されます：

| 項目 | 説明 |
|------|------|
| Id | 商品ID（システムで自動採番される一意の番号） |
| Name | 商品名 |

**画面構成：**
- 画面タイトル：「Products」
- セクション見出し：「All Products」
- Exportボタン：CSVダウンロード用（→ 6章参照）
- 商品テーブル：全商品の一覧

### 4.3 操作手順

**商品情報を確認する手順：**

1. 「Products」メニューをクリックして商品一覧画面を開きます
2. テーブルに表示される商品一覧を確認します
3. 必要に応じてブラウザの検索機能（Ctrl+F / Cmd+F）で商品を検索します

---

## 5. 【STEP2】顧客情報の参照

> **業務フローでの位置**: 商品情報を確認した後、取引先の顧客情報を確認するステップです。

### 5.1 顧客一覧の表示

顧客一覧画面では、システムに登録されている全顧客を一覧形式で確認できます。

**アクセス方法：**
1. ヘッダーメニューから「Customers」をクリックします
2. または、URL `/customers` に直接アクセスします

> **重要**: 顧客情報の参照には**ログインが必要**です。未ログイン状態でアクセスすると、自動的にログイン画面に遷移します。

### 5.2 画面の見方

顧客一覧画面には以下の情報が表示されます：

| 項目 | 説明 |
|------|------|
| # | 顧客ID（5文字の英数字） |
| Name | 顧客名（会社名） |

**画面構成：**
- 画面タイトル：「Customers」
- セクション見出し：「All Customers」
- 顧客テーブル：全顧客の一覧（クリック可能）

### 5.3 顧客詳細の確認

顧客の詳細情報を確認するには、一覧から顧客行をクリックします。

**操作手順：**

1. 顧客一覧画面で、詳細を確認したい顧客の行をクリックします
2. 顧客詳細モーダルが表示されます
3. 詳細情報を確認後、モーダル外をクリックするか「×」ボタンで閉じます

**顧客詳細モーダルで確認できる情報：**

| 項目 | 説明 |
|------|------|
| 顧客ID | 顧客を識別する一意のID |
| 会社名 | 顧客の会社名 |
| 担当者名 | 取引担当者の氏名 |
| 住所 | 会社の所在地 |
| 郵便番号 | 郵便番号 |
| 国 | 所在国 |
| 電話番号 | 連絡先電話番号 |
| ファックス | FAX番号 |

---

## 6. 【STEP3】データのエクスポート

> **業務フローでの位置**: 参照した商品情報をエクスポートして、帳票作成や分析に活用するステップです。

### 6.1 商品一覧のCSVダウンロード

商品一覧をCSVファイルとしてダウンロードできます。Excelなどの表計算ソフトで開いて、分析や帳票作成に活用できます。

**操作手順：**

1. 商品一覧画面（/products）を開きます
2. 画面上部の「Export」ボタンをクリックします
3. CSVファイルのダウンロードが開始されます
4. ダウンロードフォルダにファイルが保存されます

> **ポイント**: CSVダウンロードはログインなしで利用可能です。

### 6.2 CSVファイルの内容

ダウンロードされるCSVファイルには、以下の情報が含まれます：

| 列名 | 説明 |
|------|------|
| ProductId | 商品ID |
| ProductName | 商品名 |
| UnitPrice | 単価 |
| SupplierId | 仕入先ID |
| CategoryId | カテゴリID |
| UnitsInStock | 在庫数 |
| UnitsOnOrder | 発注数 |
| ReorderLevel | 再発注レベル |
| Discontinued | 販売停止フラグ |

### 6.3 CSVファイルの活用例

- **在庫分析**: 在庫数と発注数を確認して発注計画を立てる
- **売上レポート**: 商品カテゴリ別の集計を行う
- **仕入先管理**: 仕入先別の商品一覧を作成する

---

## 7. 【STEP4】マスタ管理（管理者向け）

> **業務フローでの位置**: 管理者が商品・顧客・従業員・カテゴリのマスタ情報を管理するステップです。

### 7.1 概要

管理者は、RESTful APIを通じてマスタデータの登録・更新・削除を行うことができます。これらの操作は現在、画面からではなくAPIを直接呼び出して行います。

### 7.2 API一覧

Swagger UIを使用してAPIを確認・実行できます。

**アクセス方法：**
- URL: `https://{システムURL}/api`

**主要なAPI：**

| カテゴリ | エンドポイント | 機能 |
|---------|---------------|------|
| 商品管理 | POST /api/Products | 商品登録 |
| 商品管理 | PUT /api/Products | 商品更新 |
| 商品管理 | DELETE /api/Products/{id} | 商品削除 |
| 顧客管理 | POST /api/Customers | 顧客登録 |
| 顧客管理 | PUT /api/Customers/{id} | 顧客更新 |
| 顧客管理 | DELETE /api/Customers/{id} | 顧客削除 |
| 従業員管理 | POST /api/Employees | 従業員登録・更新 |
| 従業員管理 | DELETE /api/Employees/{id} | 従業員削除 |
| カテゴリ管理 | POST /api/Categories | カテゴリ登録・更新 |
| カテゴリ管理 | DELETE /api/Categories/{id} | カテゴリ削除 |

> **注意**: 管理APIの操作は認証が必要な場合があります。

---

## 8. 認証機能

### 8.1 認証の仕組み

本システムは、ASP.NET Core IdentityとIdentityServerを使用した認証機能を提供しています。OAuth2/OpenID Connect(OIDC)プロトコルに準拠した安全な認証を実現しています。

### 8.2 認証が必要な機能

以下の機能は認証が必要です：

| 機能 | 認証 |
|------|------|
| 商品一覧表示 | 不要 |
| 商品一覧ダウンロード | 不要 |
| 顧客一覧表示 | **必要** |
| 顧客詳細表示 | **必要** |
| マスタ管理API | **必要** |

### 8.3 セキュリティ機能

| 機能 | 説明 |
|------|------|
| アカウントロックアウト | ログイン失敗が続くとアカウントが一時的にロックされます |
| メール確認 | 新規登録時にメールアドレスの有効性を確認します |
| 二要素認証 | 設定により二要素認証を有効化できます |

---

## 9. エラー対応

### 9.1 エラー画面

システムでエラーが発生した場合、エラー画面が表示されます。

**表示される情報：**
- エラーメッセージ
- リクエストID（サポートへの問い合わせ時に必要）

### 9.2 主なエラーと対処法

| エラー | 原因 | 対処法 |
|--------|------|--------|
| 認証エラー | ログインしていない状態で認証が必要な画面にアクセス | ログインしてから再度アクセス |
| 接続エラー | サーバーに接続できない | ネットワーク接続を確認し、しばらく待ってから再試行 |
| 404 Not Found | 指定したページが存在しない | URLを確認して正しいパスにアクセス |

---

## 10. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
============================================================
【STEP 1】商品情報の参照 → 4章参照
    ↓
【STEP 2】顧客情報の参照（要ログイン） → 5章参照
    ↓
【STEP 3】データのエクスポート → 6章参照
    ↓
【STEP 4】マスタ管理（管理者向け） → 7章参照
============================================================
```

### 10.1 【一般ユーザー】STEP1-3: 日常的な情報参照

**業務シーン**: 日々の業務で商品情報や在庫状況を確認する

**手順：**

1. ブラウザでNorthwind Tradersにアクセスします
2. 「Products」メニューから商品一覧画面を開きます
3. 商品情報を確認します
4. 必要に応じて「Export」ボタンでCSVをダウンロードします

### 10.2 【認証済みユーザー】STEP2: 顧客情報の確認

**業務シーン**: 顧客への連絡や取引対応のために顧客情報を確認する

**前提条件**: ログイン済みであること

**手順：**

1. 「Customers」メニューから顧客一覧画面を開きます
2. 顧客一覧から該当する顧客を探します
3. 顧客の行をクリックして詳細モーダルを表示します
4. 連絡先や住所などの必要な情報を確認します

### 10.3 【管理者】STEP4: マスタデータの管理

**業務シーン**: 新商品の登録、顧客情報の更新、従業員の追加など

**前提条件**: 管理者権限を持つアカウントでログイン済みであること

**手順：**

1. Swagger UI（/api）にアクセスします
2. 適切なAPIエンドポイントを選択します
3. 必要なパラメータを入力してAPIを実行します
4. レスポンスを確認して操作が成功したことを確認します

---

## 11. よくある質問と対処法

### 11.1 ログインに関するQ&A

**Q: ログインできません**

A: 以下を確認してください：
- メールアドレスが正しく入力されているか
- パスワードが正しいか（Caps Lockがオフになっているか）
- アカウントがロックアウトされていないか（複数回のログイン失敗後）
- メール確認が完了しているか（新規登録後）

**Q: パスワードを忘れました**

A: ログイン画面の「Forgot your password?」リンクからパスワードリセット手続きを行ってください。

### 11.2 顧客情報に関するQ&A

**Q: 顧客一覧画面にアクセスできません**

A: 顧客情報の参照には認証が必要です。まずログインしてから再度アクセスしてください。

**Q: 顧客詳細モーダルが表示されません**

A: 顧客の行をクリックしてもモーダルが表示されない場合は、以下を確認してください：
- ブラウザのポップアップブロックが有効になっていないか
- JavaScriptが有効になっているか
- ブラウザを再読み込み（F5）してみる

### 11.3 CSVダウンロードに関するQ&A

**Q: CSVファイルがダウンロードできません**

A: 以下を確認してください：
- ブラウザのダウンロード設定でブロックされていないか
- ダウンロードフォルダに十分な空き容量があるか
- ブラウザを再起動してから再試行

**Q: CSVファイルをExcelで開くと文字化けします**

A: CSVファイルをExcelで開く際は、インポートウィザードを使用してUTF-8エンコーディングを指定してください。

---

## 12. トラブルシューティング

### 12.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| Invalid login attempt | メールアドレスまたはパスワードが間違っている | 正しい認証情報を入力してください |
| Your account is locked out | ログイン失敗が続きアカウントがロック | しばらく待ってから再試行するか、管理者に連絡 |
| You must confirm your email | メール確認が完了していない | 登録時に送信された確認メールのリンクをクリック |
| Network Error | サーバーへの接続に失敗 | インターネット接続を確認し、しばらく待ってから再試行 |

### 12.2 よくあるトラブルと解決方法

**画面が正しく表示されない場合：**
1. ブラウザのキャッシュをクリア（Ctrl+Shift+Delete）
2. ブラウザを再起動
3. 別のブラウザで試してみる

**ログイン状態が維持されない場合：**
1. ブラウザのCookie設定を確認
2. サードパーティCookieが許可されているか確認
3. ログイン時に「Remember me」をチェック

**APIが動作しない場合：**
1. 認証トークンが有効か確認
2. APIエンドポイントのURLが正しいか確認
3. リクエストボディのフォーマットが正しいか確認

### 12.3 サポートへの連絡方法

問題が解決しない場合は、以下の情報を添えてシステム管理者に連絡してください：

- エラー画面に表示されたリクエストID
- エラーが発生した操作の手順
- 使用しているブラウザとバージョン
- 発生した日時

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-07 | 初版作成 |

---

*本マニュアルは、Northwind Tradersのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
