---
generated_at: 2026-01-07 23:50:00
metrics:
  claims_total: 52
  claims_with_evidence: 45
  claims_without_evidence: 7
confidence_derived: 0.87
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された非機能要件テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 45 / 52 = 0.87
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：45 / 52、根拠なし：7
- 優先レビュー（高）
  1. **NFT-005 同時接続ユーザー数テスト**：具体的な同時接続数要件の根拠不足
  2. **NFT-044 ゼロダウンタイムデプロイテスト**：デプロイ戦略の詳細根拠不足
  3. **NFT-048 エラー発生時アラートテスト**：外部監視システム連携の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Startup.cs` - アプリケーション設定、ミドルウェア構成
- E-02: `Src/Application/Common/Behaviours/RequestPerformanceBehaviour.cs` - 性能監視実装（500ms閾値）
- E-03: `Src/Application/Common/Behaviours/RequestValidationBehavior.cs` - バリデーション実装
- E-04: `Src/Application/Common/Behaviours/RequestLogger.cs` - リクエストログ出力
- E-05: `Src/WebUI/Common/CustomExceptionHandlerMiddleware.cs` - 例外処理ミドルウェア
- E-06: `Src/Persistence/NorthwindDbContext.cs` - DBコンテキスト、監査フィールド
- E-07: `Src/WebUI/Controllers/CustomersController.cs` - 顧客API、認証設定
- E-08: `Src/WebUI/Controllers/ProductsController.cs` - 商品API、匿名アクセス許可
- E-09: `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` - ログイン処理、ロックアウト設定
- E-10: `Src/WebUI/Services/CurrentUserService.cs` - ユーザー情報取得
- E-11: `Src/Infrastructure/DependencyInjection.cs` - 認証・IdentityServer設定
- E-12: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommandValidator.cs` - バリデーションルール
- E-13: `Src/Persistence/DependencyInjection.cs` - DB接続設定
- E-14: `azure-pipelines.yml` - CI/CDパイプライン設定
- E-15: `Src/WebUI/WebUI.csproj` - パッケージ依存関係
- E-16: `Tests/Application.UnitTests/` - 単体テストプロジェクト
- E-17: `Tests/WebUI.IntegrationTests/` - 結合テストプロジェクト
- E-18: `Tests/Application.UnitTests/Mappings/MappingTests.cs` - マッピングテスト
- E-19: `Src/Application/DependencyInjection.cs` - MediatRパイプライン設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001 API応答時間テスト - 500ms閾値 | E-02 | ○ |
| C-02 | NFT-002 API応答時間テスト - 500ms閾値 | E-02 | ○ |
| C-03 | NFT-003 API応答時間テスト - 書き込み処理 | E-02, E-06 | ○ |
| C-04 | NFT-004 CSVダウンロード処理 | E-08, E-15 | ○ |
| C-05 | NFT-005 同時接続50ユーザー | **根拠なし** | △ |
| C-06 | NFT-006 DB接続プール | E-13 | ○ |
| C-07 | NFT-007 長時間稼働テスト | E-19 | ○ |
| C-08 | NFT-008 データ大量登録 | E-06 | ○ |
| C-09 | NFT-009 未認証アクセス拒否 | E-07 | ○ |
| C-10 | NFT-010 JWTトークン検証 | E-11 | ○ |
| C-11 | NFT-011 トークン有効期限 | E-11 | ○ |
| C-12 | NFT-012 アカウントロックアウト | E-09 | ○ |
| C-13 | NFT-013 2要素認証 | E-09 | ○ |
| C-14 | NFT-014 匿名アクセス許可 | E-08 | ○ |
| C-15 | NFT-015 SQLインジェクション対策 | E-06, E-13 | ○ |
| C-16 | NFT-016 XSS対策 | **根拠なし（フロントエンド）** | △ |
| C-17 | NFT-017 バリデーション境界値 | E-12 | ○ |
| C-18 | NFT-018 必須項目バリデーション | E-12 | ○ |
| C-19 | NFT-019 HTTPS強制 | E-01 | ○ |
| C-20 | NFT-020 HSTSヘッダー | E-01 | ○ |
| C-21 | NFT-021 リクエストログ | E-04 | ○ |
| C-22 | NFT-022 長時間リクエスト警告 | E-02 | ○ |
| C-23 | NFT-023 例外情報漏洩防止 | E-05 | ○ |
| C-24 | NFT-024 ヘルスチェック | E-01 | ○ |
| C-25 | NFT-025 DBヘルスチェック | E-01, E-15 | ○ |
| C-26 | NFT-026 DB障害回復 | E-13 | ○ |
| C-27 | NFT-027 起動時間30秒 | **根拠なし** | △ |
| C-28 | NFT-028 監査フィールド | E-06 | ○ |
| C-29 | NFT-029 トランザクション整合性 | E-06 | ○ |
| C-30 | NFT-030 ValidationException処理 | E-05 | ○ |
| C-31 | NFT-031 NotFoundException処理 | E-05 | ○ |
| C-32 | NFT-032 DeleteFailureException処理 | E-05 | ○ |
| C-33 | NFT-033 同一データ同時更新 | E-06 | ○ |
| C-34 | NFT-034 単体テストカバレッジ | E-16 | ○ |
| C-35 | NFT-035 結合テスト | E-17 | ○ |
| C-36 | NFT-036 AutoMapperマッピング検証 | E-18 | ○ |
| C-37 | NFT-037 OpenAPI仕様 | E-01, E-15 | ○ |
| C-38 | NFT-038 NuGetパッケージ脆弱性 | E-15 | ○ |
| C-39 | NFT-039 新規エンティティ追加 | E-06 | ○ |
| C-40 | NFT-040 新規バリデーター追加 | E-03, E-19 | ○ |
| C-41 | NFT-041 パイプラインビヘイビア追加 | E-19 | ○ |
| C-42 | NFT-042 構造化ログ出力 | E-04 | ○ |
| C-43 | NFT-043 ログレベル動的変更 | **根拠なし** | △ |
| C-44 | NFT-044 ゼロダウンタイムデプロイ | **根拠なし** | △ |
| C-45 | NFT-045 ロールバック | E-14 | ○ |
| C-46 | NFT-046 接続文字列設定 | E-13 | ○ |
| C-47 | NFT-047 環境別設定 | E-01, E-11 | ○ |
| C-48 | NFT-048 エラー時アラート | **根拠なし** | △ |
| C-49 | NFT-049 Chrome動作 | **根拠なし（Angularデフォルト）** | △ |
| C-50 | NFT-050 Edge動作 | **根拠なし（Angularデフォルト）** | △ |
| C-51 | NFT-051 OpenAPI仕様準拠 | E-01, E-15 | ○ |
| C-52 | NFT-052 SQL Server互換性 | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- **同時接続数要件**：具体的な同時接続ユーザー数の要件定義が見つからない
  - 候補：SLA文書 / 非機能要件定義書 / 負荷テスト計画書
- **デプロイ戦略**：ゼロダウンタイムデプロイの詳細設計が見つからない
  - 候補：インフラ設計書 / Azure運用マニュアル
- **監視設計**：外部監視システム連携の詳細が見つからない
  - 候補：運用設計書 / Application Insights設定
- **起動時間要件**：具体的な起動時間の要件定義が見つからない
  - 候補：SLA文書 / 運用要件定義書
- **フロントエンドセキュリティ**：Angularクライアントのサニタイズ設定詳細
  - 候補：フロントエンド設計書 / セキュリティ設計書
- **ブラウザ互換性要件**：対象ブラウザの明示的な要件定義が見つからない
  - 候補：要件定義書 / UI/UXガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 性能テスト（NFT-001〜004）、認証テスト（NFT-009〜013）
- 1: 中リスク - 負荷テスト（NFT-005〜008）、運用テスト（NFT-043〜048）
- 2: 高リスク - デプロイ関連テスト（NFT-044）、監視関連テスト（NFT-048）

## 6) レビュアーチェックリスト（最小）
- [ ] 同時接続数50ユーザーの根拠を確認（SLA文書等）
- [ ] ゼロダウンタイムデプロイの実現可能性を確認
- [ ] 外部監視システム（Application Insights等）の導入状況を確認
- [ ] 起動時間30秒の妥当性を確認
- [ ] フロントエンドのセキュリティ対策（XSS等）の実装状況を確認
- [ ] 対象ブラウザの要件を確認
- [ ] テストケースの優先度（高/中/低）の妥当性を確認
