# 非機能要件定義書

## プロジェクト概要

| 項目 | 内容 |
|------|------|
| プロジェクト名 | Northwind Traders |
| システム種別 | WebアプリケーションシステムWe Webアプリケーション (ASP.NET Core + Angular SPA) |
| フレームワーク | .NET Core 3.0 / Angular |
| アーキテクチャ | Clean Architecture |
| 対象データベース | SQL Server (LocalDB / Azure SQL) |
| ドキュメント作成日 | 2026-01-07 |
| ドキュメントバージョン | 1.0 |

---

## 1. パフォーマンス要件

### 1.1 応答時間要件

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| PRF-001 | API応答時間 | 500ms以下を目標とする | `RequestPerformanceBehaviour.cs`にて500ms超過時に警告ログを出力する実装あり |
| PRF-002 | 長時間リクエスト検知 | 500msを超過するリクエストはログに記録される | `RequestPerformanceBehaviour`で`Stopwatch`による計測を実施 |
| PRF-003 | ページ読み込み時間 | Angular SPAの初回ロードは3秒以内を目標 | プロダクションビルドで最適化される設定あり |

### 1.2 スループット要件

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| PRF-004 | 同時接続数 | 明示的な設定なし（ASP.NET Coreデフォルト） | 構成ファイルに特別な設定なし |
| PRF-005 | データベース接続 | MultipleActiveResultSets有効 | 接続文字列に`MultipleActiveResultSets=true`設定 |

### 1.3 リソース使用量

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| PRF-006 | メモリ使用量 | 明示的な制限設定なし | 構成に記載なし |
| PRF-007 | CPU使用量 | 明示的な制限設定なし | 構成に記載なし |

---

## 2. セキュリティ要件

### 2.1 認証・認可

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| SEC-001 | 認証方式 | ASP.NET Core Identity + IdentityServer4 | `DependencyInjection.cs`にIdentityServer設定あり |
| SEC-002 | 認可方式 | JWT Bearer Token認証 | `AddIdentityServerJwt()`使用 |
| SEC-003 | APIエンドポイント保護 | `[Authorize]`属性による認可制御 | `CustomersController.cs`等に適用 |
| SEC-004 | ユーザー管理 | ASP.NET Core Identity による管理 | `UserManagerService.cs`で実装 |

### 2.2 通信セキュリティ

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| SEC-005 | HTTPS強制 | 本番環境でHTTPS強制（HSTS） | `Startup.cs`にて`UseHttpsRedirection()`と`UseHsts()` |
| SEC-006 | HSTS有効期間 | デフォルト30日 | ASP.NET Coreデフォルト値 |
| SEC-007 | 開発環境HTTPS | HTTPSへのリダイレクト有効 | `UseHttpsRedirection()`実装 |

### 2.3 入力検証

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| SEC-008 | バリデーション方式 | FluentValidation使用 | `RequestValidationBehavior.cs`で一括検証 |
| SEC-009 | 入力長制限 | エンティティごとに最大長設定 | `CreateCustomerCommandValidator.cs`等で定義 |
| SEC-010 | 必須フィールド検証 | NotEmpty規則による検証 | FluentValidation規則で定義 |

### 2.4 データ保護

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| SEC-011 | パスワード保護 | ASP.NET Core Identityによるハッシュ化 | Identity標準機能使用 |
| SEC-012 | 本番環境キー管理 | 証明書ストアによる管理 | `appsettings.Production.json`で設定 |
| SEC-013 | 開発環境キー管理 | 開発用キー使用 | `appsettings.Development.json`で`Type: Development` |

### 2.5 監査証跡

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| SEC-014 | エンティティ監査 | 作成者・更新者・日時の自動記録 | `AuditableEntity.cs`と`NorthwindDbContext.cs` |
| SEC-015 | リクエストログ | 全リクエストをログに記録 | `RequestLogger.cs`で実装 |

---

## 3. 可用性要件

### 3.1 稼働時間

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| AVL-001 | 目標稼働率 | 明示的な設定なし | SLA定義なし |
| AVL-002 | 計画停止 | 定義なし | 構成に記載なし |

### 3.2 ヘルスチェック

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| AVL-003 | ヘルスチェックエンドポイント | `/health`エンドポイント提供 | `Startup.cs`にて`UseHealthChecks("/health")` |
| AVL-004 | データベースヘルスチェック | DbContext接続確認 | `AddDbContextCheck<NorthwindDbContext>()`設定 |

### 3.3 エラー処理

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| AVL-005 | 例外ハンドリング | カスタム例外ハンドラーによる一元処理 | `CustomExceptionHandlerMiddleware.cs` |
| AVL-006 | HTTP状態コード | 例外種別に応じたコード返却 | ValidationException->400, NotFoundException->404等 |
| AVL-007 | 開発環境エラー表示 | 詳細エラーページ表示 | `UseDeveloperExceptionPage()`使用 |
| AVL-008 | 本番環境エラー表示 | 汎用エラーページ表示 | `UseExceptionHandler("/Error")`使用 |

---

## 4. スケーラビリティ要件

### 4.1 水平スケーリング

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| SCL-001 | ステートレス設計 | セッション状態をサーバー外に保持可能 | JWT認証によるステートレス設計 |
| SCL-002 | データベース共有 | 複数インスタンスでDB共有可能 | SQL Server使用 |

### 4.2 垂直スケーリング

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| SCL-003 | リソース上限設定 | 明示的な設定なし | 構成に記載なし |

---

## 5. 保守性要件

### 5.1 アーキテクチャ

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| MNT-001 | 設計パターン | Clean Architecture採用 | Domain, Application, Infrastructure, Persistence, WebUIの層分離 |
| MNT-002 | 依存性注入 | DIコンテナによる疎結合化 | `DependencyInjection.cs`で各層のサービス登録 |
| MNT-003 | CQRSパターン | MediatRによるCommand/Query分離 | Application層でCQRS実装 |

### 5.2 コード品質

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| MNT-004 | オブジェクトマッピング | AutoMapper使用 | `DependencyInjection.cs`にて`AddAutoMapper()` |
| MNT-005 | 入力検証 | FluentValidation使用 | FluentValidation 8.5.0使用 |
| MNT-006 | データベースマイグレーション | EF Core Migrations使用 | Migrations フォルダにマイグレーション履歴 |

### 5.3 テスト

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| MNT-007 | 単体テスト | xUnit使用 | Application.UnitTests, Domain.UnitTestsプロジェクト |
| MNT-008 | 統合テスト | ASP.NET Core TestServer使用 | WebUI.IntegrationTestsプロジェクト |
| MNT-009 | E2Eテスト | Protractor使用 | ClientApp/e2eディレクトリ |
| MNT-010 | インメモリDB | テスト用InMemoryDB使用 | `Microsoft.EntityFrameworkCore.InMemory`パッケージ |

---

## 6. 運用性要件

### 6.1 ログ管理

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| OPR-001 | ログレベル（開発） | Debug | `appsettings.Development.json`設定 |
| OPR-002 | ログレベル（本番） | Debug（調整推奨） | `appsettings.Production.json`設定 |
| OPR-003 | ログレベル（デフォルト） | Warning | `appsettings.json`設定 |
| OPR-004 | パフォーマンスログ | 長時間リクエストの警告出力 | `RequestPerformanceBehaviour.cs` |
| OPR-005 | リクエストログ | 全リクエストのInformationログ | `RequestLogger.cs` |

### 6.2 CI/CD

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| OPR-006 | ビルドパイプライン | Azure DevOps Pipelines | `azure-pipelines.yml`定義 |
| OPR-007 | ビルド構成 | Release構成 | `buildConfiguration: 'Release'` |
| OPR-008 | ターゲットランタイム | win-x86 (self-contained) | `--runtime win-x86`オプション |
| OPR-009 | トリガー | masterブランチへのプッシュ | `trigger: master`設定 |
| OPR-010 | ビルドエージェント | ubuntu-latest | `vmImage: 'ubuntu-latest'` |

### 6.3 デプロイ

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| OPR-011 | デプロイ先 | Azure App Service想定 | appsettings.Production.jsonのCN名 |
| OPR-012 | 発行形式 | ZIPパッケージ | `zipAfterPublish: True` |
| OPR-013 | 成果物名 | Drop | `artifactName: 'Drop'` |

---

## 7. 相互運用性要件

### 7.1 API仕様

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| IOP-001 | API仕様書 | OpenAPI (Swagger)自動生成 | NSwag使用、`nswag.json`設定 |
| IOP-002 | Swagger UI | `/api`エンドポイントで提供 | `UseSwaggerUi3()`設定 |
| IOP-003 | APIルーティング | RESTful API設計 | `api/[controller]/[action]`パターン |

### 7.2 クライアント連携

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| IOP-004 | TypeScriptクライアント生成 | NSwagによる自動生成 | ClientApp/nswag.json設定 |
| IOP-005 | JSONシリアライズ | Newtonsoft.Json使用 | `AddNewtonsoftJson()`設定 |

---

## 8. 移植性要件

### 8.1 プラットフォーム

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| POR-001 | ターゲットフレームワーク | .NET Core 3.0 | `global.json`, `*.csproj`設定 |
| POR-002 | ライブラリ互換性 | .NET Standard 2.1 | Application層のターゲット |
| POR-003 | データベース | SQL Server依存 | `UseSqlServer()`使用 |

### 8.2 ブラウザ対応

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| POR-004 | サポートブラウザ | Angular CLI browserslist準拠 | `ClientApp/browserslist`設定 |

---

## 9. その他の品質要件

### 9.1 開発者体験

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| DXP-001 | 開発サーバー連携 | Angular開発サーバーへのプロキシ | `UseProxyToSpaDevelopmentServer("http://localhost:4200")` |
| DXP-002 | サービス一覧表示 | 開発環境でDIサービス一覧表示 | `/services`エンドポイント |
| DXP-003 | ホットリロード | Angular CLI開発サーバー使用 | 開発モード設定 |

### 9.2 データ整合性

| 要件ID | 項目 | 要件内容 | 根拠 |
|--------|------|----------|------|
| DIN-001 | エンティティ設定 | Fluent APIによる詳細設定 | Persistence/Configurationsディレクトリ |
| DIN-002 | サンプルデータ | シードデータの提供 | `SampleDataSeeder.cs` |

---

## 付録A: 技術スタック一覧

| 分類 | 技術/ライブラリ | バージョン |
|------|-----------------|------------|
| バックエンドフレームワーク | ASP.NET Core | 3.0 |
| フロントエンドフレームワーク | Angular | - |
| ORM | Entity Framework Core | 3.0.0 |
| 認証 | IdentityServer4 | - |
| マッピング | AutoMapper | 9.0.0 |
| バリデーション | FluentValidation | 8.5.0-preview5 |
| CQRS/Mediator | MediatR | 7.0.0 |
| API仕様 | NSwag | 13.1.2 |
| テスト | xUnit | 2.4.1 |
| データベース | SQL Server | - |

---

## 付録B: 環境別設定一覧

| 設定項目 | Development | Production | Test |
|----------|-------------|------------|------|
| ログレベル（Default） | Debug | Debug | Debug |
| ログレベル（System） | Information | Information | Information |
| ログレベル（Microsoft） | Information | Information | Information |
| IdentityServer Key Type | Development | Store | Development |
| 証明書 | - | CN=northwindtraders.azurewebsites.net | - |

---

## 付録C: エンドポイント一覧

| エンドポイント | 用途 | 認証要否 |
|----------------|------|----------|
| `/health` | ヘルスチェック | 不要 |
| `/api` | Swagger UI | 不要 |
| `/api/Customers/*` | 顧客管理API | 必要 |
| `/api/Products/*` | 商品管理API | 必要 |
| `/api/Categories/*` | カテゴリ管理API | 必要 |
| `/api/Employees/*` | 従業員管理API | 必要 |
| `/services` | DIサービス一覧（開発環境のみ） | 不要 |

---

## 変更履歴

| バージョン | 日付 | 変更者 | 変更内容 |
|------------|------|--------|----------|
| 1.0 | 2026-01-07 | 自動生成 | 初版作成 |
