# API設計書

## 概要

本ドキュメントは、AureusERP（Laravel + Filament v4ベースのオープンソースERPシステム）のAPI仕様を記載したものです。このシステムは主にFilamentの管理パネル（Livewireベース）を通じてデータ操作を行うアーキテクチャを採用しており、従来のREST APIは限定的に提供されています。

## 共通仕様

### ベースURL

```
管理パネル: {APP_URL}/admin
顧客ポータル: {APP_URL}/
```

### 認証方式

| 認証方式 | 説明 | 対象 |
| --- | --- | --- |
| セッション認証（Web Guard） | Laravelのセッションベース認証 | 管理者ユーザー |
| セッション認証（Customer Guard） | 顧客向けセッションベース認証 | 顧客ユーザー |
| 署名付きURL（Signed URL） | 時限付き署名URLによる認証 | 公開エンドポイント |

### 共通ヘッダー

| ヘッダー名 | 必須 | 説明 |
| --- | --- | --- |
| Cookie | ○ | セッションCookie |
| X-CSRF-TOKEN | ○ | CSRF保護トークン |
| Content-Type | ○ | application/json |
| Accept | - | application/json |

### 共通エラーレスポンス

| ステータスコード | 説明 |
| --- | --- |
| 400 | Bad Request - リクエストパラメータ不正 |
| 401 | Unauthorized - 認証エラー |
| 403 | Forbidden - 権限エラー（Filament Shield連携） |
| 404 | Not Found - リソース未検出 |
| 419 | CSRF Token Mismatch - CSRFトークン不一致 |
| 422 | Unprocessable Entity - バリデーションエラー |
| 500 | Internal Server Error - サーバーエラー |

### ミドルウェア構成

#### 管理パネル（Admin Panel）
- `EncryptCookies` - Cookie暗号化
- `StartSession` - セッション開始
- `AuthenticateSession` - セッション認証
- `VerifyCsrfToken` - CSRF保護
- `SubstituteBindings` - ルートモデルバインディング
- `Authenticate` - 認証必須

#### 顧客ポータル（Customer Panel）
- `EncryptCookies` - Cookie暗号化
- `StartSession` - セッション開始
- `AuthenticateSession` - セッション認証（customer guard）
- `VerifyCsrfToken` - CSRF保護

## API一覧

### Webエンドポイント（従来のHTTPルート）

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| 認証 | /admin/login | GET/POST | 管理者ログイン |
| 認証 | /login | GET | 顧客ログインへリダイレクト |
| 購買 | /purchase/{order}/{action} | GET | 見積回答（署名付きURL） |
| セキュリティ | /invitation/{invitation}/accept | GET | 招待承諾（署名付きURL） |
| キャッシュ | /cache/{filename} | GET | 画像キャッシュ取得 |

### Filamentリソースエンドポイント（Livewireベース）

Filamentリソースは、Livewire経由でCRUD操作を提供します。各リソースは以下のURLパターンでアクセスされます。

#### URLパターン

| 操作 | URLパターン | 例 |
| --- | --- | --- |
| 一覧 | /admin/{resource} | /admin/users |
| 作成 | /admin/{resource}/create | /admin/users/create |
| 表示 | /admin/{resource}/{record} | /admin/users/1 |
| 編集 | /admin/{resource}/{record}/edit | /admin/users/1/edit |
| サブページ | /admin/{resource}/{record}/{page} | /admin/orders/1/invoices |

## 各APIエンドポイント定義

### 認証関連

#### 1. 管理者ログイン

管理者の認証を行う

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET/POST /admin/login` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（POST）**

```json
{
  "email": "admin@example.com",
  "password": "password",
  "remember": true
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| email | string | ○ | email形式、max:255 | ログインメールアドレス |
| password | string | ○ | min:8 | パスワード |
| remember | boolean | - | - | ログイン状態を維持 |

**レスポンス（成功時）**

ステータスコード: `302 Redirect`

ダッシュボードへリダイレクト

**レスポンス（エラー時）**

ステータスコード: `422 Unprocessable Entity`

```json
{
  "message": "These credentials do not match our records.",
  "errors": {
    "email": ["These credentials do not match our records."]
  }
}
```

---

### 購買管理

#### 2. 見積回答

ベンダーが見積（RFQ）に対して承諾または拒否を行う

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /purchase/{order}/{action}` |
| 認証 | 署名付きURL（signed） |
| 権限 | なし（署名で認証） |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| order | integer | ○ | 注文ID |
| action | string | ○ | アクション（accept/decline） |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| signature | string | ○ | - | URL署名 |
| expires | integer | ○ | - | 有効期限タイムスタンプ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Livewireコンポーネントによる結果画面表示

**処理内容**
- `accept`: `mail_reception_confirmed`を`true`に設定し、承諾メッセージを追加
- `decline`: `mail_reception_declined`を`true`に設定し、拒否メッセージを追加

---

### セキュリティ管理

#### 3. 招待承諾

ユーザー招待を承諾し、アカウントを作成する

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /invitation/{invitation}/accept` |
| 認証 | 署名付きURL（signed） |
| 権限 | なし（署名で認証） |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| invitation | integer | ○ | 招待ID |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| signature | string | ○ | - | URL署名 |
| expires | integer | ○ | - | 有効期限タイムスタンプ |

**フォーム入力（Livewire）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| name | string | ○ | max:255 | ユーザー名 |
| email | string | - | - | メールアドレス（招待から自動設定、編集不可） |
| password | string | ○ | min:8、same:passwordConfirmation | パスワード |
| passwordConfirmation | string | ○ | - | パスワード確認 |

**レスポンス（成功時）**

ステータスコード: `302 Redirect`

ダッシュボードへリダイレクト

---

### 画像キャッシュ

#### 4. 画像キャッシュ取得

キャッシュされた画像を取得する

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /cache/{filename}` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| filename | string | ○ | ファイル名（正規表現: `[ \w\.\/-\@\(\)\=]+`） |

**レスポンス（成功時）**

ステータスコード: `200 OK`

| ヘッダー | 値 |
| --- | --- |
| Content-Type | image/png（または適切なMIMEタイプ） |
| Cache-Control | max-age=10080, public |
| Etag | {コンテンツハッシュ} |

**レスポンス（キャッシュヒット時）**

ステータスコード: `304 Not Modified`

---

## Filamentリソース一覧

### セキュリティモジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| UserResource | User | /admin/users | ユーザー管理 |
| RoleResource | Role | /admin/roles | ロール管理 |
| CompanyResource | Company | /admin/companies | 会社管理 |
| TeamResource | Team | /admin/teams | チーム管理 |

### 連絡先モジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| PartnerResource | Partner | /admin/contacts/partners | パートナー管理 |
| AddressResource | Address | /admin/contacts/addresses | 住所管理 |
| BankResource | Bank | /admin/contacts/configurations/banks | 銀行管理 |
| BankAccountResource | BankAccount | /admin/contacts/configurations/bank-accounts | 銀行口座管理 |
| IndustryResource | Industry | /admin/contacts/configurations/industries | 業種管理 |
| TitleResource | Title | /admin/contacts/configurations/titles | 敬称管理 |
| TagResource | Tag | /admin/contacts/configurations/tags | タグ管理 |

### 販売モジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| QuotationResource | Order | /admin/sales/orders/quotations | 見積管理 |
| OrderResource | Order | /admin/sales/orders/orders | 受注管理 |
| CustomerResource | Partner | /admin/sales/orders/customers | 顧客管理 |
| ProductResource | Product | /admin/sales/products | 製品管理 |
| TeamResource | Team | /admin/sales/configuration/teams | 営業チーム |
| ActivityPlanResource | ActivityPlan | /admin/sales/configuration/activity-plans | アクティビティプラン |
| ActivityTypeResource | ActivityType | /admin/sales/configuration/activity-types | アクティビティタイプ |
| TagResource | Tag | /admin/sales/configuration/tags | タグ |
| PackagingResource | Packaging | /admin/sales/configuration/packagings | パッケージング |
| ProductAttributeResource | Attribute | /admin/sales/configuration/product-attributes | 製品属性 |
| ProductCategoryResource | Category | /admin/sales/configuration/product-categories | 製品カテゴリ |
| OrderToInvoiceResource | Order | /admin/sales/to-invoice/orders | 請求待ち受注 |
| OrderToUpsellResource | Order | /admin/sales/to-invoice/upsells | アップセル機会 |

### 購買モジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| QuotationResource | Order | /admin/purchases/orders/quotations | 見積依頼管理 |
| PurchaseOrderResource | Order | /admin/purchases/orders/purchase-orders | 発注管理 |
| OrderResource | Order | /admin/purchases/orders/orders | 注文管理 |
| VendorResource | Partner | /admin/purchases/orders/vendors | ベンダー管理 |
| PurchaseAgreementResource | Order | /admin/purchases/orders/agreements | 購買契約 |
| ProductResource | Product | /admin/purchases/products | 製品管理 |
| VendorPriceResource | ProductSupplier | /admin/purchases/configurations/vendor-prices | ベンダー価格 |
| PackagingResource | Packaging | /admin/purchases/configurations/packagings | パッケージング |
| ProductAttributeResource | Attribute | /admin/purchases/configurations/product-attributes | 製品属性 |
| ProductCategoryResource | Category | /admin/purchases/configurations/product-categories | 製品カテゴリ |

### 請求モジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| InvoiceResource | Invoice | /admin/invoices/customer/invoices | 請求書管理 |
| CreditNotesResource | CreditNote | /admin/invoices/customer/credit-notes | クレジットノート |
| PaymentsResource | Payment | /admin/invoices/customer/payments | 入金管理 |
| PartnerResource | Partner | /admin/invoices/customer/partners | 顧客管理 |
| BillResource | Bill | /admin/invoices/vendors/bills | 請求書（仕入） |
| RefundResource | Refund | /admin/invoices/vendors/refunds | 返金管理 |
| VendorResource | Partner | /admin/invoices/vendors/vendors | ベンダー管理 |
| TaxResource | Tax | /admin/invoices/configuration/taxes | 税金設定 |
| TaxGroupResource | TaxGroup | /admin/invoices/configuration/tax-groups | 税グループ |
| PaymentTermResource | PaymentTerm | /admin/invoices/configuration/payment-terms | 支払条件 |
| IncoTermResource | Incoterm | /admin/invoices/configuration/incoterms | インコタームズ |
| BankAccountResource | BankAccount | /admin/invoices/configuration/bank-accounts | 銀行口座 |

### 在庫モジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| ProductResource | Product | /admin/inventories/products | 製品管理 |
| LotResource | Lot | /admin/inventories/products/lots | ロット管理 |
| PackageResource | Package | /admin/inventories/products/packages | パッケージ管理 |
| ReceiptResource | Operation | /admin/inventories/operations/receipts | 入荷管理 |
| DeliveryResource | Operation | /admin/inventories/operations/deliveries | 出荷管理 |
| InternalResource | Operation | /admin/inventories/operations/internals | 内部移動 |
| DropshipResource | Operation | /admin/inventories/operations/dropships | ドロップシップ |
| ScrapResource | Scrap | /admin/inventories/operations/scraps | 廃棄管理 |
| QuantityResource | Quantity | /admin/inventories/operations/quantities | 数量管理 |
| ReplenishmentResource | OrderPoint | /admin/inventories/operations/replenishments | 補充管理 |
| WarehouseResource | Warehouse | /admin/inventories/configurations/warehouses | 倉庫管理 |
| LocationResource | Location | /admin/inventories/configurations/locations | ロケーション |
| RouteResource | Route | /admin/inventories/configurations/routes | ルート管理 |
| RuleResource | Rule | /admin/inventories/configurations/rules | ルール管理 |
| OperationTypeResource | OperationType | /admin/inventories/configurations/operation-types | 操作タイプ |
| PackageTypeResource | PackageType | /admin/inventories/configurations/package-types | パッケージタイプ |
| StorageCategoryResource | StorageCategory | /admin/inventories/configurations/storage-categories | 保管カテゴリ |
| PackagingResource | Packaging | /admin/inventories/configurations/packagings | パッケージング |
| ProductAttributeResource | Attribute | /admin/inventories/configurations/product-attributes | 製品属性 |
| ProductCategoryResource | Category | /admin/inventories/configurations/product-categories | 製品カテゴリ |

### プロジェクトモジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| ProjectResource | Project | /admin/projects | プロジェクト管理 |
| TaskResource | Task | /admin/tasks | タスク管理 |
| TaskStageResource | TaskStage | /admin/projects/configurations/task-stages | タスクステージ |
| ProjectStageResource | ProjectStage | /admin/projects/configurations/project-stages | プロジェクトステージ |
| MilestoneResource | Milestone | /admin/projects/configurations/milestones | マイルストーン |
| TagResource | Tag | /admin/projects/configurations/tags | タグ |
| ActivityPlanResource | ActivityPlan | /admin/projects/configurations/activity-plans | アクティビティプラン |

### 従業員モジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| EmployeeResource | Employee | /admin/employees | 従業員管理 |
| DepartmentResource | Department | /admin/employees/configurations/departments | 部門管理 |
| JobPositionResource | JobPosition | /admin/employees/configurations/job-positions | 職位管理 |
| SkillTypeResource | SkillType | /admin/employees/configurations/skill-types | スキルタイプ |

### 休暇管理モジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| MyTimeOffResource | Leave | /admin/time-off/my-time/time-offs | 自分の休暇申請 |
| MyAllocationResource | LeaveAllocation | /admin/time-off/my-time/allocations | 自分の休暇割当 |
| TimeOffResource | Leave | /admin/time-off/management/time-offs | 休暇管理 |
| AllocationResource | LeaveAllocation | /admin/time-off/management/allocations | 割当管理 |
| ByEmployeeResource | Leave | /admin/time-off/reporting/by-employee | 従業員別レポート |
| LeaveTypeResource | LeaveType | /admin/time-off/configurations/leave-types | 休暇タイプ |
| AccrualPlanResource | LeaveAccrualPlan | /admin/time-off/configurations/accrual-plans | 積立プラン |
| PublicHolidayResource | CalendarLeave | /admin/time-off/configurations/public-holidays | 祝日管理 |
| MandatoryDayResource | LeaveMandatoryDay | /admin/time-off/configurations/mandatory-days | 必須出勤日 |

### 採用モジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| ApplicantResource | Applicant | /admin/recruitments/applications/applicants | 応募者管理 |
| CandidateResource | Candidate | /admin/recruitments/applications/candidates | 候補者管理 |
| JobByPositionResource | JobPosition | /admin/recruitments/applications/jobs | 求人管理 |
| JobPositionResource | JobPosition | /admin/recruitments/configurations/job-positions | 職位設定 |
| StageResource | Stage | /admin/recruitments/configurations/stages | ステージ設定 |
| DegreeResource | Degree | /admin/recruitments/configurations/degrees | 学位設定 |
| RefuseReasonResource | RefuseReason | /admin/recruitments/configurations/refuse-reasons | 不採用理由 |
| SkillTypeResource | SkillType | /admin/recruitments/configurations/skill-types | スキルタイプ |
| EmploymentTypeResource | EmploymentType | /admin/recruitments/configurations/employment-types | 雇用形態 |
| ApplicantCategoryResource | ApplicantCategory | /admin/recruitments/configurations/applicant-categories | 応募者カテゴリ |
| DepartmentResource | Department | /admin/recruitments/configurations/departments | 部門設定 |

### タイムシートモジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| TimesheetResource | Timesheet | /admin/timesheets | タイムシート管理 |

### ブログモジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| PostResource | Post | /admin/blogs/posts | 投稿管理 |
| CategoryResource | Category | /admin/blogs/configurations/categories | カテゴリ管理 |
| TagResource | Tag | /admin/blogs/configurations/tags | タグ管理 |

### Webサイトモジュール

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| PageResource | Page | /admin/website/pages | ページ管理 |
| PartnerResource | Partner | /admin/website/partners | パートナー管理 |

### プラグイン管理

| リソース | モデル | パス | 説明 |
| --- | --- | --- | --- |
| PluginResource | Plugin | /admin/plugins | プラグイン管理 |

---

## Livewireエンドポイント

Filamentはすべてのリソース操作をLivewireを通じて実行します。Livewireリクエストは以下の形式で送信されます。

### Livewireリクエスト

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /livewire/update` |
| 認証 | セッション認証 |
| Content-Type | application/json |

**リクエストボディ**

```json
{
  "components": [
    {
      "snapshot": "{...}",
      "updates": {},
      "calls": [
        {
          "path": "",
          "method": "create",
          "params": []
        }
      ]
    }
  ]
}
```

---

## 権限管理（Filament Shield）

本システムはFilament Shieldを使用してロールベースの権限管理を実装しています。

### 権限タイプ

| 権限 | 説明 |
| --- | --- |
| view_any | 一覧表示 |
| view | 個別表示 |
| create | 作成 |
| update | 更新 |
| delete | 削除 |
| delete_any | 一括削除 |
| restore | 復元 |
| restore_any | 一括復元 |
| force_delete | 完全削除 |
| force_delete_any | 一括完全削除 |

### リソース権限パターン

権限名は以下の形式で構成されます:

```
{permission}_{resource}
```

例:
- `view_any_user` - ユーザー一覧表示
- `create_order` - 注文作成
- `delete_product` - 製品削除

---

## ユーザーリソース権限

システムでは3種類のリソース権限レベルをサポートしています。

| 権限レベル | 説明 |
| --- | --- |
| GLOBAL | すべてのリソースにアクセス可能 |
| GROUP | 所属チームのリソースのみアクセス可能 |
| INDIVIDUAL | 自分が作成したリソースのみアクセス可能 |

---

## 備考

### アーキテクチャ特性

1. **Filamentベース**: 本システムは従来のREST APIではなく、Filament管理パネルを通じてすべてのCRUD操作を提供しています。

2. **Livewire通信**: すべてのデータ操作はLivewireを介して行われ、リアルタイムでUIが更新されます。

3. **プラグインアーキテクチャ**: 機能はプラグインとしてモジュール化されており、`plugins/webkul/` ディレクトリに配置されています。

4. **マルチテナント対応**: Company（会社）単位でデータを分離し、ユーザーは複数の会社にアクセス可能です。

### 外部API連携について

本システムは現時点で外部向けのREST APIを提供していません。外部システムとの連携が必要な場合は、以下の選択肢を検討してください:

1. **Laravel Sanctum/Passport導入**: APIトークン認証の追加
2. **カスタムAPIコントローラー作成**: 必要なエンドポイントの個別実装
3. **Webhooks実装**: イベント駆動型の連携

### セキュリティ考慮事項

1. **CSRF保護**: すべてのPOSTリクエストにCSRFトークンが必要です
2. **セッション管理**: セッションはデータベースまたはファイルで管理されます
3. **パスワードポリシー**: 最小8文字、確認入力必須
4. **署名付きURL**: 有効期限付きの一時的なアクセスを提供

### 推奨事項

1. 本番環境では必ずHTTPSを使用してください
2. セッションの有効期限を適切に設定してください
3. Filament Shieldを使用して適切な権限設定を行ってください
4. 定期的にセキュリティアップデートを適用してください
