# Aureus ERP

## 概要

Aureus ERPは、中小企業（SME）から大規模企業向けに設計された、包括的なオープンソースのエンタープライズリソースプランニング（ERP）ソリューションです。LaravelフレームワークとFilamentPHPを基盤に構築され、財務、人事、在庫管理、CRM、プロジェクト管理など、ビジネス運営のあらゆる側面を管理するための拡張可能で開発者フレンドリーなプラットフォームを提供します。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| プラグインアーキテクチャ | モジュール式プラグインシステムにより、必要な機能のみを選択してインストール可能 |
| セキュリティ管理 | Filament Shieldによるロールベースのアクセス制御と認証機能 |
| 財務会計 | 会計、請求書、支払い処理と追跡機能 |
| 人事管理 | 従業員管理、採用、休暇管理、タイムシート機能 |
| 在庫管理 | 在庫および倉庫管理機能 |
| 販売・購買管理 | 販売パイプライン、購買発注管理機能 |
| プロジェクト管理 | プロジェクト計画と管理機能 |
| カスタムフィールド | カスタマイズ可能なデータ構造管理 |
| 内部コミュニケーション | Chatterによる社内コミュニケーション・コラボレーション機能 |
| 分析・レポート | ビジネスインテリジェンスとレポートツール |
| Webサイト機能 | 顧客向けWebサイト構築機能 |
| ブログ機能 | ブログ管理機能 |

## 技術スタック

### コア

- フレームワーク: Laravel 11.x
- 言語: PHP 8.2以上
- 管理パネル: FilamentPHP 4.x
- データベース: MySQL 8.0+ / SQLite
- フロントエンドビルド: Vite 5.x

### 主要ライブラリ

- bezhansalleh/filament-shield: ロール・権限管理
- barryvdh/laravel-dompdf: PDF生成
- spatie/eloquent-sortable: ソート機能
- flowframe/laravel-trend: トレンド分析
- guava/filament-icon-picker: アイコン選択
- hugomyb/filament-media-action: メディアアクション
- awcodes/filament-badgeable-column: バッジ付きカラム
- milon/barcode: バーコード生成
- wikimedia/composer-merge-plugin: プラグインcomposer統合

### フロントエンド

- TailwindCSS 4.x
- PostCSS
- Axios

## ディレクトリ構成

```
aureuserp-master/
├── app/                    # アプリケーションコア
│   ├── Http/              # HTTPレイヤー（コントローラ等）
│   ├── Models/            # Eloquentモデル
│   └── Providers/         # サービスプロバイダー
├── bootstrap/              # フレームワーク起動ファイル
├── config/                 # 設定ファイル
│   ├── app.php            # アプリケーション設定
│   ├── auth.php           # 認証設定
│   ├── database.php       # データベース設定
│   ├── filament.php       # Filament設定
│   ├── filament-shield.php # 権限管理設定
│   └── ...
├── database/               # データベース関連
│   ├── factories/         # モデルファクトリ
│   ├── migrations/        # マイグレーション
│   └── seeders/           # シーダー
├── lang/                   # 言語ファイル
├── plugins/                # プラグインディレクトリ
│   └── webkul/            # Webkul製プラグイン
│       ├── accounts/      # 財務会計
│       ├── analytics/     # 分析
│       ├── blogs/         # ブログ
│       ├── chatter/       # 内部コミュニケーション
│       ├── contacts/      # 連絡先管理
│       ├── employees/     # 従業員管理
│       ├── fields/        # カスタムフィールド
│       ├── full-calendar/ # カレンダー
│       ├── inventories/   # 在庫管理
│       ├── invoices/      # 請求書
│       ├── partners/      # パートナー管理
│       ├── payments/      # 支払い
│       ├── plugin-manager/# プラグイン管理
│       ├── products/      # 製品管理
│       ├── projects/      # プロジェクト管理
│       ├── purchases/     # 購買管理
│       ├── recruitments/  # 採用管理
│       ├── sales/         # 販売管理
│       ├── security/      # セキュリティ
│       ├── support/       # サポート
│       ├── table-views/   # テーブルビュー
│       ├── time-off/      # 休暇管理
│       ├── timesheets/    # タイムシート
│       └── website/       # Webサイト
├── public/                 # 公開ディレクトリ
├── resources/              # リソース
│   ├── css/               # スタイルシート
│   ├── js/                # JavaScript
│   ├── svg/               # SVGファイル
│   └── views/             # Bladeビュー
├── routes/                 # ルート定義
│   ├── console.php        # コンソールルート
│   └── web.php            # Webルート
├── storage/                # ストレージ
├── tests/                  # テスト
│   ├── Feature/           # 機能テスト
│   └── Unit/              # 単体テスト
├── composer.json           # Composer依存関係
├── package.json            # NPM依存関係
├── phpunit.xml             # PHPUnit設定
├── tailwind.config.js      # TailwindCSS設定
├── vite.config.js          # Vite設定
└── artisan                 # Artisanコマンド
```

## セットアップ

### 必要条件

- PHP 8.2以上
- Composer（最新版）
- Node.js & NPM（最新安定版）
- MySQL 8.0+ または SQLite
- Apache / Nginx（必要なPHP拡張: OpenSSL, PDO, Mbstring, Tokenizer, XML, Ctype, JSON）

### インストール手順

1. **リポジトリのクローン**

   ```bash
   git clone https://github.com/aureuserp/aureuserp.git
   cd aureuserp
   ```

2. **依存関係のインストール**

   ```bash
   composer install
   npm install
   ```

3. **環境設定**

   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

4. **データベース設定**

   `.env`ファイルでデータベース接続を設定します。デフォルトはSQLiteです。

   ```env
   DB_CONNECTION=sqlite
   # または MySQL を使用する場合
   # DB_CONNECTION=mysql
   # DB_HOST=127.0.0.1
   # DB_PORT=3306
   # DB_DATABASE=aureuserp
   # DB_USERNAME=root
   # DB_PASSWORD=
   ```

5. **ERPインストールコマンドの実行**

   ```bash
   php artisan erp:install
   ```

   このコマンドにより以下が実行されます：
   - マイグレーションとシーダーの実行
   - Filament Shieldによるロール・権限の生成
   - 管理者アカウントの作成（メールアドレスとパスワードの入力プロンプト）

6. **フロントエンドアセットのビルド**

   ```bash
   npm run build
   ```

## 開発

### 開発サーバーの起動

開発用に複数のサービスを同時起動する統合コマンドが用意されています：

```bash
composer dev
```

このコマンドは以下を並行起動します：
- `php artisan serve` - Laravelサーバー
- `php artisan queue:listen` - キューワーカー
- `php artisan pail` - ログビューア
- `npm run dev` - Vite開発サーバー

### Linter / Formatter

Laravel Pintを使用してコードフォーマットを行います：

```bash
./vendor/bin/pint
```

設定は`pint.json`に定義されています。

### テストの実行

PHPUnitによるテスト実行：

```bash
php artisan test
# または
./vendor/bin/phpunit
```

テストスイート：
- Unit: `tests/Unit`
- Feature: `tests/Feature`

### プラグインのインストール

```bash
php artisan <plugin-name>:install
```

例：在庫管理プラグインのインストール

```bash
php artisan inventories:install
```

### プラグインのアンインストール

```bash
php artisan <plugin-name>:uninstall
```

## ライセンス

MIT License - 詳細は[LICENSE](../../LICENSE)ファイルを参照してください。
