# インフラ構成図

## 全体システム構成図

```mermaid
graph TB
    subgraph "インターネット"
        User[ユーザー/ブラウザ]
    end

    subgraph "ロードバランサー層"
        LB[ロードバランサー<br/>Nginx/ALB]
    end

    subgraph "Web/AP層"
        WEB1[Webサーバー 1<br/>Apache/Nginx]
        WEB2[Webサーバー 2<br/>Apache/Nginx]

        subgraph "アプリケーション"
            PHP1[PHP 8.2+<br/>Laravel 11.x]
            PHP2[PHP 8.2+<br/>Laravel 11.x]
            FILAMENT[FilamentPHP 4.x<br/>管理パネル]
        end
    end

    subgraph "キュー処理層"
        QUEUE[Queue Worker<br/>php artisan queue:listen]
        SCHEDULER[Scheduler<br/>php artisan schedule:run]
    end

    subgraph "データ層"
        subgraph "データベース"
            DB[(SQLite / MySQL 8.0+<br/>PostgreSQL / MariaDB)]
        end

        subgraph "キャッシュ/セッション"
            CACHE[(Redis / Memcached<br/>/ Database Cache)]
        end

        subgraph "ストレージ"
            STORAGE[(Local Storage<br/>storage/app)]
            S3[(AWS S3<br/>オプション)]
        end
    end

    subgraph "外部サービス"
        MAIL[メールサービス<br/>SMTP/SES/Postmark]
        SLACK[Slack<br/>通知/ログ]
    end

    User --> LB
    LB --> WEB1
    LB --> WEB2
    WEB1 --> PHP1
    WEB2 --> PHP2
    PHP1 --> FILAMENT
    PHP2 --> FILAMENT
    PHP1 --> DB
    PHP2 --> DB
    PHP1 --> CACHE
    PHP2 --> CACHE
    PHP1 --> STORAGE
    PHP2 --> STORAGE
    STORAGE -.-> S3
    QUEUE --> DB
    QUEUE --> CACHE
    SCHEDULER --> DB
    PHP1 --> MAIL
    PHP2 --> MAIL
    PHP1 --> SLACK
    PHP2 --> SLACK
```

## レイヤー別構成図

### アプリケーション層詳細

```mermaid
graph LR
    subgraph "フロントエンド"
        VITE[Vite 5.x<br/>ビルドツール]
        TAILWIND[TailwindCSS 4.x<br/>スタイリング]
        BLADE[Blade Templates<br/>ビュー]
    end

    subgraph "バックエンド"
        LARAVEL[Laravel 11.x<br/>フレームワーク]
        FILAMENT[FilamentPHP 4.x<br/>管理パネル]

        subgraph "コアコンポーネント"
            ROUTER[ルーター]
            MIDDLEWARE[ミドルウェア]
            CONTROLLER[コントローラ]
            MODEL[Eloquent ORM]
        end
    end

    subgraph "プラグイン"
        CORE[コアプラグイン<br/>Analytics, Security, etc.]
        OPTIONAL[オプションプラグイン<br/>Accounts, Inventories, etc.]
    end

    VITE --> TAILWIND
    TAILWIND --> BLADE
    BLADE --> LARAVEL
    LARAVEL --> ROUTER
    ROUTER --> MIDDLEWARE
    MIDDLEWARE --> CONTROLLER
    CONTROLLER --> MODEL
    FILAMENT --> LARAVEL
    CORE --> LARAVEL
    OPTIONAL --> LARAVEL
```

### データフロー図

```mermaid
sequenceDiagram
    participant User as ユーザー
    participant Web as Webサーバー
    participant App as Laravel App
    participant Cache as キャッシュ
    participant DB as データベース
    participant Queue as キューワーカー
    participant Mail as メールサービス

    User->>Web: HTTPリクエスト
    Web->>App: PHP処理
    App->>Cache: セッション確認
    Cache-->>App: セッションデータ
    App->>DB: データ取得/更新
    DB-->>App: 結果
    App->>Cache: キャッシュ更新
    App-->>Web: レスポンス
    Web-->>User: HTML/JSON

    Note over App,Queue: 非同期処理
    App->>Queue: ジョブ投入
    Queue->>DB: ジョブ取得
    Queue->>Mail: メール送信
    Queue->>DB: ジョブ完了
```

## データベース接続構成

```mermaid
graph TB
    subgraph "Laravel Application"
        APP[Laravel App]
    end

    subgraph "Database Connections"
        subgraph "Primary (default)"
            SQLITE[(SQLite<br/>database.sqlite)]
        end

        subgraph "Alternative Options"
            MYSQL[(MySQL 8.0+<br/>Port: 3306)]
            PGSQL[(PostgreSQL<br/>Port: 5432)]
            MARIADB[(MariaDB<br/>Port: 3306)]
            SQLSRV[(SQL Server<br/>Port: 1433)]
        end
    end

    subgraph "Redis Configuration"
        REDIS_DEFAULT[(Redis Default<br/>DB: 0)]
        REDIS_CACHE[(Redis Cache<br/>DB: 1)]
    end

    APP --> SQLITE
    APP -.-> MYSQL
    APP -.-> PGSQL
    APP -.-> MARIADB
    APP -.-> SQLSRV
    APP --> REDIS_DEFAULT
    APP --> REDIS_CACHE
```

## キャッシュ/セッション/キュー構成

```mermaid
graph LR
    subgraph "Cache Stores"
        CACHE_DB[(Database Cache<br/>table: cache)]
        CACHE_FILE[(File Cache<br/>storage/framework/cache)]
        CACHE_REDIS[(Redis Cache)]
        CACHE_MEM[(Memcached)]
        CACHE_DYNAMO[(DynamoDB)]
    end

    subgraph "Session Stores"
        SESSION_DB[(Database Session<br/>table: sessions)]
        SESSION_FILE[(File Session<br/>storage/framework/sessions)]
        SESSION_REDIS[(Redis Session)]
    end

    subgraph "Queue Connections"
        QUEUE_DB[(Database Queue<br/>table: jobs)]
        QUEUE_REDIS[(Redis Queue)]
        QUEUE_SQS[(Amazon SQS)]
        QUEUE_BEAN[(Beanstalkd)]
    end

    APP[Laravel App]

    APP --> CACHE_DB
    APP -.-> CACHE_FILE
    APP -.-> CACHE_REDIS
    APP -.-> CACHE_MEM
    APP -.-> CACHE_DYNAMO

    APP --> SESSION_DB
    APP -.-> SESSION_FILE
    APP -.-> SESSION_REDIS

    APP --> QUEUE_DB
    APP -.-> QUEUE_REDIS
    APP -.-> QUEUE_SQS
    APP -.-> QUEUE_BEAN
```

## ファイルストレージ構成

```mermaid
graph TB
    subgraph "Laravel Application"
        APP[Laravel App]
    end

    subgraph "Filesystem Disks"
        subgraph "Local Storage"
            LOCAL[(storage/app/private<br/>非公開ファイル)]
            PUBLIC[(storage/app/public<br/>公開ファイル)]
        end

        subgraph "Cloud Storage"
            S3[(Amazon S3<br/>オプション)]
        end
    end

    subgraph "Public Access"
        SYMLINK[public/storage<br/>シンボリックリンク]
    end

    APP --> LOCAL
    APP --> PUBLIC
    APP -.-> S3
    PUBLIC --> SYMLINK
```

## メール送信構成

```mermaid
graph LR
    subgraph "Laravel Application"
        APP[Laravel App]
        MAILABLE[Mailable Class]
    end

    subgraph "Mail Drivers"
        SMTP[SMTP<br/>ポート: 2525]
        SES[Amazon SES]
        POSTMARK[Postmark]
        RESEND[Resend]
        SENDMAIL[Sendmail]
        LOG[Log Driver<br/>開発用]
    end

    subgraph "Failover Configuration"
        FAILOVER{Failover}
    end

    APP --> MAILABLE
    MAILABLE --> LOG
    MAILABLE -.-> SMTP
    MAILABLE -.-> SES
    MAILABLE -.-> POSTMARK
    MAILABLE -.-> RESEND
    MAILABLE -.-> SENDMAIL

    SMTP --> FAILOVER
    FAILOVER --> LOG
```

## ログ収集構成

```mermaid
graph TB
    subgraph "Laravel Application"
        APP[Laravel App]
        MONOLOG[Monolog]
    end

    subgraph "Log Channels"
        subgraph "Stack Channel (default)"
            SINGLE[Single File<br/>storage/logs/laravel.log]
            DAILY[Daily Rotation<br/>14日保持]
        end

        subgraph "External Channels"
            SLACK_LOG[Slack Webhook<br/>Critical Alerts]
            PAPERTRAIL[Papertrail<br/>SyslogUDP]
            SYSLOG[Syslog]
        end

        subgraph "Container/Development"
            STDERR[stderr<br/>コンテナ向け]
            ERRORLOG[errorlog<br/>PHP Error Log]
        end
    end

    APP --> MONOLOG
    MONOLOG --> SINGLE
    MONOLOG --> DAILY
    MONOLOG -.-> SLACK_LOG
    MONOLOG -.-> PAPERTRAIL
    MONOLOG -.-> SYSLOG
    MONOLOG -.-> STDERR
    MONOLOG -.-> ERRORLOG
```

## プラグインアーキテクチャ

```mermaid
graph TB
    subgraph "AureusERP Core"
        LARAVEL[Laravel 11.x]
        FILAMENT[FilamentPHP 4.x]
    end

    subgraph "Core Plugins (システムプラグイン)"
        ANALYTICS[Analytics<br/>BI・レポート]
        CHATTER[Chatter<br/>内部コミュニケーション]
        FIELDS[Fields<br/>カスタムフィールド]
        SECURITY[Security<br/>認証・認可]
        SUPPORT[Support<br/>ヘルプデスク]
        TABLE_VIEWS[Table Views<br/>データ表示]
    end

    subgraph "Installable Plugins (オプション)"
        subgraph "財務系"
            ACCOUNTS[Accounts]
            INVOICES[Invoices]
            PAYMENTS[Payments]
        end

        subgraph "販売・購買系"
            SALES[Sales]
            PURCHASES[Purchases]
            PRODUCTS[Products]
        end

        subgraph "人事系"
            EMPLOYEES[Employees]
            RECRUITMENTS[Recruitments]
            TIME_OFF[Time-off]
            TIMESHEETS[Timesheets]
        end

        subgraph "その他"
            CONTACTS[Contacts]
            PARTNERS[Partners]
            INVENTORIES[Inventories]
            PROJECTS[Projects]
            BLOGS[Blogs]
            WEBSITE[Website]
        end
    end

    LARAVEL --> FILAMENT
    FILAMENT --> ANALYTICS
    FILAMENT --> CHATTER
    FILAMENT --> FIELDS
    FILAMENT --> SECURITY
    FILAMENT --> SUPPORT
    FILAMENT --> TABLE_VIEWS

    FILAMENT -.-> ACCOUNTS
    FILAMENT -.-> INVOICES
    FILAMENT -.-> PAYMENTS
    FILAMENT -.-> SALES
    FILAMENT -.-> PURCHASES
    FILAMENT -.-> PRODUCTS
    FILAMENT -.-> EMPLOYEES
    FILAMENT -.-> RECRUITMENTS
    FILAMENT -.-> TIME_OFF
    FILAMENT -.-> TIMESHEETS
    FILAMENT -.-> CONTACTS
    FILAMENT -.-> PARTNERS
    FILAMENT -.-> INVENTORIES
    FILAMENT -.-> PROJECTS
    FILAMENT -.-> BLOGS
    FILAMENT -.-> WEBSITE
```

## 本番環境推奨構成

```mermaid
graph TB
    subgraph "インターネット"
        USER[ユーザー]
        CDN[CDN<br/>CloudFront等]
    end

    subgraph "ロードバランサー層"
        ALB[Application Load Balancer<br/>HTTPS Termination]
    end

    subgraph "Web/AP層 (Auto Scaling)"
        subgraph "EC2 / Container"
            WEB1[Nginx + PHP-FPM<br/>Instance 1]
            WEB2[Nginx + PHP-FPM<br/>Instance 2]
            WEB3[Nginx + PHP-FPM<br/>Instance N]
        end
    end

    subgraph "ワーカー層"
        SUPERVISOR[Supervisor]
        WORKER1[Queue Worker 1]
        WORKER2[Queue Worker N]
        SCHEDULER[Scheduler<br/>Cron]
    end

    subgraph "データ層"
        subgraph "Amazon RDS"
            RDS_MASTER[(MySQL Master)]
            RDS_REPLICA[(MySQL Replica)]
        end

        ELASTICACHE[(ElastiCache<br/>Redis)]
        S3[(S3<br/>ファイルストレージ)]
    end

    subgraph "監視・ログ"
        CLOUDWATCH[CloudWatch]
        XRAY[X-Ray]
    end

    USER --> CDN
    CDN --> ALB
    ALB --> WEB1
    ALB --> WEB2
    ALB --> WEB3

    WEB1 --> RDS_MASTER
    WEB2 --> RDS_MASTER
    WEB3 --> RDS_MASTER
    RDS_MASTER --> RDS_REPLICA

    WEB1 --> ELASTICACHE
    WEB2 --> ELASTICACHE
    WEB3 --> ELASTICACHE

    WEB1 --> S3
    WEB2 --> S3
    WEB3 --> S3

    SUPERVISOR --> WORKER1
    SUPERVISOR --> WORKER2
    SUPERVISOR --> SCHEDULER

    WORKER1 --> RDS_MASTER
    WORKER2 --> RDS_MASTER
    WORKER1 --> ELASTICACHE
    WORKER2 --> ELASTICACHE

    WEB1 --> CLOUDWATCH
    WEB2 --> CLOUDWATCH
    WEB3 --> CLOUDWATCH
    WORKER1 --> CLOUDWATCH
    WORKER2 --> CLOUDWATCH
```

## 開発環境構成

```mermaid
graph LR
    subgraph "開発マシン"
        subgraph "並列実行 (composer dev)"
            SERVER[php artisan serve<br/>ポート: 8000]
            QUEUE_DEV[php artisan queue:listen]
            PAIL[php artisan pail<br/>ログ監視]
            VITE_DEV[npm run dev<br/>HMR対応]
        end

        SQLITE_DEV[(SQLite<br/>database/database.sqlite)]
        STORAGE_DEV[(Local Storage<br/>storage/)]
    end

    subgraph "ブラウザ"
        BROWSER[Chrome/Firefox/Edge]
        DEBUGBAR[Laravel Debugbar]
    end

    BROWSER --> SERVER
    SERVER --> SQLITE_DEV
    SERVER --> STORAGE_DEV
    BROWSER --> DEBUGBAR
    VITE_DEV --> BROWSER
```
