# インフラ設計書

## 概要

本ドキュメントは、AureusERP（オープンソースERPソリューション）のインフラストラクチャ設計を記載したものである。AureusERPはLaravel 11.xとFilamentPHP 4.xをベースとしたモジュラー型ERPシステムであり、中小企業から大規模企業まで対応可能な拡張性を持つ。

## システム構成

### 全体構成

AureusERPは以下のコンポーネントで構成される標準的なLaravelアプリケーションアーキテクチャを採用している：

1. **Webサーバー層**: Apache/Nginx
2. **アプリケーション層**: PHP 8.2+ / Laravel 11.x
3. **データベース層**: SQLite（デフォルト）/ MySQL 8.0+ / MariaDB / PostgreSQL / SQL Server
4. **キャッシュ/セッション層**: Database / Redis / Memcached
5. **キュー処理層**: Database / Redis / Amazon SQS
6. **フロントエンド**: Vite 5.x + TailwindCSS 4.x

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| Webサーバー | HTTPリクエスト処理、静的ファイル配信、リバースプロキシ | Apache/Nginx、PHP拡張必須（OpenSSL, PDO, Mbstring, Tokenizer, XML, Ctype, JSON） | 1台以上（スケーラブル） |
| APサーバー | Laravelアプリケーション実行、ビジネスロジック処理 | PHP 8.2+、Composer、Node.js/NPM | Webサーバーと同居または分離可 |
| DBサーバー | データ永続化、トランザクション処理 | SQLite / MySQL 8.0+ / PostgreSQL / MariaDB | 1台（冗長構成可） |
| キャッシュサーバー | セッション管理、データキャッシュ | Redis / Memcached（オプション） | 0-1台 |
| キューワーカー | 非同期ジョブ処理 | PHP CLI | 1台以上（オプション） |

### ネットワーク構成

```
[インターネット]
      |
      v
[ロードバランサー/リバースプロキシ] (オプション)
      |
      v
[Webサーバー (Apache/Nginx)]
      |
      +---> [PHPアプリケーション (Laravel)]
      |           |
      |           +---> [DBサーバー (SQLite/MySQL/PostgreSQL)]
      |           |
      |           +---> [キャッシュ (Redis/Memcached/Database)]
      |           |
      |           +---> [キュー (Database/Redis/SQS)]
      |           |
      |           +---> [ファイルストレージ (Local/S3)]
      |
      +---> [静的ファイル (public/)]
```

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| PHP | 8.2以上 | サーバーサイドスクリプト言語 |
| Laravel Framework | 11.9以上 | PHPウェブアプリケーションフレームワーク |
| FilamentPHP | 4.1以上 | 管理パネル・リソース管理 |
| Composer | 最新 | PHPパッケージ管理 |
| Node.js | 最新安定版 | フロントエンドビルド |
| NPM | 最新 | JavaScriptパッケージ管理 |
| Vite | 5.x | フロントエンドビルドツール |
| TailwindCSS | 4.x | CSSフレームワーク |
| Apache/Nginx | 最新 | Webサーバー |
| SQLite | デフォルト | 軽量データベース |
| MySQL | 8.0+ | リレーショナルデータベース（オプション） |
| PostgreSQL | 最新 | リレーショナルデータベース（オプション） |
| Redis | 最新 | キャッシュ・セッション・キュー（オプション） |
| Memcached | 最新 | キャッシュ（オプション） |
| Monolog | 最新 | ロギングライブラリ |
| PHPUnit | 11.x | テストフレームワーク |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| AWS S3 | ファイルストレージ | AWS SDK / S3 API |
| AWS SES | メール送信 | AWS SDK / SMTP |
| AWS DynamoDB | キャッシュ（オプション） | AWS SDK |
| Postmark | メール送信 | HTTP API |
| Resend | メール送信 | HTTP API |
| Slack | 通知・ログ連携 | Webhook / Bot API |
| SMTP サーバー | メール送信 | SMTP プロトコル |
| Redis（外部） | キャッシュ・セッション・キュー | Redis プロトコル |

## スケーリング設計

### 水平スケーリング

1. **Webサーバー層**
   - ロードバランサーを使用した複数Webサーバーへの負荷分散
   - セッションをデータベースまたはRedisに保存することでステートレス化

2. **キューワーカー**
   - 複数のキューワーカープロセスを起動可能
   - `php artisan queue:listen --tries=1` で並列処理

3. **データベース層**
   - リードレプリカの追加によるリード負荷分散
   - マスター・スレーブ構成への対応

### 垂直スケーリング

1. **PHP CLI ワーカー数**: `PHP_CLI_SERVER_WORKERS` 環境変数で調整（デフォルト: 4）
2. **データベース接続プール**: 各ドライバ設定で調整可能

### キュー並列処理

- **デフォルト**: Database キュー
- **高負荷対応**: Redis または Amazon SQS への切り替え
- **リトライ制御**: `retry_after` 設定で再実行間隔を調整（デフォルト: 90秒）

## 可用性設計

### 冗長構成

1. **Webサーバー**
   - 複数台構成でアクティブ-アクティブ運用
   - ロードバランサーによるヘルスチェックと自動切り替え

2. **データベース**
   - マスター・スレーブレプリケーション対応
   - 自動フェイルオーバーはデータベースレベルで実装

3. **キャッシュ**
   - Redis Cluster / Sentinel による冗長化（オプション）
   - Memcached クラスタリング対応

### フェイルオーバー方式

1. **メール送信**: `failover` ドライバで SMTP -> Log への自動フェイルオーバー
2. **セッション**: Database / Redis への自動永続化
3. **キュー**: 失敗ジョブは `failed_jobs` テーブルに記録

### メンテナンスモード

- `APP_MAINTENANCE_DRIVER`: file / cache
- 複数サーバー構成では `cache` ドライバ推奨
- `php artisan down` / `php artisan up` でメンテナンス切り替え

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| データベース（SQLite） | ファイルコピー | 日次 | 30日 |
| データベース（MySQL/PostgreSQL） | mysqldump / pg_dump | 日次 | 30日 |
| アップロードファイル（storage/app） | rsync / S3 Sync | 日次 | 永続 |
| 設定ファイル（.env） | バージョン管理外での安全な保管 | 変更時 | 永続 |
| ログファイル | ローテーション | daily（14日保持） | 14日 |

## 監視設計

### アプリケーション監視

| 監視項目 | 方式 | ツール |
| --- | --- | --- |
| アプリケーションログ | Monolog / Stack ドライバ | Laravel Pail / ログ集約サービス |
| エラー監視 | Slack Webhook / Papertrail | LOG_SLACK_WEBHOOK_URL 設定 |
| パフォーマンス | Laravel Debugbar（開発時） | barryvdh/laravel-debugbar |

### ログ設計

| ログチャネル | 用途 | 保持期間 |
| --- | --- | --- |
| single | 単一ファイルログ | 永続 |
| daily | 日次ローテーション | 14日（LOG_DAILY_DAYS） |
| slack | クリティカルエラー通知 | 即時配信 |
| papertrail | 外部ログ集約 | サービス依存 |
| stderr | コンテナ環境向け | 永続（外部収集） |
| syslog | システムログ連携 | システム設定依存 |

### インフラ監視（推奨）

| 監視項目 | 推奨ツール |
| --- | --- |
| サーバーリソース（CPU/メモリ/ディスク） | CloudWatch / Prometheus / Datadog |
| プロセス監視（PHP-FPM/Queue Worker） | Supervisor / systemd |
| 死活監視 | UptimeRobot / Pingdom |
| データベース監視 | MySQL Performance Schema / pg_stat |

## 環境変数設計

### 必須環境変数

| 変数名 | 説明 | デフォルト値 |
| --- | --- | --- |
| APP_NAME | アプリケーション名 | YourERP |
| APP_ENV | 実行環境 | local |
| APP_KEY | 暗号化キー | 自動生成 |
| APP_DEBUG | デバッグモード | true |
| APP_URL | アプリケーションURL | http://localhost |
| DB_CONNECTION | データベースドライバ | sqlite |

### オプション環境変数

| 変数名 | 説明 | デフォルト値 |
| --- | --- | --- |
| CACHE_STORE | キャッシュドライバ | database |
| SESSION_DRIVER | セッションドライバ | database |
| QUEUE_CONNECTION | キュードライバ | database |
| REDIS_HOST | Redisホスト | 127.0.0.1 |
| MAIL_MAILER | メールドライバ | log |
| FILESYSTEM_DISK | ファイルシステム | local |

## セキュリティ設計

### 暗号化

- **暗号化方式**: AES-256-CBC
- **キー管理**: APP_KEY 環境変数で管理
- **パスワードハッシュ**: Bcrypt（BCRYPT_ROUNDS: 12）

### セッションセキュリティ

- **有効期限**: 120分（SESSION_LIFETIME）
- **HTTPOnly**: 有効（SESSION_HTTP_ONLY）
- **SameSite**: lax（SESSION_SAME_SITE）
- **暗号化**: オプション（SESSION_ENCRYPT）

### 権限管理

- **Filament Shield**: ロールベースアクセス制御
- **Spatie Permission**: パーミッション管理

## 備考

### 開発環境

- `php artisan serve` で開発サーバー起動
- `npm run dev` で Vite 開発サーバー起動
- `composer dev` で並列起動（server, queue, logs, vite）

### 本番環境推奨構成

1. Webサーバー: Nginx + PHP-FPM
2. データベース: MySQL 8.0+ または PostgreSQL
3. キャッシュ: Redis
4. キュー: Redis または Amazon SQS
5. ファイルストレージ: Amazon S3
6. プロセス管理: Supervisor
7. SSL/TLS: Let's Encrypt または商用証明書

### プラグインアーキテクチャ

AureusERPは24のプラグインで構成されており、必要に応じてインストール・アンインストールが可能：

- **コアプラグイン**: Analytics, Chatter, Fields, Security, Support, Table Views
- **インストール可能プラグイン**: Accounts, Blogs, Contacts, Employees, Inventories, Invoices, Partners, Payments, Products, Projects, Purchases, Recruitments, Sales, Time-off, Timesheets, Website, Full Calendar, Plugin Manager
