---
generated_at: 2025-12-27 15:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **CORS設定の詳細**：設定ファイルの確認が必要
  2. **HSTS設定**：本番環境での設定確認が必要
  3. **二要素認証**：現状未実装の推奨事項

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `config/auth.php` - 認証設定ファイル
- E-02: `config/session.php` - セッション設定ファイル
- E-03: `config/app.php` - アプリケーション設定（暗号化設定含む）
- E-04: `config/filament-shield.php` - Filament Shield設定
- E-05: `config/permission.php` - Spatie Permission設定
- E-06: `config/logging.php` - ログ設定
- E-07: `app/Providers/Filament/AdminPanelProvider.php` - 管理パネルミドルウェア設定
- E-08: `app/Providers/Filament/CustomerPanelProvider.php` - 顧客パネルミドルウェア設定
- E-09: `app/Models/User.php` - 基本Userモデル
- E-10: `plugins/webkul/security/src/Models/User.php` - セキュリティUserモデル
- E-11: `plugins/webkul/security/src/Policies/UserPolicy.php` - ユーザーポリシー
- E-12: `plugins/webkul/security/src/Models/Role.php` - ロールモデル
- E-13: `plugins/webkul/website/src/Filament/Customer/Auth/Register.php` - 登録フォーム
- E-14: `plugins/webkul/chatter/src/Traits/HasLogActivity.php` - アクティビティログtrait
- E-15: `plugins/webkul/chatter/src/Models/Message.php` - メッセージモデル
- E-16: `plugins/webkul/fields/src/Filament/Resources/FieldResource.php` - バリデーション設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セッションベース認証を採用 | E-01, E-07 | ○ |
| C-02 | 認証ガードはweb/customerのマルチガード構成 | E-01 | ○ |
| C-03 | ユーザープロバイダはEloquent | E-01 | ○ |
| C-04 | パスワードはhashed castで保護 | E-09 | ○ |
| C-05 | メール認証が有効 | E-07 | ○ |
| C-06 | パスワードリセットトークンは60分で失効 | E-01 | ○ |
| C-07 | セッションドライバはdatabase | E-02 | ○ |
| C-08 | セッション有効期限は120分 | E-02 | ○ |
| C-09 | HttpOnly Cookieがデフォルトで有効 | E-02 | ○ |
| C-10 | SameSite属性はlax | E-02 | ○ |
| C-11 | 登録時にセッション再生成を実行 | E-13 | ○ |
| C-12 | パスワード確認タイムアウトは10800秒 | E-01 | ○ |
| C-13 | 登録時に2回/分のレートリミット適用 | E-13 | ○ |
| C-14 | Spatie Laravel Permissionを使用 | E-04, E-05 | ○ |
| C-15 | Filament Shieldを使用 | E-07, E-04 | ○ |
| C-16 | RBACによる権限管理 | E-04, E-11 | ○ |
| C-17 | Policyベースの認可 | E-11 | ○ |
| C-18 | 標準ポリシーメソッド一覧 | E-04 | ○ |
| C-19 | 暗号化方式はAES-256-CBC | E-03 | ○ |
| C-20 | EncryptCookiesミドルウェアで暗号化 | E-07, E-08 | ○ |
| C-21 | AuthenticateSessionミドルウェア使用 | E-07, E-08 | ○ |
| C-22 | パスワードは$hidden配列で保護 | E-09 | ○ |
| C-23 | VerifyCsrfTokenミドルウェア使用 | E-07, E-08 | ○ |
| C-24 | $fillableによるマスアサインメント対策 | E-09, E-10 | ○ |
| C-25 | Password::default()ルール適用 | E-13 | ○ |
| C-26 | maxLength/required等のバリデーション | E-13, E-16 | ○ |
| C-27 | unique制約の適用 | E-13, E-16 | ○ |
| C-28 | ログチャネルはstack | E-06 | ○ |
| C-29 | dailyログは14日保持 | E-06 | ○ |
| C-30 | HasLogActivityによる監査ログ | E-14 | ○ |
| C-31 | created/updated/deletedイベント記録 | E-14 | ○ |
| C-32 | 変更前後の値を記録 | E-14 | ○ |
| C-33 | causer情報の自動記録 | E-14, E-15 | ○ |
| C-34 | ミドルウェアスタックの構成 | E-07, E-08 | ○ |
| C-35 | Eloquent ORMによるSQLインジェクション対策 | E-09, E-10 | ○ |
| C-36 | Blade自動エスケープ | **フレームワーク標準** | ○ |
| C-37 | 各種バリデーションルール一覧 | E-16 | ○ |
| C-38 | ソフト削除/ハード削除の記録 | E-14 | ○ |
| C-39 | propertiesへの変更詳細保存 | E-14, E-15 | ○ |
| C-40 | remember_tokenの$hidden保護 | E-09 | ○ |
| C-41 | パネル別の認証ガード設定 | E-08 | ○ |
| C-42 | emailメソッドによるメール形式検証 | E-13 | ○ |
| C-43 | CORS設定の詳細 | **根拠なし** | △ |
| C-44 | HSTS設定の詳細 | **根拠なし** | △ |
| C-45 | 二要素認証の実装状況 | **根拠なし（未実装）** | △ |

## 4) 不足情報（Unknown / Missing）
- CORS設定の詳細
  - 候補：`config/cors.php` / Laravelデフォルト設定
- HSTS設定
  - 候補：Webサーバー設定 / `.htaccess` / Nginxコンフィグ
- 二要素認証
  - 候補：現時点で未実装、将来実装の検討項目

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 認証・認可の基本設計は適切に実装
- **0（低リスク）**: CSRF/XSS対策はフレームワーク標準で実装済み
- **1（中リスク）**: CORS/HSTS設定の詳細確認が必要
- **1（中リスク）**: 本番環境でのSecure Cookie設定確認
- **0（低リスク）**: 監査ログ機能は実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] `config/cors.php`でCORS設定を確認
- [ ] 本番環境で`SESSION_SECURE_COOKIE=true`が設定されているか確認
- [ ] Webサーバー設定でHSTSヘッダーが設定されているか確認
- [ ] `APP_DEBUG=false`が本番環境で設定されているか確認
- [ ] ログローテーション設定が適切か確認
- [ ] セキュリティパッケージのバージョンが最新か確認
