# セキュリティ設計書

## 概要

本ドキュメントは、AureusERP（Laravel/Filamentベースのエンタープライズリソースプランニングシステム）のセキュリティ設計について記述します。認証・認可、データ保護、入力検証、監査ログなどのセキュリティ対策を網羅的に説明します。

## 認証設計

### 認証方式

本システムでは、Laravel標準のセッションベース認証を採用しています。

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| 認証方式 | セッションベース認証 | Laravelの標準Authenticatable実装 |
| 認証ガード | web（管理者）、customer（顧客） | マルチガード構成 |
| ユーザープロバイダ | Eloquent | `Webkul\Security\Models\User` / `Webkul\Website\Models\Partner` |
| パスワードハッシュ | Laravel Hash（Bcrypt/Argon2） | `password`属性に`hashed`キャストを適用 |
| メール認証 | 有効 | `emailVerification()`を設定 |
| パスワードリセット | 有効 | 60分でトークン失効、60秒のスロットリング |

### セッション管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| セッションドライバ | database | デフォルト設定 |
| セッション有効期限 | 120分 | `SESSION_LIFETIME`環境変数で設定可能 |
| ブラウザ終了時の失効 | false（デフォルト） | `SESSION_EXPIRE_ON_CLOSE`で設定可能 |
| セッション暗号化 | false（デフォルト） | `SESSION_ENCRYPT`で有効化可能 |
| セッション固定化対策 | 有効 | 登録時に`session()->regenerate()`を実行 |
| HttpOnly Cookie | true | JavaScript からのアクセスを防止 |
| SameSite属性 | lax | CSRF攻撃の軽減 |
| Secure Cookie | 環境変数で設定 | HTTPS使用時に有効化推奨 |

### パスワードポリシー

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| パスワードルール | Laravel Password::default() | 登録フォームで適用 |
| パスワード確認タイムアウト | 10800秒（3時間） | 重要操作時の再認証 |
| パスワードリセットトークン有効期限 | 60分 | 短時間で失効しセキュリティを確保 |
| レートリミット | 2回/分（登録時） | ブルートフォース攻撃対策 |

## 認可設計

### 権限体系

本システムでは、Spatie Laravel Permissionパッケージと Filament Shieldを使用したロールベースアクセス制御（RBAC）を実装しています。

| ロール | 権限 | 説明 |
| --- | --- | --- |
| Admin | 全権限 | デフォルトのパネルユーザーロール |
| カスタムロール | 個別設定 | Filament Shield経由で定義 |

### パーミッション構造

| パーミッション種別 | 形式 | 例 |
| --- | --- | --- |
| リソース操作 | `{action}_{resource}` | `view_any_user`, `create_user`, `update_user`, `delete_user` |
| ページアクセス | `view_{page}` | `view_dashboard` |
| ウィジェット表示 | `view_{widget}` | `view_stats_widget` |

### 標準ポリシーメソッド

```
view_any, view, create, update, delete, restore,
delete_any, force_delete, force_delete_any, restore_any, reorder
```

### アクセス制御

- **Policyベースの認可**: 各モデルに対応するPolicyクラスを配置（例: `UserPolicy`, `RolePolicy`）
- **Gate統合**: Spatie Permissionパッケージによる自動Gate登録
- **リソースレベル制御**: Filament Shieldによるリソース、ページ、ウィジェット単位の制御
- **マルチテナント対応**: 会社（Company）単位のデータ分離が可能

## 通信セキュリティ

| 項目 | 対策 |
| --- | --- |
| HTTPS | 環境設定で有効化（`SESSION_SECURE_COOKIE`） |
| Cookie暗号化 | `EncryptCookies`ミドルウェアで全Cookieを暗号化 |
| セッション保護 | `AuthenticateSession`ミドルウェアでセッション固定攻撃を防止 |
| CORS | Laravel標準のCORS設定で制御可能 |

## データセキュリティ

### 暗号化

| 対象 | 暗号化方式 |
| --- | --- |
| アプリケーション暗号化 | AES-256-CBC（`APP_KEY`使用） |
| パスワード保存 | Bcrypt/Argon2ハッシュ |
| Cookie暗号化 | Laravel Encryptionサービス |
| セッションデータ | オプションで暗号化可能 |

### 機密情報管理

| 項目 | 対策 |
| --- | --- |
| パスワード | `password`属性を`$hidden`配列で保護、シリアライズ時に除外 |
| リメンバートークン | `remember_token`を`$hidden`配列で保護 |
| 環境変数 | `.env`ファイルで管理、Gitから除外 |
| APIキー・シークレット | 環境変数経由で注入 |

## 入出力対策

| 脅威 | 対策 |
| --- | --- |
| XSS | Blade自動エスケープ（`{{ }}`）、Filamentコンポーネントによる出力サニタイズ |
| SQLインジェクション | Eloquent ORMによるパラメータバインディング、クエリビルダ使用 |
| CSRF | `VerifyCsrfToken`ミドルウェア、全フォームにCSRFトークン自動挿入 |
| マスアサインメント | `$fillable`プロパティによる許可属性の明示的定義 |
| ファイルアップロード | Filament FileUploadコンポーネントの検証機能 |

### 入力検証

本システムでは以下の多層的な入力検証を実装しています：

| 検証レイヤー | 実装方法 |
| --- | --- |
| フォーム検証 | Filament Forms（`required()`, `maxLength()`, `email()`, `unique()`等） |
| パスワード検証 | `Password::default()`ルール適用 |
| カスタムフィールド検証 | 動的バリデーションルール（regex, unique, in, notIn等） |
| 型キャスト | Eloquentの`$casts`プロパティによる型強制 |

### 検証ルール例

- テキスト: `alphaDash`, `alphaNum`, `ascii`, `ip`, `uuid`, `ulid`, `macAddress`
- 文字列: `maxLength`, `minLength`, `regex`, `startsWith`, `endsWith`
- 数値: `gt`, `gte`, `lt`, `lte`, `multipleOf`
- 日時: `after`, `before`, `afterOrEqual`, `beforeOrEqual`
- 選択: `in`, `notIn`, `exists`, `different`

## 監査ログ

### ログ設定

| 項目 | 設定値 |
| --- | --- |
| デフォルトチャネル | stack |
| ログドライバ | single / daily |
| ログ保持期間 | 14日（dailyドライバ） |
| ログレベル | debug（環境変数で設定可能） |
| ログパス | `storage/logs/laravel.log` |

### アクティビティログ

本システムでは、Chatterプラグインの`HasLogActivity`トレイトにより、モデルの変更履歴を自動記録します。

| ログ種別 | 記録内容 | 保持期間 |
| --- | --- | --- |
| モデル作成ログ | 作成されたモデルの属性値 | データベース永続化 |
| モデル更新ログ | 変更前後の値（old_value / new_value） | データベース永続化 |
| モデル削除ログ | 削除イベント（ソフト削除/ハード削除） | データベース永続化 |
| モデル復元ログ | ソフト削除からの復元 | データベース永続化 |

### 監査メッセージ構造

```php
[
    'type'         => 'notification',
    'log_name'     => 'default',
    'body'         => '変更内容の説明',
    'subject_type' => 'モデルタイプ',
    'subject_id'   => 'モデルID',
    'causer_type'  => 'ユーザータイプ',
    'causer_id'    => 'ユーザーID',
    'event'        => 'created|updated|deleted',
    'properties'   => ['変更プロパティ詳細']
]
```

## ミドルウェア構成

### 管理パネル（Admin）

```php
[
    EncryptCookies::class,           // Cookie暗号化
    AddQueuedCookiesToResponse::class,
    StartSession::class,              // セッション開始
    AuthenticateSession::class,       // セッション認証
    ShareErrorsFromSession::class,
    VerifyCsrfToken::class,          // CSRF検証
    SubstituteBindings::class,
    DisableBladeIconComponents::class,
    DispatchServingFilamentEvent::class,
]
// 認証ミドルウェア
[
    Authenticate::class,
]
```

### 顧客パネル（Customer）

管理パネルと同様のミドルウェアスタックを使用し、`customer`認証ガードを適用。

## セキュリティ機能一覧

| 機能 | 実装状況 | 備考 |
| --- | --- | --- |
| パスワードハッシュ | 有効 | Bcrypt/Argon2 |
| CSRF保護 | 有効 | 全フォーム対象 |
| XSS対策 | 有効 | Blade自動エスケープ |
| SQLインジェクション対策 | 有効 | Eloquent ORM |
| セッション固定攻撃対策 | 有効 | セッション再生成 |
| ブルートフォース対策 | 有効 | レートリミット |
| RBAC | 有効 | Spatie Permission + Filament Shield |
| 監査ログ | 有効 | HasLogActivity trait |
| Cookie暗号化 | 有効 | EncryptCookiesミドルウェア |
| メール認証 | 有効 | emailVerification() |

## 備考

### セキュリティ推奨事項

1. **本番環境での推奨設定**
   - `APP_DEBUG=false`に設定
   - `SESSION_SECURE_COOKIE=true`でHTTPS強制
   - `SESSION_ENCRYPT=true`でセッション暗号化を有効化

2. **定期的なセキュリティメンテナンス**
   - 依存パッケージの定期更新
   - セキュリティパッチの適用
   - ログの定期的なレビュー

3. **追加検討事項**
   - 二要素認証（2FA）の導入
   - IPホワイトリスト/ブラックリストの実装
   - セキュリティヘッダー（CSP, HSTS等）の設定
   - WAF（Web Application Firewall）の導入
