# テスト方針書

## 概要

本ドキュメントは、AureusERP（Laravel + FilamentベースのオープンソースERPソリューション）のテスト戦略、テストレベル、テスト環境、使用ツール、品質基準を定義するものである。中小企業から大規模企業向けのERPシステムとして、高い品質と信頼性を確保するためのテスト方針を策定する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のクラス・メソッドの機能を検証する。ビジネスロジック、モデル、サービスクラスの動作確認 | 開発者 |
| 結合テスト（Feature Test） | 複数のコンポーネントが連携して正しく動作することを検証する。HTTPリクエスト/レスポンス、データベース操作を含む統合的な動作確認 | 開発者 |
| システムテスト | システム全体の動作を本番に近い環境で検証する。エンドツーエンドのワークフロー確認 | QAチーム/開発者 |
| 受入テスト | 業務要件を満たしているか、ユーザー視点での動作確認 | QAチーム/ステークホルダー |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | ERPの各モジュール（販売、購買、在庫、会計、人事等）の業務機能を検証 | 開発中・リリース前 |
| 性能テスト | 大量データ処理、同時接続ユーザー数に対するレスポンス時間を検証 | リリース前・定期的 |
| セキュリティテスト | 認証・認可、データアクセス制御、SQLインジェクション対策等を検証 | リリース前・定期的 |
| 回帰テスト | 既存機能への影響がないことを確認 | 変更時・リリース前 |
| 互換性テスト | 各種ブラウザ、デバイスでの動作を検証 | リリース前 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者による単体・結合テスト実行 | SQLite/MySQL、PHP 8.2+、Node.js、Vite |
| ステージング環境 | システムテスト・受入テスト実行 | 本番同等のサーバー構成、MySQL/PostgreSQL |
| 本番環境 | スモークテスト・本番確認 | 本番サーバー |

### 環境構成詳細

**ローカル開発環境**
- PHP: 8.2以上
- データベース: SQLite（テスト用）/ MySQL（開発用）
- キャッシュ: array（テスト時）
- セッション: array（テスト時）
- キュー: sync（テスト時）
- メール: array（テスト時）

**テスト用環境変数設定（phpunit.xml）**
- APP_ENV: testing
- BCRYPT_ROUNDS: 4（テスト高速化のため）
- PULSE_ENABLED: false
- TELESCOPE_ENABLED: false

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| PHPUnit | PHP単体・結合テストフレームワーク | ^11.0.1 |
| Mockery | PHPモックライブラリ | ^1.6 |
| Faker | テストデータ生成 | ^1.23 |
| Laravel Pint | コードスタイルチェック | ^1.13 |
| Laravel Sail | Docker開発環境 | ^1.26 |
| Vite | フロントエンドビルドツール | ^5.0 |
| TailwindCSS | CSSフレームワーク | ^4.1 |
| Collision | テストエラー出力改善 | ^8.1 |

### 主要依存パッケージ

- **Filament**: ^4.1（管理パネルフレームワーク）
- **Filament Shield**: ^4.0（権限管理）
- **Laravel Framework**: ^11.9

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 70% |
| 分岐カバレッジ | 60% |
| クリティカルパス | 90% |

### 優先カバレッジ対象

1. **コアビジネスロジック**: 販売・購買・在庫・会計処理
2. **認証・認可**: ユーザーログイン、権限チェック
3. **データ整合性**: トランザクション処理、データ検証
4. **API エンドポイント**: 外部連携機能

## テストデータ

### テストデータ準備方針

1. **Factory パターンの活用**
   - Laravelのモデルファクトリを使用してテストデータを生成
   - 各プラグインモジュールに対応するファクトリを整備済み
   - 主要ファクトリ: UserFactory, CompanyFactory, OrderFactory, ProductFactory等

2. **Seeder の活用**
   - DatabaseSeederを通じた初期データ投入
   - SecurityDatabaseSeeder: ユーザー・権限データ
   - SupportDatabaseSeeder: 基盤データ
   - CurrencySeeder: 通貨データ

3. **テストデータベースの分離**
   - テスト時はSQLite（インメモリまたはファイル）を使用
   - RefreshDatabaseトレイトによるテスト毎のデータベースリセット

4. **機密データの取り扱い**
   - 本番データをテスト環境にコピーしない
   - 個人情報はFakerで生成した擬似データを使用

### 利用可能なテストファクトリ（抜粋）

| モジュール | ファクトリ |
| --- | --- |
| Support | CompanyFactory, BankFactory, UOMFactory |
| Partners | PartnerFactory, BankAccountFactory |
| Products | ProductFactory, CategoryFactory, PriceListFactory |
| Sales | OrderFactory, TeamFactory |
| Purchases | OrderFactory, RequisitionFactory |
| Inventories | WarehouseFactory, LocationFactory, OperationFactory |
| Accounts | AccountFactory, JournalFactory, MoveFactory, PaymentFactory |
| Employees | EmployeeFactory, DepartmentFactory, CalendarFactory |
| Projects | ProjectFactory, TaskFactory, MilestoneFactory |
| Time-off | LeaveFactory, LeaveTypeFactory, LeaveAllocationFactory |

## 不具合管理

### 不具合管理方針

1. **チケット管理**
   - GitHubのIssueトラッカーを使用（https://github.com/aureuserp/aureuserp/issues）
   - 不具合発見時は速やかにIssueを作成

2. **優先度分類**
   - Critical: システム停止、データ損失の可能性
   - High: 主要機能の動作不可
   - Medium: 機能の一部に問題
   - Low: 軽微な問題、UI/UXの改善

3. **不具合レポート必須項目**
   - 再現手順
   - 期待される動作
   - 実際の動作
   - 環境情報（PHP/Laravel/ブラウザバージョン等）
   - スクリーンショット/ログ

4. **修正確認**
   - 修正後は必ずリグレッションテストを実施
   - 該当する単体/結合テストを追加

## CI/CD連携

### 現状の構成

現時点では、GitHub ActionsやGitLab CI等のCI/CD設定ファイルは確認されていない。以下は推奨されるCI/CD構成である。

### 推奨CI/CD構成

1. **プルリクエスト時**
   - PHPUnitテスト実行
   - Laravel Pintによるコードスタイルチェック
   - 静的解析（PHPStan推奨）

2. **マージ時**
   - 全テストスイート実行
   - カバレッジレポート生成
   - ステージング環境へのデプロイ

3. **リリース時**
   - 本番環境へのデプロイ
   - スモークテスト実行
   - ロールバック手順の確認

### 推奨GitHub Actions設定

```yaml
name: Tests
on: [push, pull_request]
jobs:
  tests:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v4
      - name: Setup PHP
        uses: shivammathur/setup-php@v2
        with:
          php-version: '8.2'
      - name: Install Dependencies
        run: composer install --prefer-dist --no-progress
      - name: Run Tests
        run: vendor/bin/phpunit
```

## 備考

### テストスイート構成

現在のプロジェクトには以下のテストスイートが定義されている（phpunit.xml）：

1. **Unit**: `tests/Unit` - 純粋な単体テスト
2. **Feature**: `tests/Feature` - アプリケーション機能テスト

### プラグインモジュール

AureusERPはプラグイン形式でモジュールを追加できる構成となっており、以下のモジュールが存在する：

- accounts（会計）
- analytics（分析）
- blogs（ブログ）
- chatter（チャット）
- contacts（連絡先）
- employees（従業員）
- fields（カスタムフィールド）
- full-calendar（カレンダー）
- inventories（在庫）
- invoices（請求書）
- partners（取引先）
- payments（支払い）
- plugin-manager（プラグイン管理）
- products（商品）
- projects（プロジェクト）
- purchases（購買）
- recruitments（採用）
- sales（販売）
- security（セキュリティ）
- support（サポート）
- table-views（テーブルビュー）
- time-off（休暇）
- timesheets（勤怠）
- website（ウェブサイト）

各プラグインモジュールには、個別のテストファクトリが整備されており、モジュール単位でのテストが可能な構成となっている。

### 今後の推奨事項

1. **テストカバレッジの拡充**: 現在、サンプルテストのみ存在するため、各モジュールの単体・結合テストを追加
2. **CI/CD設定の導入**: GitHub Actionsによる自動テスト実行環境の構築
3. **E2Eテストの追加**: Laravel Dusk等によるブラウザテストの導入検討
4. **静的解析ツールの導入**: PHPStanやPsalmによるコード品質向上
5. **APIテストの強化**: API エンドポイントの網羅的なテスト
