# ER図

## 概要

本ドキュメントは、AureusERPのデータベース構造をMermaid形式のER図で表現したものです。システムの複雑さを考慮し、ドメインごとにER図を分割して記載しています。

---

## 1. コアモジュール

ユーザー、会社、権限管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    users {
        bigint id PK
        varchar name
        varchar email UK
        timestamp email_verified_at
        varchar language
        boolean is_active
        varchar password
        varchar remember_token
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    companies {
        bigint id PK
        bigint parent_id FK
        bigint currency_id FK
        bigint creator_id FK
        integer sort
        varchar name
        varchar company_id UK
        varchar tax_id UK
        varchar registration_number
        varchar email
        varchar phone
        varchar mobile
        varchar website
        varchar color
        boolean is_active
        date founded_date
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    sessions {
        varchar id PK
        bigint user_id FK
        varchar ip_address
        text user_agent
        longtext payload
        integer last_activity
    }

    permissions {
        bigint id PK
        varchar name
        varchar guard_name
        timestamp created_at
        timestamp updated_at
    }

    roles {
        bigint id PK
        bigint team_foreign_key FK
        varchar name
        varchar guard_name
        timestamp created_at
        timestamp updated_at
    }

    teams {
        bigint id PK
        varchar name
        timestamp created_at
        timestamp updated_at
    }

    user_team {
        bigint user_id FK
        bigint team_id FK
    }

    model_has_roles {
        bigint role_id FK
        varchar model_type
        bigint model_id
    }

    model_has_permissions {
        bigint permission_id FK
        varchar model_type
        bigint model_id
    }

    role_has_permissions {
        bigint permission_id FK
        bigint role_id FK
    }

    users ||--o{ sessions : "has"
    users ||--o{ user_team : "belongs to"
    teams ||--o{ user_team : "has"
    companies ||--o| companies : "parent"
    companies }o--|| users : "created by"
    roles ||--o{ model_has_roles : "assigned to"
    permissions ||--o{ model_has_permissions : "granted to"
    roles ||--o{ role_has_permissions : "has"
    permissions ||--o{ role_has_permissions : "belongs to"
```

---

## 2. パートナーモジュール

取引先（顧客/仕入先）管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    partners_partners {
        bigint id PK
        varchar account_type
        varchar sub_type
        varchar name
        varchar avatar
        varchar email
        varchar job_title
        varchar website
        varchar tax_id
        varchar phone
        varchar mobile
        varchar color
        varchar company_registry
        varchar reference
        bigint parent_id FK
        bigint creator_id FK
        bigint user_id FK
        bigint title_id FK
        bigint company_id FK
        bigint industry_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    partners_titles {
        bigint id PK
        varchar name
        varchar shortcut
        timestamp created_at
        timestamp updated_at
    }

    partners_industries {
        bigint id PK
        varchar name
        varchar full_name
        bigint parent_id FK
        timestamp created_at
        timestamp updated_at
    }

    partners_tags {
        bigint id PK
        varchar name
        varchar color
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    partners_partner_tag {
        bigint partner_id FK
        bigint tag_id FK
    }

    partners_bank_accounts {
        bigint id PK
        bigint partner_id FK
        varchar account_number
        varchar bank_name
        boolean is_active
        timestamp created_at
        timestamp updated_at
    }

    partners_partners ||--o| partners_partners : "parent"
    partners_partners }o--o| partners_titles : "has title"
    partners_partners }o--o| partners_industries : "in industry"
    partners_partners }o--o| companies : "belongs to"
    partners_partners }o--o| users : "linked to"
    partners_partners ||--o{ partners_partner_tag : "has"
    partners_tags ||--o{ partners_partner_tag : "tagged"
    partners_partners ||--o{ partners_bank_accounts : "has"
```

---

## 3. 商品モジュール

商品管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    products_products {
        bigint id PK
        varchar type
        varchar name
        varchar service_tracking
        varchar reference
        varchar barcode
        decimal price
        decimal cost
        decimal volume
        decimal weight
        text description
        text description_purchase
        text description_sale
        boolean enable_sales
        boolean enable_purchase
        boolean is_favorite
        boolean is_configurable
        integer sort
        json images
        bigint parent_id FK
        bigint uom_id FK
        bigint uom_po_id FK
        bigint category_id FK
        bigint company_id FK
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    products_categories {
        bigint id PK
        varchar name
        varchar full_name
        varchar parent_path
        bigint parent_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    products_tags {
        bigint id PK
        varchar name UK
        varchar color
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    products_product_tag {
        bigint product_id FK
        bigint tag_id FK
    }

    products_attributes {
        bigint id PK
        varchar name
        varchar type
        integer sort
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    products_attribute_options {
        bigint id PK
        varchar name
        varchar color
        decimal extra_price
        integer sort
        bigint attribute_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    products_packagings {
        bigint id PK
        varchar name
        bigint product_id FK
        decimal qty
        timestamp created_at
        timestamp updated_at
    }

    products_product_suppliers {
        bigint id PK
        bigint product_id FK
        bigint partner_id FK
        decimal price
        integer delay
        timestamp created_at
        timestamp updated_at
    }

    products_products ||--o| products_products : "variant of"
    products_products }o--|| products_categories : "in category"
    products_products ||--o{ products_product_tag : "has"
    products_tags ||--o{ products_product_tag : "tagged"
    products_attributes ||--o{ products_attribute_options : "has options"
    products_products ||--o{ products_packagings : "has"
    products_products ||--o{ products_product_suppliers : "supplied by"
    partners_partners ||--o{ products_product_suppliers : "supplies"
    products_categories ||--o| products_categories : "parent"
```

---

## 4. 販売モジュール

販売・受注管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    sales_teams {
        bigint id PK
        integer sort
        bigint company_id FK
        bigint user_id FK
        varchar color
        bigint creator_id FK
        varchar name
        boolean is_active
        decimal invoiced_target
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    sales_team_members {
        bigint id PK
        bigint team_id FK
        bigint user_id FK
        timestamp created_at
        timestamp updated_at
    }

    sales_orders {
        bigint id PK
        bigint utm_source_id FK
        bigint campaign_id FK
        bigint medium_id FK
        bigint company_id FK
        bigint partner_id FK
        bigint journal_id FK
        bigint partner_invoice_id FK
        bigint partner_shipping_id FK
        bigint fiscal_position_id FK
        bigint payment_term_id FK
        bigint currency_id FK
        bigint user_id FK
        bigint team_id FK
        bigint creator_id FK
        bigint sale_order_template_id FK
        varchar access_token
        varchar name
        varchar state
        varchar client_order_ref
        varchar origin
        varchar reference
        varchar signed_by
        varchar invoice_status
        date validity_date
        text note
        decimal currency_rate
        decimal amount_untaxed
        decimal amount_tax
        decimal amount_total
        boolean locked
        boolean require_signature
        boolean require_payment
        date commitment_date
        date date_order
        date signed_on
        decimal prepayment_percent
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    sales_order_lines {
        bigint id PK
        integer sort
        bigint order_id FK
        bigint company_id FK
        bigint currency_id FK
        bigint order_partner_id FK
        bigint salesman_id FK
        bigint product_id FK
        bigint product_uom_id FK
        bigint product_packaging_id FK
        bigint creator_id FK
        varchar state
        varchar display_type
        varchar name
        decimal product_uom_qty
        decimal product_qty
        decimal price_unit
        decimal discount
        decimal price_subtotal
        decimal price_total
        decimal qty_delivered
        decimal qty_invoiced
        decimal qty_to_invoice
        boolean is_downpayment
        timestamp created_at
        timestamp updated_at
    }

    sales_order_templates {
        bigint id PK
        varchar name
        integer confirmation_mail_template_id FK
        text note
        boolean is_active
        timestamp created_at
        timestamp updated_at
    }

    sales_order_template_products {
        bigint id PK
        bigint template_id FK
        bigint product_id FK
        decimal quantity
        decimal price_unit
        timestamp created_at
        timestamp updated_at
    }

    sales_teams ||--o{ sales_team_members : "has"
    users ||--o{ sales_team_members : "belongs to"
    sales_teams ||--o{ sales_orders : "manages"
    sales_orders ||--o{ sales_order_lines : "contains"
    sales_orders }o--|| partners_partners : "customer"
    sales_orders }o--|| partners_partners : "invoice to"
    sales_orders }o--|| partners_partners : "ship to"
    sales_order_lines }o--o| products_products : "for product"
    sales_order_templates ||--o{ sales_order_template_products : "has"
    sales_orders }o--o| sales_order_templates : "from template"
```

---

## 5. 購買モジュール

購買・発注管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    purchases_order_groups {
        bigint id PK
        varchar name
        bigint company_id FK
        timestamp created_at
        timestamp updated_at
    }

    purchases_requisitions {
        bigint id PK
        varchar name
        varchar state
        bigint company_id FK
        bigint user_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    purchases_requisition_lines {
        bigint id PK
        bigint requisition_id FK
        bigint product_id FK
        decimal quantity
        timestamp created_at
        timestamp updated_at
    }

    purchases_orders {
        bigint id PK
        varchar name
        text description
        varchar priority
        varchar origin
        varchar partner_reference
        varchar state
        varchar invoice_status
        varchar receipt_status
        decimal untaxed_amount
        decimal tax_amount
        decimal total_amount
        decimal total_cc_amount
        decimal currency_rate
        integer invoice_count
        datetime ordered_at
        datetime approved_at
        datetime planned_at
        datetime effective_date
        varchar incoterm_location
        boolean mail_reminder_confirmed
        boolean mail_reception_confirmed
        boolean report_grids
        bigint requisition_id FK
        bigint purchases_group_id FK
        bigint partner_id FK
        bigint currency_id FK
        bigint fiscal_position_id FK
        bigint payment_term_id FK
        bigint incoterm_id FK
        bigint user_id FK
        bigint company_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    purchases_order_lines {
        bigint id PK
        text name
        varchar state
        integer sort
        varchar qty_received_method
        varchar display_type
        decimal product_qty
        double product_uom_qty
        decimal discount
        decimal price_unit
        decimal price_subtotal
        decimal price_total
        decimal qty_invoiced
        decimal qty_received
        decimal qty_to_invoice
        boolean is_downpayment
        timestamp planned_at
        bigint uom_id FK
        bigint product_id FK
        bigint product_packaging_id FK
        bigint order_id FK
        bigint partner_id FK
        bigint currency_id FK
        bigint company_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    purchases_order_groups ||--o{ purchases_orders : "contains"
    purchases_requisitions ||--o{ purchases_requisition_lines : "has"
    purchases_requisitions ||--o{ purchases_orders : "generates"
    purchases_orders ||--o{ purchases_order_lines : "contains"
    purchases_orders }o--|| partners_partners : "vendor"
    purchases_order_lines }o--o| products_products : "for product"
    purchases_requisition_lines }o--|| products_products : "for product"
```

---

## 6. 在庫モジュール

在庫・倉庫管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    inventories_warehouses {
        bigint id PK
        varchar name
        varchar code
        integer sort
        varchar reception_steps
        varchar delivery_steps
        bigint company_id FK
        bigint partner_address_id FK
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    inventories_locations {
        bigint id PK
        integer position_x
        integer position_y
        integer position_z
        varchar type
        varchar name
        varchar full_name
        varchar description
        varchar parent_path
        varchar barcode
        varchar removal_strategy
        integer cyclic_inventory_frequency
        date last_inventory_date
        date next_inventory_date
        boolean is_scrap
        boolean is_replenish
        boolean is_dock
        bigint parent_id FK
        bigint company_id FK
        bigint storage_category_id FK
        bigint warehouse_id FK
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    inventories_storage_categories {
        bigint id PK
        varchar name
        bigint company_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    inventories_operation_types {
        bigint id PK
        varchar name
        varchar code
        varchar type
        bigint warehouse_id FK
        bigint default_location_src_id FK
        bigint default_location_dest_id FK
        timestamp created_at
        timestamp updated_at
    }

    inventories_operations {
        bigint id PK
        varchar name
        varchar state
        varchar origin
        bigint operation_type_id FK
        bigint partner_id FK
        bigint source_location_id FK
        bigint destination_location_id FK
        bigint company_id FK
        bigint creator_id FK
        datetime scheduled_date
        timestamp created_at
        timestamp updated_at
    }

    inventories_moves {
        bigint id PK
        varchar name
        varchar state
        varchar origin
        varchar procure_method
        varchar reference
        text description_picking
        decimal product_qty
        decimal product_uom_qty
        decimal quantity
        boolean is_picked
        boolean is_scraped
        boolean is_inventory
        date reservation_date
        datetime scheduled_at
        datetime deadline
        bigint operation_id FK
        bigint product_id FK
        bigint uom_id FK
        bigint source_location_id FK
        bigint destination_location_id FK
        bigint partner_id FK
        bigint warehouse_id FK
        bigint company_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    inventories_lots {
        bigint id PK
        varchar name
        bigint product_id FK
        bigint company_id FK
        date expiration_date
        timestamp created_at
        timestamp updated_at
    }

    inventories_product_quantities {
        bigint id PK
        bigint product_id FK
        bigint location_id FK
        bigint lot_id FK
        bigint package_id FK
        bigint company_id FK
        decimal quantity
        decimal reserved_quantity
        timestamp created_at
        timestamp updated_at
    }

    inventories_warehouses ||--o{ inventories_locations : "has"
    inventories_locations ||--o| inventories_locations : "parent"
    inventories_locations }o--o| inventories_storage_categories : "category"
    inventories_warehouses ||--o{ inventories_operation_types : "has"
    inventories_operations ||--o{ inventories_moves : "contains"
    inventories_moves }o--|| products_products : "for product"
    inventories_moves }o--|| inventories_locations : "from"
    inventories_moves }o--|| inventories_locations : "to"
    inventories_product_quantities }o--|| products_products : "for"
    inventories_product_quantities }o--|| inventories_locations : "at"
    inventories_product_quantities }o--o| inventories_lots : "lot"
```

---

## 7. 会計モジュール

会計・仕訳管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    accounts_accounts {
        bigint id PK
        varchar code
        varchar name
        varchar type
        varchar internal_type
        varchar internal_group
        boolean reconcile
        boolean deprecated
        bigint company_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    accounts_journals {
        bigint id PK
        varchar name
        varchar code
        varchar type
        bigint company_id FK
        bigint default_account_id FK
        bigint payment_debit_account_id FK
        bigint payment_credit_account_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    accounts_taxes {
        bigint id PK
        varchar name
        varchar type_tax_use
        decimal amount
        varchar amount_type
        boolean is_active
        bigint company_id FK
        bigint tax_group_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    accounts_tax_groups {
        bigint id PK
        varchar name
        integer sort
        bigint company_id FK
        timestamp created_at
        timestamp updated_at
    }

    accounts_payment_terms {
        bigint id PK
        varchar name
        text note
        boolean is_active
        bigint company_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    accounts_account_moves {
        bigint id PK
        integer sort
        bigint journal_id FK
        bigint company_id FK
        bigint invoice_payment_term_id FK
        bigint partner_id FK
        bigint fiscal_position_id FK
        bigint currency_id FK
        bigint creator_id FK
        varchar name
        varchar reference
        varchar state
        varchar move_type
        varchar payment_state
        date date
        date invoice_date
        date invoice_date_due
        text narration
        decimal amount_untaxed
        decimal amount_tax
        decimal amount_total
        decimal amount_residual
        boolean auto_post
        timestamp created_at
        timestamp updated_at
    }

    accounts_account_move_lines {
        bigint id PK
        bigint move_id FK
        bigint account_id FK
        bigint partner_id FK
        bigint product_id FK
        bigint currency_id FK
        bigint company_id FK
        varchar name
        decimal quantity
        decimal price_unit
        decimal discount
        decimal debit
        decimal credit
        decimal balance
        decimal amount_currency
        timestamp created_at
        timestamp updated_at
    }

    accounts_account_payments {
        bigint id PK
        varchar name
        varchar payment_type
        varchar partner_type
        decimal amount
        bigint partner_id FK
        bigint journal_id FK
        bigint company_id FK
        bigint creator_id FK
        date date
        timestamp created_at
        timestamp updated_at
    }

    accounts_journals ||--o{ accounts_account_moves : "records"
    accounts_account_moves ||--o{ accounts_account_move_lines : "contains"
    accounts_account_move_lines }o--|| accounts_accounts : "for account"
    accounts_account_moves }o--o| partners_partners : "for partner"
    accounts_account_moves }o--o| accounts_payment_terms : "payment term"
    accounts_taxes }o--|| accounts_tax_groups : "in group"
    accounts_account_payments }o--|| accounts_journals : "in journal"
    accounts_account_payments }o--|| partners_partners : "to/from"
```

---

## 8. プロジェクトモジュール

プロジェクト・タスク管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    projects_project_stages {
        bigint id PK
        varchar name
        integer sort
        varchar color
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    projects_projects {
        bigint id PK
        varchar name
        varchar tasks_label
        text description
        varchar visibility
        varchar color
        integer sort
        date start_date
        date end_date
        decimal allocated_hours
        boolean allow_timesheets
        boolean allow_milestones
        boolean allow_task_dependencies
        boolean is_active
        bigint stage_id FK
        bigint partner_id FK
        bigint company_id FK
        bigint user_id FK
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    projects_milestones {
        bigint id PK
        varchar name
        bigint project_id FK
        date deadline
        boolean is_reached
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    projects_task_stages {
        bigint id PK
        varchar name
        integer sort
        varchar color
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    projects_tasks {
        bigint id PK
        varchar title
        text description
        varchar color
        boolean priority
        varchar state
        json tags
        integer sort
        boolean is_active
        boolean is_recurring
        datetime deadline
        decimal allocated_hours
        decimal remaining_hours
        decimal effective_hours
        decimal total_hours_spent
        decimal progress
        bigint project_id FK
        bigint milestone_id FK
        bigint stage_id FK
        bigint partner_id FK
        bigint parent_id FK
        bigint company_id FK
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    projects_task_users {
        bigint id PK
        bigint task_id FK
        bigint user_id FK
        timestamp created_at
        timestamp updated_at
    }

    projects_tags {
        bigint id PK
        varchar name
        varchar color
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    projects_project_tag {
        bigint project_id FK
        bigint tag_id FK
    }

    projects_task_tag {
        bigint task_id FK
        bigint tag_id FK
    }

    projects_project_stages ||--o{ projects_projects : "stage of"
    projects_projects ||--o{ projects_milestones : "has"
    projects_projects ||--o{ projects_tasks : "contains"
    projects_tasks ||--o| projects_tasks : "subtask of"
    projects_tasks }o--o| projects_milestones : "for milestone"
    projects_tasks }o--o| projects_task_stages : "at stage"
    projects_tasks ||--o{ projects_task_users : "assigned to"
    users ||--o{ projects_task_users : "works on"
    projects_projects ||--o{ projects_project_tag : "has"
    projects_tags ||--o{ projects_project_tag : "tagged"
    projects_tasks ||--o{ projects_task_tag : "has"
    projects_tags ||--o{ projects_task_tag : "tagged"
```

---

## 9. 従業員モジュール

従業員・人事管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    employees_departments {
        bigint id PK
        varchar name
        bigint parent_id FK
        bigint company_id FK
        bigint manager_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    employees_job_positions {
        bigint id PK
        varchar name
        text description
        text requirements
        boolean is_active
        bigint department_id FK
        bigint company_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    employees_work_locations {
        bigint id PK
        varchar name
        varchar address
        bigint company_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    employees_employees {
        bigint id PK
        varchar name
        varchar job_title
        varchar work_phone
        varchar mobile_phone
        varchar work_email
        varchar gender
        varchar birthday
        varchar marital
        varchar employee_type
        varchar barcode
        varchar pin
        boolean is_active
        bigint company_id FK
        bigint user_id FK
        bigint department_id FK
        bigint job_id FK
        bigint partner_id FK
        bigint work_location_id FK
        bigint parent_id FK
        bigint coach_id FK
        bigint country_id FK
        bigint departure_reason_id FK
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    employees_skill_types {
        bigint id PK
        varchar name
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    employees_skills {
        bigint id PK
        varchar name
        bigint skill_type_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    employees_skill_levels {
        bigint id PK
        varchar name
        integer level
        bigint skill_type_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    employees_employee_skills {
        bigint id PK
        bigint employee_id FK
        bigint skill_id FK
        bigint skill_level_id FK
        timestamp created_at
        timestamp updated_at
    }

    employees_calendars {
        bigint id PK
        varchar name
        bigint company_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    employees_departure_reasons {
        bigint id PK
        varchar name
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    employees_departments ||--o| employees_departments : "parent"
    employees_departments ||--o{ employees_job_positions : "has"
    employees_departments ||--o{ employees_employees : "has"
    employees_employees }o--o| employees_job_positions : "holds"
    employees_employees }o--o| employees_work_locations : "works at"
    employees_employees ||--o| employees_employees : "reports to"
    employees_employees ||--o| employees_employees : "coached by"
    employees_employees ||--o{ employees_employee_skills : "has"
    employees_skills ||--o{ employees_employee_skills : "possessed by"
    employees_skill_levels ||--o{ employees_employee_skills : "at level"
    employees_skill_types ||--o{ employees_skills : "has"
    employees_skill_types ||--o{ employees_skill_levels : "has"
    employees_employees }o--o| employees_departure_reasons : "left for"
    employees_employees }o--o| employees_calendars : "follows"
```

---

## 10. 休暇管理モジュール

休暇申請・管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    time_off_leave_types {
        bigint id PK
        integer sort
        varchar color
        bigint company_id FK
        integer max_allowed_negative
        bigint creator_id FK
        enum leave_validation_type
        enum requires_allocation
        enum employee_requests
        enum allocation_validation_type
        enum time_type
        enum request_unit
        varchar name
        boolean create_calendar_meeting
        boolean is_active
        boolean show_on_dashboard
        boolean unpaid
        boolean support_document
        boolean allows_negative
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    time_off_leaves {
        bigint id PK
        bigint user_id FK
        bigint manager_id FK
        bigint holiday_status_id FK
        bigint employee_id FK
        bigint employee_company_id FK
        bigint company_id FK
        bigint department_id FK
        bigint calendar_id FK
        integer meeting_id
        bigint first_approver_id FK
        bigint second_approver_id FK
        bigint creator_id FK
        varchar private_name
        varchar state
        varchar duration_display
        timestamp request_date_from
        timestamp request_date_to
        text notes
        varchar attachment
        boolean request_unit_half
        boolean request_unit_hours
        timestamp date_from
        timestamp date_to
        decimal number_of_days
        decimal number_of_hours
        timestamp created_at
        timestamp updated_at
    }

    time_off_leave_allocations {
        bigint id PK
        bigint employee_id FK
        bigint holiday_status_id FK
        bigint company_id FK
        bigint creator_id FK
        decimal number_of_days
        varchar state
        timestamp created_at
        timestamp updated_at
    }

    time_off_leave_accrual_plans {
        bigint id PK
        varchar name
        bigint time_off_type_id FK
        bigint company_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    time_off_leave_accrual_levels {
        bigint id PK
        bigint accrual_plan_id FK
        decimal added_value
        varchar frequency
        integer start_count
        varchar start_type
        timestamp created_at
        timestamp updated_at
    }

    time_off_leave_types ||--o{ time_off_leaves : "type of"
    time_off_leave_types ||--o{ time_off_leave_allocations : "allocated as"
    time_off_leave_types ||--o{ time_off_leave_accrual_plans : "accrued via"
    time_off_leave_accrual_plans ||--o{ time_off_leave_accrual_levels : "has"
    employees_employees ||--o{ time_off_leaves : "requests"
    employees_employees ||--o{ time_off_leave_allocations : "has allocation"
    time_off_leaves }o--o| employees_employees : "approved by first"
    time_off_leaves }o--o| employees_employees : "approved by second"
```

---

## 11. 採用モジュール

採用・応募者管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    recruitments_applicant_categories {
        bigint id PK
        varchar name
        varchar color
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    recruitments_candidates {
        bigint id PK
        varchar name
        varchar email
        varchar phone
        varchar mobile
        text availability
        boolean is_active
        bigint partner_id FK
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    recruitments_stages {
        bigint id PK
        varchar name
        integer sort
        boolean is_default
        varchar requirements
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    recruitments_applicants {
        bigint id PK
        bigint source_id FK
        bigint medium_id FK
        bigint candidate_id FK
        bigint stage_id FK
        bigint last_stage_id FK
        bigint company_id FK
        bigint recruiter_id FK
        bigint job_id FK
        bigint department_id FK
        bigint refuse_reason_id FK
        bigint creator_id FK
        varchar email_cc
        varchar priority
        varchar salary_proposed_extra
        varchar salary_expected_extra
        json applicant_properties
        text applicant_notes
        boolean is_active
        varchar state
        timestamp create_date
        timestamp date_closed
        timestamp date_opened
        timestamp date_last_stage_updated
        timestamp refuse_date
        decimal probability
        decimal salary_proposed
        decimal salary_expected
        decimal delay_close
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    recruitments_refuse_reasons {
        bigint id PK
        varchar name
        bigint creator_id FK
        timestamp created_at
        timestamp updated_at
    }

    recruitments_candidate_skills {
        bigint id PK
        bigint candidate_id FK
        bigint skill_id FK
        bigint skill_level_id FK
        timestamp created_at
        timestamp updated_at
    }

    recruitments_job_position_interviewers {
        bigint id PK
        bigint job_id FK
        bigint user_id FK
        timestamp created_at
        timestamp updated_at
    }

    recruitments_candidates ||--o{ recruitments_applicants : "applies as"
    recruitments_stages ||--o{ recruitments_applicants : "at stage"
    recruitments_applicants }o--o| employees_job_positions : "for position"
    recruitments_applicants }o--o| employees_departments : "in department"
    recruitments_applicants }o--o| recruitments_refuse_reasons : "refused for"
    recruitments_candidates ||--o{ recruitments_candidate_skills : "has"
    employees_skills ||--o{ recruitments_candidate_skills : "possessed by"
    employees_job_positions ||--o{ recruitments_job_position_interviewers : "interviewed by"
    users ||--o{ recruitments_job_position_interviewers : "interviews for"
```

---

## 12. ブログモジュール

ブログ・コンテンツ管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    blogs_categories {
        bigint id PK
        varchar name
        text sub_title
        varchar slug UK
        varchar image
        varchar meta_title
        varchar meta_keywords
        text meta_description
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    blogs_posts {
        bigint id PK
        varchar title
        text sub_title
        text content
        varchar slug UK
        varchar image
        varchar author_name
        boolean is_published
        datetime published_at
        integer visits
        text meta_title
        text meta_keywords
        text meta_description
        bigint category_id FK
        bigint author_id FK
        bigint creator_id FK
        bigint last_editor_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    blogs_tags {
        bigint id PK
        varchar name UK
        varchar color
        bigint creator_id FK
        timestamp deleted_at
        timestamp created_at
        timestamp updated_at
    }

    blogs_post_tags {
        bigint post_id FK
        bigint tag_id FK
    }

    blogs_categories ||--o{ blogs_posts : "contains"
    blogs_posts ||--o{ blogs_post_tags : "has"
    blogs_tags ||--o{ blogs_post_tags : "tagged"
    users ||--o{ blogs_posts : "authored by"
    users ||--o{ blogs_posts : "last edited by"
```

---

## 13. 決済モジュール

決済・トランザクション管理に関するエンティティの関連を示します。

```mermaid
erDiagram
    payments_payment_methods {
        bigint id PK
        integer sort
        bigint primary_payment_method_id FK
        bigint created_by FK
        varchar code
        varchar support_refund
        varchar name
        boolean is_active
        boolean support_tokenization
        boolean support_express_checkout
        timestamp created_at
        timestamp updated_at
    }

    payments_payment_tokens {
        bigint id PK
        bigint company_id FK
        bigint payment_method_id FK
        bigint partner_id FK
        bigint created_by FK
        json payment_details
        varchar provider_reference_id
        boolean is_active
        timestamp created_at
        timestamp updated_at
    }

    payments_payment_transactions {
        bigint id PK
        bigint payment_method_id FK
        bigint partner_id FK
        bigint company_id FK
        bigint created_by FK
        varchar reference
        varchar state
        decimal amount
        varchar currency
        timestamp created_at
        timestamp updated_at
    }

    payments_payment_methods ||--o| payments_payment_methods : "primary"
    payments_payment_methods ||--o{ payments_payment_tokens : "issues"
    payments_payment_methods ||--o{ payments_payment_transactions : "processes"
    partners_partners ||--o{ payments_payment_tokens : "owns"
    partners_partners ||--o{ payments_payment_transactions : "makes"
```

---

## 備考

- 上記ER図はシステムの主要なエンティティとリレーションシップを示しています
- 実際のデータベースには追加のインデックス、制約、トリガーが設定されている場合があります
- 各モジュールは疎結合で設計されており、モジュール間の依存は最小限に抑えられています
- 多対多の関連は中間テーブル（ピボットテーブル）を使用して実装されています
