---
generated_at: 2025-12-26 14:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **unit_of_measuresテーブル定義**：マイグレーションファイルが見つからず詳細不明
  2. **currenciesテーブル定義**：マイグレーションファイルが見つからず詳細不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `database/migrations/0001_01_01_000000_create_users_table.php`
- E-02: `database/migrations/0001_01_01_000001_create_cache_table.php`
- E-03: `database/migrations/0001_01_01_000002_create_jobs_table.php`
- E-04: `database/migrations/2024_11_04_132945_create_permission_tables.php`
- E-05: `database/migrations/2022_12_14_083707_create_settings_table.php`
- E-06: `plugins/webkul/products/database/migrations/2025_01_05_100751_create_products_products_table.php`
- E-07: `plugins/webkul/products/database/migrations/2025_01_05_063925_create_products_categories_table.php`
- E-08: `plugins/webkul/products/database/migrations/2025_01_05_100830_create_products_tags_table.php`
- E-09: `plugins/webkul/products/database/migrations/2025_01_05_104456_create_products_attributes_table.php`
- E-10: `plugins/webkul/products/database/migrations/2025_01_05_104512_create_products_attribute_options_table.php`
- E-11: `plugins/webkul/sales/database/migrations/2025_02_05_053212_create_sales_orders_table.php`
- E-12: `plugins/webkul/sales/database/migrations/2025_02_05_102851_create_sales_order_lines_table.php`
- E-13: `plugins/webkul/sales/database/migrations/2025_01_28_061110_create_sales_teams_table.php`
- E-14: `plugins/webkul/purchases/database/migrations/2025_02_11_101110_create_purchases_orders_table.php`
- E-15: `plugins/webkul/purchases/database/migrations/2025_02_11_101118_create_purchases_order_lines_table.php`
- E-16: `plugins/webkul/projects/database/migrations/2024_12_12_074929_create_projects_projects_table.php`
- E-17: `plugins/webkul/projects/database/migrations/2024_12_12_101344_create_projects_tasks_table.php`
- E-18: `plugins/webkul/blogs/database/migrations/2025_03_06_093011_create_blogs_categories_table.php`
- E-19: `plugins/webkul/blogs/database/migrations/2025_03_06_094011_create_blogs_posts_table.php`
- E-20: `plugins/webkul/security/database/migrations/2024_11_12_125715_create_teams_table.php`
- E-21: `plugins/webkul/time-off/database/migrations/2025_01_17_080711_create_time_off_leave_types_table.php`
- E-22: `plugins/webkul/time-off/database/migrations/2025_01_17_080712_create_time_off_leaves_table.php`
- E-23: `plugins/webkul/recruitments/database/migrations/2025_01_10_115422_create_recruitments_applicants_table.php`
- E-24: `plugins/webkul/payments/database/migrations/2025_02_10_131418_create_payments_payment_methods_table.php`
- E-25: `plugins/webkul/payments/database/migrations/2025_02_11_101123_create_payments_payment_tokens_table.php`
- E-26: `plugins/webkul/partners/database/migrations/2024_12_11_101220_create_partners_partners_table.php`
- E-27: `plugins/webkul/support/database/migrations/2024_12_10_092657_create_companies_table.php`
- E-28: `plugins/webkul/employees/database/migrations/2024_12_12_063353_create_employees_employees_table.php`
- E-29: `plugins/webkul/accounts/database/migrations/2025_02_11_055303_create_accounts_account_moves_table.php`
- E-30: `plugins/webkul/inventories/database/migrations/2025_01_14_133260_create_inventories_moves_table.php`
- E-31: `plugins/webkul/inventories/database/migrations/2025_01_06_072130_create_inventories_warehouses_table.php`
- E-32: `plugins/webkul/inventories/database/migrations/2025_01_06_072224_create_inventories_locations_table.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | usersテーブルにはid, name, email, password等のカラムが存在する | E-01 | ○ |
| C-02 | usersテーブルはソフトデリートを採用している | E-01 | ○ |
| C-03 | sessionsテーブルはユーザーセッション管理に使用される | E-01 | ○ |
| C-04 | cacheテーブルはキャッシュデータ管理に使用される | E-02 | ○ |
| C-05 | jobsテーブルはキュージョブ管理に使用される | E-03 | ○ |
| C-06 | permissionsテーブルは権限定義を管理する | E-04 | ○ |
| C-07 | rolesテーブルはロール定義を管理する | E-04 | ○ |
| C-08 | role_has_permissionsテーブルでロールと権限を関連付ける | E-04 | ○ |
| C-09 | settingsテーブルはシステム設定を管理する | E-05 | ○ |
| C-10 | products_productsテーブルは商品情報を管理する | E-06 | ○ |
| C-11 | products_productsテーブルはparent_idで自己参照を持つ | E-06 | ○ |
| C-12 | products_productsテーブルはuom_idで単位を参照する | E-06 | ○ |
| C-13 | products_categoriesテーブルは階層構造を持つ | E-07 | ○ |
| C-14 | products_tagsテーブルは商品タグを管理する | E-08 | ○ |
| C-15 | products_attributesテーブルは商品属性を管理する | E-09 | ○ |
| C-16 | products_attribute_optionsテーブルは属性オプションを管理する | E-10 | ○ |
| C-17 | sales_ordersテーブルは受注オーダーを管理する | E-11 | ○ |
| C-18 | sales_ordersテーブルは複数の外部キー参照を持つ | E-11 | ○ |
| C-19 | sales_order_linesテーブルは受注明細を管理する | E-12 | ○ |
| C-20 | sales_order_linesテーブルはorder_idで受注に関連付く | E-12 | ○ |
| C-21 | sales_teamsテーブルは営業チームを管理する | E-13 | ○ |
| C-22 | purchases_ordersテーブルは発注オーダーを管理する | E-14 | ○ |
| C-23 | purchases_ordersテーブルは複数のインデックスを持つ | E-14 | ○ |
| C-24 | purchases_order_linesテーブルは発注明細を管理する | E-15 | ○ |
| C-25 | projects_projectsテーブルはプロジェクトを管理する | E-16 | ○ |
| C-26 | projects_tasksテーブルはタスクを管理する | E-17 | ○ |
| C-27 | projects_tasksテーブルはparent_idで親子関係を持つ | E-17 | ○ |
| C-28 | blogs_categoriesテーブルはブログカテゴリを管理する | E-18 | ○ |
| C-29 | blogs_postsテーブルはブログ投稿を管理する | E-19 | ○ |
| C-30 | teamsテーブルはチームを管理する | E-20 | ○ |
| C-31 | time_off_leave_typesテーブルは休暇タイプを管理する | E-21 | ○ |
| C-32 | time_off_leavesテーブルは休暇申請を管理する | E-22 | ○ |
| C-33 | recruitments_applicantsテーブルは応募者を管理する | E-23 | ○ |
| C-34 | payments_payment_methodsテーブルは決済方法を管理する | E-24 | ○ |
| C-35 | payments_payment_tokensテーブルは決済トークンを管理する | E-25 | ○ |
| C-36 | partners_partnersテーブルは取引先を管理する | E-26 | ○ |
| C-37 | partners_partnersテーブルはparent_idで自己参照を持つ | E-26 | ○ |
| C-38 | companiesテーブルは会社情報を管理する | E-27 | ○ |
| C-39 | companiesテーブルはparent_idで親子関係を持つ | E-27 | ○ |
| C-40 | employees_employeesテーブルは従業員を管理する | E-28 | ○ |
| C-41 | employees_employeesテーブルは多数の外部キー参照を持つ | E-28 | ○ |
| C-42 | accounts_account_movesテーブルは会計仕訳を管理する | E-29 | ○ |
| C-43 | inventories_movesテーブルは在庫移動を管理する | E-30 | ○ |
| C-44 | unit_of_measuresテーブルは単位を管理する | **根拠なし** | △ |
| C-45 | currenciesテーブルは通貨を管理する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **unit_of_measuresテーブル**：products_productsテーブルがuom_id, uom_po_idで参照しているが、マイグレーションファイルが発見できなかった
  - 候補：supportプラグインまたは外部パッケージで定義されている可能性 / seedersで作成されている可能性 / 別名のマイグレーションファイル
- **currenciesテーブル**：companiesテーブル、sales_ordersテーブル等が参照しているが、マイグレーションファイルが発見できなかった
  - 候補：supportプラグインまたは外部パッケージで定義されている可能性 / seedersで作成されている可能性 / 別名のマイグレーションファイル

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**：テーブル一覧と各テーブル定義は全てマイグレーションファイルから抽出しており、高い信頼性がある
- **0: 低リスク**：外部キー制約とカラム定義は実際のマイグレーションコードに基づいている
- **1: 中リスク**：unit_of_measures, currenciesテーブルの詳細定義が確認できていない
- **0: 低リスク**：ER図のリレーションシップはマイグレーションファイル内のforeign key定義に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] unit_of_measuresテーブルのマイグレーションファイルを確認し、テーブル定義を補完する
- [ ] currenciesテーブルのマイグレーションファイルを確認し、テーブル定義を補完する
- [ ] 本番環境のデータベーススキーマとドキュメントを照合し、差異がないか確認する
- [ ] 追加のalterマイグレーション（テーブル変更）により、最新のカラム構成が反映されているか確認する
- [ ] インデックス設定が運用要件を満たしているか確認する
