# データベース設計書

## 概要

本ドキュメントは、AureusERP（Laravel/Filament ベースのオープンソースERP）のデータベース設計を記述したものです。本システムは、販売管理、購買管理、在庫管理、プロジェクト管理、人事管理、会計管理、ブログ管理など複数のドメインを持つモジュラー構造のERPアプリケーションです。

## テーブル一覧

### コアモジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| users | User | システムユーザー情報 |
| password_reset_tokens | PasswordResetToken | パスワードリセットトークン管理 |
| sessions | Session | ユーザーセッション管理 |
| cache | Cache | キャッシュデータ |
| cache_locks | CacheLock | キャッシュロック管理 |
| jobs | Job | キュージョブ管理 |
| job_batches | JobBatch | バッチジョブ管理 |
| failed_jobs | FailedJob | 失敗ジョブ管理 |
| settings | Setting | システム設定 |
| permissions | Permission | 権限定義 |
| roles | Role | ロール定義 |
| model_has_permissions | ModelHasPermission | モデルと権限の関連 |
| model_has_roles | ModelHasRole | モデルとロールの関連 |
| role_has_permissions | RoleHasPermission | ロールと権限の関連 |
| teams | Team | チーム管理 |
| user_team | UserTeam | ユーザーとチームの関連 |
| user_invitations | UserInvitation | ユーザー招待管理 |
| companies | Company | 会社情報 |
| user_allowed_companies | UserAllowedCompany | ユーザーの許可会社 |

### パートナーモジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| partners_partners | Partner | 取引先（顧客・仕入先）情報 |
| partners_titles | PartnerTitle | 敬称マスタ |
| partners_industries | Industry | 業種マスタ |
| partners_tags | PartnerTag | パートナータグ |
| partners_partner_tag | PartnerTagPivot | パートナーとタグの関連 |
| partners_bank_accounts | PartnerBankAccount | パートナー銀行口座 |

### 商品モジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| products_products | Product | 商品情報 |
| products_categories | ProductCategory | 商品カテゴリ |
| products_tags | ProductTag | 商品タグ |
| products_product_tag | ProductTagPivot | 商品とタグの関連 |
| products_attributes | ProductAttribute | 商品属性 |
| products_attribute_options | AttributeOption | 属性オプション |
| products_product_attributes | ProductProductAttribute | 商品と属性の関連 |
| products_product_attribute_values | ProductAttributeValue | 商品属性値 |
| products_product_combinations | ProductCombination | 商品バリエーション |
| products_packagings | Packaging | 梱包情報 |
| products_price_rules | PriceRule | 価格ルール |
| products_price_rule_items | PriceRuleItem | 価格ルール項目 |
| products_product_price_lists | ProductPriceList | 商品価格リスト |
| products_product_suppliers | ProductSupplier | 商品仕入先関連 |

### 販売モジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| sales_teams | SalesTeam | 営業チーム |
| sales_team_members | SalesTeamMember | 営業チームメンバー |
| sales_orders | SalesOrder | 受注オーダー |
| sales_order_lines | SalesOrderLine | 受注明細 |
| sales_order_line_taxes | SalesOrderLineTax | 受注明細税金 |
| sales_order_templates | SalesOrderTemplate | 受注テンプレート |
| sales_order_template_products | SalesOrderTemplateProduct | 受注テンプレート商品 |
| sales_order_options | SalesOrderOption | 受注オプション |
| sales_tag | SalesTag | 販売タグ |
| sales_order_tags | SalesOrderTag | 受注タグ関連 |
| sales_order_invoices | SalesOrderInvoice | 受注請求書関連 |
| sales_order_line_invoices | SalesOrderLineInvoice | 受注明細請求書関連 |
| sales_advance_payment_invoices | AdvancePaymentInvoice | 前受金請求書 |
| sales_advance_payment_invoice_order_sales | AdvancePaymentInvoiceOrderSale | 前受金請求書と受注の関連 |

### 購買モジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| purchases_order_groups | PurchaseOrderGroup | 購買オーダーグループ |
| purchases_requisitions | PurchaseRequisition | 購買依頼 |
| purchases_requisition_lines | PurchaseRequisitionLine | 購買依頼明細 |
| purchases_orders | PurchaseOrder | 発注オーダー |
| purchases_order_lines | PurchaseOrderLine | 発注明細 |
| purchases_order_line_taxes | PurchaseOrderLineTax | 発注明細税金 |
| purchases_order_account_moves | PurchaseOrderAccountMove | 発注と会計仕訳の関連 |
| purchases_order_operations | PurchaseOrderOperation | 発注オペレーション |

### 在庫モジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| inventories_warehouses | Warehouse | 倉庫 |
| inventories_warehouse_resupplies | WarehouseResupply | 倉庫補充設定 |
| inventories_locations | Location | ロケーション |
| inventories_storage_categories | StorageCategory | 保管カテゴリ |
| inventories_storage_category_capacities | StorageCategoryCapacity | 保管カテゴリ容量 |
| inventories_tags | InventoryTag | 在庫タグ |
| inventories_routes | Route | ルート |
| inventories_route_warehouses | RouteWarehouse | ルートと倉庫の関連 |
| inventories_route_packagings | RoutePackaging | ルートと梱包の関連 |
| inventories_rules | Rule | 在庫ルール |
| inventories_product_routes | ProductRoute | 商品ルート |
| inventories_category_routes | CategoryRoute | カテゴリルート |
| inventories_operation_types | OperationType | オペレーションタイプ |
| inventories_operations | Operation | オペレーション |
| inventories_moves | Move | 在庫移動 |
| inventories_move_lines | MoveLine | 在庫移動明細 |
| inventories_move_destinations | MoveDestination | 移動先 |
| inventories_packages | Package | パッケージ |
| inventories_package_types | PackageType | パッケージタイプ |
| inventories_package_levels | PackageLevel | パッケージレベル |
| inventories_package_destinations | PackageDestination | パッケージ移動先 |
| inventories_lots | Lot | ロット |
| inventories_scraps | Scrap | 廃棄 |
| inventories_scrap_tags | ScrapTag | 廃棄タグ |
| inventories_product_quantities | ProductQuantity | 商品在庫数量 |
| inventories_product_quantity_relocations | ProductQuantityRelocation | 商品在庫移動 |
| inventories_order_points | OrderPoint | 発注点 |

### 会計モジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| accounts_accounts | Account | 勘定科目 |
| accounts_account_tags | AccountTag | 勘定科目タグ |
| accounts_account_account_tags | AccountAccountTag | 勘定科目とタグの関連 |
| accounts_journals | Journal | 仕訳帳 |
| accounts_journal_accounts | JournalAccount | 仕訳帳と勘定科目の関連 |
| accounts_taxes | Tax | 税金 |
| accounts_tax_groups | TaxGroup | 税金グループ |
| accounts_tax_partition_lines | TaxPartitionLine | 税金分割行 |
| accounts_tax_tax_relations | TaxTaxRelation | 税金間の関連 |
| accounts_account_taxes | AccountTax | 勘定科目と税金の関連 |
| accounts_product_taxes | ProductTax | 商品税金 |
| accounts_product_supplier_taxes | ProductSupplierTax | 商品仕入先税金 |
| accounts_payment_terms | PaymentTerm | 支払条件 |
| accounts_payment_due_terms | PaymentDueTerm | 支払期限条件 |
| accounts_payment_methods | PaymentMethod | 支払方法 |
| accounts_payment_method_lines | PaymentMethodLine | 支払方法行 |
| accounts_incoterms | Incoterm | インコタームズ |
| accounts_fiscal_positions | FiscalPosition | 会計ポジション |
| accounts_fiscal_position_taxes | FiscalPositionTax | 会計ポジション税金 |
| accounts_cash_roundings | CashRounding | 現金端数処理 |
| accounts_account_moves | AccountMove | 会計仕訳 |
| accounts_account_move_lines | AccountMoveLine | 会計仕訳明細 |
| accounts_accounts_move_line_taxes | AccountMoveLineTax | 仕訳明細税金 |
| accounts_account_payments | AccountPayment | 支払い |
| accounts_accounts_move_payment | AccountMovePayment | 仕訳と支払いの関連 |
| accounts_bank_statements | BankStatement | 銀行明細書 |
| accounts_bank_statement_lines | BankStatementLine | 銀行明細書行 |
| accounts_reconciles | Reconcile | 照合 |
| accounts_full_reconciles | FullReconcile | 完全照合 |
| accounts_partial_reconciles | PartialReconcile | 部分照合 |
| accounts_payment_registers | PaymentRegister | 支払登録 |
| accounts_account_payment_register_move_lines | PaymentRegisterMoveLine | 支払登録仕訳行 |
| accounts_accounts_move_reversals | AccountMoveReversal | 仕訳取消 |
| accounts_accounts_move_reversal_move | AccountMoveReversalMove | 取消仕訳関連 |
| accounts_accounts_move_reversal_new_move | AccountMoveReversalNewMove | 新規取消仕訳関連 |

### 決済モジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| payments_payment_methods | PaymentMethod | 決済方法 |
| payments_payment_tokens | PaymentToken | 決済トークン |
| payments_payment_transactions | PaymentTransaction | 決済トランザクション |

### プロジェクトモジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| projects_project_stages | ProjectStage | プロジェクトステージ |
| projects_projects | Project | プロジェクト |
| projects_tags | ProjectTag | プロジェクトタグ |
| projects_project_tag | ProjectTagPivot | プロジェクトとタグの関連 |
| projects_user_project_favorites | UserProjectFavorite | ユーザーお気に入りプロジェクト |
| projects_milestones | Milestone | マイルストーン |
| projects_task_stages | TaskStage | タスクステージ |
| projects_tasks | Task | タスク |
| projects_task_users | TaskUser | タスク担当者 |
| projects_task_tag | TaskTag | タスクとタグの関連 |

### 従業員モジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| employees_departments | Department | 部署 |
| employees_work_locations | WorkLocation | 勤務地 |
| employees_categories | EmployeeCategory | 従業員カテゴリ |
| employees_employment_types | EmploymentType | 雇用形態 |
| employees_skill_types | SkillType | スキルタイプ |
| employees_skill_levels | SkillLevel | スキルレベル |
| employees_skills | Skill | スキル |
| employees_job_positions | JobPosition | 職位 |
| employees_employees | Employee | 従業員 |
| employees_employee_skills | EmployeeSkill | 従業員スキル |
| employees_employee_categories | EmployeeEmployeeCategory | 従業員カテゴリ関連 |
| employees_calendars | Calendar | カレンダー |
| employees_calendar_attendances | CalendarAttendance | カレンダー出勤 |
| employees_calendar_leaves | CalendarLeave | カレンダー休暇 |
| employees_departure_reasons | DepartureReason | 退職理由 |
| employees_employee_resume_line_types | ResumeLineType | 履歴書行タイプ |
| employees_employee_resumes | EmployeeResume | 従業員履歴書 |

### 休暇管理モジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| time_off_leave_types | LeaveType | 休暇タイプ |
| time_off_user_leave_types | UserLeaveType | ユーザー休暇タイプ |
| time_off_leaves | Leave | 休暇申請 |
| time_off_leave_allocations | LeaveAllocation | 休暇割当 |
| time_off_leave_accrual_plans | LeaveAccrualPlan | 休暇積立プラン |
| time_off_leave_accrual_levels | LeaveAccrualLevel | 休暇積立レベル |
| time_off_leave_mandatory_days | LeaveMandatoryDay | 必須休暇日 |

### 採用モジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| recruitments_applicant_categories | ApplicantCategory | 応募者カテゴリ |
| recruitments_candidates | Candidate | 候補者 |
| recruitments_candidate_skills | CandidateSkill | 候補者スキル |
| recruitments_candidate_applicant_categories | CandidateApplicantCategory | 候補者と応募者カテゴリの関連 |
| recruitments_stages | RecruitmentStage | 採用ステージ |
| recruitments_stages_jobs | StageJob | ステージと職位の関連 |
| recruitments_applicants | Applicant | 応募者 |
| recruitments_applicant_applicant_categories | ApplicantApplicantCategory | 応募者とカテゴリの関連 |
| recruitments_job_position_interviewers | JobPositionInterviewer | 職位面接官 |
| recruitments_refuse_reasons | RefuseReason | 不採用理由 |

### ブログモジュール

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| blogs_categories | BlogCategory | ブログカテゴリ |
| blogs_posts | BlogPost | ブログ投稿 |
| blogs_tags | BlogTag | ブログタグ |
| blogs_post_tags | BlogPostTag | ブログ投稿とタグの関連 |

---

## 各テーブル定義

### 1. users

システムユーザー情報を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| name | varchar(255) | NO | ユーザー名 |
| email | varchar(255) | NO | メールアドレス（ユニーク） |
| email_verified_at | timestamp | YES | メール確認日時 |
| language | varchar(255) | YES | 言語設定 |
| is_active | boolean | NO | アクティブ状態（デフォルト: true） |
| password | varchar(255) | NO | パスワード（ハッシュ化） |
| remember_token | varchar(100) | YES | 記憶トークン |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 2. sessions

ユーザーセッション管理テーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | varchar(255) | NO | 主キー（セッションID） |
| user_id | bigint unsigned | YES | ユーザーID（外部キー） |
| ip_address | varchar(45) | YES | IPアドレス |
| user_agent | text | YES | ユーザーエージェント |
| payload | longtext | NO | セッションデータ |
| last_activity | integer | NO | 最終アクティビティ（インデックス） |

### 3. companies

会社情報を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| parent_id | bigint unsigned | YES | 親会社ID（自己参照外部キー） |
| currency_id | bigint unsigned | YES | 通貨ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| sort | integer | YES | ソート順 |
| name | varchar(255) | NO | 会社名 |
| company_id | varchar(255) | NO | 会社ID（ユニーク） |
| tax_id | varchar(255) | YES | 税務ID（ユニーク） |
| registration_number | varchar(255) | YES | 登記番号 |
| email | varchar(255) | YES | メールアドレス |
| phone | varchar(255) | YES | 電話番号 |
| mobile | varchar(255) | YES | 携帯番号 |
| website | varchar(255) | YES | Webサイト |
| color | varchar(255) | YES | カラー |
| is_active | boolean | NO | アクティブ状態（デフォルト: true） |
| founded_date | date | YES | 設立日 |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 4. partners_partners

取引先（顧客・仕入先）情報を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| account_type | varchar(255) | NO | アカウントタイプ（デフォルト: individual） |
| sub_type | varchar(255) | YES | サブタイプ（デフォルト: partner） |
| name | varchar(255) | NO | パートナー名（インデックス） |
| avatar | varchar(255) | YES | アバター画像 |
| email | varchar(255) | YES | メールアドレス |
| job_title | varchar(255) | YES | 役職 |
| website | varchar(255) | YES | Webサイト |
| tax_id | varchar(255) | YES | 税務ID（インデックス） |
| phone | varchar(255) | YES | 電話番号（インデックス） |
| mobile | varchar(255) | YES | 携帯番号（インデックス） |
| color | varchar(255) | YES | カラー |
| company_registry | varchar(255) | YES | 会社登記番号（インデックス） |
| reference | varchar(255) | YES | 参照番号（インデックス） |
| parent_id | bigint unsigned | YES | 親パートナーID（自己参照外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| user_id | bigint unsigned | YES | 関連ユーザーID（外部キー） |
| title_id | bigint unsigned | YES | 敬称ID（外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| industry_id | bigint unsigned | YES | 業種ID（外部キー） |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 5. products_products

商品情報を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| type | varchar(255) | NO | 商品タイプ |
| name | varchar(255) | NO | 商品名 |
| service_tracking | varchar(255) | NO | サービストラッキング（デフォルト: none） |
| reference | varchar(255) | YES | 参照番号 |
| barcode | varchar(255) | YES | バーコード |
| price | decimal(15,4) | YES | 価格 |
| cost | decimal(15,4) | YES | 原価 |
| volume | decimal(15,4) | YES | 容積 |
| weight | decimal(15,4) | YES | 重量 |
| description | text | YES | 説明 |
| description_purchase | text | YES | 購買説明 |
| description_sale | text | YES | 販売説明 |
| enable_sales | boolean | YES | 販売有効 |
| enable_purchase | boolean | YES | 購買有効 |
| is_favorite | boolean | YES | お気に入り |
| is_configurable | boolean | YES | 設定可能 |
| sort | integer | YES | ソート順 |
| images | json | YES | 画像 |
| parent_id | bigint unsigned | YES | 親商品ID（自己参照外部キー） |
| uom_id | bigint unsigned | NO | 単位ID（外部キー） |
| uom_po_id | bigint unsigned | NO | 購買単位ID（外部キー） |
| category_id | bigint unsigned | NO | カテゴリID（外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 6. products_categories

商品カテゴリを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| name | varchar(255) | NO | カテゴリ名（インデックス） |
| full_name | varchar(255) | YES | フルパス名 |
| parent_path | varchar(255) | YES | 親パス |
| parent_id | bigint unsigned | YES | 親カテゴリID（自己参照外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 7. products_attributes

商品属性を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| name | varchar(255) | NO | 属性名 |
| type | varchar(255) | NO | 属性タイプ |
| sort | integer | YES | ソート順 |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 8. products_attribute_options

属性オプションを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| name | varchar(255) | NO | オプション名 |
| color | varchar(255) | YES | カラー |
| extra_price | decimal(15,4) | YES | 追加価格 |
| sort | integer | YES | ソート順 |
| attribute_id | bigint unsigned | NO | 属性ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 9. sales_orders

受注オーダーを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| utm_source_id | bigint unsigned | YES | UTMソースID（外部キー） |
| campaign_id | bigint unsigned | YES | キャンペーンID（外部キー） |
| medium_id | bigint unsigned | YES | メディアID（外部キー） |
| company_id | bigint unsigned | NO | 会社ID（外部キー） |
| partner_id | bigint unsigned | NO | パートナーID（外部キー） |
| journal_id | bigint unsigned | YES | 仕訳帳ID（外部キー） |
| partner_invoice_id | bigint unsigned | NO | 請求先ID（外部キー） |
| partner_shipping_id | bigint unsigned | NO | 配送先ID（外部キー） |
| fiscal_position_id | bigint unsigned | YES | 会計ポジションID（外部キー） |
| payment_term_id | bigint unsigned | YES | 支払条件ID（外部キー） |
| currency_id | bigint unsigned | NO | 通貨ID（外部キー） |
| user_id | bigint unsigned | YES | 担当者ID（外部キー） |
| team_id | bigint unsigned | YES | チームID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| sale_order_template_id | bigint unsigned | YES | テンプレートID（外部キー） |
| access_token | varchar(255) | YES | アクセストークン |
| name | varchar(255) | NO | オーダー番号 |
| state | varchar(255) | YES | ステータス |
| client_order_ref | varchar(255) | YES | 顧客参照番号 |
| origin | varchar(255) | YES | 元ドキュメント |
| reference | varchar(255) | YES | 支払参照 |
| signed_by | varchar(255) | YES | 署名者 |
| invoice_status | varchar(255) | YES | 請求ステータス |
| validity_date | date | YES | 有効期限 |
| note | text | YES | 備考 |
| currency_rate | decimal(15,4) | YES | 通貨レート |
| amount_untaxed | decimal(15,4) | YES | 税抜金額 |
| amount_tax | decimal(15,4) | YES | 税額 |
| amount_total | decimal(15,4) | YES | 合計金額 |
| locked | boolean | NO | ロック状態 |
| require_signature | boolean | NO | 署名必須 |
| require_payment | boolean | NO | 支払必須 |
| commitment_date | date | YES | コミットメント日 |
| date_order | date | NO | オーダー日 |
| signed_on | date | YES | 署名日 |
| prepayment_percent | decimal(15,4) | YES | 前払い率 |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 10. sales_order_lines

受注明細を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| sort | integer | YES | ソート順 |
| order_id | bigint unsigned | NO | オーダーID（外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| currency_id | bigint unsigned | YES | 通貨ID（外部キー） |
| order_partner_id | bigint unsigned | YES | オーダーパートナーID（外部キー） |
| salesman_id | bigint unsigned | YES | 担当者ID（外部キー） |
| product_id | bigint unsigned | YES | 商品ID（外部キー） |
| product_uom_id | bigint unsigned | YES | 単位ID（外部キー） |
| linked_sale_order_sale_id | bigint unsigned | YES | リンク販売ID（外部キー） |
| product_packaging_id | bigint unsigned | YES | 梱包ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| state | varchar(255) | YES | ステータス |
| display_type | varchar(255) | YES | 表示タイプ |
| virtual_id | varchar(255) | YES | 仮想ID |
| linked_virtual_id | varchar(255) | YES | リンク仮想ID |
| qty_delivered_method | varchar(255) | YES | 配送数量方法 |
| invoice_status | varchar(255) | YES | 請求ステータス |
| analytic_distribution | varchar(255) | YES | 分析配分 |
| name | varchar(255) | NO | 名前 |
| product_uom_qty | decimal(15,4) | NO | 単位数量 |
| product_qty | decimal(15,4) | NO | 商品数量 |
| price_unit | decimal(15,4) | NO | 単価 |
| discount | decimal(15,4) | YES | 割引 |
| price_subtotal | decimal(15,4) | YES | 小計 |
| price_total | decimal(15,4) | YES | 合計 |
| price_reduce_taxexcl | decimal(15,4) | YES | 税抜割引後価格 |
| price_reduce_taxinc | decimal(15,4) | YES | 税込割引後価格 |
| purchase_price | decimal(15,4) | YES | 仕入価格 |
| margin | decimal(15,4) | YES | 利益額 |
| margin_percent | decimal(15,4) | YES | 利益率 |
| qty_delivered | decimal(15,4) | YES | 配送数量 |
| qty_invoiced | decimal(15,4) | YES | 請求済数量 |
| qty_to_invoice | decimal(15,4) | YES | 請求予定数量 |
| untaxed_amount_invoiced | decimal(15,4) | YES | 税抜請求額 |
| untaxed_amount_to_invoice | decimal(15,4) | YES | 税抜請求予定額 |
| is_downpayment | boolean | YES | 前払い |
| is_expense | boolean | YES | 経費 |
| create_date | timestamp | YES | 作成日 |
| write_date | timestamp | YES | 更新日 |
| technical_price_unit | decimal(15,4) | YES | 技術単価 |
| price_tax | decimal(15,4) | YES | 税額 |
| product_packaging_qty | decimal(15,4) | YES | 梱包数量 |
| customer_lead | decimal(15,4) | NO | リードタイム |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 11. purchases_orders

発注オーダーを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| name | varchar(255) | NO | オーダー番号（インデックス） |
| description | text | YES | 説明 |
| priority | varchar(255) | NO | 優先度（インデックス） |
| origin | varchar(255) | YES | 元ドキュメント |
| partner_reference | varchar(255) | YES | 仕入先参照番号 |
| state | varchar(255) | YES | ステータス（インデックス） |
| invoice_status | varchar(255) | NO | 請求ステータス |
| receipt_status | varchar(255) | NO | 入荷ステータス |
| untaxed_amount | decimal(15,4) | NO | 税抜金額 |
| tax_amount | decimal(15,4) | NO | 税額 |
| total_amount | decimal(15,4) | NO | 合計金額 |
| total_cc_amount | decimal(15,4) | NO | 会社通貨合計金額 |
| currency_rate | decimal(15,6) | NO | 通貨レート |
| invoice_count | integer | NO | 請求書数 |
| ordered_at | datetime | NO | 発注日時（インデックス） |
| approved_at | datetime | YES | 承認日時（インデックス） |
| planned_at | datetime | YES | 予定日時（インデックス） |
| calendar_start_at | datetime | YES | カレンダー開始日時 |
| effective_date | datetime | YES | 有効日 |
| incoterm_location | varchar(255) | YES | インコターム場所 |
| mail_reminder_confirmed | boolean | YES | メールリマインダー確認 |
| mail_reception_confirmed | boolean | YES | メール受領確認 |
| mail_reception_declined | boolean | YES | メール受領却下 |
| report_grids | boolean | YES | レポートグリッド |
| requisition_id | bigint unsigned | YES | 購買依頼ID（外部キー） |
| purchases_group_id | bigint unsigned | YES | 購買グループID（外部キー） |
| partner_id | bigint unsigned | NO | パートナーID（外部キー） |
| currency_id | bigint unsigned | NO | 通貨ID（外部キー） |
| fiscal_position_id | bigint unsigned | YES | 会計ポジションID（外部キー） |
| payment_term_id | bigint unsigned | YES | 支払条件ID（外部キー） |
| incoterm_id | bigint unsigned | YES | インコタームID（外部キー） |
| user_id | bigint unsigned | YES | 担当者ID（外部キー、インデックス） |
| company_id | bigint unsigned | NO | 会社ID（外部キー、インデックス） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 12. purchases_order_lines

発注明細を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| name | text | NO | 名前 |
| state | varchar(255) | YES | ステータス |
| sort | integer | YES | ソート順 |
| qty_received_method | varchar(255) | YES | 入荷数量方法 |
| display_type | varchar(255) | YES | 表示タイプ |
| product_qty | decimal(15,2) | NO | 商品数量 |
| product_uom_qty | double | YES | 単位数量 |
| product_packaging_qty | double | YES | 梱包数量 |
| price_tax | double | YES | 税額 |
| discount | decimal(15,2) | NO | 割引 |
| price_unit | decimal(15,2) | NO | 単価 |
| price_subtotal | decimal(15,2) | NO | 小計 |
| price_total | decimal(15,2) | NO | 合計 |
| qty_invoiced | decimal(15,2) | NO | 請求済数量 |
| qty_received | decimal(15,2) | NO | 入荷済数量 |
| qty_received_manual | decimal(15,2) | NO | 手動入荷数量 |
| qty_to_invoice | decimal(15,2) | NO | 請求予定数量 |
| is_downpayment | boolean | NO | 前払い |
| planned_at | timestamp | YES | 予定日時（インデックス） |
| product_description_variants | varchar(255) | YES | 商品バリエーション説明 |
| propagate_cancel | boolean | YES | キャンセル伝播 |
| price_total_cc | decimal(15,2) | NO | 会社通貨合計 |
| uom_id | bigint unsigned | YES | 単位ID（外部キー） |
| product_id | bigint unsigned | YES | 商品ID（外部キー、インデックス） |
| product_packaging_id | bigint unsigned | YES | 梱包ID（外部キー） |
| order_id | bigint unsigned | NO | オーダーID（外部キー、インデックス） |
| partner_id | bigint unsigned | YES | パートナーID（外部キー、インデックス） |
| currency_id | bigint unsigned | YES | 通貨ID（外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 13. inventories_warehouses

倉庫を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| name | varchar(255) | NO | 倉庫名（インデックス） |
| code | varchar(255) | YES | 倉庫コード |
| sort | integer | YES | ソート順 |
| reception_steps | varchar(255) | NO | 入荷ステップ |
| delivery_steps | varchar(255) | NO | 出荷ステップ |
| company_id | bigint unsigned | NO | 会社ID（外部キー） |
| partner_address_id | bigint unsigned | YES | 住所パートナーID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 14. inventories_locations

ロケーションを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| position_x | integer | YES | X座標（通路） |
| position_y | integer | YES | Y座標（棚） |
| position_z | integer | YES | Z座標（高さ） |
| type | varchar(255) | NO | ロケーションタイプ |
| name | varchar(255) | NO | ロケーション名 |
| full_name | varchar(255) | YES | フルパス名 |
| description | varchar(255) | YES | 説明 |
| parent_path | varchar(255) | YES | 親パス |
| barcode | varchar(255) | YES | バーコード |
| removal_strategy | varchar(255) | YES | 取り出し戦略 |
| cyclic_inventory_frequency | integer | YES | 棚卸頻度 |
| last_inventory_date | date | YES | 最終棚卸日 |
| next_inventory_date | date | YES | 次回棚卸日 |
| is_scrap | boolean | YES | 廃棄場所 |
| is_replenish | boolean | YES | 補充場所 |
| is_dock | boolean | YES | ドック |
| parent_id | bigint unsigned | YES | 親ロケーションID（自己参照外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| storage_category_id | bigint unsigned | YES | 保管カテゴリID（外部キー） |
| warehouse_id | bigint unsigned | YES | 倉庫ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 15. inventories_moves

在庫移動を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| name | varchar(255) | NO | 名前 |
| state | varchar(255) | YES | ステータス |
| origin | varchar(255) | YES | 元ドキュメント |
| procure_method | varchar(255) | NO | 調達方法 |
| reference | varchar(255) | YES | 参照番号 |
| description_picking | text | YES | ピッキング説明 |
| next_serial | varchar(255) | YES | 次シリアル番号 |
| next_serial_count | integer | YES | 次シリアル数 |
| is_favorite | boolean | NO | お気に入り |
| product_qty | decimal(15,4) | YES | 商品数量 |
| product_uom_qty | decimal(15,4) | YES | 単位数量 |
| quantity | decimal(15,4) | YES | 数量 |
| is_picked | boolean | NO | ピック済み |
| is_scraped | boolean | NO | 廃棄済み |
| is_inventory | boolean | NO | 棚卸 |
| reservation_date | date | YES | 予約日 |
| scheduled_at | datetime | NO | 予定日時 |
| deadline | datetime | YES | 期限 |
| alert_date | datetime | YES | アラート日時 |
| operation_id | bigint unsigned | YES | オペレーションID（外部キー） |
| product_id | bigint unsigned | NO | 商品ID（外部キー） |
| uom_id | bigint unsigned | NO | 単位ID（外部キー） |
| source_location_id | bigint unsigned | NO | 元ロケーションID（外部キー） |
| destination_location_id | bigint unsigned | NO | 先ロケーションID（外部キー） |
| final_location_id | bigint unsigned | YES | 最終ロケーションID（外部キー） |
| partner_id | bigint unsigned | YES | パートナーID（外部キー） |
| scrap_id | bigint unsigned | YES | 廃棄ID（外部キー） |
| rule_id | bigint unsigned | YES | ルールID（外部キー） |
| operation_type_id | bigint unsigned | YES | オペレーションタイプID（外部キー） |
| origin_returned_move_id | bigint unsigned | YES | 返品元移動ID（自己参照外部キー） |
| restrict_partner_id | bigint unsigned | YES | 制限パートナーID（外部キー） |
| warehouse_id | bigint unsigned | YES | 倉庫ID（外部キー） |
| package_level_id | bigint unsigned | YES | パッケージレベルID（外部キー） |
| product_packaging_id | bigint unsigned | YES | 梱包ID（外部キー） |
| company_id | bigint unsigned | NO | 会社ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 16. projects_projects

プロジェクトを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| name | varchar(255) | NO | プロジェクト名（インデックス） |
| tasks_label | varchar(255) | YES | タスクラベル |
| description | text | YES | 説明 |
| visibility | varchar(255) | YES | 可視性 |
| color | varchar(255) | YES | カラー |
| sort | integer | YES | ソート順（インデックス） |
| start_date | date | YES | 開始日 |
| end_date | date | YES | 終了日 |
| allocated_hours | decimal | YES | 割当時間 |
| allow_timesheets | boolean | NO | タイムシート許可 |
| allow_milestones | boolean | NO | マイルストーン許可 |
| allow_task_dependencies | boolean | NO | タスク依存関係許可 |
| is_active | boolean | NO | アクティブ状態 |
| stage_id | bigint unsigned | YES | ステージID（外部キー） |
| partner_id | bigint unsigned | YES | パートナーID（外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| user_id | bigint unsigned | YES | 担当者ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 17. projects_tasks

タスクを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| title | varchar(255) | NO | タイトル（インデックス） |
| description | text | YES | 説明 |
| color | varchar(255) | YES | カラー |
| priority | boolean | NO | 優先度（インデックス） |
| state | varchar(255) | NO | ステータス（インデックス） |
| tags | json | YES | タグ |
| sort | integer | YES | ソート順 |
| is_active | boolean | NO | アクティブ状態 |
| is_recurring | boolean | NO | 繰り返し |
| deadline | datetime | YES | 期限（インデックス） |
| working_hours_open | decimal | NO | 開始作業時間 |
| working_hours_close | decimal | NO | 終了作業時間 |
| allocated_hours | decimal | NO | 割当時間 |
| remaining_hours | decimal | NO | 残時間 |
| effective_hours | decimal | NO | 実績時間 |
| total_hours_spent | decimal | NO | 合計消費時間 |
| overtime | decimal | NO | 残業時間 |
| progress | decimal | NO | 進捗率 |
| subtask_effective_hours | decimal | NO | サブタスク実績時間 |
| project_id | bigint unsigned | YES | プロジェクトID（外部キー） |
| milestone_id | bigint unsigned | YES | マイルストーンID（外部キー） |
| stage_id | bigint unsigned | YES | ステージID（外部キー） |
| partner_id | bigint unsigned | YES | パートナーID（外部キー） |
| parent_id | bigint unsigned | YES | 親タスクID（自己参照外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 18. employees_employees

従業員情報を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| time_zone | varchar(255) | YES | タイムゾーン |
| work_permit | varchar(255) | YES | 就労許可証 |
| address_id | bigint unsigned | YES | 住所ID |
| leave_manager_id | bigint unsigned | YES | 休暇管理者ID（外部キー） |
| bank_account_id | bigint unsigned | YES | 銀行口座ID（外部キー） |
| private_state_id | bigint unsigned | YES | 私的住所州ID（外部キー） |
| private_country_id | bigint unsigned | YES | 私的住所国ID（外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| user_id | bigint unsigned | YES | ユーザーID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| calendar_id | bigint unsigned | YES | カレンダーID（外部キー） |
| department_id | bigint unsigned | YES | 部署ID（外部キー） |
| job_id | bigint unsigned | YES | 職位ID（外部キー） |
| partner_id | bigint unsigned | YES | パートナーID（外部キー） |
| work_location_id | bigint unsigned | YES | 勤務地ID（外部キー） |
| parent_id | bigint unsigned | YES | 上司ID（自己参照外部キー） |
| coach_id | bigint unsigned | YES | コーチID（自己参照外部キー） |
| country_id | bigint unsigned | YES | 国ID（外部キー） |
| state_id | bigint unsigned | YES | 州ID（外部キー） |
| country_of_birth | bigint unsigned | YES | 出生国ID（外部キー） |
| departure_reason_id | bigint unsigned | YES | 退職理由ID（外部キー） |
| attendance_manager_id | bigint unsigned | YES | 勤怠管理者ID（外部キー） |
| name | varchar(255) | YES | 従業員名 |
| job_title | varchar(255) | YES | 役職名 |
| work_phone | varchar(255) | YES | 勤務先電話 |
| mobile_phone | varchar(255) | YES | 携帯電話 |
| color | varchar(255) | YES | カラー |
| children | integer | YES | 子供の数 |
| distance_home_work | integer | YES | 通勤距離 |
| km_home_work | integer | YES | 通勤距離（km） |
| distance_home_work_unit | varchar(255) | YES | 通勤距離単位 |
| work_email | varchar(255) | YES | 勤務先メール |
| private_phone | varchar(255) | YES | 個人電話 |
| private_email | varchar(255) | YES | 個人メール |
| private_street1 | varchar(255) | YES | 個人住所1 |
| private_street2 | varchar(255) | YES | 個人住所2 |
| private_city | varchar(255) | YES | 個人住所市区町村 |
| private_zip | varchar(255) | YES | 個人住所郵便番号 |
| private_car_plate | varchar(255) | YES | 車両ナンバー |
| lang | varchar(255) | YES | 言語 |
| gender | varchar(255) | YES | 性別 |
| birthday | varchar(255) | YES | 誕生日 |
| marital | varchar(255) | NO | 婚姻状況 |
| spouse_complete_name | varchar(255) | YES | 配偶者名 |
| spouse_birthdate | varchar(255) | YES | 配偶者誕生日 |
| place_of_birth | varchar(255) | YES | 出生地 |
| ssnid | varchar(255) | YES | 社会保障番号 |
| sinid | varchar(255) | YES | SIN番号 |
| identification_id | varchar(255) | YES | 身分証明ID |
| passport_id | varchar(255) | YES | パスポート番号 |
| permit_no | varchar(255) | YES | 許可証番号 |
| visa_no | varchar(255) | YES | ビザ番号 |
| certificate | varchar(255) | YES | 証明書 |
| study_field | varchar(255) | YES | 専攻 |
| study_school | varchar(255) | YES | 学校 |
| emergency_contact | varchar(255) | YES | 緊急連絡先 |
| emergency_phone | varchar(255) | YES | 緊急連絡先電話 |
| employee_type | varchar(255) | NO | 従業員タイプ |
| barcode | varchar(255) | YES | バーコード |
| pin | varchar(255) | YES | PIN |
| visa_expire | varchar(255) | YES | ビザ有効期限 |
| work_permit_expiration_date | varchar(255) | YES | 就労許可有効期限 |
| departure_date | varchar(255) | YES | 退職日 |
| departure_description | text | YES | 退職説明 |
| additional_note | text | YES | 追加メモ |
| notes | text | YES | メモ |
| is_active | boolean | NO | アクティブ状態 |
| is_flexible | boolean | YES | フレキシブル |
| is_fully_flexible | boolean | YES | 完全フレキシブル |
| work_permit_scheduled_activity | boolean | YES | 就労許可スケジュール活動 |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 19. time_off_leave_types

休暇タイプを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| sort | integer | YES | ソート順 |
| color | varchar(255) | YES | カラー |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| max_allowed_negative | integer | YES | 最大許容マイナス |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| leave_validation_type | enum | YES | 休暇承認タイプ |
| requires_allocation | enum | NO | 割当必須 |
| employee_requests | enum | NO | 従業員リクエスト |
| allocation_validation_type | enum | YES | 割当承認タイプ |
| time_type | enum | YES | 時間タイプ |
| request_unit | enum | NO | リクエスト単位 |
| name | varchar(255) | NO | 名前 |
| create_calendar_meeting | boolean | YES | カレンダー会議作成 |
| is_active | boolean | YES | アクティブ状態 |
| show_on_dashboard | boolean | YES | ダッシュボード表示 |
| unpaid | boolean | YES | 無給 |
| include_public_holidays_in_duration | boolean | YES | 公休日を期間に含む |
| support_document | boolean | YES | 証明書必須 |
| allows_negative | boolean | YES | マイナス許可 |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 20. time_off_leaves

休暇申請を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| user_id | bigint unsigned | YES | ユーザーID（外部キー） |
| manager_id | bigint unsigned | YES | 管理者ID（外部キー） |
| holiday_status_id | bigint unsigned | YES | 休暇タイプID（外部キー） |
| employee_id | bigint unsigned | NO | 従業員ID（外部キー） |
| employee_company_id | bigint unsigned | YES | 従業員会社ID（外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| department_id | bigint unsigned | YES | 部署ID（外部キー） |
| calendar_id | bigint unsigned | YES | カレンダーID（外部キー） |
| meeting_id | integer | YES | 会議ID |
| first_approver_id | bigint unsigned | YES | 第一承認者ID（外部キー） |
| second_approver_id | bigint unsigned | YES | 第二承認者ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| private_name | varchar(255) | YES | プライベート名 |
| state | varchar(255) | YES | ステータス |
| duration_display | varchar(255) | YES | 期間表示 |
| request_date_from_period | varchar(255) | YES | リクエスト開始期間 |
| request_date_from | timestamp | YES | リクエスト開始日 |
| request_date_to | timestamp | YES | リクエスト終了日 |
| notes | text | YES | メモ |
| attachment | varchar(255) | YES | 添付ファイル |
| request_unit_half | boolean | YES | 半日リクエスト |
| request_unit_hours | boolean | YES | 時間リクエスト |
| date_from | timestamp | YES | 開始日 |
| date_to | timestamp | YES | 終了日 |
| number_of_days | decimal(15,4) | YES | 日数 |
| number_of_hours | decimal(15,4) | YES | 時間数 |
| request_hour_from | decimal(15,4) | YES | リクエスト開始時間 |
| request_hour_to | decimal(15,4) | YES | リクエスト終了時間 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 21. accounts_account_moves

会計仕訳を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| sort | integer | YES | ソート順 |
| journal_id | bigint unsigned | YES | 仕訳帳ID（外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| tax_cash_basis_origin_move_id | bigint unsigned | YES | 現金主義元仕訳ID（自己参照外部キー） |
| auto_post_origin_id | bigint unsigned | YES | 自動転記元ID（自己参照外部キー） |
| origin_payment_id | bigint unsigned | YES | 元支払ID（外部キー） |
| secure_sequence_number | integer | YES | セキュア連番 |
| invoice_payment_term_id | bigint unsigned | YES | 支払条件ID（外部キー） |
| partner_id | bigint unsigned | YES | パートナーID（外部キー） |
| commercial_partner_id | bigint unsigned | YES | 商業パートナーID（外部キー） |
| partner_shipping_id | bigint unsigned | YES | 配送先ID（外部キー） |
| partner_bank_id | bigint unsigned | YES | 銀行口座ID（外部キー） |
| fiscal_position_id | bigint unsigned | YES | 会計ポジションID（外部キー） |
| currency_id | bigint unsigned | YES | 通貨ID（外部キー） |
| reversed_entry_id | bigint unsigned | YES | 取消元仕訳ID（自己参照外部キー） |
| campaign_id | bigint unsigned | YES | キャンペーンID（外部キー） |
| invoice_user_id | bigint unsigned | YES | 請求担当者ID（外部キー） |
| statement_line_id | bigint unsigned | YES | 明細行ID（外部キー） |
| invoice_incoterm_id | bigint unsigned | YES | インコタームID（外部キー） |
| preferred_payment_method_line_id | bigint unsigned | YES | 優先支払方法行ID（外部キー） |
| invoice_cash_rounding_id | bigint unsigned | YES | 現金端数処理ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| sequence_prefix | varchar(255) | YES | シーケンスプレフィックス |
| access_token | varchar(255) | YES | アクセストークン |
| name | varchar(255) | YES | 名前 |
| reference | varchar(255) | YES | 参照番号 |
| state | varchar(255) | NO | ステータス |
| move_type | varchar(255) | NO | 仕訳タイプ |
| auto_post | boolean | NO | 自動転記 |
| inalterable_hash | varchar(255) | YES | 不変ハッシュ |
| payment_reference | varchar(255) | YES | 支払参照 |
| qr_code_method | varchar(255) | YES | QRコード方式 |
| payment_state | varchar(255) | YES | 支払状態 |
| invoice_source_email | varchar(255) | YES | ソースメール |
| invoice_partner_display_name | varchar(255) | YES | パートナー表示名 |
| invoice_origin | varchar(255) | YES | 請求書元 |
| incoterm_location | varchar(255) | YES | インコターム場所 |
| date | date | NO | 日付 |
| auto_post_until | date | YES | 自動転記期限 |
| invoice_date | date | YES | 請求日 |
| invoice_date_due | date | YES | 支払期限 |
| delivery_date | date | YES | 納品日 |
| sending_data | json | YES | 送信データ |
| narration | text | YES | 摘要 |
| invoice_currency_rate | decimal(15,4) | YES | 請求書通貨レート |
| amount_untaxed | decimal(15,4) | YES | 税抜金額 |
| amount_tax | decimal(15,4) | YES | 税額 |
| amount_total | decimal(15,4) | YES | 合計金額 |
| amount_residual | decimal(15,4) | YES | 残高 |
| amount_untaxed_signed | decimal(15,4) | YES | 署名済税抜金額 |
| amount_untaxed_in_currency_signed | decimal(15,4) | YES | 通貨署名済税抜金額 |
| amount_tax_signed | decimal(15,4) | YES | 署名済税額 |
| amount_total_signed | decimal(15,4) | YES | 署名済合計金額 |
| amount_total_in_currency_signed | decimal(15,4) | YES | 通貨署名済合計金額 |
| amount_residual_signed | decimal(15,4) | YES | 署名済残高 |
| quick_edit_total_amount | decimal(15,4) | YES | クイック編集合計金額 |
| is_storno | boolean | YES | 取消仕訳 |
| always_tax_exigible | boolean | YES | 常に税義務あり |
| checked | boolean | YES | チェック済み |
| posted_before | boolean | YES | 転記済み |
| made_sequence_gap | boolean | YES | シーケンスギャップ作成 |
| is_manually_modified | boolean | YES | 手動修正済み |
| is_move_sent | boolean | YES | 仕訳送信済み |
| source_id | bigint unsigned | YES | ソースID（外部キー） |
| medium_id | bigint unsigned | YES | メディアID（外部キー） |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 22. blogs_posts

ブログ投稿を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| title | varchar(255) | NO | タイトル |
| sub_title | text | YES | サブタイトル |
| content | text | NO | コンテンツ |
| slug | varchar(255) | NO | スラッグ（ユニーク） |
| image | varchar(255) | YES | 画像 |
| author_name | varchar(255) | YES | 著者名 |
| is_published | boolean | NO | 公開状態 |
| published_at | datetime | YES | 公開日時 |
| visits | integer | NO | 閲覧数 |
| meta_title | text | YES | メタタイトル |
| meta_keywords | text | YES | メタキーワード |
| meta_description | text | YES | メタ説明 |
| category_id | bigint unsigned | YES | カテゴリID（外部キー） |
| author_id | bigint unsigned | YES | 著者ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| last_editor_id | bigint unsigned | YES | 最終編集者ID（外部キー） |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 23. recruitments_applicants

応募者を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| source_id | bigint unsigned | YES | ソースID（外部キー） |
| medium_id | bigint unsigned | YES | メディアID（外部キー） |
| candidate_id | bigint unsigned | NO | 候補者ID（外部キー） |
| stage_id | bigint unsigned | YES | ステージID（外部キー） |
| last_stage_id | bigint unsigned | YES | 前ステージID（外部キー） |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| recruiter_id | bigint unsigned | YES | 採用担当者ID（外部キー） |
| job_id | bigint unsigned | YES | 職位ID（外部キー） |
| department_id | bigint unsigned | YES | 部署ID（外部キー） |
| refuse_reason_id | bigint unsigned | YES | 不採用理由ID（外部キー） |
| creator_id | bigint unsigned | YES | 作成者ID（外部キー） |
| email_cc | varchar(255) | YES | CCメール |
| priority | varchar(255) | YES | 優先度 |
| salary_proposed_extra | varchar(255) | YES | 提示給与追加 |
| salary_expected_extra | varchar(255) | YES | 希望給与追加 |
| applicant_properties | json | YES | 応募者プロパティ |
| applicant_notes | text | YES | 応募者メモ |
| is_active | boolean | NO | アクティブ状態 |
| state | varchar(255) | YES | ステータス |
| create_date | timestamp | YES | 応募日 |
| date_closed | timestamp | YES | 採用日 |
| date_opened | timestamp | YES | 対応開始日 |
| date_last_stage_updated | timestamp | YES | 最終ステージ更新日 |
| refuse_date | timestamp | YES | 不採用日 |
| probability | decimal(15,4) | YES | 採用確率 |
| salary_proposed | decimal(15,4) | YES | 提示給与 |
| salary_expected | decimal(15,4) | YES | 希望給与 |
| delay_close | decimal(15,4) | YES | クローズ遅延 |
| deleted_at | timestamp | YES | 論理削除日時 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 24. payments_payment_methods

決済方法を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| sort | integer | YES | ソート順 |
| primary_payment_method_id | bigint unsigned | YES | 主決済方法ID（自己参照外部キー） |
| created_by | bigint unsigned | YES | 作成者ID（外部キー） |
| code | varchar(255) | NO | コード |
| support_refund | varchar(255) | YES | 返金対応 |
| name | varchar(255) | NO | 名前 |
| is_active | boolean | NO | アクティブ状態 |
| support_tokenization | boolean | YES | トークン化対応 |
| support_express_checkout | boolean | YES | エクスプレスチェックアウト対応 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

### 25. payments_payment_tokens

決済トークンを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint unsigned | NO | 主キー |
| company_id | bigint unsigned | YES | 会社ID（外部キー） |
| payment_method_id | bigint unsigned | YES | 決済方法ID（外部キー） |
| partner_id | bigint unsigned | YES | パートナーID（外部キー） |
| created_by | bigint unsigned | YES | 作成者ID（外部キー） |
| payment_details | json | YES | 決済詳細 |
| provider_reference_id | varchar(255) | YES | プロバイダー参照ID |
| is_active | boolean | NO | アクティブ状態 |
| created_at | timestamp | YES | 作成日時 |
| updated_at | timestamp | YES | 更新日時 |

---

## 備考

### データベース設計方針

1. **論理削除**: 多くのテーブルで `deleted_at` カラムによる論理削除（ソフトデリート）を採用しています。

2. **監査証跡**: ほとんどのテーブルに `creator_id`、`created_at`、`updated_at` カラムを設け、作成者と日時を追跡しています。

3. **マルチテナント**: `company_id` カラムによる会社単位のデータ分離を実装しています。

4. **自己参照**: カテゴリ、パートナー、従業員などの階層構造を持つエンティティでは、`parent_id` による自己参照外部キーを使用しています。

5. **多対多関連**: ピボットテーブル（例: `products_product_tag`、`projects_project_tag` など）を使用して多対多の関連を管理しています。

### 外部キー制約

- **restrictOnDelete**: 参照先が削除される際にエラーを発生させ、データ整合性を保護
- **cascadeOnDelete**: 参照先が削除された際に関連レコードも削除
- **nullOnDelete**: 参照先が削除された際に外部キーを NULL に設定

### インデックス戦略

- 検索頻度の高いカラム（name、email、状態など）にはインデックスを設定
- 複合ユニーク制約を使用して重複防止（例: `company_id` + `name`）

### 使用技術

- **フレームワーク**: Laravel 11.x
- **管理パネル**: Filament
- **データベース**: MySQL/PostgreSQL互換
- **権限管理**: spatie/laravel-permission
