---
generated_at: 2025-12-26 15:30:00
metrics:
  claims_total: 4
  claims_with_evidence: 4
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：4 / 4、根拠なし：0
- 優先レビュー（高）
  - 該当なし（すべての項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `routes/console.php` - スケジュールタスク定義ファイル
- E-02: `plugins/webkul/support/src/Console/Commands/InstallERP.php` - ERPインストールコマンド
- E-03: `plugins/webkul/support/src/Console/Commands/InstallCommand.php` - プラグインインストールコマンド基底クラス
- E-04: `plugins/webkul/support/src/Console/Commands/UninstallCommand.php` - プラグインアンインストールコマンド基底クラス
- E-05: `config/queue.php` - キュー設定ファイル
- E-06: `bootstrap/app.php` - アプリケーション設定ファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | inspireコマンドが1時間ごとに実行される | E-01 | ○ |
| C-02 | erp:installコマンドでERPシステムをインストールできる | E-02 | ○ |
| C-03 | 各プラグインにinstallコマンドが動的生成される | E-03 | ○ |
| C-04 | 各プラグインにuninstallコマンドが動的生成される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全バッチ処理がソースコードで確認できた
  - 外部ドキュメントや要件定義書との照合は未実施

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がソースコードで確認可能

### 補足情報
- 本プロジェクトはLaravel 11系のERPシステム（AureusERP）
- ジョブキュー基盤（database driver）は設定済みだが、定期実行Jobクラスは未実装
- 実運用では`php artisan schedule:run`をcronで1分ごとに実行する想定

## 6) レビュアーチェックリスト（最小）
- [ ] inspireコマンドの実行頻度（1時間）が運用要件に合致しているか確認
- [ ] プラグインのinstall/uninstallコマンドの動作を実際に確認
- [ ] 本番環境でのスケジューラ設定（cron）が適切に行われているか確認
- [ ] 追加のバッチ処理要件がないか、業務担当者にヒアリング
