# バッチ設計書 2-erp:install

## 概要

本ドキュメントは、AureusERPシステムの初期インストールを行う「erp:install」コマンドのバッチ設計書です。このコマンドはデータベースマイグレーション、ロール・権限生成、管理者ユーザー作成など、ERPシステムの初期セットアップに必要な一連の処理を実行します。

### 本バッチの処理概要

このバッチは、AureusERPシステムを新規にセットアップする際に使用される包括的なインストールコマンドです。データベースの準備からシステム管理者の作成まで、ERPシステムを利用可能な状態にするために必要なすべての初期化処理を自動的に実行します。

**業務上の目的・背景**：ERPシステムの導入時には、データベーススキーマの構築、権限管理の設定、初期ユーザーの作成など、複数の複雑な初期化作業が必要です。このバッチはこれらの作業を一括で自動化することで、システム導入時の作業効率を大幅に向上させ、人的ミスを防止します。また、`--force`オプションによる再インストール機能により、開発環境のリセットやテスト環境の再構築にも活用できます。

**バッチの実行タイミング**：手動実行。システムの初期導入時、または開発・テスト環境のリセット時に管理者が明示的に実行します。`--force`オプションを指定することで、既存データを削除して再インストールすることも可能です。

**主要な処理内容**：
1. 既存インストールの確認と再インストール処理（--forceオプション時）
2. データベースマイグレーションの実行
3. Filament Shield によるロール・権限の生成
4. ストレージディレクトリのシンボリックリンク作成
5. データベースシーダーの実行
6. 管理者ユーザーの作成とロール割り当て
7. インストール完了マーカーの作成

**前後の処理との関連**：このバッチはERPシステムのインストールの起点となります。実行前にはデータベース接続設定（.envファイル）が完了している必要があります。インストール完了後は、各プラグインの個別インストール（{plugin}:install）を実行してシステムを拡張できます。

**影響範囲**：データベース全体（マイグレーションによるスキーマ変更）、ファイルシステム（ストレージリンク作成、インストールマーカー作成）、権限システム（ロール・権限テーブル）に影響を与えます。再インストール時は既存の全データが削除されるため、本番環境での実行には細心の注意が必要です。

## バッチ種別

インストールコマンド / システム初期化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（通常は初回のみ） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | .envファイルでデータベース接続情報が正しく設定されていること |
| PHP環境 | PHP 8.1以上が正常に動作していること |
| Composer依存関係 | `composer install`が完了していること |
| ファイル権限 | storageディレクトリへの書き込み権限があること |

### 実行可否判定

- `storage/installed`ファイルの存在確認
  - 存在しない場合：通常のインストールを実行
  - 存在する場合：再インストール確認プロンプトを表示
  - `--force`オプション指定時：確認なしで再インストールを実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --force | boolean | No | false | 確認なしで再インストールを実行 |
| --admin-name | string | No | 対話式入力 | 管理者ユーザー名 |
| --admin-email | string | No | 対話式入力 | 管理者メールアドレス |
| --admin-password | string | No | 対話式入力 | 管理者パスワード（8文字以上） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | CLI | 管理者情報（オプション） |
| 対話式入力 | STDIN | 管理者情報（引数未指定時） |
| .envファイル | 設定ファイル | データベース接続情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| データベース | SQL | マイグレーションによるスキーマ作成 |
| rolesテーブル | DB | 管理者ロールの作成 |
| permissionsテーブル | DB | 権限レコードの作成 |
| usersテーブル | DB | 管理者ユーザーの作成 |
| settingsテーブル | DB | デフォルト設定の保存 |
| storage/installed | ファイル | インストール完了マーカー |
| public/storage | シンボリックリンク | ストレージへのリンク |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | installed |
| 出力先 | storage/ |
| 文字コード | UTF-8 |
| 内容 | インストール日時とメッセージ |

## 処理フロー

### 処理シーケンス

```
1. インストール状態確認
   └─ storage/installedファイルの存在チェック
2. 再インストール処理（既存インストール時）
   ├─ 警告メッセージ表示
   ├─ "REINSTALL"入力確認
   ├─ 二重確認
   ├─ migrate:fresh実行（データベース初期化）
   └─ インストールマーカー削除
3. データベースマイグレーション
   └─ php artisan migrate 実行
4. ロール・権限生成
   ├─ admin_roleロール作成
   ├─ shield:generate --all実行
   └─ 全権限をadminロールに割り当て
5. ストレージリンク作成
   └─ php artisan storage:link 実行
6. データベースシーダー実行
   └─ php artisan db:seed 実行
7. 管理者ユーザー作成
   ├─ ユーザー情報入力/取得
   ├─ ユーザーレコード作成
   ├─ adminロール割り当て
   ├─ 欠損creator_idのバックフィル
   └─ デフォルト設定の同期
8. インストール完了処理
   ├─ storage/installedファイル作成
   └─ aureus.installedイベント発火
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{既存インストール確認}
    B -->|未インストール| D[マイグレーション実行]
    B -->|インストール済み| C{--force指定?}
    C -->|Yes| E[データベース初期化]
    C -->|No| F{再インストール確認}
    F -->|確認OK| E
    F -->|キャンセル| Z[終了]
    E --> D
    D --> G[ロール・権限生成]
    G --> H[ストレージリンク作成]
    H --> I[シーダー実行]
    I --> J[管理者ユーザー作成]
    J --> K[インストールマーカー作成]
    K --> L[イベント発火]
    L --> M[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マイグレーション | 全テーブル | CREATE | スキーマ作成 |
| ロール作成 | roles | INSERT | adminロール作成 |
| 権限生成 | permissions | INSERT | Filament権限作成 |
| ロール権限紐付け | role_has_permissions | INSERT | 全権限をadminに割当 |
| シーダー | 複数テーブル | INSERT | 初期データ投入 |
| ユーザー作成 | users | INSERT/UPDATE | 管理者ユーザー作成 |
| 会社更新 | companies | UPDATE | creator_id設定 |
| 設定保存 | settings | INSERT/UPDATE | デフォルト設定保存 |
| バックフィル | 複数テーブル | UPDATE | creator_id補完 |

### テーブル別操作詳細

#### roles
| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | Filament Shield設定から取得 | 管理者ロール名 |
| INSERT | is_default | true | デフォルトロールとして設定 |

#### users
| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | コマンド引数/対話入力 | 管理者名 |
| INSERT/UPDATE | email | コマンド引数/対話入力 | 一意制約あり |
| INSERT/UPDATE | password | Hash::make(入力値) | 8文字以上必須 |
| INSERT/UPDATE | resource_permission | 'global' | グローバル権限 |
| INSERT/UPDATE | default_company_id | Company::first()->id | 最初の会社 |
| INSERT/UPDATE | is_default | true | デフォルトユーザー |

#### settings
| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | group, name | general/default_company_id | デフォルト会社ID |
| INSERT/UPDATE | group, name | general/default_role_id | デフォルトロールID |
| INSERT/UPDATE | group, name | currency/default_currency_id | デフォルト通貨ID |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DatabaseException | データベース接続失敗 | .env設定を確認 |
| - | ValidationError | メールアドレス形式不正 | 正しい形式で再入力 |
| - | ValidationError | パスワード8文字未満 | 8文字以上で再入力 |
| - | DuplicateError | メールアドレス重複 | 別のアドレスを使用 |
| - | PermissionError | ストレージ書き込み権限なし | ファイル権限を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（対話式で再入力可能） |
| リトライ間隔 | なし |
| リトライ対象エラー | バリデーションエラー時は再入力を促す |

### 障害時対応

1. データベース接続エラー：.envファイルのDB設定を確認し、データベースサーバーの起動状態を確認
2. マイグレーションエラー：エラーログを確認し、原因を特定後に再実行
3. 途中で失敗した場合：`--force`オプションで再実行することで最初からやり直し可能

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 処理単位ごと（マイグレーション、シーダー等） |
| コミットタイミング | 各処理完了時 |
| ロールバック条件 | 各処理内でエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（初回インストールのみ） |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 256MB |

## 排他制御

同時実行不可。複数プロセスからの同時実行は想定していません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Starting ERP System Installation..." |
| 進捗ログ | 各処理完了時 | マイグレーション完了、権限生成完了等 |
| 終了ログ | バッチ終了時 | "ERP System installation completed successfully!" |
| エラーログ | エラー発生時 | エラーメッセージとスタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | 失敗時 | システム管理者 |
| 処理時間 | 10分超過 | システム管理者 |

## 備考

- 本番環境での再インストールは、全データが削除されるため厳重な注意が必要
- 再インストール時は「REINSTALL」と入力する二重確認が要求される
- `aureus.installed`イベントが発火され、リスナーで追加処理が可能
- インストール完了後は`storage/installed`ファイルで状態を管理
