# バッチ設計書 3-{plugin}:install

## 概要

本ドキュメントは、AureusERPの各プラグインをインストールする「{plugin}:install」コマンドのバッチ設計書です。このコマンドはプラグイン名に応じて動的に生成され、依存関係の解決、データベースマイグレーション、シーダーの実行など、プラグインのセットアップに必要な処理を実行します。

### 本バッチの処理概要

このバッチは、AureusERPシステムの各プラグイン（モジュール）を個別にインストールするためのコマンドです。プラグインアーキテクチャに基づき、各プラグインは独自のデータベーススキーマ、初期データ、設定を持っており、このコマンドによってそれらを適切にセットアップします。

**業務上の目的・背景**：ERPシステムは多様な業務領域（会計、在庫管理、人事、プロジェクト管理等）をカバーしますが、すべての機能を一度に導入する必要はありません。このバッチにより、必要な機能のみを選択的にインストールでき、システムの軽量化と段階的な機能拡張が可能になります。また、プラグイン間の依存関係を自動的に解決することで、正しいインストール順序を保証します。

**バッチの実行タイミング**：手動実行。ERPコアシステムのインストール後、必要なプラグインを追加する際に管理者が明示的に実行します。例えば`support:install`、`accounts:install`、`inventories:install`などの形式で呼び出されます。

**主要な処理内容**：
1. 依存プラグインの確認と自動インストール（オプション）
2. プラグイン固有のアセット・設定ファイルの公開
3. データベースマイグレーションの実行
4. データベースシーダーの実行
5. サービスプロバイダーの登録（必要な場合）
6. pluginsテーブルへのプラグイン情報登録
7. 依存関係の記録
8. 管理パネル権限の再生成

**前後の処理との関連**：このバッチを実行する前に、ERPコアシステム（erp:install）がインストールされている必要があります。また、プラグインに依存関係がある場合は、依存先のプラグインが先にインストールされている必要があります（自動インストールオプションあり）。

**影響範囲**：プラグイン固有のデータベーステーブル、pluginsテーブル（プラグイン管理）、plugin_dependenciesテーブル（依存関係管理）、permissions/rolesテーブル（権限再生成時）に影響を与えます。既存データへの影響は最小限に抑えられています。

## バッチ種別

インストールコマンド / プラグイン初期化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（プラグイン追加時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ERPコアインストール済み | erp:installが正常に完了していること |
| 依存プラグイン | 依存するプラグインがインストール済み、または自動インストールを選択 |
| データベース接続 | データベースが正常に動作していること |
| ファイル権限 | ストレージ・設定ディレクトリへの書き込み権限があること |

### 実行可否判定

- 依存プラグインの存在確認
  - 依存関係あり＆未インストール：対話式で選択（Install/Skip/Show Dependencies）
  - `installDependencies`フラグ有効時：自動的に依存プラグインをインストール

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンド自体にパラメータはなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Package設定 | PHP | プラグインのServiceProviderで定義された設定 |
| composer.json | JSON | プラグインのメタ情報（作者、説明、バージョン等） |
| マイグレーションファイル | PHP | データベーススキーマ定義 |
| シーダークラス | PHP | 初期データ定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| プラグイン固有テーブル | DB | マイグレーションで定義されたテーブル |
| pluginsテーブル | DB | プラグイン情報の登録 |
| plugin_dependenciesテーブル | DB | 依存関係の記録 |
| permissionsテーブル | DB | 権限の再生成 |
| migrationsテーブル | DB | マイグレーション実行記録 |
| 公開ディレクトリ | ファイル | 設定・アセット・ビュー等の公開 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 設定ファイル | config/{plugin}.php（publish時） |
| アセット | public/vendor/{plugin}/（publish時） |
| ビュー | resources/views/vendor/{plugin}/（publish時） |

## 処理フロー

### 処理シーケンス

```
1. startWithコールバック実行（設定されている場合）
   └─ プラグイン固有の前処理
2. 依存関係の処理
   ├─ askToInstallDependencies有効時：対話式で選択
   │   ├─ Install：依存プラグインを順次インストール
   │   ├─ Show Dependencies：依存一覧を表示して再選択
   │   └─ Skip：エラー表示して終了
   └─ installDependencies有効時：自動インストール
3. アセット・設定の公開
   └─ 設定されたpublishタグごとにvendor:publish実行
4. マイグレーション実行
   ├─ askToRunMigrations有効時：確認後に実行
   └─ runsMigrations有効時：自動実行
5. 設定マイグレーション実行
   └─ settingFileNamesに定義された設定マイグレーション
6. シーダー実行
   ├─ askToRunSeeders有効時：確認後に実行
   │   └─ 既存インストール時：Reseed/Skip/Show Seeders選択
   └─ runsSeeders有効時：自動実行
7. サービスプロバイダー登録（設定時）
   └─ bootstrap/providers.phpまたはconfig/app.phpに追加
8. プラグイン情報の登録
   └─ pluginsテーブルにupdateOrCreate
9. 依存関係の記録
   └─ plugin_dependenciesテーブルに同期
10. endWithコールバック実行（設定されている場合）
    └─ プラグイン固有の後処理
11. 管理パネル権限の再生成
    └─ shield:generate --all実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{startWithコールバック?}
    B -->|あり| C[前処理実行]
    B -->|なし| D{依存関係あり?}
    C --> D
    D -->|あり| E{対話/自動?}
    D -->|なし| H[アセット公開]
    E -->|対話式| F{Install選択?}
    E -->|自動| G[依存プラグインインストール]
    F -->|Yes| G
    F -->|No| Z[終了]
    G --> H
    H --> I{マイグレーション?}
    I -->|実行| J[マイグレーション実行]
    I -->|スキップ| K{シーダー?}
    J --> K
    K -->|実行| L[シーダー実行]
    K -->|スキップ| M[プラグイン情報登録]
    L --> M
    M --> N[依存関係記録]
    N --> O{endWithコールバック?}
    O -->|あり| P[後処理実行]
    O -->|なし| Q[権限再生成]
    P --> Q
    Q --> R[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マイグレーション | プラグイン固有テーブル | CREATE | スキーマ作成 |
| マイグレーション | migrations | INSERT | 実行記録 |
| 設定マイグレーション | 設定テーブル | CREATE | 設定スキーマ |
| シーダー | プラグイン固有テーブル | INSERT | 初期データ投入 |
| プラグイン登録 | plugins | INSERT/UPDATE | プラグイン情報 |
| 依存関係登録 | plugin_dependencies | INSERT | 依存関係記録 |
| 権限再生成 | permissions | INSERT | 新規権限作成 |
| ロール権限同期 | role_has_permissions | INSERT | 権限割り当て |

### テーブル別操作詳細

#### plugins
| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | Package名 | 一意キー |
| INSERT/UPDATE | author | composer.jsonから取得 | 作者名 |
| INSERT/UPDATE | summary | composer.jsonのdescription | 概要 |
| INSERT/UPDATE | description | composer.jsonのdescription | 説明 |
| INSERT/UPDATE | latest_version | Package設定から取得 | バージョン |
| INSERT/UPDATE | license | composer.jsonのlicense | ライセンス |
| INSERT/UPDATE | sort | Package設定から取得 | 並び順 |
| INSERT/UPDATE | is_active | true | 有効フラグ |
| INSERT/UPDATE | is_installed | true | インストールフラグ |

#### plugin_dependencies
| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | plugin_id | 親プラグインID | syncWithoutDetaching使用 |
| INSERT | dependency_id | 依存プラグインID | 重複なし |

#### migrations
| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | migration | マイグレーションファイル名 | 実行済みチェック用 |
| INSERT | batch | バッチ番号 | 順序管理 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DependencyError | 依存プラグインがインストールされていない | 依存プラグインを先にインストール |
| - | MigrationError | マイグレーション実行失敗 | エラーログを確認し原因を特定 |
| - | SeederError | シーダー実行失敗 | シーダークラスの内容を確認 |
| - | FilePermissionError | ファイル公開失敗 | 書き込み権限を確認 |
| - | DatabaseError | データベース接続失敗 | 接続設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（再実行で対応） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし（エラー時は原因を特定して再実行） |

### 障害時対応

1. 依存関係エラー：依存プラグインを先にインストールするか、対話時にInstallを選択
2. マイグレーションエラー：エラーメッセージを確認し、必要に応じてデータベースを確認
3. シーダーエラー：シーダークラスの実装を確認し、データ整合性をチェック
4. 権限生成エラー：shield:generateコマンドを手動で実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | マイグレーション・シーダーは個別トランザクション |
| コミットタイミング | 各処理完了時 |
| ロールバック条件 | 各処理内でエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/プラグイン |
| 目標処理時間 | 2分以内 |
| メモリ使用量上限 | 256MB |

## 排他制御

同時実行不可。異なるプラグインの同時インストールは避けることを推奨します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 依存インストール開始時 | "Installing {dependency}..." |
| 進捗ログ | 各処理完了時 | マイグレーション完了、シーダー完了等 |
| 終了ログ | バッチ終了時 | "Package {plugin} has been installed!" |
| エラーログ | エラー発生時 | "Please install the dependencies first." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | 失敗時 | システム管理者 |
| 権限再生成結果 | 失敗時 | システム管理者 |

## 備考

- コマンド名はPackage設定の`shortName()`から動的に生成される（例：support:install）
- `$hidden = true`が設定されており、artisan listには表示されない
- 既存インストール済みプラグインに対するシーダー実行時は、Reseed/Skip/Show Seedersから選択可能
- 各プラグインのServiceProviderで`hasInstallCommand()`を使用してカスタマイズ可能
- 権限再生成は`shield:generate --all --option=permissions --panel=admin`を実行
