# バッチ設計書 4-{plugin}:uninstall

## 概要

本ドキュメントは、AureusERPの各プラグインをアンインストールする「{plugin}:uninstall」コマンドのバッチ設計書です。このコマンドはプラグイン名に応じて動的に生成され、データベーステーブルの削除、マイグレーションのロールバック、プラグイン登録の解除など、プラグインの完全な削除処理を実行します。

### 本バッチの処理概要

このバッチは、AureusERPシステムにインストールされたプラグイン（モジュール）を安全にアンインストールするためのコマンドです。プラグインに関連するデータベーステーブルを削除し、マイグレーション履歴をクリアし、プラグイン登録を解除することで、システムからプラグインを完全に除去します。

**業務上の目的・背景**：ERPシステムの運用において、不要になったプラグインや、テスト目的でインストールしたプラグインを削除する必要が生じます。このバッチにより、プラグインの完全な削除を安全かつ確実に実行できます。また、依存関係チェックにより、他のプラグインが依存しているプラグインの誤削除を防止し、システムの整合性を保護します。

**バッチの実行タイミング**：手動実行。不要なプラグインを削除する際に管理者が明示的に実行します。`--force`オプションを使用することで、確認プロンプトをスキップできます。例えば`accounts:uninstall`、`inventories:uninstall`などの形式で呼び出されます。

**主要な処理内容**：
1. プラグインのインストール状態確認
2. 依存プラグインの存在チェック（他プラグインからの依存）
3. ユーザー確認（--forceオプションでスキップ可能）
4. データベーステーブルの削除（マイグレーションのdown()実行）
5. 設定マイグレーションのロールバック
6. マイグレーション履歴の削除
7. pluginsテーブルからのプラグイン登録解除

**前後の処理との関連**：このバッチを実行する前に、対象プラグインに依存している他のプラグインを先にアンインストールする必要があります。依存されているプラグインを削除しようとすると、エラーが発生し処理が中断されます。

**影響範囲**：プラグイン固有のデータベーステーブル（完全削除）、migrationsテーブル（実行記録削除）、pluginsテーブル（プラグイン登録削除）に影響を与えます。この操作は取り消し不可能であり、プラグインに関連する全データが失われます。

## バッチ種別

アンインストールコマンド / プラグイン削除

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（プラグイン削除時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| プラグインインストール済み | 対象プラグインがインストールされていること |
| 依存プラグインなし | このプラグインに依存する他プラグインが存在しないこと |
| データベース接続 | データベースが正常に動作していること |

### 実行可否判定

- プラグインのインストール状態確認
  - 未インストール：エラーメッセージ「Package {plugin} is not installed!」で終了
- 依存プラグインの確認
  - 依存あり：エラーメッセージ「Package {plugin} has dependents: {list}. Please uninstall dependents first!」で終了
- 確認プロンプト（--forceなしの場合）
  - キャンセル：「Uninstallation cancelled.」で終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --force | boolean | No | false | 確認なしでアンインストールを実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Package設定 | PHP | プラグインのServiceProviderで定義された設定 |
| pluginsテーブル | DB | インストール状態と依存関係情報 |
| マイグレーションファイル | PHP | テーブル削除用のdown()メソッド |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| プラグイン固有テーブル | DB | テーブル削除（DROP） |
| migrationsテーブル | DB | マイグレーション履歴削除 |
| pluginsテーブル | DB | プラグイン登録削除 |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. インストール状態確認
   └─ package->isInstalled()でチェック
      └─ 未インストール時：エラー終了
2. 依存プラグイン確認
   └─ plugin->dependents->isEmpty()でチェック
      └─ 依存あり時：エラー終了（依存プラグイン一覧を表示）
3. startWithコールバック実行（設定されている場合）
   └─ プラグイン固有の前処理
4. 確認プロンプト（--forceなしの場合）
   └─ "Are you sure you want to uninstall this package?"
      └─ キャンセル時：終了
5. データベーステーブル削除
   ├─ マイグレーションを逆順で処理
   │   ├─ マイグレーションファイルを読み込み
   │   ├─ down()メソッドを実行
   │   └─ migrationsテーブルから記録削除
   └─ 設定マイグレーションも同様に処理
6. プラグイン登録削除
   └─ package->delete()を実行
      └─ pluginsテーブルから削除
7. 完了メッセージ表示
8. endWithコールバック実行（設定されている場合）
   └─ プラグイン固有の後処理
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{インストール済み?}
    B -->|No| C[エラー: 未インストール]
    B -->|Yes| D{依存プラグインあり?}
    C --> Z[終了]
    D -->|Yes| E[エラー: 依存プラグインを先に削除]
    D -->|No| F{startWithコールバック?}
    E --> Z
    F -->|あり| G[前処理実行]
    F -->|なし| H{--force指定?}
    G --> H
    H -->|No| I{確認プロンプト}
    H -->|Yes| J[テーブル削除開始]
    I -->|確認OK| J
    I -->|キャンセル| Z
    J --> K[マイグレーションdown実行]
    K --> L[migrations履歴削除]
    L --> M[設定マイグレーション処理]
    M --> N[プラグイン登録削除]
    N --> O{endWithコールバック?}
    O -->|あり| P[後処理実行]
    O -->|なし| Q[完了]
    P --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テーブル削除 | プラグイン固有テーブル | DROP | マイグレーションdown()実行 |
| 履歴削除 | migrations | DELETE | マイグレーション記録削除 |
| プラグイン削除 | plugins | DELETE | プラグイン登録削除 |

### テーブル別操作詳細

#### プラグイン固有テーブル
| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DROP | テーブル全体 | マイグレーションのdown()で定義 | 逆順で実行 |

#### migrations
| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | migration | WHERE migration = {マイグレーション名} | 各マイグレーションごとに削除 |

#### plugins
| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | * | WHERE name = {プラグイン名} | プラグイン全情報削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NotInstalledError | プラグインが未インストール | 正しいプラグイン名を確認 |
| - | DependencyError | 他プラグインがこのプラグインに依存 | 依存プラグインを先にアンインストール |
| - | MigrationError | down()メソッド実行失敗 | マイグレーションファイルを確認 |
| - | DatabaseError | データベース接続失敗 | 接続設定を確認 |
| - | FileNotFoundError | マイグレーションファイルが存在しない | ファイルの存在を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（エラー時は原因を特定して再実行） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

1. 未インストールエラー：正しいプラグイン名を確認し、`plugins`テーブルの状態をチェック
2. 依存関係エラー：エラーメッセージに表示された依存プラグインを先にアンインストール
3. マイグレーションエラー：手動でテーブル削除とmigrationsテーブルの更新が必要な場合あり
4. 途中で失敗した場合：データベース状態を確認し、手動でクリーンアップが必要

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | down()メソッドは個別に実行 |
| コミットタイミング | 各down()実行後 |
| ロールバック条件 | なし（down()は個別実行） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/プラグイン |
| 目標処理時間 | 1分以内 |
| メモリ使用量上限 | 128MB |

## 排他制御

同時実行不可。同一プラグインの複数削除は不可能ですが、異なるプラグインの同時アンインストールは避けることを推奨します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | テーブル削除開始時 | "Dropping database tables for {plugin}..." |
| 進捗ログ | 各マイグレーション処理時 | "Rolling back migration: {migration}" |
| 終了ログ | バッチ終了時 | "Package {plugin} has been uninstalled!" |
| エラーログ | エラー発生時 | "Package {plugin} is not installed!" |
| エラーログ | 依存エラー時 | "Package {plugin} has dependents: {list}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行結果 | 失敗時 | システム管理者 |

## 備考

- コマンド名はPackage設定の`shortName()`から動的に生成される（例：support:uninstall）
- `$hidden = true`が設定されており、artisan listには表示されない
- マイグレーションは`array_reverse()`で逆順に処理される（作成の逆順で削除）
- `--force`オプションはコマンドシグネチャで定義：`{--force : Force the operation to run without confirmation}`
- down()メソッドが存在しない場合はスキップされる（`method_exists`でチェック）
- 設定マイグレーション（settingFileNames）も同様に処理される
- この操作は**取り消し不可能**であり、実行前に必ずバックアップを取得することを推奨
- プラグイン削除後は`Package::$plugins`からも削除される
