---
generated_at: 2025-12-27 10:40:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-plugin_install.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/support/src/Console/Commands/InstallCommand.php`
- E-02: `plugins/webkul/support/src/Package.php`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は{plugin}:install形式 | E-01（L44: `$package->shortName().':install'`） | ○ |
| C-02 | $hidden = trueでartisan listに非表示 | E-01（L40: `$hidden = true`） | ○ |
| C-03 | startWithコールバックで前処理実行 | E-01（L55-57: `if ($this->startWith)`） | ○ |
| C-04 | 依存関係を対話式で処理（Install/Skip/Show） | E-01（L59-94: 選択肢処理） | ○ |
| C-05 | installDependenciesフラグで自動インストール | E-01（L95-109: 自動インストール処理） | ○ |
| C-06 | vendor:publishでアセット公開 | E-01（L111-118: `callSilently('vendor:publish')`） | ○ |
| C-07 | askToRunMigrationsで確認後マイグレーション | E-01（L120-123: confirm後にrunMigrations） | ○ |
| C-08 | runsMigrationsフラグで自動マイグレーション | E-01（L124-126: 自動実行） | ○ |
| C-09 | askToRunSeedersで確認後シーダー実行 | E-01（L128-131: confirm後にrunSeeders） | ○ |
| C-10 | runsSeedersフラグで自動シーダー実行 | E-01（L132-134: 自動実行） | ○ |
| C-11 | copyServiceProviderInAppでプロバイダー登録 | E-01（L136-142, L387-432: 登録処理） | ○ |
| C-12 | GitHubリポジトリへのスター機能 | E-01（L144-158: starRepo処理） | ○ |
| C-13 | pluginsテーブルにupdateOrCreate | E-01（L160: `$this->package->updateOrCreate()`） | ○ |
| C-14 | 依存関係をsyncWithoutDetaching | E-01（L162-166: 依存関係同期） | ○ |
| C-15 | endWithコールバックで後処理実行 | E-01（L168-170: `if ($this->endWith)`） | ○ |
| C-16 | 権限再生成実行 | E-01（L172: `regenerateAdminPanelPermissions()`） | ○ |
| C-17 | shield:generate --all実行 | E-01（L442: コマンド構築） | ○ |
| C-18 | migrationsテーブルで実行済みチェック | E-01（L380-385: `hasMigrationAlreadyRun()`） | ○ |
| C-19 | 設定マイグレーション実行 | E-01（L276-302: settingFileNames処理） | ○ |
| C-20 | 既存インストール時にReseed/Skip選択 | E-01（L309-330: シーダー選択処理） | ○ |
| C-21 | Package::updateOrCreateでプラグイン情報保存 | E-02（L143-163: updateOrCreate実装） | ○ |
| C-22 | composer.jsonからメタ情報取得 | E-02（L145-156: composerData処理） | ○ |
| C-23 | is_active, is_installedをtrueで保存 | E-02（L157-158: フラグ設定） | ○ |
| C-24 | 手動実行のインストールコマンド | E-03（No.3の備考列） | ○ |
| C-25 | プラグイン名に応じて動的生成 | E-03（No.3のバッチ名列: `{plugin}:install`） | ○ |
| C-26 | publishメソッドでタグ指定公開 | E-01（L177-182, L184-202: publish系メソッド） | ○ |
| C-27 | runMigrationsで未実行マイグレーションのみ実行 | E-01（L246-274: マイグレーション実行ロジック） | ○ |
| C-28 | db:seedコマンドでシーダー実行 | E-01（L337-343: `call('db:seed')`） | ○ |
| C-29 | bootstrap/providers.phpへのプロバイダー追加 | E-01（L411-423: Laravel 11+対応） | ○ |
| C-30 | config/app.phpへのプロバイダー追加（旧版） | E-01（L400-410, 411-417: Laravel 10以前対応） | ○ |
| C-31 | 最初のロールに全権限を同期 | E-01（L450-454: `$role->permissions()->sync()`） | ○ |
| C-32 | 依存プラグインを順次インストール | E-01（L71-77, L100-106: 依存インストールループ） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に対して根拠が確認できました）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク
  - プラグイン固有のテーブル作成を伴うため、スキーマ変更リスクあり
  - 権限再生成により既存の権限設定に影響する可能性あり
  - 依存関係の解決順序が重要

## 6) レビュアーチェックリスト（最小）
- [x] コマンド名の動的生成が正確に記載されているか確認
- [x] 依存関係処理フロー（対話式/自動）が正確か確認
- [x] マイグレーション・シーダー実行オプションが正確か確認
- [x] pluginsテーブルへの保存内容が正確か確認
- [x] 権限再生成処理が正確に記載されているか確認
- [x] 既存インストール時のシーダー選択肢が正確か確認
