---
generated_at: 2025-12-27 10:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-plugin_uninstall.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/support/src/Console/Commands/UninstallCommand.php`
- E-02: `plugins/webkul/support/src/Package.php`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は{plugin}:uninstall形式 | E-01（L25: `$package->shortName().':uninstall'`） | ○ |
| C-02 | --forceオプションで確認スキップ | E-01（L25: `{--force : Force the operation...}`） | ○ |
| C-03 | $hidden = trueでartisan listに非表示 | E-01（L19: `$hidden = true`） | ○ |
| C-04 | 未インストール時はエラー終了 | E-01（L36-40: `isInstalled()`チェック） | ○ |
| C-05 | 依存プラグイン存在時はエラー終了 | E-01（L42-46: `dependents->isEmpty()`チェック） | ○ |
| C-06 | 依存プラグイン一覧をエラーメッセージに表示 | E-01（L43: `dependents->pluck('name')->implode(', ')`） | ○ |
| C-07 | startWithコールバックで前処理実行 | E-01（L48-50: `if ($this->startWith)`） | ○ |
| C-08 | forceUninstallフラグでオプション取得 | E-01（L52: `$this->option('force')`） | ○ |
| C-09 | 確認プロンプトでキャンセル可能 | E-01（L54-58: `confirm`処理） | ○ |
| C-10 | dropTables()でテーブル削除 | E-01（L60: `$this->dropTables()`） | ○ |
| C-11 | マイグレーションを逆順で処理 | E-01（L75: `array_reverse($this->package->migrationFileNames)`） | ○ |
| C-12 | down()メソッドを実行 | E-01（L87-90: `method_exists`と`down()`呼び出し） | ○ |
| C-13 | migrationsテーブルから記録削除 | E-01（L94: `DB::table('migrations')->where(...)->delete()`） | ○ |
| C-14 | 設定マイグレーションも同様に処理 | E-01（L97-115: settingFileNames処理） | ○ |
| C-15 | package->delete()でプラグイン削除 | E-01（L62: `$this->package->delete()`） | ○ |
| C-16 | Package::delete()でpluginsテーブルから削除 | E-02（L134-141: delete実装） | ○ |
| C-17 | Package::$pluginsからも削除 | E-02（L138: `unset(static::$plugins[$this->name])`） | ○ |
| C-18 | endWithコールバックで後処理実行 | E-01（L66-68: `if ($this->endWith)`） | ○ |
| C-19 | 手動実行のアンインストールコマンド | E-03（No.4の備考列） | ○ |
| C-20 | プラグイン名に応じて動的生成 | E-03（No.4のバッチ名列: `{plugin}:uninstall`） | ○ |
| C-21 | マイグレーションファイルの存在確認 | E-01（L82: `file_exists($migrationPath)`） | ○ |
| C-22 | method_existsでdown()メソッドチェック | E-01（L87: `method_exists($migrationInstance, 'down')`） | ○ |
| C-23 | 進捗メッセージでロールバック状況表示 | E-01（L88: "Rolling back migration: {$migration}"） | ○ |
| C-24 | 完了メッセージ表示 | E-01（L64: "Package {$plugin} has been uninstalled!"） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に対して根拠が確認できました）

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク
  - このバッチはデータベーステーブルを完全に削除する破壊的操作
  - 実行後はデータの復元が不可能
  - 依存関係チェックは実装されているが、データの整合性確認は行われない

## 6) レビュアーチェックリスト（最小）
- [x] コマンドシグネチャ（--forceオプション含む）が正確に記載されているか確認
- [x] インストール状態チェックが正確か確認
- [x] 依存プラグインチェックが正確か確認
- [x] テーブル削除処理（逆順、down()実行）が正確か確認
- [x] migrationsテーブルからの記録削除が正確か確認
- [x] 設定マイグレーション処理が正確か確認
- [x] pluginsテーブルからの削除処理が正確か確認
