---
generated_at: 2025-12-29 17:35:00
metrics:
  claims_total: 111
  claims_with_evidence: 111
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：accounts.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：111 / 111、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースにソースコードの根拠あり
  2. 高優先度のテストケースは金額計算・状態遷移に集中
  3. Filamentアクションのバリデーション・表示制御は実装コードで確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/accounts/src/Models/Account.php`
- E-02: `plugins/webkul/accounts/src/Models/Move.php`
- E-03: `plugins/webkul/accounts/src/Models/MoveLine.php`
- E-04: `plugins/webkul/accounts/src/Models/Journal.php`
- E-05: `plugins/webkul/accounts/src/Models/Tax.php`
- E-06: `plugins/webkul/accounts/src/Models/Payment.php`
- E-07: `plugins/webkul/accounts/src/Models/PaymentTerm.php`
- E-08: `plugins/webkul/accounts/src/Models/PaymentMethod.php`
- E-09: `plugins/webkul/accounts/src/Models/PaymentMethodLine.php`
- E-10: `plugins/webkul/accounts/src/Models/TaxGroup.php`
- E-11: `plugins/webkul/accounts/src/Models/FiscalPosition.php`
- E-12: `plugins/webkul/accounts/src/Models/FiscalPositionTax.php`
- E-13: `plugins/webkul/accounts/src/Models/PaymentRegister.php`
- E-14: `plugins/webkul/accounts/src/Models/Incoterm.php`
- E-15: `plugins/webkul/accounts/src/Models/CashRounding.php`
- E-16: `plugins/webkul/accounts/src/Models/Tag.php`
- E-17: `plugins/webkul/accounts/src/Models/BankStatement.php`
- E-18: `plugins/webkul/accounts/src/Models/TaxPartition.php`
- E-19: `plugins/webkul/accounts/src/Models/PartialReconcile.php`
- E-20: `plugins/webkul/accounts/src/Models/FullReconcile.php`
- E-21: `plugins/webkul/accounts/src/Models/Reconcile.php`
- E-22: `plugins/webkul/accounts/src/Models/MoveReversal.php`
- E-23: `plugins/webkul/accounts/src/Models/PaymentDueTerm.php`
- E-24: `plugins/webkul/accounts/src/Models/Partner.php`
- E-25: `plugins/webkul/accounts/src/TaxManager.php`
- E-26: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/ConfirmAction.php`
- E-27: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/CancelAction.php`
- E-28: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/PayAction.php`
- E-29: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/ResetToDraftAction.php`
- E-30: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/CreditNoteAction.php`
- E-31: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/SetAsCheckedAction.php`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Account.currencyリレーションがbelongsToで定義 | E-01 L36-39 | ○ |
| C-02 | Account.createdByリレーションがbelongsToで定義 | E-01 L41-44 | ○ |
| C-03 | Account.taxesリレーションがbelongsToManyで定義 | E-01 L46-49 | ○ |
| C-04 | Account.tagsリレーションがbelongsToManyで定義 | E-01 L51-54 | ○ |
| C-05 | Account.journalsリレーションがbelongsToManyで定義 | E-01 L56-59 | ○ |
| C-06 | Account.castsでdeprecated/reconcile/non_tradeがboolean | E-01 L29-34 | ○ |
| C-07 | Account.castsでaccount_typeがAccountType Enum | E-01 L33 | ○ |
| C-08 | Move.journalリレーションがbelongsToで定義 | E-02 L161-163 | ○ |
| C-09 | Move.partnerリレーションがbelongsToで定義 | E-02 L185-188 | ○ |
| C-10 | Move.linesリレーションがhasManyでdisplay_type=productフィルタ | E-02 L294-298 | ○ |
| C-11 | Move.allLinesリレーションがhasManyで全行取得 | E-02 L300-303 | ○ |
| C-12 | Move.taxLinesリレーションがhasManyでdisplay_type=taxフィルタ | E-02 L305-309 | ○ |
| C-13 | Move.paymentTermLineリレーションがhasOneでdisplay_type=payment_termフィルタ | E-02 L311-315 | ○ |
| C-14 | Move.getTotalDiscountAttributeがlinesのdiscount合計を計算 | E-02 L255-260 | ○ |
| C-15 | Move.isInboundがOUT_INVOICE/IN_REFUND/OUT_RECEIPTを判定 | E-02 L262-276 | ○ |
| C-16 | Move.isOutboundがIN_INVOICE/OUT_REFUND/IN_RECEIPTを判定 | E-02 L278-292 | ○ |
| C-17 | Move.isInvoiceがisSaleDocument/isPurchaseDocumentで判定 | E-02 L317-320 | ○ |
| C-18 | Move.isEntryがmove_type===ENTRYで判定 | E-02 L322-325 | ○ |
| C-19 | Move.isSaleDocumentがOUT_INVOICE/OUT_REFUNDを判定 | E-02 L327-337 | ○ |
| C-20 | Move.isPurchaseDocumentがIN_INVOICE/IN_REFUNDを判定 | E-02 L339-346 | ○ |
| C-21 | Move.getValidJournalTypesがドキュメントタイプに応じたジャーナルタイプを返却 | E-02 L348-359 | ○ |
| C-22 | Move.boot-creatingでcreator_idが設定される | E-02 L368-370 | ○ |
| C-23 | Move.boot-createdでsequence_prefixとnameが更新される | E-02 L372-378 | ○ |
| C-24 | Move.updateSequencePrefixがmove_typeに応じたプレフィックスを設定 | E-02 L384-410 | ○ |
| C-25 | Move.castsでstate/payment_state/move_typeがEnum | E-02 L143-148 | ○ |
| C-26 | MoveLine.moveリレーションがbelongsToで定義 | E-03 L86-89 | ○ |
| C-27 | MoveLine.accountリレーションがbelongsToで定義 | E-03 L101-104 | ○ |
| C-28 | MoveLine.taxesリレーションがbelongsToManyで定義 | E-03 L121-124 | ○ |
| C-29 | MoveLine.productリレーションがbelongsToで定義 | E-03 L141-144 | ○ |
| C-30 | MoveLine.paymentリレーションがbelongsToで定義 | E-03 L161-164 | ○ |
| C-31 | MoveLine.castsでdisplay_typeがDisplayType Enum | E-03 L76-79 | ○ |
| C-32 | Journal.getAvailablePaymentMethodLinesがinbound/outboundで分岐 | E-04 L99-110 | ○ |
| C-33 | Journal.getAvailablePaymentMethodLinesが無効タイプで例外スロー | E-04 L108 | ○ |
| C-34 | Journal.getAvailablePaymentMethodLinesが未保存で空コレクション返却 | E-04 L101-103 | ○ |
| C-35 | Journal.computeInboundPaymentMethodLinesがbank/cash/creditで処理 | E-04 L122-143 | ○ |
| C-36 | Journal.defaultAccountリレーションがbelongsToで定義 | E-04 L74-77 | ○ |
| C-37 | Journal.allowedAccountsリレーションがbelongsToManyで定義 | E-04 L94-97 | ○ |
| C-38 | Tax.companyリレーションがbelongsToで定義 | E-05 L50-53 | ○ |
| C-39 | Tax.taxGroupリレーションがbelongsToで定義 | E-05 L55-58 | ○ |
| C-40 | Tax.distributionForInvoiceリレーションがhasManyで定義 | E-05 L75-78 | ○ |
| C-41 | Tax.parentTaxesリレーションがbelongsToManyで定義 | E-05 L85-88 | ○ |
| C-42 | Tax.boot-createdでINVOICE/REFUND用分配レコード作成 | E-05 L90-166 | ○ |
| C-43 | Payment.moveリレーションがbelongsToで定義 | E-06 L70-73 | ○ |
| C-44 | Payment.paymentMethodリレーションがbelongsToで定義 | E-06 L100-103 | ○ |
| C-45 | Payment.pairedInternalTransferPaymentリレーションがbelongsToで定義 | E-06 L90-93 | ○ |
| C-46 | Payment.accountMovePaymentリレーションがbelongsToManyで定義 | E-06 L145-148 | ○ |
| C-47 | PaymentTerm.dueTermリレーションがhasOneで定義 | E-07 L49-52 | ○ |
| C-48 | PaymentTerm.boot-createdでデフォルトPaymentDueTerm作成 | E-07 L54-68 | ○ |
| C-49 | TaxPartition.validateRepartitionLinesがinvoices/refunds件数チェック | E-18 L57-60 | ○ |
| C-50 | TaxPartition.validateRepartitionLinesがbaseタイプ件数チェック | E-18 L62-65 | ○ |
| C-51 | TaxPartition.validateRepartitionLinesがtaxタイプ件数チェック | E-18 L67-69 | ○ |
| C-52 | TaxPartition.validateRepartitionLinesがfactor合計100チェック | E-18 L79-88 | ○ |
| C-53 | TaxPartition.boot-savedでバリデーション実行 | E-18 L91-119 | ○ |
| C-54 | TaxPartition.boot-deletingでバリデーション実行 | E-18 L121-142 | ○ |
| C-55 | FiscalPosition.fiscalPositionTaxesリレーションがhasManyで定義 | E-11 L59-62 | ○ |
| C-56 | FiscalPositionTax.taxSourceリレーションがbelongsToで定義 | E-12 L34-37 | ○ |
| C-57 | FiscalPositionTax.taxDestinationリレーションがbelongsToで定義 | E-12 L39-42 | ○ |
| C-58 | PaymentRegister.registerMoveLinesリレーションがbelongsToManyで定義 | E-13 L91-94 | ○ |
| C-59 | CashRounding.profitAccountリレーションがbelongsToで定義 | E-15 L30-33 | ○ |
| C-60 | CashRounding.lossAccountリレーションがbelongsToで定義 | E-15 L35-38 | ○ |
| C-61 | PartialReconcile.debitMoveリレーションがbelongsToで定義 | E-19 L30-33 | ○ |
| C-62 | PartialReconcile.creditMoveリレーションがbelongsToで定義 | E-19 L35-38 | ○ |
| C-63 | MoveReversal.newMovesリレーションがbelongsToManyで定義 | E-22 L20-23 | ○ |
| C-64 | MoveReversal.movesリレーションがbelongsToManyで定義 | E-22 L25-28 | ○ |
| C-65 | Partner.propertyAccountPayableリレーションがbelongsToで定義 | E-24 L42-45 | ○ |
| C-66 | Partner.propertyAccountReceivableリレーションがbelongsToで定義 | E-24 L47-50 | ○ |
| C-67 | Partner.propertyPaymentTermリレーションがbelongsToで定義 | E-24 L57-60 | ○ |
| C-68 | TaxManager.collectが空taxIdsで[subTotal,0,[]]返却 | E-25 L17-21 | ○ |
| C-69 | TaxManager.collectがpercent税金を計算 | E-25 L65-67 | ○ |
| C-70 | TaxManager.collectがfixed税金を計算 | E-25 L68-69 | ○ |
| C-71 | TaxManager.collectがtax_included価格で逆算 | E-25 L50-63 | ○ |
| C-72 | TaxManager.collectがis_base_affectedで累積計算 | E-25 L40-46 | ○ |
| C-73 | ConfirmAction.validateMoveがpartner_id未設定で警告 | E-26 L45-53 | ○ |
| C-74 | ConfirmAction.validateMoveがlines空で警告 | E-26 L55-66 | ○ |
| C-75 | ConfirmAction.hiddenがDRAFT以外で非表示 | E-26 L36-40 | ○ |
| C-76 | CancelAction.hiddenがDRAFT以外で非表示 | E-27 L31-35 | ○ |
| C-77 | CancelAction.hiddenがENTRYで非表示 | E-27 L34 | ○ |
| C-78 | PayAction.hiddenがPOSTED以外で非表示 | E-28 L104-108 | ○ |
| C-79 | PayAction.hiddenがPAID状態で非表示 | E-28 L107 | ○ |
| C-80 | PayAction.registerPaymentがPaymentRegister作成 | E-28 L111-135 | ○ |
| C-81 | PayAction.createPaymentがPayment作成 | E-28 L137-168 | ○ |
| C-82 | PayAction.createMoveがMove作成 | E-28 L170-209 | ○ |
| C-83 | PayAction.createMoveLineがdebit/credit MoveLine作成 | E-28 L211-264 | ○ |
| C-84 | ResetToDraftAction.visibleがCANCEL/POSTEDで表示 | E-29 L33-37 | ○ |
| C-85 | CreditNoteAction.visibleがPOSTEDで表示 | E-30 L39 | ○ |
| C-86 | CreditNoteAction.createMoveがOUT_REFUNDタイプで作成 | E-30 L81-102 | ○ |
| C-87 | CreditNoteAction.createMoveLinesが明細行コピー | E-30 L104-119 | ○ |
| C-88 | SetAsCheckedAction.hiddenがchecked=trueで非表示 | E-31 L30-34 | ○ |
| C-89 | SetAsCheckedAction.hiddenがDRAFTで非表示 | E-31 L33 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全てのテストケースはソースコードから直接抽出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- 高優先度テストケースの重点確認推奨:
  - 金額計算ロジック（TaxManager.collect、Move.getTotalDiscountAttribute）
  - 状態遷移ロジック（ConfirmAction、CancelAction、PayAction）
  - バリデーションロジック（TaxPartition.validateRepartitionLines）

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケースの入力値・期待結果が妥当か確認
- [ ] Enumの値がソースコードと一致しているか確認
- [ ] リレーションのテストケースが中間テーブル名を正しく参照しているか確認
- [ ] bootイベントのテストケースがトランザクション処理を考慮しているか確認
- [ ] Filamentアクションの表示制御条件が網羅されているか確認
