---
generated_at: 2025-12-29 17:30:00
metrics:
  claims_total: 75
  claims_with_evidence: 75
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：blogs.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で対応を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：75 / 75、根拠なし：0
- 優先レビュー（高）
  - 全てのテストケースがソースコードに基づいて生成されており、特に優先的なレビュー対象はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/blogs/src/Models/Category.php`
- E-02: `plugins/webkul/blogs/src/Models/Post.php`
- E-03: `plugins/webkul/blogs/src/Models/Tag.php`
- E-04: `plugins/webkul/blogs/src/Policies/CategoryPolicy.php`
- E-05: `plugins/webkul/blogs/src/Policies/PostPolicy.php`
- E-06: `plugins/webkul/blogs/src/Policies/TagPolicy.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Categoryモデル関連（UT-BLG-001 〜 UT-BLG-013）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Category::posts()がHasManyリレーションを返す | E-01 (55-58行目) | ○ |
| C-02 | 関連投稿一覧が取得可能 | E-01 (55-58行目) | ○ |
| C-03 | 投稿0件で空Collection | E-01 (55-58行目) | ○ |
| C-04 | Category::creator()がBelongsToリレーションを返す | E-01 (60-63行目) | ○ |
| C-05 | 作成者ユーザー情報が取得可能 | E-01 (60-63行目) | ○ |
| C-06 | 存在しないcreator_idでnull | E-01 (60-63行目) | ○ |
| C-07 | getImageUrlAttributeがStorage URL返却 | E-01 (46-53行目) | ○ |
| C-08 | imageがnullでnull返却 | E-01 (48-50行目) | ○ |
| C-09 | imageが空文字でnull返却 | E-01 (48行目) | ○ |
| C-10 | fillable属性によるマスアサインメント | E-01 (30-39行目) | ○ |
| C-11 | fillable外フィールドの保護 | E-01 (30-39行目) | ○ |
| C-12 | SoftDeletes::delete()動作 | E-01 (16行目) | ○ |
| C-13 | SoftDeletes::restore()動作 | E-01 (16行目) | ○ |

### Postモデル関連（UT-BLG-014 〜 UT-BLG-034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | Post::tags()がBelongsToManyリレーションを返す | E-02 (82-85行目) | ○ |
| C-15 | 関連タグ一覧が取得可能 | E-02 (82-85行目) | ○ |
| C-16 | タグ0件で空Collection | E-02 (82-85行目) | ○ |
| C-17 | Post::category()がBelongsToリレーションを返す | E-02 (87-90行目) | ○ |
| C-18 | カテゴリ情報が取得可能 | E-02 (87-90行目) | ○ |
| C-19 | 存在しないcategory_idでnull | E-02 (87-90行目) | ○ |
| C-20 | Post::author()がBelongsToリレーションを返す | E-02 (92-95行目) | ○ |
| C-21 | 著者ユーザー情報が取得可能 | E-02 (92-95行目) | ○ |
| C-22 | Post::creator()がBelongsToリレーションを返す | E-02 (97-100行目) | ○ |
| C-23 | Post::lastEditor()がBelongsToリレーションを返す | E-02 (102-105行目) | ○ |
| C-24 | getImageUrlAttributeがStorage URL返却 | E-02 (64-71行目) | ○ |
| C-25 | imageがnullでnull返却 | E-02 (66-68行目) | ○ |
| C-26 | getReadingTimeAttributeが読了時間計算 | E-02 (73-80行目) | ○ |
| C-27 | 400語で2分計算 | E-02 (75-77行目) | ○ |
| C-28 | 201語で2分（切り上げ） | E-02 (77行目) | ○ |
| C-29 | 空コンテンツの動作 | E-02 (73-80行目) | ○ |
| C-30 | HTMLタグ除去して語数計算 | E-02 (75行目) | ○ |
| C-31 | is_publishedがbooleanキャスト | E-02 (54-57行目) | ○ |
| C-32 | published_atがdatetimeキャスト | E-02 (54-57行目) | ○ |
| C-33 | fillable属性によるマスアサインメント | E-02 (30-47行目) | ○ |
| C-34 | SoftDeletes::delete()動作 | E-02 (9行目) | ○ |

### Tagモデル関連（UT-BLG-035 〜 UT-BLG-041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Tag::creator()がBelongsToリレーションを返す | E-03 (42-45行目) | ○ |
| C-36 | 作成者ユーザー情報が取得可能 | E-03 (42-45行目) | ○ |
| C-37 | SortableTrait::sort_when_creating動作 | E-03 (37-40行目) | ○ |
| C-38 | moveOrderUp()動作 | E-03 (16行目 SortableTrait) | ○ |
| C-39 | moveOrderDown()動作 | E-03 (16行目 SortableTrait) | ○ |
| C-40 | fillable属性によるマスアサインメント | E-03 (30-35行目) | ○ |
| C-41 | SoftDeletes::delete()動作 | E-03 (16行目) | ○ |

### CategoryPolicy関連（UT-BLG-042 〜 UT-BLG-053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | viewAny権限チェック（許可） | E-04 (16-19行目) | ○ |
| C-43 | viewAny権限チェック（拒否） | E-04 (16-19行目) | ○ |
| C-44 | create権限チェック（許可） | E-04 (24-27行目) | ○ |
| C-45 | create権限チェック（拒否） | E-04 (24-27行目) | ○ |
| C-46 | update権限チェック（許可） | E-04 (32-35行目) | ○ |
| C-47 | update権限チェック（拒否） | E-04 (32-35行目) | ○ |
| C-48 | delete権限チェック（許可） | E-04 (40-43行目) | ○ |
| C-49 | deleteAny権限チェック（許可） | E-04 (48-51行目) | ○ |
| C-50 | forceDelete権限チェック（許可） | E-04 (56-59行目) | ○ |
| C-51 | forceDeleteAny権限チェック（許可） | E-04 (64-67行目) | ○ |
| C-52 | restore権限チェック（許可） | E-04 (72-75行目) | ○ |
| C-53 | restoreAny権限チェック（許可） | E-04 (80-83行目) | ○ |

### PostPolicy関連（UT-BLG-054 〜 UT-BLG-065）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | viewAny権限チェック（許可） | E-05 (16-19行目) | ○ |
| C-55 | viewAny権限チェック（拒否） | E-05 (16-19行目) | ○ |
| C-56 | view権限チェック（許可） | E-05 (24-27行目) | ○ |
| C-57 | view権限チェック（拒否） | E-05 (24-27行目) | ○ |
| C-58 | create権限チェック（許可） | E-05 (32-35行目) | ○ |
| C-59 | update権限チェック（許可） | E-05 (40-43行目) | ○ |
| C-60 | delete権限チェック（許可） | E-05 (48-51行目) | ○ |
| C-61 | deleteAny権限チェック（許可） | E-05 (56-59行目) | ○ |
| C-62 | forceDelete権限チェック（許可） | E-05 (64-67行目) | ○ |
| C-63 | forceDeleteAny権限チェック（許可） | E-05 (72-75行目) | ○ |
| C-64 | restore権限チェック（許可） | E-05 (80-83行目) | ○ |
| C-65 | restoreAny権限チェック（許可） | E-05 (88-91行目) | ○ |

### TagPolicy関連（UT-BLG-066 〜 UT-BLG-075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | viewAny権限チェック（許可） | E-06 (16-19行目) | ○ |
| C-67 | viewAny権限チェック（拒否） | E-06 (16-19行目) | ○ |
| C-68 | create権限チェック（許可） | E-06 (24-27行目) | ○ |
| C-69 | update権限チェック（許可） | E-06 (32-35行目) | ○ |
| C-70 | delete権限チェック（許可） | E-06 (40-43行目) | ○ |
| C-71 | deleteAny権限チェック（許可） | E-06 (48-51行目) | ○ |
| C-72 | forceDelete権限チェック（許可） | E-06 (56-59行目) | ○ |
| C-73 | forceDeleteAny権限チェック（許可） | E-06 (64-67行目) | ○ |
| C-74 | restore権限チェック（許可） | E-06 (72-75行目) | ○ |
| C-75 | restoreAny権限チェック（許可） | E-06 (80-83行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全てのテストケースはソースコードを直接解析して生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**
  - 全テストケースがソースコードから直接導出されており、根拠が明確
  - Policyのテストケースは認証・認可に関わるため、実装時は慎重にテスト

## 6) レビュアーチェックリスト（最小）
- [ ] Categoryモデルのリレーション（posts, creator）が正しく定義されているか確認
- [ ] PostモデルのgetReadingTimeAttribute計算ロジック（200語/分、ceil使用）が妥当か確認
- [ ] Post.tagsの多対多リレーションで中間テーブル名（blogs_post_tags）が正しいか確認
- [ ] TagのSortableTraitの動作（order_column_name: sort）が期待通りか確認
- [ ] 各Policyの権限名（view_any_blog_category等）が実際のシステム権限と一致しているか確認
- [ ] SoftDeletesトレイトの動作がLaravel標準と一致しているか確認

---

## 補足：解析対象ファイル一覧

| ファイルパス | クラス名 | テストケース数 |
|-------------|---------|--------------|
| plugins/webkul/blogs/src/Models/Category.php | Webkul\Blog\Models\Category | 13 |
| plugins/webkul/blogs/src/Models/Post.php | Webkul\Blog\Models\Post | 21 |
| plugins/webkul/blogs/src/Models/Tag.php | Webkul\Blog\Models\Tag | 7 |
| plugins/webkul/blogs/src/Policies/CategoryPolicy.php | Webkul\Blog\Policies\CategoryPolicy | 12 |
| plugins/webkul/blogs/src/Policies/PostPolicy.php | Webkul\Blog\Policies\PostPolicy | 12 |
| plugins/webkul/blogs/src/Policies/TagPolicy.php | Webkul\Blog\Policies\TagPolicy | 10 |

**合計：75テストケース**
