---
generated_at: 2025-12-29 12:00:00
metrics:
  claims_total: 130
  claims_with_evidence: 130
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：employees 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：130 / 130、根拠なし：0
- 優先レビュー（高）
  1. **UT-EMP-028〜031**：Employeeのboot/savedイベントでのPartner自動作成・更新ロジック
  2. **UT-EMP-044〜057**：Departmentの循環参照検出ロジック
  3. **UT-EMP-015**：bankAccountリレーション（給与関連で重要）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/employees/src/Models/Employee.php`
- E-02: `plugins/webkul/employees/src/Models/Department.php`
- E-03: `plugins/webkul/employees/src/Models/Calendar.php`
- E-04: `plugins/webkul/employees/src/Models/CalendarAttendance.php`
- E-05: `plugins/webkul/employees/src/Models/CalendarLeaves.php`
- E-06: `plugins/webkul/employees/src/Models/EmployeeSkill.php`
- E-07: `plugins/webkul/employees/src/Models/Skill.php`
- E-08: `plugins/webkul/employees/src/Models/SkillType.php`
- E-09: `plugins/webkul/employees/src/Models/SkillLevel.php`
- E-10: `plugins/webkul/employees/src/Models/EmployeeCategory.php`
- E-11: `plugins/webkul/employees/src/Models/ActivityPlan.php`
- E-12: `plugins/webkul/employees/src/Models/DepartureReason.php`
- E-13: `plugins/webkul/employees/src/Models/EmploymentType.php`
- E-14: `plugins/webkul/employees/src/Models/WorkLocation.php`
- E-15: `plugins/webkul/employees/src/Models/EmployeeJobPosition.php`
- E-16: `plugins/webkul/employees/src/Models/EmployeeResume.php`
- E-17: `plugins/webkul/employees/src/Models/EmployeeResumeLineType.php`
- E-18: `plugins/webkul/employees/src/Models/JobPositionSkill.php`
- E-19: `plugins/webkul/employees/src/Models/EmployeeEmployeeCategory.php`
- E-20: `plugins/webkul/employees/src/Enums/DayPeriod.php`
- E-21: `plugins/webkul/employees/src/Enums/DistanceUnit.php`
- E-22: `plugins/webkul/employees/src/Enums/Colors.php`
- E-23: `plugins/webkul/employees/src/Enums/MaritalStatus.php`
- E-24: `plugins/webkul/employees/src/Enums/Gender.php`
- E-25: `plugins/webkul/employees/src/Enums/WorkLocation.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Employee モデル（UT-EMP-001〜036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-001〜027 | Employeeの各種BelongsTo/HasManyリレーション | E-01 L118-221 | ○ |
| UT-EMP-028〜029 | boot(saved)イベントでPartner自動作成/更新 | E-01 L249-260 | ○ |
| UT-EMP-030 | handlePartnerCreationでPartner属性設定 | E-01 L265-284 | ○ |
| UT-EMP-031 | handlePartnerUpdationでPartner更新 | E-01 L289-313 | ○ |
| UT-EMP-032〜034 | is_active/is_flexible/is_fully_flexibleのboolキャスト | E-01 L111-116 | ○ |
| UT-EMP-035〜036 | SoftDeletes機能 | E-01 L9, L24 | ○ |

### Department モデル（UT-EMP-037〜057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-037〜043 | Departmentの各種リレーション | E-02 L36-69 | ○ |
| UT-EMP-044〜047 | boot(creating/updating)で循環参照チェック | E-02 L76-95 | ○ |
| UT-EMP-048〜050 | validateNoRecursionの循環参照検出ロジック | E-02 L97-126 | ○ |
| UT-EMP-051〜053 | handleDepartmentDataでparent_path/master_department_id設定 | E-02 L128-141 | ○ |
| UT-EMP-054 | findTopLevelParentIdで最上位親取得 | E-02 L143-152 | ○ |
| UT-EMP-055〜056 | getCompleteNameで完全名生成 | E-02 L154-166 | ○ |
| UT-EMP-057 | SoftDeletes機能 | E-02 L9, L20 | ○ |

### Calendar モデル（UT-EMP-058〜062）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-058〜061 | Calendarの各種リレーション | E-03 L31-44 | ○ |
| UT-EMP-062 | SoftDeletes機能 | E-03 L7, L15 | ○ |

### CalendarAttendance モデル（UT-EMP-063〜066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-063〜064 | CalendarAttendanceの各種リレーション | E-04 L39-47 | ○ |
| UT-EMP-065〜066 | Sortable機能 | E-04 L7-8, L34-37 | ○ |

### CalendarLeaves モデル（UT-EMP-067〜069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-067〜069 | CalendarLeavesの各種リレーション | E-05 L26-39 | ○ |

### EmployeeSkill モデル（UT-EMP-070〜075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-070〜074 | EmployeeSkillの各種リレーション | E-06 L25-48 | ○ |
| UT-EMP-075 | SoftDeletes機能 | E-06 L8, L13 | ○ |

### Skill モデル（UT-EMP-076〜081）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-076〜079 | Skillの各種リレーション | E-07 L34-52 | ○ |
| UT-EMP-080 | Sortable機能 | E-07 L10-11, L29-32 | ○ |
| UT-EMP-081 | SoftDeletes機能 | E-07 L9, L18 | ○ |

### SkillType モデル（UT-EMP-082〜086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-082〜084 | SkillTypeの各種リレーション | E-08 L31-44 | ○ |
| UT-EMP-085 | is_activeのboolキャスト | E-08 L27-29 | ○ |
| UT-EMP-086 | SoftDeletes機能 | E-08 L9, L16 | ○ |

### SkillLevel モデル（UT-EMP-087〜089）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-087〜088 | SkillLevelの各種リレーション | E-09 L25-33 | ○ |
| UT-EMP-089 | SoftDeletes機能 | E-09 L9, L14 | ○ |

### EmployeeCategory モデル（UT-EMP-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-090 | EmployeeCategoryのcreatedByリレーション | E-10 L19-22 | ○ |

### ActivityPlan モデル（UT-EMP-091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-091 | ActivityPlanのdepartmentリレーション | E-11 L10-13 | ○ |

### DepartureReason モデル（UT-EMP-092〜094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-092〜093 | DepartureReasonの各種リレーション | E-12 L31-39 | ○ |
| UT-EMP-094 | Sortable機能 | E-12 L7-8, L26-29 | ○ |

### EmploymentType モデル（UT-EMP-095〜097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-095〜096 | EmploymentTypeの各種リレーション | E-13 L33-41 | ○ |
| UT-EMP-097 | Sortable機能 | E-13 L7-8, L28-31 | ○ |

### WorkLocation モデル（UT-EMP-098〜104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-098〜099 | WorkLocationの各種リレーション | E-14 L36-44 | ○ |
| UT-EMP-100〜101 | scopeActiveスコープ | E-14 L49-52 | ○ |
| UT-EMP-102〜103 | is_active/location_typeのキャスト | E-14 L31-34 | ○ |
| UT-EMP-104 | SoftDeletes機能 | E-14 L9, L18 | ○ |

### EmployeeJobPosition モデル（UT-EMP-105〜112）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-105〜109 | EmployeeJobPositionの各種リレーション | E-15 L52-75 | ○ |
| UT-EMP-110 | is_activeのboolキャスト | E-15 L43-45 | ○ |
| UT-EMP-111 | Sortable機能 | E-15 L9-10, L47-50 | ○ |
| UT-EMP-112 | SoftDeletes機能 | E-15 L8, L18 | ○ |

### EmployeeResume モデル（UT-EMP-113〜115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-113〜115 | EmployeeResumeの各種リレーション | E-16 L24-37 | ○ |

### EmployeeResumeLineType モデル（UT-EMP-116〜117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-116 | EmployeeResumeLineTypeのresumeリレーション | E-17 L26-29 | ○ |
| UT-EMP-117 | Sortable機能 | E-17 L6-7, L21-24 | ○ |

### JobPositionSkill モデル（UT-EMP-118〜119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-118〜119 | JobPositionSkillの各種リレーション | E-18 L15-23 | ○ |

### EmployeeEmployeeCategory モデル（UT-EMP-120〜121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-120〜121 | EmployeeEmployeeCategoryの各種リレーション | E-19 L22-33 | ○ |

### Enums（UT-EMP-122〜130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-EMP-122〜123 | DayPeriodのoptions/値 | E-20 L5-24 | ○ |
| UT-EMP-124 | DistanceUnitのoptions | E-21 L5-18 | ○ |
| UT-EMP-125 | Colorsのoptions | E-22 L5-27 | ○ |
| UT-EMP-126 | MaritalStatusのoptions | E-23 L5-24 | ○ |
| UT-EMP-127 | Genderのoptions | E-24 L5-21 | ○ |
| UT-EMP-128〜130 | WorkLocationのgetLabel/getColor/getIcon | E-25 L17-42 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースにソースコードの根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり

以下の項目は重点レビュー推奨：
- **Employeeのboot/savedイベント**：Partner自動作成/更新ロジックは副作用が大きいため、テスト時のモック設定に注意
- **Departmentの循環参照検出**：再帰的なロジックのため、テストケースで様々な階層パターンを網羅すること
- **SoftDeletes使用モデル**：削除後のリレーション取得テストも考慮すること

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースIDの連番に欠番がないか確認
- [ ] 高優先度テストケース（boot/saved、循環参照検出）の網羅性を確認
- [ ] SoftDeletes対応モデルの論理削除テストが含まれているか確認
- [ ] Enumのoptions()メソッドで期待される件数が正しいか確認
- [ ] リレーションテストでnull/空の境界値ケースが含まれているか確認
