---
generated_at: 2025-12-29 17:30:00
metrics:
  claims_total: 147
  claims_with_evidence: 147
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：fields.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（fields.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で状態の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：147 / 147、根拠なし：0
- 優先レビュー（高）
  1. **FieldsColumnManager スキーマ変更テスト**：実際のDB操作を伴うため統合テスト環境での検証推奨
  2. **HasCustomFields トレイト**：動的fillable/casts拡張のため複雑なモック設定が必要
  3. **FieldPolicy 権限テスト**：認可ロジックのためセキュリティ観点での詳細レビュー推奨

## 2) 参照した情報（Evidence一覧）
> ここに実在するソースコードファイルを列挙

- E-01: `plugins/webkul/fields/src/Models/Field.php`
- E-02: `plugins/webkul/fields/src/Traits/HasCustomFields.php`
- E-03: `plugins/webkul/fields/src/Policies/FieldPolicy.php`
- E-04: `plugins/webkul/fields/src/FieldsColumnManager.php`
- E-05: `plugins/webkul/fields/src/Filament/Forms/Components/CustomFields.php`
- E-06: `plugins/webkul/fields/src/Filament/Forms/Components/ProgressStepper.php`
- E-07: `plugins/webkul/fields/src/Filament/Forms/Components/TimeToFloatPicker.php`
- E-08: `plugins/webkul/fields/src/Filament/Tables/Columns/CustomColumns.php`
- E-09: `plugins/webkul/fields/src/Filament/Tables/Filters/CustomFilters.php`
- E-10: `plugins/webkul/fields/src/Filament/Infolists/Components/CustomEntries.php`
- E-11: `plugins/webkul/fields/src/Filament/Traits/HasCustomFields.php`
- E-12: `plugins/webkul/fields/src/FieldServiceProvider.php`
- E-13: `plugins/webkul/fields/src/FieldsPlugin.php`
- E-14: `plugins/webkul/fields/src/Filament/Resources/FieldResource.php`
- E-15: `plugins/webkul/fields/src/Filament/Resources/FieldResource/Pages/CreateField.php`
- E-16: `plugins/webkul/fields/src/Filament/Resources/FieldResource/Pages/EditField.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Fieldモデル（UT-FLD-001 - UT-FLD-014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | is_multiselectがbooleanにキャストされる | E-01（26行目: 'is_multiselect' => 'boolean'） | ○ |
| C-02 | optionsがarrayにキャストされる | E-01（27行目: 'options' => 'array'） | ○ |
| C-03 | form_settingsがarrayにキャストされる | E-01（28行目: 'form_settings' => 'array'） | ○ |
| C-04 | table_settingsがarrayにキャストされる | E-01（29行目: 'table_settings' => 'array'） | ○ |
| C-05 | infolist_settingsがarrayにキャストされる | E-01（30行目: 'infolist_settings' => 'array'） | ○ |
| C-06 | SoftDeletesトレイトを使用 | E-01（12行目: use SoftDeletes） | ○ |
| C-07 | SortableTraitを使用 | E-01（12行目: use SortableTrait） | ○ |
| C-08 | fillable属性が定義されている | E-01（39-53行目: $fillable配列） | ○ |

### HasCustomFieldsトレイト（UT-FLD-015 - UT-FLD-029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | bootHasCustomFieldsでイベントハンドラ登録 | E-02（17-23行目: static::retrieved, creating, updating） | ○ |
| C-10 | fill()でloadCustomFieldsが呼ばれる | E-02（29-34行目: fill()メソッド） | ○ |
| C-11 | loadCustomFieldsで例外がキャッチされる | E-02（47-48行目: try-catch） | ○ |
| C-12 | getCustomFieldsでcustomizable_typeでフィルタ | E-02（55-58行目: where条件） | ○ |
| C-13 | mergeFillableで重複なくマージ | E-02（63-66行目: array_unique, array_merge） | ○ |
| C-14 | mergeCastsでselectタイプの分岐 | E-02（84行目: 'select' => ...） | ○ |
| C-15 | mergeCastsでcheckboxがboolean | E-02（85行目: 'checkbox' => 'boolean'） | ○ |
| C-16 | mergeCastsでtoggleがboolean | E-02（86行目: 'toggle' => 'boolean'） | ○ |
| C-17 | mergeCastsでcheckbox_listがarray | E-02（87行目: 'checkbox_list' => 'array'） | ○ |

### FieldPolicy（UT-FLD-030 - UT-FLD-044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | viewAnyで'view_any_field'権限チェック | E-03（16-19行目） | ○ |
| C-19 | viewで'view_field'権限チェック | E-03（24-27行目） | ○ |
| C-20 | createで'create_field'権限チェック | E-03（32-35行目） | ○ |
| C-21 | updateで'update_field'権限チェック | E-03（40-43行目） | ○ |
| C-22 | deleteで'delete_field'権限チェック | E-03（48-51行目） | ○ |
| C-23 | deleteAnyで'delete_any_field'権限チェック | E-03（56-59行目） | ○ |
| C-24 | forceDeleteで'force_delete_field'権限チェック | E-03（64-67行目） | ○ |
| C-25 | forceDeleteAnyで'force_delete_any_field'権限チェック | E-03（72-75行目） | ○ |
| C-26 | restoreで'restore_field'権限チェック | E-03（80-83行目） | ○ |
| C-27 | restoreAnyで'restore_any_field'権限チェック | E-03（88-91行目） | ○ |

### FieldsColumnManager（UT-FLD-045 - UT-FLD-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | createColumnでテーブル存在チェック | E-04（18-19行目: Schema::hasTable） | ○ |
| C-29 | createColumnでカラム存在チェック | E-04（23-25行目: Schema::hasColumn） | ○ |
| C-30 | updateColumnでテーブル存在チェック | E-04（38-39行目） | ○ |
| C-31 | updateColumnでカラム未存在時createColumn呼出 | E-04（43-47行目） | ○ |
| C-32 | deleteColumnでカラム削除 | E-04（67行目: dropColumn） | ○ |
| C-33 | getColumnTypeのmatch式 | E-04（97-108行目） | ○ |
| C-34 | getTextColumnTypeのmatch式 | E-04（115-119行目） | ○ |
| C-35 | addColumnでnullable設定 | E-04（82行目: nullable()） | ○ |
| C-36 | getTableNameでモデルからテーブル名取得 | E-04（141-144行目） | ○ |

### CustomFields（UT-FLD-072 - UT-FLD-096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | makeでインスタンス生成 | E-05（34-40行目） | ○ |
| C-38 | include/excludeメソッド | E-05（42-54行目） | ○ |
| C-39 | getSchemaでフィールド変換 | E-05（61-68行目） | ○ |
| C-40 | createFieldのmatch式 | E-05（88-101行目） | ○ |
| C-41 | バリデーション適用ロジック | E-05（106-109行目） | ○ |
| C-42 | 設定適用ロジック | E-05（112-115行目） | ○ |
| C-43 | optionsの設定 | E-05（122-132行目） | ○ |
| C-44 | applyValidationメソッド | E-05（141-159行目） | ○ |
| C-45 | applySettingメソッド | E-05（162-174行目） | ○ |

### TimeToFloatPicker（UT-FLD-097 - UT-FLD-103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | dehydrateStateUsingで時刻→float変換 | E-07（14-27行目） | ○ |
| C-47 | afterStateHydratedでfloat→時刻変換 | E-07（29-39行目） | ○ |
| C-48 | null/空値の処理 | E-07（15-17行目, 30-32行目） | ○ |

### CustomColumns（UT-FLD-104 - UT-FLD-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | use_in_tableフィルタ | E-08（64行目: where('use_in_table', true)） | ○ |
| C-50 | createColumnのmatch式 | E-08（84-92行目） | ○ |
| C-51 | applySettingでweight/size変換 | E-08（113-118行目） | ○ |

### CustomFilters（UT-FLD-111 - UT-FLD-121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | filterableフィルタ | E-09（94行目: whereJsonContains） | ○ |
| C-53 | createFilterのmatch式 | E-09（100-161行目） | ○ |
| C-54 | createConstraintのmatch式 | E-09（168-203行目） | ○ |
| C-55 | getQueryBuilderConstraintsメソッド | E-09（69-76行目） | ○ |

### CustomEntries（UT-FLD-122 - UT-FLD-126）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | getSchemaメソッド | E-10（56-63行目） | ○ |
| C-57 | createEntryのmatch式 | E-10（83-91行目） | ○ |
| C-58 | applySettingメソッド | E-10（105-123行目） | ○ |

### HasCustomFields Trait (Filament)（UT-FLD-127 - UT-FLD-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | mergeCustomFormFieldsメソッド | E-11（12-15行目） | ○ |
| C-60 | mergeCustomTableColumnsメソッド | E-11（17-20行目） | ○ |
| C-61 | mergeCustomTableFiltersメソッド | E-11（22-25行目） | ○ |
| C-62 | mergeCustomInfolistEntriesメソッド | E-11（32-35行目） | ○ |

### FieldServiceProvider（UT-FLD-131 - UT-FLD-133）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | パッケージ名がfieldsに設定 | E-12（15行目: $name = 'fields'） | ○ |
| C-64 | packageBootedでPolicy登録 | E-12（35行目: Gate::policy） | ○ |
| C-65 | registerCustomCssでアセット登録 | E-12（40-42行目） | ○ |

### FieldsPlugin（UT-FLD-134 - UT-FLD-137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | getIdでfieldsを返却 | E-13（11-14行目） | ○ |
| C-67 | makeでインスタンス生成 | E-13（16-19行目） | ○ |
| C-68 | registerでadminパネル条件分岐 | E-13（24行目: when($panel->getId() == 'admin'） | ○ |

### FieldResource Pages（UT-FLD-138 - UT-FLD-139）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | afterCreateでFieldsColumnManager::createColumn | E-15（22-25行目） | ○ |
| C-70 | afterSaveでFieldsColumnManager::updateColumn | E-16（30-33行目） | ○ |

### FieldResource設定メソッド（UT-FLD-140 - UT-FLD-147）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | getTypeFormValidationsメソッド | E-14（506-618行目） | ○ |
| C-72 | getTypeFormSettingsメソッド | E-14（620-832行目） | ○ |
| C-73 | getTypeTableSettingsメソッド | E-14（969-1024行目） | ○ |
| C-74 | getTypeInfolistSettingsメソッド | E-14（1146-1222行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません
- 全てのテストケースはソースコードから直接抽出された情報に基づいています

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - FieldsColumnManagerのスキーマ変更テスト
  - 実際のデータベース操作を伴うため、テスト環境の適切な分離が必要
  - トランザクションのロールバックまたはテストDBの使用を推奨

- **1: 中リスク** - HasCustomFieldsトレイトの動的拡張テスト
  - 静的プロパティ（$customFillable, $customCasts）を使用しているため、テスト間の状態分離に注意

- **0: 低リスク** - その他のテストケース
  - 標準的なユニットテストで対応可能

## 6) レビュアーチェックリスト（最小）
- [ ] FieldsColumnManagerのテストで実際のDB操作が発生することを考慮したテスト環境設計
- [ ] HasCustomFieldsトレイトの静的プロパティがテスト間で干渉しないことの確認
- [ ] FieldPolicyの全権限パターン（10種類）のテスト網羅性確認
- [ ] TimeToFloatPickerの時刻変換ロジックの境界値（00:00, 23:59）テスト確認
- [ ] CustomFields/CustomColumns/CustomFilters/CustomEntriesの全フィールドタイプ（11種類）の網羅確認
