---
generated_at: 2025-12-29 17:30:00
metrics:
  claims_total: 203
  claims_with_evidence: 203
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：inventories.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：203 / 203、根拠なし：0
- 優先レビュー（高）
  1. **在庫数量計算ロジック（UT-INV-028〜031, UT-INV-152〜154, UT-INV-172〜174）**：ビジネス上重要な計算ロジック
  2. **オペレーション状態遷移（UT-INV-177〜198）**：Filament Actionによる状態管理
  3. **Location階層管理（UT-INV-093〜102）**：bootイベントによる自動更新処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### Models
- E-01: `plugins/webkul/inventories/src/Models/Category.php`
- E-02: `plugins/webkul/inventories/src/Models/InternalTransfer.php`
- E-03: `plugins/webkul/inventories/src/Models/PackageType.php`
- E-04: `plugins/webkul/inventories/src/Models/MoveLine.php`
- E-05: `plugins/webkul/inventories/src/Models/Package.php`
- E-06: `plugins/webkul/inventories/src/Models/Product.php`
- E-07: `plugins/webkul/inventories/src/Models/Rule.php`
- E-08: `plugins/webkul/inventories/src/Models/StorageCategoryCapacity.php`
- E-09: `plugins/webkul/inventories/src/Models/Move.php`
- E-10: `plugins/webkul/inventories/src/Models/Delivery.php`
- E-11: `plugins/webkul/inventories/src/Models/Tag.php`
- E-12: `plugins/webkul/inventories/src/Models/StorageCategory.php`
- E-13: `plugins/webkul/inventories/src/Models/Attribute.php`
- E-14: `plugins/webkul/inventories/src/Models/Receipt.php`
- E-15: `plugins/webkul/inventories/src/Models/OperationType.php`
- E-16: `plugins/webkul/inventories/src/Models/OrderPoint.php`
- E-17: `plugins/webkul/inventories/src/Models/Route.php`
- E-18: `plugins/webkul/inventories/src/Models/Location.php`
- E-19: `plugins/webkul/inventories/src/Models/PackageDestination.php`
- E-20: `plugins/webkul/inventories/src/Models/Warehouse.php`
- E-21: `plugins/webkul/inventories/src/Models/ProductQuantityRelocation.php`
- E-22: `plugins/webkul/inventories/src/Models/Packaging.php`
- E-23: `plugins/webkul/inventories/src/Models/Dropship.php`
- E-24: `plugins/webkul/inventories/src/Models/PackageLevel.php`
- E-25: `plugins/webkul/inventories/src/Models/Operation.php`
- E-26: `plugins/webkul/inventories/src/Models/ProductQuantity.php`
- E-27: `plugins/webkul/inventories/src/Models/Scrap.php`
- E-28: `plugins/webkul/inventories/src/Models/Lot.php`

### Filament Actions
- E-29: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/ValidateAction.php`
- E-30: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/TodoAction.php`
- E-31: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/CancelAction.php`
- E-32: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/CheckAvailabilityAction.php`
- E-33: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/ReturnAction.php`
- E-34: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/LabelsAction.php`
- E-35: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/PackageAction.php`
- E-36: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/ReturnSlipAction.php`
- E-37: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/DeliverySlipAction.php`
- E-38: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/PickingOperationAction.php`

### Enums（参照用）
- E-39: `plugins/webkul/inventories/src/Enums/MoveState.php`
- E-40: `plugins/webkul/inventories/src/Enums/OperationState.php`
- E-41: `plugins/webkul/inventories/src/Enums/LocationType.php`
- E-42: `plugins/webkul/inventories/src/Enums/ProductTracking.php`
- E-43: `plugins/webkul/inventories/src/Enums/CreateBackorder.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Category（UT-INV-001〜003）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Categoryモデルがroutesリレーションを持つ | E-01 (28-31行目) | ○ |
| C-02 | Categoryモデルがproductsリレーションを持つ | E-01 (33-36行目) | ○ |
| C-03 | BaseCategoryを継承している | E-01 (9行目) | ○ |

### InternalTransfer（UT-INV-004）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | InternalTransferはOperationを継承している | E-02 (5行目) | ○ |

### PackageType（UT-INV-005〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | companyリレーションを持つ | E-03 (50-53行目) | ○ |
| C-06 | creatorリレーションを持つ | E-03 (55-58行目) | ○ |
| C-07 | SortableTraitを使用している | E-03 (16行目) | ○ |

### MoveLine（UT-INV-008〜015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | moveリレーションを持つ | E-04 (66-69行目) | ○ |
| C-09 | operationリレーションを持つ | E-04 (71-74行目) | ○ |
| C-10 | productリレーションを持つ | E-04 (76-79行目) | ○ |
| C-11 | sourceLocationはwithTrashed付き | E-04 (86-89行目) | ○ |
| C-12 | destinationLocationはwithTrashed付き | E-04 (91-94行目) | ○ |
| C-13 | lotリレーションを持つ | E-04 (111-114行目) | ○ |
| C-14 | stateがMoveStateにキャストされる | E-04 (61行目) | ○ |
| C-15 | is_pickedがbooleanにキャストされる | E-04 (62行目) | ○ |

### Package（UT-INV-016〜021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | packageTypeリレーションを持つ | E-05 (51-54行目) | ○ |
| C-17 | locationリレーションを持つ | E-05 (56-59行目) | ○ |
| C-18 | quantitiesリレーションを持つ | E-05 (61-64行目) | ○ |
| C-19 | operationsはHasManyThrough | E-05 (66-76行目) | ○ |
| C-20 | movesはHasManyThrough | E-05 (78-88行目) | ○ |
| C-21 | package_useがPackageUseにキャストされる | E-05 (47行目) | ○ |

### Product（UT-INV-022〜032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | categoryリレーションを持つ | E-06 (49-52行目) | ○ |
| C-23 | routesリレーションを持つ | E-06 (54-57行目) | ○ |
| C-24 | variantsリレーションを持つ | E-06 (59-62行目) | ○ |
| C-25 | quantitiesリレーションはis_configurableで分岐 | E-06 (64-72行目) | ○ |
| C-26 | movesリレーションはis_configurableで分岐 | E-06 (74-82行目) | ○ |
| C-27 | getOnHandQuantityAttributeはINTERNAL型のみ集計 | E-06 (109-117行目) | ○ |
| C-28 | getOnHandQuantityAttributeはis_scrap=falseのみ集計 | E-06 (114行目) | ○ |
| C-29 | trackingがProductTrackingにキャストされる | E-06 (41行目) | ○ |

### Move（UT-INV-041〜052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | isPurchaseReturnメソッドが存在する | E-09 (99-106行目) | ○ |
| C-31 | isDropshippedメソッドが存在する | E-09 (113-123行目) | ○ |
| C-32 | isDropshippedReturnedメソッドが存在する | E-09 (130-140行目) | ○ |
| C-33 | shouldBypassReservationメソッドが存在する | E-09 (237-240行目) | ○ |
| C-34 | linesリレーションを持つ | E-09 (217-220行目) | ○ |
| C-35 | stateがMoveStateにキャストされる | E-09 (82行目) | ○ |

### Location（UT-INV-080〜103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | parentリレーションを持つ | E-18 (72-75行目) | ○ |
| C-37 | childrenリレーションを持つ | E-18 (77-80行目) | ○ |
| C-38 | getIsStockLocationAttributeが存在する | E-18 (102-110行目) | ○ |
| C-39 | shouldBypassReservationメソッドが存在する | E-18 (112-120行目) | ○ |
| C-40 | bootイベントでupdateParentPathが呼ばれる | E-18 (125-142行目) | ○ |
| C-41 | updateFullNameメソッドが存在する | E-18 (147-156行目) | ○ |
| C-42 | updateParentPathメソッドが存在する | E-18 (161-170行目) | ○ |
| C-43 | updateChildrenFullNamesメソッドが存在する | E-18 (172-185行目) | ○ |
| C-44 | updateChildrenParentPathsメソッドが存在する | E-18 (187-200行目) | ○ |

### Operation（UT-INV-128〜147）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | userリレーションを持つ | E-25 (107-110行目) | ○ |
| C-46 | operationTypeはwithTrashed付き | E-25 (117-120行目) | ○ |
| C-47 | sourceLocationはwithTrashed付き | E-25 (122-125行目) | ○ |
| C-48 | movesリレーションを持つ | E-25 (157-160行目) | ○ |
| C-49 | moveLinesリレーションを持つ | E-25 (162-165行目) | ○ |
| C-50 | bootイベントでupdateNameが呼ばれる | E-25 (185-202行目) | ○ |
| C-51 | updateNameメソッドが存在する | E-25 (207-214行目) | ○ |
| C-52 | updateChildrenNamesメソッドが存在する | E-25 (216-225行目) | ○ |

### ProductQuantity（UT-INV-148〜158）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | productリレーションを持つ | E-26 (62-65行目) | ○ |
| C-54 | locationリレーションを持つ | E-26 (67-70行目) | ○ |
| C-55 | getAvailableQuantityAttributeが存在する | E-26 (107-110行目) | ○ |
| C-56 | bootイベントでupdateScheduledAtが呼ばれる | E-26 (115-122行目) | ○ |
| C-57 | updateScheduledAtメソッドが存在する | E-26 (127-139行目) | ○ |

### Lot（UT-INV-168〜176）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | productリレーションを持つ | E-28 (62-65行目) | ○ |
| C-59 | quantitiesリレーションを持つ | E-28 (87-90行目) | ○ |
| C-60 | getTotalQuantityAttributeが存在する | E-28 (92-100行目) | ○ |

### ValidateAction（UT-INV-177〜185）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | hasMoveErrorsメソッドが存在する | E-29 (82-93行目) | ○ |
| C-62 | hasMoveLineErrorsメソッドが存在する | E-29 (100-171行目) | ○ |
| C-63 | DONE/CANCELED状態で非表示になる | E-29 (74-79行目) | ○ |
| C-64 | create_backorder=ASK時に確認ダイアログ | E-29 (34-37行目) | ○ |

### TodoAction（UT-INV-186〜188）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | moves.count=0で警告 | E-30 (26-34行目) | ○ |
| C-66 | DRAFT以外で非表示 | E-30 (47行目) | ○ |

### CancelAction（UT-INV-189〜191）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | Inventory::cancelTransferを呼び出す | E-31 (26行目) | ○ |
| C-68 | DONE/CANCELED状態で非表示 | E-31 (30-33行目) | ○ |

### CheckAvailabilityAction（UT-INV-192〜195）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | Inventory::checkTransferAvailabilityを呼び出す | E-32 (26行目) | ○ |
| C-70 | CONFIRMED/ASSIGNED以外で非表示 | E-32 (30-36行目) | ○ |

### ReturnAction（UT-INV-196〜198）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Inventory::returnTransferを呼び出す | E-33 (28行目) | ○ |
| C-72 | DONE状態でのみ表示 | E-33 (34行目) | ○ |

### Print Actions（UT-INV-199〜203）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | LabelsActionでPDF生成 | E-34 (116-135行目) | ○ |
| C-74 | DeliverySlipActionでPDF生成 | E-37 (21-31行目) | ○ |
| C-75 | PickingOperationActionでPDF生成 | E-38 (21-31行目) | ○ |
| C-76 | PackageActionでPDF生成 | E-35 (21-33行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースにソースコードによる根拠が存在する
- 特に不足情報なし

## 5) リスクフラグ（レビュー観点）
- **リスクレベル0（低リスク）**
  - 全てのテストケースがソースコードから直接導出されている
  - ビジネスロジックを含むメソッド（getOnHandQuantityAttribute, getAvailableQuantityAttribute, shouldBypassReservation等）は重点的にテストケースを設定
  - 状態遷移に関わるFilament Actionは正常系・異常系両方をカバー

## 6) レビュアーチェックリスト（最小）
- [ ] 在庫数量計算ロジック（UT-INV-028〜031）のテストケースが実際のビジネス要件を満たしているか確認
- [ ] オペレーション状態遷移のテストケースが全状態パターンをカバーしているか確認
- [ ] Location階層管理のbootイベントテストが再帰的な更新を正しく検証しているか確認
- [ ] Enum値のキャストテストが全Enum値をカバーしているか確認
- [ ] withTrashed付きリレーションのテストがソフトデリート済みデータを正しく検証しているか確認
