---
generated_at: 2025-12-29 18:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：invoices.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で該当項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. **Invoice.paymentTermLine**：hasOneリレーションの正確性確認
  2. **Product.productTaxes/supplierTaxes**：belongsToManyリレーションの中間テーブル確認
  3. **各Policy**：権限文字列の整合性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/invoices/src/Models/Invoice.php`
- E-02: `plugins/webkul/invoices/src/Models/Bill.php`
- E-03: `plugins/webkul/invoices/src/Models/Payment.php`
- E-04: `plugins/webkul/invoices/src/Models/Refund.php`
- E-05: `plugins/webkul/invoices/src/Models/CreditNote.php`
- E-06: `plugins/webkul/invoices/src/Models/Tax.php`
- E-07: `plugins/webkul/invoices/src/Models/TaxGroup.php`
- E-08: `plugins/webkul/invoices/src/Models/PaymentTerm.php`
- E-09: `plugins/webkul/invoices/src/Models/Partner.php`
- E-10: `plugins/webkul/invoices/src/Models/BankAccount.php`
- E-11: `plugins/webkul/invoices/src/Models/Incoterm.php`
- E-12: `plugins/webkul/invoices/src/Models/Attribute.php`
- E-13: `plugins/webkul/invoices/src/Models/Product.php`
- E-14: `plugins/webkul/invoices/src/Models/Category.php`
- E-15: `plugins/webkul/invoices/src/Enums/InvoicePolicy.php`
- E-16: `plugins/webkul/invoices/src/Enums/InvoiceSendingMethod.php`
- E-17: `plugins/webkul/invoices/src/Enums/InvoiceFormat.php`
- E-18: `plugins/webkul/invoices/src/Enums/AutoPostBills.php`
- E-19: `plugins/webkul/invoices/src/Enums/PartyIdentificationScheme.php`
- E-20: `plugins/webkul/invoices/src/Policies/InvoicePolicy.php`
- E-21: `plugins/webkul/invoices/src/Policies/BillPolicy.php`
- E-22: `plugins/webkul/invoices/src/Policies/PaymentPolicy.php`
- E-23: `plugins/webkul/invoices/src/Policies/ProductPolicy.php`
- E-24: `plugins/webkul/invoices/src/Policies/CategoryPolicy.php`
- E-25: `plugins/webkul/invoices/src/Policies/TaxPolicy.php`
- E-26: `plugins/webkul/invoices/src/Policies/TaxGroupPolicy.php`
- E-27: `plugins/webkul/invoices/src/Policies/PaymentTermPolicy.php`
- E-28: `plugins/webkul/invoices/src/Policies/BankAccountPolicy.php`
- E-29: `plugins/webkul/invoices/src/Policies/RefundPolicy.php`
- E-30: `plugins/webkul/invoices/src/Policies/CreditNotePolicy.php`
- E-31: `plugins/webkul/invoices/src/Policies/IncotermPolicy.php`
- E-32: `plugins/webkul/invoices/src/Policies/PartnerPolicy.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Models

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Invoice.paymentTermLineリレーションがhasOneで定義されている | E-01 (L10-14) | ○ |
| C-02 | Invoice.paymentTermLineは支払期限行が存在しない場合nullを返す | E-01 (hasOne) | ○ |
| C-03 | InvoiceはBaseMoveを継承している | E-01 (L8) | ○ |
| C-04 | BillはBaseMoveを継承している | E-02 (L7) | ○ |
| C-05 | PaymentはBasePaymentを継承している | E-03 (L7) | ○ |
| C-06 | RefundはBaseMoveを継承している | E-04 (L7) | ○ |
| C-07 | CreditNoteはBaseMoveを継承している | E-05 (L7) | ○ |
| C-08 | TaxはBaseTaxを継承している | E-06 (L7) | ○ |
| C-09 | TaxGroupはBaseTaxGroupを継承している | E-07 (L7) | ○ |
| C-10 | PaymentTermはBasePaymentTermを継承している | E-08 (L7) | ○ |
| C-11 | PartnerはBasePartnerを継承している | E-09 (L7) | ○ |
| C-12 | BankAccountはBaseBankAccountを継承している | E-10 (L7) | ○ |
| C-13 | IncotermはBaseIncotermを継承している | E-11 (L7) | ○ |
| C-14 | AttributeはBaseAttributeを継承している | E-12 (L7) | ○ |
| C-15 | Product.__constructでfillableにフィールドがマージされる | E-13 (L20-33) | ○ |
| C-16 | Product.productTaxesがbelongsToManyで定義されている | E-13 (L61-64) | ○ |
| C-17 | Product.supplierTaxesがbelongsToManyで定義されている | E-13 (L66-69) | ○ |
| C-18 | Product.logAttributesが定義されている | E-13 (L38-59) | ○ |
| C-19 | Category.__constructでfillableにフィールドがマージされる | E-14 (L14-23) | ○ |
| C-20 | Category.createdByがbelongsToで定義されている | E-14 (L26-29) | ○ |
| C-21 | Category.productsがhasManyで定義されている | E-14 (L31-34) | ○ |

### Enums

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | InvoicePolicy enumがORDER, DELIVERYを持つ | E-15 (L9-11) | ○ |
| C-23 | InvoicePolicy.getLabelが正しいラベルを返す | E-15 (L13-18) | ○ |
| C-24 | InvoicePolicy.optionsが全オプションを返す | E-15 (L20-27) | ○ |
| C-25 | InvoiceSendingMethod enumが3つの値を持つ | E-16 (L9-14) | ○ |
| C-26 | InvoiceSendingMethod.getLabelが正しいラベルを返す | E-16 (L16-22) | ○ |
| C-27 | InvoiceSendingMethod.optionsが全オプションを返す | E-16 (L24-31) | ○ |
| C-28 | InvoiceFormat enumが6つの値を持つ | E-17 (L9-19) | ○ |
| C-29 | InvoiceFormat.getLabelが正しいラベルを返す | E-17 (L21-31) | ○ |
| C-30 | InvoiceFormat.optionsが全オプションを返す | E-17 (L33-43) | ○ |
| C-31 | AutoPostBills enumがALWAYS, ASK, NEVERを持つ | E-18 (L9-13) | ○ |
| C-32 | AutoPostBills.getLabelが正しいラベルを返す | E-18 (L15-21) | ○ |
| C-33 | AutoPostBills.optionsが全オプションを返す | E-18 (L23-31) | ○ |
| C-34 | PartyIdentificationScheme enumが56種類の値を持つ | E-19 (L9-83) | ○ |
| C-35 | PartyIdentificationScheme.getLabelが正しいラベルを返す | E-19 (L85-163) | ○ |
| C-36 | PartyIdentificationScheme.optionsが全オプションを返す | E-19 (L166-244) | ○ |

### Policies

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | InvoicePolicy.viewAnyがview_any_invoice権限をチェック | E-20 (L16-19) | ○ |
| C-38 | InvoicePolicy.viewがview_invoice権限をチェック | E-20 (L24-27) | ○ |
| C-39 | InvoicePolicy.createがcreate_invoice権限をチェック | E-20 (L32-35) | ○ |
| C-40 | InvoicePolicy.updateがupdate_invoice権限をチェック | E-20 (L40-43) | ○ |
| C-41 | InvoicePolicy.deleteがdelete_invoice権限をチェック | E-20 (L48-51) | ○ |
| C-42 | InvoicePolicy.deleteAnyがdelete_any_invoice権限をチェック | E-20 (L56-59) | ○ |
| C-43 | BillPolicy.viewAnyがview_any_bill権限をチェック | E-21 (L16-19) | ○ |
| C-44 | BillPolicy.viewがview_bill権限をチェック | E-21 (L24-27) | ○ |
| C-45 | BillPolicy.createがcreate_bill権限をチェック | E-21 (L32-35) | ○ |
| C-46 | BillPolicy.updateがupdate_bill権限をチェック | E-21 (L40-43) | ○ |
| C-47 | BillPolicy.deleteがdelete_bill権限をチェック | E-21 (L48-51) | ○ |
| C-48 | BillPolicy.deleteAnyがdelete_any_bill権限をチェック | E-21 (L56-59) | ○ |
| C-49 | PaymentPolicy.viewAnyがview_any_payments権限をチェック | E-22 (L16-19) | ○ |
| C-50 | PaymentPolicy.viewがview_payments権限をチェック | E-22 (L24-27) | ○ |
| C-51 | PaymentPolicy.createがcreate_payments権限をチェック | E-22 (L32-35) | ○ |
| C-52 | PaymentPolicy.updateがupdate_payments権限をチェック | E-22 (L40-43) | ○ |
| C-53 | PaymentPolicy.deleteがdelete_payments権限をチェック | E-22 (L48-51) | ○ |
| C-54 | PaymentPolicy.deleteAnyがdelete_any_payments権限をチェック | E-22 (L56-59) | ○ |
| C-55 | ProductPolicyが10個のメソッドを持つ | E-23 (L16-99) | ○ |
| C-56 | CategoryPolicyが6個のメソッドを持つ | E-24 (L16-59) | ○ |
| C-57 | TaxPolicyが7個のメソッドを持つ | E-25 (L16-67) | ○ |
| C-58 | TaxGroupPolicyが5個のメソッドを持つ | E-26 (L16-51) | ○ |
| C-59 | PaymentTermPolicyが9個のメソッドを持つ | E-27 (L16-92) | ○ |
| C-60 | BankAccountPolicyが10個のメソッドを持つ | E-28 (L16-92) | ○ |
| C-61 | RefundPolicyが6個のメソッドを持つ | E-29 (L16-59) | ○ |
| C-62 | CreditNotePolicyが6個のメソッドを持つ | E-30 (L16-60) | ○ |
| C-63 | IncotermPolicyが10個のメソッドを持つ | E-31 (L16-92) | ○ |
| C-64 | PartnerPolicyが10個のメソッドを持つ | E-32 (L16-92) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク
  - invoicesモジュールは主に継承ベースの薄いラッパーで構成されており、固有のビジネスロジックは少ない
  - 親クラス（BaseMove, BasePayment等）のテストは別途accountsモジュールで実施される想定

## 6) レビュアーチェックリスト（最小）
- [ ] Invoice.paymentTermLineのdisplay_type='payment_term'フィルタが正しいか確認
- [ ] Product.productTaxes/supplierTaxesの中間テーブル名が正しいか確認（accounts_product_taxes, accounts_product_supplier_taxes）
- [ ] Category.productsリレーションがProduct::classを参照していることを確認
- [ ] 各Policyの権限文字列が他のモジュールと競合しないか確認
- [ ] 継承のみのモデル（Bill, Refund等）について親クラスのテストが別途存在するか確認
