---
generated_at: 2025-12-29 17:45:00
metrics:
  claims_total: 86
  claims_with_evidence: 86
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：partners.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で該当の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：86 / 86、根拠なし：0
- 優先レビュー（高）
  1. **UT-PTN-014, UT-PTN-016**：addressesとcontactsのフィルタリングロジック - ビジネスロジックの重要部分
  2. **UT-PTN-031, UT-PTN-032**：BankAccountのbootメソッド - 自動データ同期ロジック
  3. **UT-PTN-054〜UT-PTN-066**：認可ポリシー - セキュリティ関連のテスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/partners/src/Models/Partner.php`
- E-02: `plugins/webkul/partners/src/Models/BankAccount.php`
- E-03: `plugins/webkul/partners/src/Models/Title.php`
- E-04: `plugins/webkul/partners/src/Models/Tag.php`
- E-05: `plugins/webkul/partners/src/Models/Industry.php`
- E-06: `plugins/webkul/partners/src/Models/Bank.php`
- E-07: `plugins/webkul/partners/src/Enums/AccountType.php`
- E-08: `plugins/webkul/partners/src/Enums/AddressType.php`
- E-09: `plugins/webkul/partners/src/Policies/PartnerPolicy.php`
- E-10: `plugins/webkul/partners/src/Policies/BankAccountPolicy.php`
- E-11: `plugins/webkul/partners/src/Policies/TitlePolicy.php`
- E-12: `plugins/webkul/partners/src/Policies/TagPolicy.php`
- E-13: `plugins/webkul/partners/src/Policies/BankPolicy.php`
- E-14: `plugins/webkul/partners/src/Policies/IndustryPolicy.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Partner モデル（UT-PTN-001〜UT-PTN-027）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getAvatarUrlAttribute正常系 | E-01 L91-98 | ○ |
| C-02 | getAvatarUrlAttributeでnull時の挙動 | E-01 L93-95 | ○ |
| C-03 | getAvatarUrlAttributeで空文字時の挙動 | E-01 L93 | ○ |
| C-04 | countryリレーション | E-01 L100-103 | ○ |
| C-05 | country_idがnullの場合 | E-01 L100-103 | ○ |
| C-06 | stateリレーション | E-01 L105-108 | ○ |
| C-07 | parentリレーション（自己参照） | E-01 L110-113 | ○ |
| C-08 | parent_idがnullの場合 | E-01 L110-113 | ○ |
| C-09 | creatorリレーション | E-01 L115-118 | ○ |
| C-10 | userリレーション | E-01 L120-123 | ○ |
| C-11 | titleリレーション | E-01 L125-128 | ○ |
| C-12 | companyリレーション | E-01 L130-133 | ○ |
| C-13 | industryリレーション | E-01 L135-138 | ○ |
| C-14 | addressesリレーション（ADDRESSタイプのみ） | E-01 L140-144 | ○ |
| C-15 | addresses空コレクション | E-01 L140-144 | ○ |
| C-16 | contactsリレーション（ADDRESS以外） | E-01 L146-149 | ○ |
| C-17 | contacts空コレクション | E-01 L146-149 | ○ |
| C-18 | bankAccountsリレーション | E-01 L151-154 | ○ |
| C-19 | tagsリレーション | E-01 L156-159 | ○ |
| C-20 | tags空コレクション | E-01 L156-159 | ○ |
| C-21 | canAccessPanelメソッド | E-01 L81-84 | ○ |
| C-22 | account_type Enumキャスト | E-01 L73-76 | ○ |
| C-23 | is_active booleanキャスト | E-01 L73-76 | ○ |
| C-24 | fillable属性許可 | E-01 L40-66 | ○ |
| C-25 | fillable外属性拒否 | E-01 L40-66 | ○ |
| C-26 | SoftDeletes動作 | E-01 L11, L26 | ○ |
| C-27 | restore動作 | E-01 L11, L26 | ○ |

### BankAccount モデル（UT-PTN-028〜UT-PTN-035）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | bankリレーション | E-02 L49-52 | ○ |
| C-29 | partnerリレーション | E-02 L54-57 | ○ |
| C-30 | creatorリレーション | E-02 L59-62 | ○ |
| C-31 | boot creatingイベント | E-02 L67-78 | ○ |
| C-32 | boot updatingイベント | E-02 L67-78 | ○ |
| C-33 | is_active booleanキャスト | E-02 L44-47 | ○ |
| C-34 | can_send_money booleanキャスト | E-02 L44-47 | ○ |
| C-35 | SoftDeletes動作 | E-02 L8, L15 | ○ |

### Title モデル（UT-PTN-036〜UT-PTN-037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | creatorリレーション | E-03 L33-36 | ○ |
| C-37 | fillable属性 | E-03 L27-31 | ○ |

### Tag モデル（UT-PTN-038〜UT-PTN-040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | creatorリレーション | E-04 L34-37 | ○ |
| C-39 | SoftDeletes動作 | E-04 L8, L14 | ○ |
| C-40 | fillable属性 | E-04 L28-32 | ○ |

### Industry モデル（UT-PTN-041〜UT-PTN-044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | creatorリレーション | E-05 L45-48 | ○ |
| C-42 | is_active booleanキャスト | E-05 L41-43 | ○ |
| C-43 | SoftDeletes動作 | E-05 L8, L14 | ○ |
| C-44 | fillable属性 | E-05 L28-34 | ○ |

### AccountType Enum（UT-PTN-045〜UT-PTN-048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | options静的メソッド | E-07 L15-22 | ○ |
| C-46 | INDIVIDUAL getLabel | E-07 L24-31 | ○ |
| C-47 | COMPANY getLabel | E-07 L24-31 | ○ |
| C-48 | ADDRESS getLabel | E-07 L24-31 | ○ |

### AddressType Enum（UT-PTN-049〜UT-PTN-053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | PERMANENT getLabel | E-08 L19-27 | ○ |
| C-50 | PRESENT getLabel | E-08 L19-27 | ○ |
| C-51 | INVOICE getLabel | E-08 L19-27 | ○ |
| C-52 | DELIVERY getLabel | E-08 L19-27 | ○ |
| C-53 | OTHER getLabel | E-08 L19-27 | ○ |

### PartnerPolicy（UT-PTN-054〜UT-PTN-062）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | viewAny権限あり | E-09 L16-19 | ○ |
| C-55 | viewAny権限なし | E-09 L16-19 | ○ |
| C-56 | view権限あり | E-09 L24-27 | ○ |
| C-57 | create権限あり | E-09 L32-35 | ○ |
| C-58 | update権限あり | E-09 L40-43 | ○ |
| C-59 | delete権限あり | E-09 L48-51 | ○ |
| C-60 | deleteAny権限あり | E-09 L56-59 | ○ |
| C-61 | forceDelete権限あり | E-09 L64-67 | ○ |
| C-62 | restore権限あり | E-09 L80-83 | ○ |

### BankAccountPolicy（UT-PTN-063〜UT-PTN-066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | viewAny権限あり | E-10 L17-20 | ○ |
| C-64 | create権限あり | E-10 L33-36 | ○ |
| C-65 | update権限あり | E-10 L41-44 | ○ |
| C-66 | delete権限あり | E-10 L49-52 | ○ |

### TitlePolicy（UT-PTN-067〜UT-PTN-070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | viewAny権限あり | E-11 L17-20 | ○ |
| C-68 | create権限あり | E-11 L25-28 | ○ |
| C-69 | update権限あり | E-11 L33-36 | ○ |
| C-70 | delete権限あり | E-11 L41-44 | ○ |

### TagPolicy（UT-PTN-071〜UT-PTN-076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | viewAny権限あり | E-12 L17-20 | ○ |
| C-72 | create権限あり | E-12 L33-36 | ○ |
| C-73 | update権限あり | E-12 L41-44 | ○ |
| C-74 | delete権限あり | E-12 L49-52 | ○ |
| C-75 | forceDelete権限あり | E-12 L64-67 | ○ |
| C-76 | restore権限あり | E-12 L80-83 | ○ |

### BankPolicy（UT-PTN-077〜UT-PTN-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | viewAny権限あり | E-13 L17-20 | ○ |
| C-78 | create権限あり | E-13 L33-36 | ○ |
| C-79 | update権限あり | E-13 L41-44 | ○ |
| C-80 | delete権限あり | E-13 L49-52 | ○ |

### IndustryPolicy（UT-PTN-081〜UT-PTN-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | viewAny権限あり | E-14 L17-20 | ○ |
| C-82 | create権限あり | E-14 L33-36 | ○ |
| C-83 | update権限あり | E-14 L41-44 | ○ |
| C-84 | delete権限あり | E-14 L49-52 | ○ |
| C-85 | forceDelete権限あり | E-14 L64-67 | ○ |
| C-86 | restore権限あり | E-14 L80-83 | ○ |

## 4) 不足情報（Unknown / Missing）
- **なし**：全てのテストケースはソースコードに基づいて作成されています。

補足事項：
- `Webkul\Partner\Models\Bank` は `Webkul\Support\Models\Bank` を継承しており、独自のメソッドやプロパティを持たないため、個別のテストケースは生成していません。
- データベースマイグレーションファイルは本解析の対象外としましたが、fillable属性やcasts定義はモデルファイルから確認可能です。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコードに直接対応しています。

特に注目すべき点：
1. `Partner.addresses()` と `Partner.contacts()` のフィルタリング条件が正しく動作するか実際のテストで確認が必要
2. `BankAccount.boot()` の creating/updating イベントでパートナー名が正しく同期されるかテストで確認が必要
3. 認可ポリシーは全て `$user->can()` メソッドに委譲しているため、権限設定の整合性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Partner.addressesとcontactsのフィルタリング条件（AccountType）が意図通りか確認
- [ ] BankAccount.bootのイベントハンドラでpartner.nameのnullチェックが不要か確認
- [ ] 各ポリシーの権限名（view_any_partner等）がシステム全体で一貫しているか確認
- [ ] SoftDeletesを使用しているモデル（Partner, BankAccount, Tag, Industry）のカスケード削除要件を確認
- [ ] テストデータ作成時にファクトリ（PartnerFactory等）が正しく動作するか確認
