---
generated_at: 2025-12-29 15:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：products.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. なし - 全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/products/src/Models/Product.php`
- E-02: `plugins/webkul/products/src/Models/Category.php`
- E-03: `plugins/webkul/products/src/Models/Attribute.php`
- E-04: `plugins/webkul/products/src/Models/AttributeOption.php`
- E-05: `plugins/webkul/products/src/Models/ProductAttribute.php`
- E-06: `plugins/webkul/products/src/Models/ProductAttributeValue.php`
- E-07: `plugins/webkul/products/src/Models/ProductCombination.php`
- E-08: `plugins/webkul/products/src/Models/ProductSupplier.php`
- E-09: `plugins/webkul/products/src/Models/Tag.php`
- E-10: `plugins/webkul/products/src/Models/PriceList.php`
- E-11: `plugins/webkul/products/src/Models/PriceRule.php`
- E-12: `plugins/webkul/products/src/Models/PriceRuleItem.php`
- E-13: `plugins/webkul/products/src/Models/Packaging.php`
- E-14: `plugins/webkul/products/src/Enums/ProductType.php`
- E-15: `plugins/webkul/products/src/Enums/AttributeType.php`
- E-16: `plugins/webkul/products/src/Enums/PriceRuleType.php`
- E-17: `plugins/webkul/products/src/Enums/PriceRuleApplyTo.php`
- E-18: `plugins/webkul/products/src/Enums/PriceRuleBase.php`
- E-19: `plugins/webkul/products/src/Enums/ProductRemoval.php`
- E-20: `plugins/webkul/products/src/Filament/Resources/ProductResource/Actions/GenerateVariantsAction.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Product Model (UT-PRD-001 〜 UT-PRD-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Product::parent() は BelongsTo リレーションで自己参照を返す | E-01 (108-111行目) | ○ |
| C-02 | Product::uom() は UOM への BelongsTo リレーション | E-01 (113-116行目) | ○ |
| C-03 | Product::uomPO() は UOM への BelongsTo リレーション | E-01 (118-121行目) | ○ |
| C-04 | Product::category() は Category への BelongsTo リレーション | E-01 (123-126行目) | ○ |
| C-05 | Product::tags() は Tag への BelongsToMany リレーション | E-01 (128-131行目) | ○ |
| C-06 | Product::company() は Company への BelongsTo リレーション | E-01 (133-136行目) | ○ |
| C-07 | Product::creator() は User への BelongsTo リレーション | E-01 (138-141行目) | ○ |
| C-08 | Product::attributes() は ProductAttribute への HasMany リレーション | E-01 (143-146行目) | ○ |
| C-09 | Product::attribute_values() は ProductAttributeValue への HasMany リレーション | E-01 (148-151行目) | ○ |
| C-10 | Product::variants() は自己参照の HasMany リレーション | E-01 (153-156行目) | ○ |
| C-11 | Product::combinations() は ProductCombination への HasMany リレーション | E-01 (158-161行目) | ○ |
| C-12 | Product::priceRuleItems() は PriceRuleItem への HasMany リレーション | E-01 (163-166行目) | ○ |
| C-13 | Product::supplierInformation() は is_configurable によって動作が分岐する | E-01 (168-176行目) | ○ |
| C-14 | Product の casts 定義（type, enable_sales, enable_purchase, is_favorite, is_configurable, images, cost, price） | E-01 (69-78行目) | ○ |
| C-15 | Product は SoftDeletes トレイトを使用 | E-01 (23行目) | ○ |
| C-16 | Product は SortableTrait を使用 | E-01 (23行目, 103-106行目) | ○ |

### Category Model (UT-PRD-029 〜 UT-PRD-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | Category::parent() は自己参照の BelongsTo リレーション | E-02 (47-50行目) | ○ |
| C-18 | Category::children() は自己参照の HasMany リレーション | E-02 (52-55行目) | ○ |
| C-19 | Category::products() は Product への HasMany リレーション | E-02 (57-60行目) | ○ |
| C-20 | Category::creator() は User への BelongsTo リレーション | E-02 (62-65行目) | ○ |
| C-21 | Category::priceRuleItems() は PriceRuleItem への HasMany リレーション | E-02 (67-70行目) | ○ |
| C-22 | Category::boot() で creating/updating 時に循環参照チェックを実行 | E-02 (72-91行目) | ○ |
| C-23 | Category::validateNoRecursion() で循環参照を検出 | E-02 (93-125行目) | ○ |
| C-24 | Category::handleProductCategoryData() で parent_path と full_name を設定 | E-02 (127-143行目) | ○ |
| C-25 | Category::getCompleteName() で階層的な名前を生成 | E-02 (145-163行目) | ○ |

### Attribute Model (UT-PRD-047 〜 UT-PRD-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | Attribute::options() は AttributeOption への HasMany リレーション | E-03 (53-56行目) | ○ |
| C-27 | Attribute::creator() は User への BelongsTo リレーション | E-03 (58-61行目) | ○ |
| C-28 | Attribute の casts 定義（type => AttributeType::class） | E-03 (44-46行目) | ○ |
| C-29 | Attribute は SoftDeletes トレイトを使用 | E-03 (18行目) | ○ |
| C-30 | Attribute は SortableTrait を使用 | E-03 (18行目, 48-51行目) | ○ |

### AttributeOption Model (UT-PRD-053 〜 UT-PRD-055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | AttributeOption::attribute() は Attribute への BelongsTo リレーション | E-04 (43-46行目) | ○ |
| C-32 | AttributeOption::creator() は User への BelongsTo リレーション | E-04 (48-51行目) | ○ |
| C-33 | AttributeOption は SortableTrait を使用 | E-04 (15行目, 38-41行目) | ○ |

### ProductAttribute Model (UT-PRD-056 〜 UT-PRD-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | ProductAttribute::product() は Product への BelongsTo リレーション | E-05 (41-44行目) | ○ |
| C-35 | ProductAttribute::attribute() は Attribute への BelongsTo リレーション（withTrashed） | E-05 (46-49行目) | ○ |
| C-36 | ProductAttribute::options() は AttributeOption への BelongsToMany リレーション | E-05 (51-54行目) | ○ |
| C-37 | ProductAttribute::values() は ProductAttributeValue への HasMany リレーション | E-05 (56-59行目) | ○ |
| C-38 | ProductAttribute::creator() は User への BelongsTo リレーション | E-05 (61-64行目) | ○ |
| C-39 | ProductAttribute::boot() で削除時にバリアントを強制削除 | E-05 (66-73行目) | ○ |
| C-40 | ProductAttribute は SortableTrait を使用 | E-05 (15行目, 36-39行目) | ○ |

### ProductAttributeValue Model (UT-PRD-063 〜 UT-PRD-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | ProductAttributeValue::product() は Product への BelongsTo リレーション | E-06 (38-41行目) | ○ |
| C-42 | ProductAttributeValue::attribute() は Attribute への BelongsTo リレーション | E-06 (43-46行目) | ○ |
| C-43 | ProductAttributeValue::productAttribute() は ProductAttribute への BelongsTo リレーション | E-06 (48-51行目) | ○ |
| C-44 | ProductAttributeValue::attributeOption() は AttributeOption への BelongsTo リレーション | E-06 (53-56行目) | ○ |
| C-45 | ProductAttributeValue::creator() は User への BelongsTo リレーション | E-06 (58-61行目) | ○ |

### ProductCombination Model (UT-PRD-068 〜 UT-PRD-069)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | ProductCombination::product() は Product への BelongsTo リレーション | E-07 (20-23行目) | ○ |
| C-47 | ProductCombination::productAttributeValue() は ProductAttributeValue への BelongsTo リレーション | E-07 (25-28行目) | ○ |

### ProductSupplier Model (UT-PRD-070 〜 UT-PRD-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | ProductSupplier::product() は Product への BelongsTo リレーション | E-08 (57-60行目) | ○ |
| C-49 | ProductSupplier::partner() は Partner への BelongsTo リレーション | E-08 (62-65行目) | ○ |
| C-50 | ProductSupplier::currency() は Currency への BelongsTo リレーション | E-08 (67-70行目) | ○ |
| C-51 | ProductSupplier::creator() は User への BelongsTo リレーション | E-08 (72-75行目) | ○ |
| C-52 | ProductSupplier::company() は Company への BelongsTo リレーション | E-08 (77-80行目) | ○ |
| C-53 | ProductSupplier の casts 定義（starts_at, ends_at => date） | E-08 (47-50行目) | ○ |
| C-54 | ProductSupplier は SortableTrait を使用 | E-08 (16行目, 52-55行目) | ○ |

### Tag Model (UT-PRD-078 〜 UT-PRD-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | Tag::creator() は User への BelongsTo リレーション | E-09 (34-37行目) | ○ |
| C-56 | Tag は SoftDeletes トレイトを使用 | E-09 (14行目) | ○ |

### PriceList Model (UT-PRD-080 〜 UT-PRD-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | PriceList::currency() は Currency への BelongsTo リレーション | E-10 (33-36行目) | ○ |
| C-58 | PriceList::company() は Company への BelongsTo リレーション | E-10 (38-41行目) | ○ |
| C-59 | PriceList::creator() は User への BelongsTo リレーション | E-10 (43-46行目) | ○ |
| C-60 | PriceList は SortableTrait を使用 | E-10 (15行目, 28-31行目) | ○ |

### PriceRule Model (UT-PRD-084 〜 UT-PRD-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | PriceRule::currency() は Currency への BelongsTo リレーション | E-11 (46-49行目) | ○ |
| C-62 | PriceRule::company() は Company への BelongsTo リレーション | E-11 (51-54行目) | ○ |
| C-63 | PriceRule::creator() は User への BelongsTo リレーション | E-11 (56-59行目) | ○ |
| C-64 | PriceRule::items() は PriceRuleItem への HasMany リレーション | E-11 (61-64行目) | ○ |
| C-65 | PriceRule は SoftDeletes トレイトを使用 | E-11 (19行目) | ○ |
| C-66 | PriceRule は SortableTrait を使用 | E-11 (19行目, 41-44行目) | ○ |

### PriceRuleItem Model (UT-PRD-091 〜 UT-PRD-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | PriceRuleItem::priceRule() は PriceRule への BelongsTo リレーション | E-12 (69-72行目) | ○ |
| C-68 | PriceRuleItem::basePriceRule() は PriceRule への BelongsTo リレーション | E-12 (74-77行目) | ○ |
| C-69 | PriceRuleItem::product() は Product への BelongsTo リレーション | E-12 (79-82行目) | ○ |
| C-70 | PriceRuleItem::category() は Category への BelongsTo リレーション | E-12 (84-87行目) | ○ |
| C-71 | PriceRuleItem::currency() は Currency への BelongsTo リレーション | E-12 (89-92行目) | ○ |
| C-72 | PriceRuleItem::company() は Company への BelongsTo リレーション | E-12 (94-97行目) | ○ |
| C-73 | PriceRuleItem::creator() は User への BelongsTo リレーション | E-12 (99-102行目) | ○ |
| C-74 | PriceRuleItem の casts 定義（starts_at, ends_at => datetime, apply_to, base, type => Enum） | E-12 (61-67行目) | ○ |

### Packaging Model (UT-PRD-103 〜 UT-PRD-106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | Packaging::product() は Product への BelongsTo リレーション（withTrashed） | E-13 (45-48行目) | ○ |
| C-76 | Packaging::company() は Company への BelongsTo リレーション | E-13 (50-53行目) | ○ |
| C-77 | Packaging::creator() は User への BelongsTo リレーション | E-13 (55-58行目) | ○ |
| C-78 | Packaging は SortableTrait を使用 | E-13 (16行目, 40-43行目) | ○ |

### Enums (UT-PRD-107 〜 UT-PRD-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | ProductType Enum は GOODS, SERVICE の2値を持つ | E-14 (8-11行目) | ○ |
| C-80 | ProductType::getLabel() で翻訳されたラベルを返す | E-14 (13-19行目) | ○ |
| C-81 | AttributeType Enum は RADIO, SELECT, COLOR の3値を持つ | E-15 (8-13行目) | ○ |
| C-82 | AttributeType::getLabel() で翻訳されたラベルを返す | E-15 (15-22行目) | ○ |
| C-83 | PriceRuleType Enum は PERCENTAGE, FORMULA, FIXED の3値を持つ | E-16 (8-13行目) | ○ |
| C-84 | PriceRuleType::getLabel() で翻訳されたラベルを返す | E-16 (15-22行目) | ○ |
| C-85 | PriceRuleApplyTo Enum は PRODUCT, CATEGORY の2値を持つ | E-17 (8-11行目) | ○ |
| C-86 | PriceRuleApplyTo::getLabel() で翻訳されたラベルを返す | E-17 (13-19行目) | ○ |
| C-87 | PriceRuleBase Enum は LIST_PRICE, STANDARD_PRICE, PRICE_RULES の3値を持つ | E-18 (8-13行目) | ○ |
| C-88 | PriceRuleBase::getLabel() で翻訳されたラベルを返す | E-18 (15-22行目) | ○ |
| C-89 | ProductRemoval Enum は FIFO, LIFO, CLOSEST, LEAST_PACKAGES, FEFO の5値を持つ | E-19 (8-17行目) | ○ |
| C-90 | ProductRemoval::getLabel() で翻訳されたラベルを返す | E-19 (19-28行目) | ○ |

### GenerateVariantsAction (UT-PRD-125 〜 UT-PRD-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | GenerateVariantsAction::generateVariants() でバリアント生成処理を実行 | E-20 (47-72行目) | ○ |
| C-92 | 単一属性の場合 handleSingleAttributeVariants() が呼ばれる | E-20 (54-55行目) | ○ |
| C-93 | 複数属性の場合 handleMultipleAttributeVariants() が呼ばれる | E-20 (56-57行目) | ○ |
| C-94 | handleSingleAttributeVariants() で単一属性のバリアントを処理 | E-20 (74-115行目) | ○ |
| C-95 | handleMultipleAttributeVariants() で複数属性の組み合わせを処理 | E-20 (117-168行目) | ○ |
| C-96 | generateAttributeCombinations() で再帰的に組み合わせを生成 | E-20 (170-190行目) | ○ |
| C-97 | createVariant() で新規バリアントを作成 | E-20 (192-228行目) | ○ |
| C-98 | createVariant() でバリアント名を「親商品名 - 属性値1 / 属性値2」形式で生成 | E-20 (194-196行目) | ○ |
| C-99 | createVariant() で extra_price を加算した価格を設定 | E-20 (198, 205行目) | ○ |
| C-100 | updateVariant() で既存バリアントの名前と価格を更新 | E-20 (230-244行目) | ○ |
| C-101 | setUp() で hidden 条件として attributes が空の場合を設定 | E-20 (44行目) | ○ |
| C-102 | action() 実行後に is_configurable を true に設定 | E-20 (41-42行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースに対応するソースコードの根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいて生成されている

## 6) レビュアーチェックリスト（最小）
- [ ] 金額計算関連のテストケース（UT-PRD-024, UT-PRD-025, UT-PRD-136）が十分な境界値をカバーしているか確認
- [ ] Category の循環参照チェック（UT-PRD-034〜UT-PRD-041）が全てのエッジケースをカバーしているか確認
- [ ] GenerateVariantsAction のテストケース（UT-PRD-125〜UT-PRD-140）がトランザクション処理の観点を含んでいるか確認
- [ ] ProductAttribute 削除時のカスケード削除（UT-PRD-061）が適切に検証されているか確認
- [ ] サプライヤー情報の is_configurable による分岐（UT-PRD-016, UT-PRD-017）が正しくテストされているか確認
