---
generated_at: 2025-12-29 12:00:00
metrics:
  claims_total: 105
  claims_with_evidence: 105
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：projects.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：105 / 105、根拠なし：0
- 優先レビュー（高）
  1. なし - 全てのテストケースに根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/projects/src/Models/Project.php`
- E-02: `plugins/webkul/projects/src/Models/Task.php`
- E-03: `plugins/webkul/projects/src/Models/Milestone.php`
- E-04: `plugins/webkul/projects/src/Models/Timesheet.php`
- E-05: `plugins/webkul/projects/src/Models/TaskStage.php`
- E-06: `plugins/webkul/projects/src/Models/ProjectStage.php`
- E-07: `plugins/webkul/projects/src/Models/Tag.php`
- E-08: `plugins/webkul/projects/src/Enums/TaskState.php`
- E-09: `plugins/webkul/projects/src/Enums/ProjectVisibility.php`
- E-10: `plugins/webkul/projects/src/Policies/ProjectPolicy.php`
- E-11: `plugins/webkul/projects/src/Policies/TaskPolicy.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Project モデル (UT-PRJ-001 〜 UT-PRJ-024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Projectモデルにpartner()リレーションが存在する | E-01 L116-118 | ○ |
| C-02 | partner()はBelongsTo<Partner>を返す | E-01 L117 | ○ |
| C-03 | creator()リレーションがUser型を返す | E-01 L121-124 | ○ |
| C-04 | user()リレーションがUser型を返す | E-01 L126-129 | ○ |
| C-05 | stage()リレーションがProjectStageを返す | E-01 L131-134 | ○ |
| C-06 | taskStages()がHasMany関係を持つ | E-01 L136-139 | ○ |
| C-07 | favoriteUsers()がBelongsToMany関係を持つ | E-01 L141-144 | ○ |
| C-08 | getIsFavoriteByUserAttributeがfavoriteUsersをチェックする | E-01 L146-153 | ○ |
| C-09 | getRemainingHoursAttributeがallocated_hoursからtasks.sumを引く | E-01 L155-158 | ○ |
| C-10 | milestones()がHasMany関係を持つ | E-01 L160-163 | ○ |
| C-11 | tasks()がHasMany関係を持つ | E-01 L165-168 | ○ |
| C-12 | company()がBelongsTo関係を持つ | E-01 L170-173 | ○ |
| C-13 | tags()がBelongsToMany関係を持つ | E-01 L175-178 | ○ |
| C-14 | plannedDate()アクセサがstart_date - end_dateを返す | E-01 L109-114 | ○ |
| C-15 | booted()でUserPermissionScopeが追加される | E-01 L180-183 | ○ |
| C-16 | $castsでstart_dateがdate型にキャストされる | E-01 L66-78 | ○ |
| C-17 | $castsでis_activeがboolean型にキャストされる | E-01 L69 | ○ |
| C-18 | $castsでallow_timesheetsがboolean型にキャストされる | E-01 L70 | ○ |

### Task モデル (UT-PRJ-025 〜 UT-PRJ-044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | parent()が自己参照BelongsToを持つ | E-02 L113-116 | ○ |
| C-20 | subTasks()が自己参照HasManyを持つ | E-02 L118-121 | ○ |
| C-21 | project()がProjectへのBelongsToを持つ | E-02 L123-126 | ○ |
| C-22 | milestone()がMilestoneへのBelongsToを持つ | E-02 L128-131 | ○ |
| C-23 | stage()がTaskStageへのBelongsToを持つ | E-02 L133-136 | ○ |
| C-24 | partner()がPartnerへのBelongsToを持つ | E-02 L138-141 | ○ |
| C-25 | creator()がUserへのBelongsToを持つ | E-02 L143-146 | ○ |
| C-26 | users()がBelongsToMany関係を持つ | E-02 L148-151 | ○ |
| C-27 | company()がBelongsTo関係を持つ | E-02 L153-156 | ○ |
| C-28 | tags()がBelongsToMany関係を持つ | E-02 L158-161 | ○ |
| C-29 | timesheets()がHasMany関係を持つ | E-02 L163-166 | ○ |
| C-30 | booted()でUserPermissionScope('users')が追加される | E-02 L168-171 | ○ |
| C-31 | boot()のupdatedイベントでtimesheetsが連動更新される | E-02 L176-187 | ○ |
| C-32 | $castsでstateがTaskState enumにキャストされる | E-02 L84 | ○ |
| C-33 | $castsでdeadlineがdatetime型にキャストされる | E-02 L73 | ○ |
| C-34 | $castsでallocated_hoursがfloat型にキャストされる | E-02 L79 | ○ |

### Milestone モデル (UT-PRJ-045 〜 UT-PRJ-049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | project()がProjectへのBelongsToを持つ | E-03 L47-50 | ○ |
| C-36 | creator()がUserへのBelongsToを持つ | E-03 L52-55 | ○ |
| C-37 | $castsでis_completedがboolean型にキャストされる | E-03 L42 | ○ |
| C-38 | $castsでdeadlineがdatetime型にキャストされる | E-03 L43 | ○ |
| C-39 | $castsでcompleted_atがdatetime型にキャストされる | E-03 L44 | ○ |

### Timesheet モデル (UT-PRJ-050 〜 UT-PRJ-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | project()がProjectへのBelongsToを持つ | E-04 L30-33 | ○ |
| C-41 | task()がTaskへのBelongsToを持つ | E-04 L35-38 | ○ |
| C-42 | updateTaskTimes()がタスクの時間集計を更新する | E-04 L40-80 | ○ |
| C-43 | updateTaskTimes()でサブタスクの時間が加算される | E-04 L50-54 | ○ |
| C-44 | updateTaskTimes()でovertimeが計算される | E-04 L59 | ○ |
| C-45 | updateTaskTimes()でprogressが計算される | E-04 L61 | ○ |
| C-46 | updateTaskTimes()でallocated_hours=0の場合progress=0 | E-04 L61 三項演算子 | ○ |
| C-47 | updateTaskTimes()で親タスクも連動更新される | E-04 L64-79 | ○ |
| C-48 | updateTaskTimes()でtask=nullの場合早期リターン | E-04 L42-44 | ○ |
| C-49 | boot()のcreatedイベントでupdateTaskTimesが呼ばれる | E-04 L17-19 | ○ |
| C-50 | boot()のupdatedイベントでupdateTaskTimesが呼ばれる | E-04 L21-23 | ○ |
| C-51 | boot()のdeletedイベントでupdateTaskTimesが呼ばれる | E-04 L25-27 | ○ |

### TaskStage モデル (UT-PRJ-063 〜 UT-PRJ-069)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | project()がProjectへのBelongsToを持つ | E-05 L58-61 | ○ |
| C-53 | tasks()がHasMany関係を持つ | E-05 L63-66 | ○ |
| C-54 | user()がUserへのBelongsToを持つ | E-05 L68-71 | ○ |
| C-55 | creator()がUserへのBelongsToを持つ | E-05 L73-76 | ○ |
| C-56 | company()がBelongsTo関係を持つ | E-05 L78-81 | ○ |
| C-57 | $castsでis_activeがboolean型にキャストされる | E-05 L49 | ○ |
| C-58 | $castsでis_collapsedがboolean型にキャストされる | E-05 L50 | ○ |

### ProjectStage モデル (UT-PRJ-070 〜 UT-PRJ-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | creator()がUserへのBelongsToを持つ | E-06 L56-59 | ○ |
| C-60 | company()がBelongsTo関係を持つ | E-06 L61-64 | ○ |
| C-61 | projects()がHasMany関係を持つ | E-06 L66-69 | ○ |
| C-62 | $castsでis_activeがboolean型にキャストされる | E-06 L47 | ○ |
| C-63 | $castsでis_collapsedがboolean型にキャストされる | E-06 L48 | ○ |

### Tag モデル (UT-PRJ-075 〜 UT-PRJ-076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | creator()がUserへのBelongsToを持つ | E-07 L34-37 | ○ |

### TaskState Enum (UT-PRJ-077 〜 UT-PRJ-081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | getLabel()が翻訳キーを返す | E-08 L16-18 | ○ |
| C-66 | getIcon()がアイコン名を返す | E-08 L20-23 | ○ |
| C-67 | getColor()が色名を返す | E-08 L25-28 | ○ |
| C-68 | options()が5つの選択肢を返す | E-08 L30-38 | ○ |
| C-69 | 5つの状態が定義されている | E-08 L9-13 | ○ |

### ProjectVisibility Enum (UT-PRJ-082 〜 UT-PRJ-084)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | options()が3つの選択肢を返す | E-09 L11-17 | ○ |
| C-71 | icons()がアイコン名を返す | E-09 L19-26 | ○ |
| C-72 | colors()が色名を返す | E-09 L28-35 | ○ |

### ProjectPolicy (UT-PRJ-085 〜 UT-PRJ-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | viewAny()がview_any_project権限をチェックする | E-10 L17-20 | ○ |
| C-74 | view()がview_project権限をチェックする | E-10 L25-28 | ○ |
| C-75 | create()がcreate_project権限をチェックする | E-10 L33-36 | ○ |
| C-76 | update()がupdate_project権限とhasAccessをチェックする | E-10 L41-48 | ○ |
| C-77 | delete()がdelete_project権限とhasAccessをチェックする | E-10 L53-60 | ○ |
| C-78 | deleteAny()がdelete_any_project権限をチェックする | E-10 L65-68 | ○ |
| C-79 | forceDelete()がforce_delete_project権限とhasAccessをチェックする | E-10 L73-80 | ○ |
| C-80 | restore()がrestore_project権限とhasAccessをチェックする | E-10 L93-100 | ○ |
| C-81 | reorder()がreorder_project権限をチェックする | E-10 L113-116 | ○ |

### TaskPolicy (UT-PRJ-097 〜 UT-PRJ-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | viewAny()がview_any_task権限をチェックする | E-11 L17-20 | ○ |
| C-83 | view()がview_task権限をチェックする | E-11 L25-28 | ○ |
| C-84 | create()がcreate_task権限をチェックする | E-11 L33-36 | ○ |
| C-85 | update()がupdate_task権限とhasAccess('users')をチェックする | E-11 L41-48 | ○ |
| C-86 | delete()がdelete_task権限とhasAccess('users')をチェックする | E-11 L53-60 | ○ |
| C-87 | forceDelete()がforce_delete_task権限とhasAccess('users')をチェックする | E-11 L73-80 | ○ |
| C-88 | restore()がrestore_task権限とhasAccess('users')をチェックする | E-11 L93-100 | ○ |
| C-89 | reorder()がreorder_task権限をチェックする | E-11 L113-116 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全てのテストケースにソースコードの根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されている
- 注意点:
  - Timesheetモデルは親クラス（Webkul\Analytic\Models\Record）を継承しているため、親クラスの挙動も確認が必要
  - TaskState enumのアイコン定義に誤植の可能性（heroicon-c-check-circle）があるが、これはソースコードに存在するため根拠としては有効

## 6) レビュアーチェックリスト（最小）
- [ ] 時間計算ロジック（UT-PRJ-012〜014, UT-PRJ-052〜058）の計算式が要件と一致しているか確認
- [ ] 認可ポリシー（UT-PRJ-085〜105）がセキュリティ要件を満たしているか確認
- [ ] Timesheetのboot処理（UT-PRJ-060〜062）が期待通りのタイミングで実行されるか確認
- [ ] Task更新時のtimesheets連動更新（UT-PRJ-039〜041）でデータ整合性が保たれるか確認
- [ ] UserPermissionScopeの適用（UT-PRJ-021, UT-PRJ-038）が全クエリで機能するか確認
