---
generated_at: 2025-12-29 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：purchases.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. **金額計算ロジック（UT-PUR-088〜093）**：ビジネスクリティカルな計算処理
  2. **状態遷移（UT-PUR-082〜087）**：注文ワークフローの核心部分
  3. **請求書作成（UT-PUR-107, 110, 111）**：会計連携の重要処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Models/Order.php`
- E-02: `plugins/webkul/purchases/src/Models/OrderLine.php`
- E-03: `plugins/webkul/purchases/src/Models/Requisition.php`
- E-04: `plugins/webkul/purchases/src/Models/RequisitionLine.php`
- E-05: `plugins/webkul/purchases/src/Models/Product.php`
- E-06: `plugins/webkul/purchases/src/Models/Partner.php`
- E-07: `plugins/webkul/purchases/src/Models/AccountMove.php`
- E-08: `plugins/webkul/purchases/src/Models/AccountMoveLine.php`
- E-09: `plugins/webkul/purchases/src/Models/OrderGroup.php`
- E-10: `plugins/webkul/purchases/src/Models/Quotation.php`
- E-11: `plugins/webkul/purchases/src/Models/PurchaseOrder.php`
- E-12: `plugins/webkul/purchases/src/Models/CustomerPurchaseOrder.php`
- E-13: `plugins/webkul/purchases/src/Models/Category.php`
- E-14: `plugins/webkul/purchases/src/Models/Attribute.php`
- E-15: `plugins/webkul/purchases/src/Models/Packaging.php`
- E-16: `plugins/webkul/purchases/src/Models/ProductSupplier.php`
- E-17: `plugins/webkul/purchases/src/Enums/OrderState.php`
- E-18: `plugins/webkul/purchases/src/Enums/RequisitionState.php`
- E-19: `plugins/webkul/purchases/src/Enums/RequisitionType.php`
- E-20: `plugins/webkul/purchases/src/Enums/OrderInvoiceStatus.php`
- E-21: `plugins/webkul/purchases/src/Enums/OrderReceiptStatus.php`
- E-22: `plugins/webkul/purchases/src/Enums/QtyReceivedMethod.php`
- E-23: `plugins/webkul/purchases/src/PurchaseOrder.php`
- E-24: `plugins/webkul/purchases/src/Settings/OrderSettings.php`
- E-25: `plugins/webkul/purchases/src/Settings/ProductSettings.php`
- E-26: `plugins/webkul/purchases/src/Livewire/Summary.php`
- E-27: `plugins/webkul/purchases/src/Livewire/RespondQuotation.php`
- E-28: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/ConfirmAction.php`
- E-29: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/CancelAction.php`
- E-30: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/DraftAction.php`
- E-31: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/LockAction.php`
- E-32: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/UnlockAction.php`
- E-33: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/CreateBillAction.php`
- E-34: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/SendEmailAction.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### モデル：Order（UT-PUR-001〜028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Orderモデルにrequisitionリレーションが定義されている | E-01 (L138-141) | ○ |
| C-02 | Orderモデルにgroupリレーションが定義されている | E-01 (L143-146) | ○ |
| C-03 | Orderモデルにpartnerリレーションが定義されている | E-01 (L148-151) | ○ |
| C-04 | OrderモデルにfiscalPositionリレーションが定義されている | E-01 (L153-156) | ○ |
| C-05 | OrderモデルにpaymentTermリレーションが定義されている | E-01 (L158-161) | ○ |
| C-06 | Orderモデルにincotermリレーションが定義されている | E-01 (L163-166) | ○ |
| C-07 | Orderモデルにcurrencyリレーションが定義されている | E-01 (L168-171) | ○ |
| C-08 | Orderモデルにuserリレーションが定義されている | E-01 (L173-176) | ○ |
| C-09 | Orderモデルにcompanyリレーションが定義されている | E-01 (L178-181) | ○ |
| C-10 | Orderモデルにcreatorリレーションが定義されている | E-01 (L183-186) | ○ |
| C-11 | Orderモデルにlinesリレーション(HasMany)が定義されている | E-01 (L188-191) | ○ |
| C-12 | Orderモデルにaccountmovesリレーション(BelongsToMany)が定義されている | E-01 (L193-196) | ○ |
| C-13 | Orderモデルにoperationtype/operationsリレーションが定義されている | E-01 (L198-206) | ○ |
| C-14 | getQtyToInvoiceAttributeアクセサがlinesのqty_to_invoiceを合計する | E-01 (L133-136) | ○ |
| C-15 | addMessageメソッドがMessageを作成して返す | E-01 (L211-228) | ○ |
| C-16 | bootメソッドでsaving時にupdateNameが呼ばれる | E-01 (L233-244) | ○ |
| C-17 | updateNameメソッドでname='PO/{id}'形式が設定される | E-01 (L249-252) | ○ |
| C-18 | castsでOrderState/OrderInvoiceStatus/OrderReceiptStatusが定義されている | E-01 (L87-100) | ○ |

### モデル：OrderLine（UT-PUR-029〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | OrderLineにorderリレーションが定義されている | E-02 (L93-96) | ○ |
| C-20 | OrderLineにpartnerリレーションが定義されている | E-02 (L98-101) | ○ |
| C-21 | OrderLineにproductリレーションが定義されている | E-02 (L103-106) | ○ |
| C-22 | OrderLineにproductPackagingリレーションが定義されている | E-02 (L108-111) | ○ |
| C-23 | OrderLineにuomリレーションが定義されている | E-02 (L113-116) | ○ |
| C-24 | OrderLineにtaxesリレーション(BelongsToMany)が定義されている | E-02 (L118-121) | ○ |
| C-25 | OrderLineにcurrency/company/creatorリレーションが定義されている | E-02 (L123-141) | ○ |
| C-26 | OrderLineにaccountMoveLines/inventoryMovesリレーション(HasMany)が定義されている | E-02 (L143-151) | ○ |
| C-27 | OrderLineにfinalLocation/orderPointリレーションが定義されている | E-02 (L153-161) | ○ |
| C-28 | castsでQtyReceivedMethodが定義されている | E-02 (L81-86) | ○ |
| C-29 | SortableTraitで$sortable設定が定義されている | E-02 (L88-91) | ○ |

### モデル：Requisition（UT-PUR-044〜053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | Requisitionにpartner/currency/user/company/creatorリレーションが定義されている | E-03 (L77-100) | ○ |
| C-31 | Requisitionにlinesリレーション(HasMany)が定義されている | E-03 (L102-105) | ○ |
| C-32 | bootメソッドでsaving時にupdateNameが呼ばれる | E-03 (L110-121) | ○ |
| C-33 | updateNameでBLANKET_ORDERならBO/、それ以外ならPT/形式になる | E-03 (L126-133) | ○ |
| C-34 | castsでRequisitionState/RequisitionTypeが定義されている | E-03 (L57-60) | ○ |

### モデル：RequisitionLine（UT-PUR-054〜058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | RequisitionLineにrequisition/product/uom/company/creatorリレーションが定義されている | E-04 (L39-62) | ○ |

### モデル：Product（UT-PUR-059〜061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | supplierInformationメソッドでis_configurable時にバリアントも含める | E-05 (L26-34) | ○ |

### モデル：Partner（UT-PUR-062〜063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | Partnerにorders/accountMovesリレーションが定義されている | E-06 (L11-19) | ○ |

### モデル：AccountMove/AccountMoveLine（UT-PUR-064〜069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | AccountMoveにlines/purchaseOrdersリレーションが定義されている | E-07 (L10-18) | ○ |
| C-39 | AccountMoveLineにmove/purchaseOrderLineリレーションが定義されている | E-08 (L24-32) | ○ |
| C-40 | AccountMoveLineのコンストラクタでpurchase_order_line_idがfillableにマージされる | E-08 (L15-22) | ○ |

### モデル：OrderGroup（UT-PUR-069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | OrderGroupにcreatorリレーションが定義されている | E-09 (L42-45) | ○ |

### Enum類（UT-PUR-070〜078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | OrderStateにoptions/getLabel/getColorメソッドが定義されている | E-17 | ○ |
| C-43 | RequisitionStateにoptions/getLabel/getColorメソッドが定義されている | E-18 | ○ |
| C-44 | RequisitionTypeにoptions/getLabelメソッドが定義されている | E-19 | ○ |
| C-45 | OrderInvoiceStatusにoptions/getLabel/getColorメソッドが定義されている | E-20 | ○ |
| C-46 | OrderReceiptStatusにoptions/getLabel/getColorメソッドが定義されている | E-21 | ○ |
| C-47 | QtyReceivedMethodにgetLabelメソッドが定義されている | E-22 | ○ |

### サービス：PurchaseOrder（UT-PUR-079〜111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | getOrderSettingsでOrderSettingsインスタンスが返される | E-23 (L33-36) | ○ |
| C-49 | sendRFQでメール送信後stateがSENTに更新される | E-23 (L38-69) | ○ |
| C-50 | confirmPurchaseOrderでenable_lock_confirmed_ordersに基づきDONEまたはPURCHASEに更新 | E-23 (L71-85) | ○ |
| C-51 | cancelPurchaseOrderでstateがCANCELEDに更新される | E-23 (L118-129) | ○ |
| C-52 | draftPurchaseOrderでstateがDRAFTに更新される | E-23 (L131-140) | ○ |
| C-53 | lockPurchaseOrderでstateがDONEに更新される | E-23 (L142-151) | ○ |
| C-54 | unlockPurchaseOrderでstateがPURCHASEに更新される | E-23 (L153-162) | ○ |
| C-55 | computePurchaseOrderで金額計算と状態計算が行われる | E-23 (L173-199) | ○ |
| C-56 | computePurchaseOrderLineで明細行の金額・数量計算が行われる | E-23 (L201-236) | ○ |
| C-57 | computeInvoiceStatusで請求状態が計算される | E-23 (L238-265) | ○ |
| C-58 | computeReceiptStatusで受領状態が計算される | E-23 (L267-292) | ○ |
| C-59 | computeQtyBilledで請求済み数量が計算される | E-23 (L294-324) | ○ |
| C-60 | computeQtyReceivedで受領数量が計算される | E-23 (L326-381) | ○ |
| C-61 | createPurchaseOrderBillでAccountMoveが作成される | E-23 (L164-171) | ○ |
| C-62 | createAccountMoveでmove_typeがqty_to_invoiceに基づき設定される | E-23 (L546-566) | ○ |
| C-63 | createAccountMoveLineで明細が作成されtaxesがsyncされる | E-23 (L568-588) | ○ |

### Filament Actions（UT-PUR-112〜124）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | ConfirmActionはPURCHASE/DONE/CANCELED以外で表示される | E-28 (L38-42) | ○ |
| C-65 | CancelActionはDONE/CANCELED以外で表示される | E-29 (L63-66) | ○ |
| C-66 | CancelActionでqty_received>0の場合警告が表示される | E-29 (L29-39) | ○ |
| C-67 | CancelActionでキャンセルされていないaccountMovesがある場合警告が表示される | E-29 (L41-51) | ○ |
| C-68 | DraftActionはCANCELED状態でのみ表示される | E-30 (L37) | ○ |
| C-69 | LockActionはPURCHASE状態でのみ表示される | E-31 (L37) | ○ |
| C-70 | UnlockActionはDONE状態でのみ表示される | E-32 (L37) | ○ |
| C-71 | CreateBillActionはPURCHASE/DONE状態で表示される | E-33 (L53-56) | ○ |
| C-72 | CreateBillActionでqty_to_invoice=0の場合警告が表示される | E-33 (L33-41) | ○ |
| C-73 | SendEmailActionはDRAFT/SENT状態で表示される | E-34 (L121-124) | ○ |
| C-74 | SendEmailActionでDRAFT時は送信ラベル、SENT時は再送ラベルが表示される | E-34 (L32-36) | ○ |

### Settings/Livewire（UT-PUR-125〜133）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | OrderSettings::group()で'purchases_order'が返される | E-24 (L17-20) | ○ |
| C-76 | ProductSettings::group()で'purchases_product'が返される | E-25 (L15-18) | ○ |
| C-77 | Summary::mountでproducts/currencyが設定される | E-26 (L17-23) | ○ |
| C-78 | RespondQuotation::mountでaccept時にmail_reception_confirmed=trueに更新 | E-27 (L20-30) | ○ |
| C-79 | RespondQuotation::mountでdecline時にmail_reception_declined=trueに更新 | E-27 (L31-42) | ○ |
| C-80 | RespondQuotation::getHeadingでaction別の見出しが返される | E-27 (L45-52) | ○ |

### 継承モデル（UT-PUR-134〜140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | QuotationはOrderを継承している | E-10 (L5) | ○ |
| C-82 | PurchaseOrderはOrderを継承している | E-11 (L5) | ○ |
| C-83 | CustomerPurchaseOrderはOrderを継承している | E-12 (L5) | ○ |
| C-84 | CategoryはBaseCategoryを継承している | E-13 (L6-7) | ○ |
| C-85 | AttributeはBaseAttributeを継承している | E-14 (L5-7) | ○ |
| C-86 | PackagingはBasePackagingを継承している | E-15 (L5-9) | ○ |
| C-87 | ProductSupplierはBaseProductSupplierを継承している | E-16 (L5-7) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースについてソースコードから根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されている
- 注意点：
  - 金額計算ロジック（computePurchaseOrder, computePurchaseOrderLine）は精度が重要
  - 状態遷移ロジック（confirm, cancel, lock, unlock）はビジネスルールと整合性確認が必要
  - 在庫連携（createInventoryReceipt, cancelInventoryOperations）はinventoriesプラグイン依存

## 6) レビュアーチェックリスト（最小）
- [ ] 金額計算テストケース（UT-PUR-088〜093）の期待結果が正確か確認
- [ ] 状態遷移テストケース（UT-PUR-082〜087）がビジネス要件と一致するか確認
- [ ] 請求書作成テストケース（UT-PUR-107, 110, 111）の会計処理が正確か確認
- [ ] キャンセル制限テストケース（UT-PUR-115, 116）の条件が適切か確認
- [ ] 継承モデルのテストケース（UT-PUR-134〜140）で親クラスの機能が網羅されているか確認
