---
generated_at: 2025-12-29 12:00:00
metrics:
  claims_total: 121
  claims_with_evidence: 121
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：recruitments.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（recruitments.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：121 / 121、根拠なし：0
- 優先レビュー（高）
  1. **Applicant.createEmployee**：従業員作成ロジックの複雑さ
  2. **HasApplicationStatus.updateStatus**：ステータス遷移のトランザクション処理
  3. **Candidate.boot**：Partner自動作成/更新ロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/recruitments/src/Models/Applicant.php`
- E-02: `plugins/webkul/recruitments/src/Models/Candidate.php`
- E-03: `plugins/webkul/recruitments/src/Models/JobPosition.php`
- E-04: `plugins/webkul/recruitments/src/Models/Stage.php`
- E-05: `plugins/webkul/recruitments/src/Models/CandidateSkill.php`
- E-06: `plugins/webkul/recruitments/src/Models/ApplicantCategory.php`
- E-07: `plugins/webkul/recruitments/src/Models/Degree.php`
- E-08: `plugins/webkul/recruitments/src/Models/RefuseReason.php`
- E-09: `plugins/webkul/recruitments/src/Models/JobPositionInterviewer.php`
- E-10: `plugins/webkul/recruitments/src/Models/ApplicantInterviewer.php`
- E-11: `plugins/webkul/recruitments/src/Models/StageJob.php`
- E-12: `plugins/webkul/recruitments/src/Models/ApplicantApplicantCategory.php`
- E-13: `plugins/webkul/recruitments/src/Models/CandidateApplicantCategory.php`
- E-14: `plugins/webkul/recruitments/src/Enums/ApplicationStatus.php`
- E-15: `plugins/webkul/recruitments/src/Enums/RecruitmentState.php`
- E-16: `plugins/webkul/recruitments/src/Traits/HasApplicationStatus.php`
- E-17: `plugins/webkul/recruitments/src/Traits/CandidateSkillRelation.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Applicant モデル (UT-REC-001 〜 UT-REC-033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | source()はUTMSourceへのbelongsToリレーション | E-01 L75-78 | ○ |
| C-02 | medium()はUTMMediumへのbelongsToリレーション | E-01 L80-83 | ○ |
| C-03 | candidate()はCandidateへのbelongsToリレーション | E-01 L85-88 | ○ |
| C-04 | skills()はhasManyThroughでCandidateSkillを取得 | E-01 L90-100 | ○ |
| C-05 | stage()はStageへのbelongsToリレーション | E-01 L102-105 | ○ |
| C-06 | lastStage()はStageへのbelongsTo（last_stage_id） | E-01 L107-110 | ○ |
| C-07 | company()はCompanyへのbelongsToリレーション | E-01 L112-115 | ○ |
| C-08 | recruiter()はUserへのbelongsTo（recruiter_id） | E-01 L117-120 | ○ |
| C-09 | interviewer()はbelongsToManyでUserを取得 | E-01 L122-125 | ○ |
| C-10 | categories()はbelongsToManyでApplicantCategoryを取得 | E-01 L127-130 | ○ |
| C-11 | job()はJobPositionへのbelongsTo（job_id） | E-01 L132-135 | ○ |
| C-12 | department()はDepartmentへのbelongsToリレーション | E-01 L137-140 | ○ |
| C-13 | refuseReason()はRefuseReasonへのbelongsToリレーション | E-01 L142-145 | ○ |
| C-14 | createdBy()はUserへのbelongsTo（creator_id） | E-01 L147-150 | ○ |
| C-15 | getStatusOptions()はApplicationStatus::options()を返却 | E-01 L152-155 | ○ |
| C-16 | setAsHired()はHIREDステータスに更新 | E-01 L157-160 | ○ |
| C-17 | setAsRefused()はREFUSEDステータスに更新 | E-01 L162-167 | ○ |
| C-18 | setAsArchived()はARCHIVEDステータスに更新 | E-01 L169-172 | ○ |
| C-19 | reopen()はONGOINGステータスに更新 | E-01 L174-177 | ○ |
| C-20 | updateStage()はステージデータを更新 | E-01 L179-182 | ○ |
| C-21 | getApplicationStatusAttribute()はステータスを判定 | E-01 L184-195 | ○ |
| C-22 | createEmployee()は従業員を作成 | E-01 L197-225 | ○ |
| C-23 | is_activeはbooleanにキャスト | E-01 L58 | ○ |
| C-24 | applicant_propertiesはjsonにキャスト | E-01 L64 | ○ |
| C-25 | salary_proposedはdoubleにキャスト | E-01 L67 | ○ |

### Candidate モデル (UT-REC-034 〜 UT-REC-048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | company()はCompanyへのbelongsToリレーション | E-02 L63-66 | ○ |
| C-27 | partner()はPartnerへのbelongsToリレーション | E-02 L68-71 | ○ |
| C-28 | degree()はDegreeへのbelongsToリレーション | E-02 L73-76 | ○ |
| C-29 | manager()はUserへのbelongsTo（manager_id） | E-02 L78-81 | ○ |
| C-30 | employee()はEmployeeへのbelongsToリレーション | E-02 L83-86 | ○ |
| C-31 | createdBy()はUserへのbelongsTo（creator_id） | E-02 L88-91 | ○ |
| C-32 | categories()はbelongsToManyでApplicantCategoryを取得 | E-02 L93-96 | ○ |
| C-33 | skills()はhasManyでCandidateSkillを取得 | E-02 L98-101 | ○ |
| C-34 | createEmployee()は従業員を作成 | E-02 L103-122 | ○ |
| C-35 | boot()でsavedイベントハンドラを登録 | E-02 L127-138 | ○ |
| C-36 | handlePartnerCreation()でPartnerを作成 | E-02 L143-156 | ○ |
| C-37 | handlePartnerUpdation()でPartnerを更新 | E-02 L161-179 | ○ |
| C-38 | candidate_propertiesは配列にキャスト | E-02 L59-61 | ○ |

### JobPosition モデル (UT-REC-049 〜 UT-REC-064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | address()はPartnerへのbelongsTo（sub_type条件付き） | E-03 L41-44 | ○ |
| C-40 | skills()はbelongsToManyでSkillを取得 | E-03 L46-49 | ○ |
| C-41 | interviewers()はbelongsToManyでUserを取得 | E-03 L51-54 | ○ |
| C-42 | manager()はEmployeeへのbelongsTo（manager_id） | E-03 L56-59 | ○ |
| C-43 | recruiter()はUserへのbelongsTo（recruiter_id） | E-03 L61-64 | ○ |
| C-44 | industry()はIndustryへのbelongsToリレーション | E-03 L66-69 | ○ |
| C-45 | noOfEmployee()はアクティブ従業員数を返却 | E-03 L71-82 | ○ |
| C-46 | noOfHiredEmployee()は採用済み応募者数を返却 | E-03 L84-98 | ○ |
| C-47 | expectedEmployees()は期待従業員数を計算 | E-03 L100-109 | ○ |
| C-48 | applications()はhasManyでApplicantを取得 | E-03 L111-114 | ○ |
| C-49 | boot()でupdatedイベントハンドラを登録 | E-03 L116-124 | ○ |
| C-50 | コンストラクタでfillable/castsをマージ | E-03 L21-39 | ○ |

### Stage モデル (UT-REC-065 〜 UT-REC-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | createdBy()はUserへのbelongsTo（creator_id） | E-04 L43-46 | ○ |
| C-52 | jobs()はbelongsToManyでEmployeeJobPositionを取得 | E-04 L48-51 | ○ |
| C-53 | SortableTraitでソート順を自動設定 | E-04 L38-41 | ○ |
| C-54 | is_defaultはbooleanにキャスト | E-04 L33 | ○ |
| C-55 | hired_stageはbooleanにキャスト | E-04 L34 | ○ |
| C-56 | foldはbooleanにキャスト | E-04 L35 | ○ |

### CandidateSkill モデル (UT-REC-071 〜 UT-REC-076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | candidate()はCandidateへのbelongsToリレーション | E-05 L24-27 | ○ |
| C-58 | skill()はSkillへのbelongsToリレーション | E-05 L29-32 | ○ |
| C-59 | skillLevel()はSkillLevelへのbelongsToリレーション | E-05 L34-37 | ○ |
| C-60 | skillType()はSkillTypeへのbelongsToリレーション | E-05 L39-42 | ○ |
| C-61 | creator()はUserへのbelongsTo（creator_id） | E-05 L44-47 | ○ |
| C-62 | user()はUserへのbelongsTo（user_id） | E-05 L49-52 | ○ |

### その他モデル (UT-REC-077 〜 UT-REC-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | ApplicantCategory.createdBy()はUserへのbelongsTo | E-06 L14-17 | ○ |
| C-64 | ApplicantCategoryのfillableにname/color/creator_id | E-06 L12 | ○ |
| C-65 | Degree.createdBy()はUserへのbelongsTo | E-07 L23-26 | ○ |
| C-66 | DegreeはSortableTraitを使用 | E-07 L12/L18-21 | ○ |
| C-67 | RefuseReason.createdBy()はUserへのbelongsTo | E-08 L23-26 | ○ |
| C-68 | RefuseReasonはSortableTraitを使用 | E-08 L12/L14-17 | ○ |
| C-69 | JobPositionInterviewer.jobPosition()リレーション | E-09 L16-19 | ○ |
| C-70 | JobPositionInterviewer.user()リレーション | E-09 L21-24 | ○ |
| C-71 | JobPositionInterviewerはtimestamps=false | E-09 L14 | ○ |
| C-72 | ApplicantInterviewerのfillable設定 | E-10 L13-16 | ○ |
| C-73 | ApplicantInterviewerはtimestamps=false | E-10 L11 | ○ |
| C-74 | StageJobのfillable設定 | E-11 L16-19 | ○ |
| C-75 | StageJobはtimestamps=false | E-11 L12 | ○ |
| C-76 | ApplicantApplicantCategoryのfillable設定 | E-12 L10 | ○ |
| C-77 | CandidateApplicantCategoryのfillable設定 | E-13 L10 | ○ |

### Enums (UT-REC-093 〜 UT-REC-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | ApplicationStatus.getLabel()で各ラベル取得 | E-14 L16-24 | ○ |
| C-79 | ApplicationStatus.getColor()で各色コード取得 | E-14 L26-34 | ○ |
| C-80 | ApplicationStatus.getIcon()で各アイコン取得 | E-14 L36-44 | ○ |
| C-81 | ApplicationStatus.options()で選択肢配列取得 | E-14 L46-54 | ○ |
| C-82 | RecruitmentState.getLabel()で各ラベル取得 | E-15 L16-22 | ○ |
| C-83 | RecruitmentState.getColor()で各色取得 | E-15 L24-30 | ○ |
| C-84 | RecruitmentState.getIcon()で各アイコン取得 | E-15 L32-38 | ○ |
| C-85 | RecruitmentState.options()で選択肢配列取得 | E-15 L40-48 | ○ |

### HasApplicationStatus Trait (UT-REC-106 〜 UT-REC-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | getApplicationStatusAttribute()でtrashed判定 | E-16 L13-29 | ○ |
| C-87 | scopeStatus()でステータスフィルタ | E-16 L32-50 | ○ |
| C-88 | updateStatus()でトランザクション処理 | E-16 L52-93 | ○ |
| C-89 | updateStatus()でREFUSED更新時の属性設定 | E-16 L62-67 | ○ |
| C-90 | updateStatus()でHIRED更新時の属性設定 | E-16 L68-72 | ○ |
| C-91 | updateStatus()でONGOING更新時の属性設定 | E-16 L73-79 | ○ |
| C-92 | updateStatus()でARCHIVED更新時の属性設定 | E-16 L80-86 | ○ |
| C-93 | updateStatus()でtrashedからの復元 | E-16 L57-59 | ○ |
| C-94 | scopeWithArchived()でwithTrashed適用 | E-16 L95-98 | ○ |
| C-95 | scopeOnlyArchived()でonlyTrashed適用 | E-16 L100-103 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**：全テストケースがソースコードの実装に基づいている
- **1: 中リスク**：以下の項目は実装の複雑さから追加の検証を推奨
  - Applicant.createEmployee(): 従業員作成時の条件分岐
  - Candidate.boot(): Partner自動作成/更新のサイクル
  - HasApplicationStatus.updateStatus(): トランザクションとステータス遷移

## 6) レビュアーチェックリスト（最小）
- [ ] Applicantモデルの全リレーション（13個）が正しく定義されているか確認
- [ ] getApplicationStatusAttributeのステータス判定優先順位（REFUSED > ARCHIVED > HIRED > ONGOING）が正しいか確認
- [ ] createEmployee()のpartner_id必須チェックと既存employee_idチェックのロジックを確認
- [ ] Candidate.boot()のPartner自動作成・更新ロジックが無限ループしないか確認
- [ ] JobPosition.noOfEmployee/noOfHiredEmployeeのonce()キャッシュ動作を確認
- [ ] HasApplicationStatus.updateStatus()のトランザクション処理とrestore処理を確認
- [ ] 中間テーブルモデル（ApplicantInterviewer, StageJob等）のtimestamps=false設定を確認
