---
generated_at: 2025-12-29 14:30:00
metrics:
  claims_total: 171
  claims_with_evidence: 171
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：sales.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：171 / 171、根拠なし：0
- 優先レビュー（高）
  1. **SaleManager計算ロジック**：金額計算・税計算の正確性確認推奨
  2. **状態遷移テスト**：DRAFT->SENT->SALE->CANCELの遷移パターン確認推奨
  3. **プルルール適用ロジック**：在庫連携の例外ケース確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/sales/src/Models/Order.php`
- E-02: `plugins/webkul/sales/src/Models/OrderLine.php`
- E-03: `plugins/webkul/sales/src/Models/Team.php`
- E-04: `plugins/webkul/sales/src/Models/Category.php`
- E-05: `plugins/webkul/sales/src/Models/Product.php`
- E-06: `plugins/webkul/sales/src/Models/Partner.php`
- E-07: `plugins/webkul/sales/src/Models/Tag.php`
- E-08: `plugins/webkul/sales/src/Models/Attribute.php`
- E-09: `plugins/webkul/sales/src/Models/OrderTemplate.php`
- E-10: `plugins/webkul/sales/src/Models/OrderTemplateProduct.php`
- E-11: `plugins/webkul/sales/src/Models/OrderOption.php`
- E-12: `plugins/webkul/sales/src/Models/TeamMember.php`
- E-13: `plugins/webkul/sales/src/Models/Packaging.php`
- E-14: `plugins/webkul/sales/src/Models/AdvancedPaymentInvoice.php`
- E-15: `plugins/webkul/sales/src/Models/AdvancedPaymentInvoiceOrderSale.php`
- E-16: `plugins/webkul/sales/src/Models/ActivityPlan.php`
- E-17: `plugins/webkul/sales/src/Models/ActivityType.php`
- E-18: `plugins/webkul/sales/src/SaleManager.php`
- E-19: `plugins/webkul/sales/src/Enums/OrderState.php`
- E-20: `plugins/webkul/sales/src/Enums/InvoiceStatus.php`
- E-21: `plugins/webkul/sales/src/Enums/OrderDisplayType.php`
- E-22: `plugins/webkul/sales/src/Enums/AdvancedPayment.php`
- E-23: `plugins/webkul/sales/src/Enums/QtyDeliveredMethod.php`
- E-24: `plugins/webkul/sales/src/Enums/OrderDeliveryStatus.php`
- E-25: `plugins/webkul/sales/src/Settings/InvoiceSettings.php`
- E-26: `plugins/webkul/sales/src/Settings/QuotationAndOrderSettings.php`
- E-27: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Actions/ConfirmAction.php`
- E-28: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Actions/CancelQuotationAction.php`
- E-29: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Actions/SendByEmailAction.php`
- E-30: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Actions/CreateInvoiceAction.php`
- E-31: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Actions/BackToQuotationAction.php`
- E-32: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Actions/LockAndUnlockAction.php`
- E-33: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Actions/PreviewAction.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Orderモデル関連（C-01〜C-26）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Order.companyリレーション正常動作 | E-01 L116-119 | ○ |
| C-02 | Order.company null時の挙動 | E-01 L116-119 | ○ |
| C-03 | Order.partnerリレーション正常動作 | E-01 L121-124 | ○ |
| C-04 | Order.getQtyToInvoiceAttribute計算 | E-01 L126-129 | ○ |
| C-05 | Order.getQtyToInvoiceAttribute空配列 | E-01 L126-129 | ○ |
| C-06 | Order.campaignリレーション正常動作 | E-01 L131-134 | ○ |
| C-07 | Order.journalリレーション正常動作 | E-01 L136-139 | ○ |
| C-08 | Order.accountMovesリレーション正常動作 | E-01 L141-144 | ○ |
| C-09 | Order.partnerInvoiceリレーション正常動作 | E-01 L146-149 | ○ |
| C-10 | Order.partnerShippingリレーション正常動作 | E-01 L156-159 | ○ |
| C-11 | Order.tagsリレーション正常動作 | E-01 L151-154 | ○ |
| C-12 | Order.fiscalPositionリレーション正常動作 | E-01 L161-164 | ○ |
| C-13 | Order.paymentTermリレーション正常動作 | E-01 L166-169 | ○ |
| C-14 | Order.currencyリレーション正常動作 | E-01 L171-174 | ○ |
| C-15 | Order.userリレーション正常動作 | E-01 L176-179 | ○ |
| C-16 | Order.teamリレーション正常動作 | E-01 L181-184 | ○ |
| C-17 | Order.linesリレーション正常動作 | E-01 L201-204 | ○ |
| C-18 | Order.optionalLinesリレーション正常動作 | E-01 L206-209 | ○ |
| C-19 | Order.quotationTemplateリレーション正常動作 | E-01 L211-214 | ○ |
| C-20 | Order.warehouseリレーション正常動作 | E-01 L216-219 | ○ |
| C-21 | Order.operationsリレーション正常動作 | E-01 L221-224 | ○ |
| C-22 | Order.boot saving時updateName呼出 | E-01 L226-237 | ○ |
| C-23 | Order.boot created時name更新 | E-01 L234-236 | ○ |
| C-24 | Order.updateName SO/{id}形式 | E-01 L242-245 | ○ |
| C-25 | Order.casts state Enum変換 | E-01 L111-114 | ○ |
| C-26 | Order.casts invoice_status Enum変換 | E-01 L111-114 | ○ |

### OrderLineモデル関連（C-27〜C-43）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | OrderLine.orderリレーション正常動作 | E-02 L88-91 | ○ |
| C-28 | OrderLine.companyリレーション正常動作 | E-02 L93-96 | ○ |
| C-29 | OrderLine.currencyリレーション正常動作 | E-02 L98-101 | ○ |
| C-30 | OrderLine.orderPartnerリレーション正常動作 | E-02 L103-106 | ○ |
| C-31 | OrderLine.salesmanリレーション正常動作 | E-02 L108-111 | ○ |
| C-32 | OrderLine.productリレーション正常動作 | E-02 L113-116 | ○ |
| C-33 | OrderLine.uomリレーション正常動作 | E-02 L118-121 | ○ |
| C-34 | OrderLine.taxesリレーション正常動作 | E-02 L123-126 | ○ |
| C-35 | OrderLine.accountMoveLinesリレーション正常動作 | E-02 L128-131 | ○ |
| C-36 | OrderLine.inventoryMovesリレーション正常動作 | E-02 L133-136 | ○ |
| C-37 | OrderLine.productPackagingリレーション正常動作 | E-02 L138-141 | ○ |
| C-38 | OrderLine.linkedSaleOrderSaleリレーション正常動作 | E-02 L143-146 | ○ |
| C-39 | OrderLine.createdByリレーション正常動作 | E-02 L148-151 | ○ |
| C-40 | OrderLine.warehouseリレーション正常動作 | E-02 L153-156 | ○ |
| C-41 | OrderLine.routeリレーション正常動作 | E-02 L158-161 | ○ |
| C-42 | OrderLine.casts qty_delivered_method Enum変換 | E-02 L78-81 | ○ |
| C-43 | OrderLine.sortable自動ソート | E-02 L83-86 | ○ |

### Teamモデル関連（C-44〜C-49）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | Team.companyリレーション正常動作 | E-03 L47-50 | ○ |
| C-45 | Team.userリレーション正常動作 | E-03 L52-55 | ○ |
| C-46 | Team.createdByリレーション正常動作 | E-03 L57-60 | ○ |
| C-47 | Team.membersリレーション正常動作 | E-03 L62-65 | ○ |
| C-48 | Team.newFactory正常生成 | E-03 L67-70 | ○ |
| C-49 | Team.sortable自動ソート | E-03 L33-36 | ○ |

### Categoryモデル関連（C-50）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | Category.productsリレーション正常動作 | E-04 L10-13 | ○ |

### Tagモデル関連（C-51）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | Tag.createdByリレーション正常動作 | E-07 L21-24 | ○ |

### OrderTemplateモデル関連（C-52〜C-58）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | OrderTemplate.companyリレーション正常動作 | E-09 L39-42 | ○ |
| C-53 | OrderTemplate.createdByリレーション正常動作 | E-09 L44-47 | ○ |
| C-54 | OrderTemplate.journalリレーション正常動作 | E-09 L49-52 | ○ |
| C-55 | OrderTemplate.productsリレーションフィルタリング | E-09 L54-59 | ○ |
| C-56 | OrderTemplate.sectionsリレーションフィルタリング | E-09 L61-66 | ○ |
| C-57 | OrderTemplate.notesリレーションフィルタリング | E-09 L68-73 | ○ |
| C-58 | OrderTemplate.sortable自動ソート | E-09 L34-37 | ○ |

### OrderTemplateProductモデル関連（C-59〜C-67）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | OrderTemplateProduct.orderTemplateリレーション正常動作 | E-10 L25-28 | ○ |
| C-60 | OrderTemplateProduct.companyリレーション正常動作 | E-10 L30-33 | ○ |
| C-61 | OrderTemplateProduct.productリレーション正常動作 | E-10 L35-38 | ○ |
| C-62 | OrderTemplateProduct.uomリレーション正常動作 | E-10 L40-43 | ○ |
| C-63 | OrderTemplateProduct.createdByリレーション正常動作 | E-10 L45-48 | ○ |
| C-64 | OrderTemplateProduct.boot creating company_idデフォルト設定 | E-10 L53-62 | ○ |
| C-65 | OrderTemplateProduct.boot creating product_idデフォルト設定 | E-10 L53-62 | ○ |
| C-66 | OrderTemplateProduct.boot creating product_uom_idデフォルト設定 | E-10 L53-62 | ○ |
| C-67 | OrderTemplateProduct.boot creating creator_idデフォルト設定 | E-10 L53-62 | ○ |

### OrderOptionモデル関連（C-68〜C-73）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | OrderOption.orderリレーション正常動作 | E-11 L35-38 | ○ |
| C-69 | OrderOption.productリレーション正常動作 | E-11 L40-43 | ○ |
| C-70 | OrderOption.lineリレーション正常動作 | E-11 L45-48 | ○ |
| C-71 | OrderOption.uomリレーション正常動作 | E-11 L50-53 | ○ |
| C-72 | OrderOption.creatorリレーション正常動作 | E-11 L55-58 | ○ |
| C-73 | OrderOption.sortable自動ソート | E-11 L30-33 | ○ |

### AdvancedPaymentInvoiceモデル関連（C-74〜C-77）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | AdvancedPaymentInvoice.currencyリレーション正常動作 | E-14 L26-29 | ○ |
| C-75 | AdvancedPaymentInvoice.companyリレーション正常動作 | E-14 L31-34 | ○ |
| C-76 | AdvancedPaymentInvoice.creatorリレーション正常動作 | E-14 L36-39 | ○ |
| C-77 | AdvancedPaymentInvoice.ordersリレーション正常動作 | E-14 L41-44 | ○ |

### AdvancedPaymentInvoiceOrderSaleモデル関連（C-78〜C-79）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | AdvancedPaymentInvoiceOrderSale.advancePaymentInvoiceリレーション正常動作 | E-15 L18-21 | ○ |
| C-79 | AdvancedPaymentInvoiceOrderSale.orderリレーション正常動作 | E-15 L23-26 | ○ |

### SaleManager関連（C-80〜C-137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | confirmSaleOrder stateをSALEに変更 | E-18 L64-77 | ○ |
| C-81 | confirmSaleOrder invoice_statusをTO_INVOICEに変更 | E-18 L68-71 | ○ |
| C-82 | confirmSaleOrder locked設定反映 | E-18 L71 | ○ |
| C-83 | confirmSaleOrder プルルール未設定時例外 | E-18 L661-663 | ○ |
| C-84 | backToQuotation stateをDRAFTに変更 | E-18 L79-89 | ○ |
| C-85 | backToQuotation invoice_statusをNOに変更 | E-18 L81-84 | ○ |
| C-86 | cancelSaleOrder stateをCANCELに変更 | E-18 L91-107 | ○ |
| C-87 | cancelSaleOrder invoice_statusをNOに変更 | E-18 L93-96 | ○ |
| C-88 | cancelSaleOrder data付きでメール送信実行 | E-18 L98-100 | ○ |
| C-89 | lockAndUnlock locked true→false | E-18 L55-62 | ○ |
| C-90 | lockAndUnlock locked false→true | E-18 L55-62 | ○ |
| C-91 | createInvoice DELIVERED時AccountMove作成 | E-18 L109-129 | ○ |
| C-92 | createInvoice AdvancedPaymentInvoice作成 | E-18 L116-125 | ○ |
| C-93 | computeSaleOrder 合計金額計算 | E-18 L134-164 | ○ |
| C-94 | computeSaleOrder 明細なし時0 | E-18 L136-138 | ○ |
| C-95 | computeSaleOrderLine 小計計算 | E-18 L169-220 | ○ |
| C-96 | computeSaleOrderLine 割引適用 | E-18 L181-185 | ○ |
| C-97 | computeSaleOrderLine 税金計算 | E-18 L189-195 | ○ |
| C-98 | computeSaleOrderLine 割引0時スキップ | E-18 L181 | ○ |
| C-99 | computeQtyInvoiced 請求済み数量計算 | E-18 L222-244 | ○ |
| C-100 | computeQtyInvoiced 返金分減算 | E-18 L235-237 | ○ |
| C-101 | computeQtyInvoiced キャンセル済み除外 | E-18 L227-229 | ○ |
| C-102 | computeQtyDelivered MANUAL時手動値使用 | E-18 L248-250 | ○ |
| C-103 | computeQtyDelivered STOCK_MOVE時在庫から計算 | E-18 L252-274 | ○ |
| C-104 | computeQtyDelivered 返品分減算 | E-18 L265-271 | ○ |
| C-105 | computeWarehouseId 会社紐づき倉庫設定 | E-18 L279-293 | ○ |
| C-106 | computeWarehouseId プラグイン未インストール時スキップ | E-18 L281-283 | ○ |
| C-107 | computeDeliveryStatus オペレーションなし時NO | E-18 L303-306 | ○ |
| C-108 | computeDeliveryStatus 全CANCELED時NO | E-18 L303-306 | ○ |
| C-109 | computeDeliveryStatus 全DONE時FULL | E-18 L307-310 | ○ |
| C-110 | computeDeliveryStatus 一部DONE時PARTIAL | E-18 L311-314 | ○ |
| C-111 | computeDeliveryStatus DONEなし時PENDING | E-18 L315-317 | ○ |
| C-112 | computeInvoiceStatus SALE以外時NO | E-18 L322-328 | ○ |
| C-113 | computeInvoiceStatus TO_INVOICE含む時TO_INVOICE | E-18 L330-333 | ○ |
| C-114 | computeInvoiceStatus 全INVOICED時INVOICED | E-18 L334-337 | ○ |
| C-115 | computeOrderLineInvoiceStatus SALE以外時NO | E-18 L360-366 | ○ |
| C-116 | computeOrderLineInvoiceStatus downpayment金額0時INVOICED | E-18 L370-375 | ○ |
| C-117 | computeOrderLineInvoiceStatus ORDER_POLICY計算 | E-18 L375-382 | ○ |
| C-118 | computeOrderLineInvoiceStatus DELIVERY_POLICY計算 | E-18 L383-391 | ○ |
| C-119 | computeOrderLineUntaxedAmountToInvoice DELIVERY_POLICY配送数量計算 | E-18 L407-409 | ○ |
| C-120 | computeOrderLineUntaxedAmountToInvoice ORDER_POLICY注文数量計算 | E-18 L410-411 | ○ |
| C-121 | computeOrderLineUntaxedAmountToInvoice SALE以外時0 | E-18 L399-403 | ○ |
| C-122 | sendByEmail パートナーへメール送信 | E-18 L444-506 | ○ |
| C-123 | sendByEmail メールアドレスなし時失敗追加 | E-18 L452-456 | ○ |
| C-124 | sendByEmail メール例外時失敗追加 | E-18 L492-494 | ○ |
| C-125 | sendByEmail 送信成功時SENT変更 | E-18 L497-500 | ○ |
| C-126 | getOutgoingIncomingMoves 出荷移動分類 | E-18 L540-594 | ○ |
| C-127 | getOutgoingIncomingMoves 返品移動分類 | E-18 L585-587 | ○ |
| C-128 | getOutgoingIncomingMoves キャンセル済み除外 | E-18 L546-550 | ○ |
| C-129 | applyPullRules 全明細にルール適用 | E-18 L650-688 | ○ |
| C-130 | applyPullRules ルール未設定時例外 | E-18 L661-663 | ○ |
| C-131 | applyPullRules プラグイン未インストール時スキップ | E-18 L652-654 | ○ |
| C-132 | runPullRule MANUAL時InventoryMove作成 | E-18 L746-785 | ○ |
| C-133 | runPullRule 非MANUAL時null返却 | E-18 L748-750 | ○ |
| C-134 | getPullRule 製品ルートから検索 | E-18 L790-812 | ○ |
| C-135 | getPullRule カテゴリルートから検索 | E-18 L823-828 | ○ |
| C-136 | getPullRule 倉庫ルートから検索 | E-18 L823-828 | ○ |
| C-137 | getPullRule 親ロケーション遡り検索 | E-18 L798-809 | ○ |

### Enum関連（C-138〜C-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | OrderState.getLabel DRAFT | E-19 L18-26 | ○ |
| C-139 | OrderState.getLabel SENT | E-19 L18-26 | ○ |
| C-140 | OrderState.getLabel SALE | E-19 L18-26 | ○ |
| C-141 | OrderState.getLabel CANCEL | E-19 L18-26 | ○ |
| C-142 | OrderState.options 全オプション返却 | E-19 L28-35 | ○ |
| C-143 | OrderState.getColor 各状態色返却 | E-19 L37-44 | ○ |
| C-144 | InvoiceStatus.getLabel 全ステータス | E-20 L17-24 | ○ |
| C-145 | InvoiceStatus.options 全オプション返却 | E-20 L26-33 | ○ |
| C-146 | OrderDeliveryStatus.getLabel 全ステータス | E-24 L28-35 | ○ |
| C-147 | OrderDeliveryStatus.getColor 各状態色返却 | E-24 L37-44 | ○ |
| C-148 | AdvancedPayment.getLabel 全タイプ | E-22 L15-21 | ○ |
| C-149 | QtyDeliveredMethod.getLabel 全メソッド | E-23 L13-18 | ○ |
| C-150 | OrderDisplayType.getLabel 全タイプ | E-21 L13-18 | ○ |

### Settings関連（C-151〜C-152）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-151 | InvoiceSettings.group グループ名返却 | E-25 L12-15 | ○ |
| C-152 | QuotationAndOrderSettings.group グループ名返却 | E-26 L13-16 | ○ |

### Filamentアクション関連（C-153〜C-171）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-153 | ConfirmAction.action confirmSaleOrder呼出 | E-27 L28-31 | ○ |
| C-154 | ConfirmAction.action 例外時エラー通知 | E-27 L31-39 | ○ |
| C-155 | ConfirmAction.hidden SALE状態時非表示 | E-27 L27 | ○ |
| C-156 | CancelQuotationAction.action cancelSaleOrder呼出 | E-28 L34-50 | ○ |
| C-157 | CancelQuotationAction.action メール送信付きキャンセル | E-28 L42-48 | ○ |
| C-158 | CancelQuotationAction.hidden DRAFT/SENT/SALE以外非表示 | E-28 L99 | ○ |
| C-159 | SendByEmailAction.action sendQuotationOrOrderByEmail呼出 | E-29 L82-88 | ○ |
| C-160 | SendByEmailAction.hidden SALE状態時非表示 | E-29 L81 | ○ |
| C-161 | SendByEmailAction.handleEmailResults 全成功時success通知 | E-29 L110-117 | ○ |
| C-162 | SendByEmailAction.handleEmailResults 全失敗時danger通知 | E-29 L119-127 | ○ |
| C-163 | SendByEmailAction.handleEmailResults 部分成功時warning通知 | E-29 L129-136 | ○ |
| C-164 | CreateInvoiceAction.action createInvoice呼出 | E-30 L66-74 | ○ |
| C-165 | CreateInvoiceAction.hidden TO_INVOICE以外非表示 | E-30 L65 | ○ |
| C-166 | BackToQuotationAction.action backToQuotation呼出 | E-31 L25-35 | ○ |
| C-167 | BackToQuotationAction.hidden CANCEL以外非表示 | E-31 L24 | ○ |
| C-168 | LockAndUnlockAction.action lockAndUnlock呼出 | E-32 L25-27 | ○ |
| C-169 | LockAndUnlockAction.visible 設定有効時のみ表示 | E-32 L28 | ○ |
| C-170 | LockAndUnlockAction.label ロック時Unlockラベル | E-32 L22 | ○ |
| C-171 | LockAndUnlockAction.label アンロック時Lockラベル | E-32 L22 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのClaimに対してソースコードからの根拠が確認できたため、不足情報はありません。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に信頼度が高い
- 注意点:
  - **SaleManager**の金額計算ロジック（computeSaleOrderLine）は複雑なため、実際のテスト実装時に境界値ケースを追加検討推奨
  - **applyPullRules**の在庫連携部分はinventoriesプラグインとの依存があるため、統合テストも併せて検討推奨
  - **状態遷移**（DRAFT->SENT->SALE->CANCEL）のパターンは網羅されているが、不正な遷移（例: SALE->DRAFT）のテストも検討推奨

## 6) レビュアーチェックリスト（最小）
- [ ] SaleManager.computeSaleOrderLineの税計算ロジックが正しいか確認（L203のコメント「Todo:: This calculation is wrong」に注意）
- [ ] 状態遷移の不正パターンテストが必要か判断
- [ ] inventoriesプラグイン未インストール時の挙動テストが十分か確認
- [ ] 多対多リレーション（accountMoves, tags, taxes等）のテストが適切か確認
- [ ] bootメソッドのデフォルト値設定テスト（OrderTemplateProduct）が必要十分か確認
