---
generated_at: 2025-12-29 12:00:00
metrics:
  claims_total: 94
  claims_with_evidence: 94
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：website.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：94 / 94、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースはソースコードに基づいて生成されており、根拠不足の項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/website/src/Models/Page.php`
- E-02: `plugins/webkul/website/src/Models/Partner.php`
- E-03: `plugins/webkul/website/src/Policies/PagePolicy.php`
- E-04: `plugins/webkul/website/src/Policies/PartnerPolicy.php`
- E-05: `plugins/webkul/website/src/Settings/ContactSettings.php`
- E-06: `plugins/webkul/website/src/Filament/Customer/Auth/Login.php`
- E-07: `plugins/webkul/website/src/Filament/Customer/Auth/Register.php`
- E-08: `plugins/webkul/website/src/Filament/Customer/Auth/PasswordReset/RequestPasswordReset.php`
- E-09: `plugins/webkul/website/src/Filament/Customer/Auth/PasswordReset/ResetPassword.php`
- E-10: `plugins/webkul/website/src/Http/Responses/LogoutResponse.php`
- E-11: `plugins/webkul/website/src/Filament/Customer/Pages/Homepage.php`
- E-12: `plugins/webkul/website/src/WebsiteServiceProvider.php`
- E-13: `plugins/webkul/website/src/Filament/Admin/Resources/PageResource.php`
- E-14: `plugins/webkul/website/src/Filament/Admin/Resources/PartnerResource.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### Models

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page::creator()がBelongsToリレーションを返す | E-01 (L54-57) | ○ |
| C-02 | creator_idがnullの場合nullが返る | E-01 (BelongsTo仕様) | ○ |
| C-03 | is_publishedがbooleanにキャストされる | E-01 (L48) | ○ |
| C-04 | is_header_visibleがbooleanにキャストされる | E-01 (L49) | ○ |
| C-05 | is_footer_visibleがbooleanにキャストされる | E-01 (L50) | ○ |
| C-06 | published_atがdatetimeにキャストされる | E-01 (L51) | ○ |
| C-07 | fillable属性でマスアサインメントが可能 | E-01 (L28-40) | ○ |
| C-08 | fillableに含まれない属性はマスアサインメントされない | E-01 (fillable定義) | ○ |
| C-09 | newFactory()がPageFactoryを返す | E-01 (L59-62) | ○ |
| C-10 | SoftDeletesトレイトで論理削除が動作 | E-01 (L14) | ○ |
| C-11 | 論理削除されたレコードがrestore可能 | E-01 (SoftDeletes仕様) | ○ |
| C-12 | Partner::__construct()でfillableがマージされる | E-02 (L26-29) | ○ |
| C-13 | Partner::__construct()でcastsがマージされる | E-02 (L31-34) | ○ |
| C-14 | passwordがhashedにキャストされる | E-02 (L33) | ○ |
| C-15 | email_verified_atがdatetimeにキャストされる | E-02 (L32) | ○ |
| C-16 | passwordがシリアライズ時に非表示 | E-02 (L14-17) | ○ |
| C-17 | remember_tokenがシリアライズ時に非表示 | E-02 (L14-17) | ○ |

### Policies

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | PagePolicy::viewAny()がview_any_page権限をチェック | E-03 (L16-19) | ○ |
| C-19 | PagePolicy::viewAny()が権限なしでfalseを返す | E-03 (L16-19) | ○ |
| C-20 | PagePolicy::view()がview_page権限をチェック | E-03 (L24-27) | ○ |
| C-21 | PagePolicy::view()が権限なしでfalseを返す | E-03 (L24-27) | ○ |
| C-22 | PagePolicy::create()がcreate_page権限をチェック | E-03 (L32-35) | ○ |
| C-23 | PagePolicy::create()が権限なしでfalseを返す | E-03 (L32-35) | ○ |
| C-24 | PagePolicy::update()がupdate_page権限をチェック | E-03 (L40-43) | ○ |
| C-25 | PagePolicy::update()が権限なしでfalseを返す | E-03 (L40-43) | ○ |
| C-26 | PagePolicy::delete()がdelete_page権限をチェック | E-03 (L48-51) | ○ |
| C-27 | PagePolicy::delete()が権限なしでfalseを返す | E-03 (L48-51) | ○ |
| C-28 | PagePolicy::deleteAny()がdelete_any_page権限をチェック | E-03 (L56-59) | ○ |
| C-29 | PagePolicy::forceDelete()がforce_delete_page権限をチェック | E-03 (L64-67) | ○ |
| C-30 | PagePolicy::forceDeleteAny()がforce_delete_any_page権限をチェック | E-03 (L72-75) | ○ |
| C-31 | PagePolicy::restore()がrestore_page権限をチェック | E-03 (L80-83) | ○ |
| C-32 | PagePolicy::restoreAny()がrestore_any_page権限をチェック | E-03 (L88-91) | ○ |
| C-33 | PartnerPolicy::viewAny()がview_any_partner権限をチェック | E-04 (L16-19) | ○ |
| C-34 | PartnerPolicy::viewAny()が権限なしでfalseを返す | E-04 (L16-19) | ○ |
| C-35 | PartnerPolicy::view()がview_partner権限をチェック | E-04 (L24-27) | ○ |
| C-36 | PartnerPolicy::create()がcreate_partner権限をチェック | E-04 (L32-35) | ○ |
| C-37 | PartnerPolicy::update()がupdate_partner権限をチェック | E-04 (L40-43) | ○ |
| C-38 | PartnerPolicy::delete()がdelete_partner権限をチェック | E-04 (L48-51) | ○ |
| C-39 | PartnerPolicy::deleteAny()がdelete_any_partner権限をチェック | E-04 (L56-59) | ○ |
| C-40 | PartnerPolicy::forceDelete()がforce_delete_partner権限をチェック | E-04 (L64-67) | ○ |
| C-41 | PartnerPolicy::forceDeleteAny()がforce_delete_any_partner権限をチェック | E-04 (L72-75) | ○ |
| C-42 | PartnerPolicy::restore()がrestore_partner権限をチェック | E-04 (L80-83) | ○ |
| C-43 | PartnerPolicy::restoreAny()がrestore_any_partner権限をチェック | E-04 (L88-91) | ○ |

### Settings

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | ContactSettings::group()が"website_contact"を返す | E-05 (L33-36) | ○ |
| C-45 | emailプロパティがnull許容 | E-05 (L9) | ○ |
| C-46 | phoneプロパティがnull許容 | E-05 (L11) | ○ |
| C-47 | SNS関連プロパティがnull許容 | E-05 (L13-31) | ○ |

### Auth - Login

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Login::mount()が認証済みユーザーをリダイレクト | E-06 (L36-39) | ○ |
| C-49 | Login::mount()が未認証ユーザーのフォームを初期化 | E-06 (L36-42) | ○ |
| C-50 | Login::authenticate()が正しい認証情報でログイン | E-06 (L44-74) | ○ |
| C-51 | Login::authenticate()が不正な認証情報でValidationExceptionをスロー | E-06 (L56-58, L90-95) | ○ |
| C-52 | Login::authenticate()がレート制限超過時にnullを返す | E-06 (L46-52) | ○ |
| C-53 | Login::authenticate()がFilamentUserパネルアクセス不可時にログアウト | E-06 (L62-69) | ○ |
| C-54 | Login::getCredentialsFromFormData()が認証情報を抽出 | E-06 (L183-189) | ○ |
| C-55 | Login::getEmailFormComponent()がメールフォームを返す | E-06 (L117-126) | ○ |
| C-56 | Login::getPasswordFormComponent()がパスワードフォームを返す | E-06 (L128-138) | ○ |
| C-57 | Login::getRememberFormComponent()がチェックボックスを返す | E-06 (L140-144) | ○ |

### Auth - Register

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | Register::mount()が認証済みユーザーをリダイレクト | E-07 (L44-47) | ○ |
| C-59 | Register::mount()が未認証ユーザーのフォームを初期化 | E-07 (L44-54) | ○ |
| C-60 | Register::register()が有効なデータでユーザー登録 | E-07 (L56-95) | ○ |
| C-61 | Register::register()がレート制限超過時にnullを返す | E-07 (L58-64) | ○ |
| C-62 | Register::register()がRegisteredイベントを発火 | E-07 (L86) | ○ |
| C-63 | Register::register()がMustVerifyEmail実装時にメール検証通知を送信 | E-07 (L88) | ○ |
| C-64 | Register::handleRegistration()がユーザーを作成 | E-07 (L111-114) | ○ |
| C-65 | Register::sendEmailVerificationNotification()が未検証ユーザーに通知 | E-07 (L116-136) | ○ |
| C-66 | Register::sendEmailVerificationNotification()がMustVerifyEmail未実装時に早期リターン | E-07 (L118-120) | ○ |
| C-67 | Register::sendEmailVerificationNotification()が検証済みユーザーに通知しない | E-07 (L122-124) | ○ |
| C-68 | Register::sendEmailVerificationNotification()がnotify()なしで例外をスロー | E-07 (L126-129) | ○ |
| C-69 | Register::getUserModel()がモデルクラスを取得 | E-07 (L209-222) | ○ |
| C-70 | Register::getPasswordFormComponent()がHash::makeでデハイドレート | E-07 (L186) | ○ |

### Auth - PasswordReset

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | RequestPasswordReset::mount()が認証済みユーザーをリダイレクト | E-08 (L34-38) | ○ |
| C-72 | RequestPasswordReset::request()が有効なメールでリセットリンクを送信 | E-08 (L43-86) | ○ |
| C-73 | RequestPasswordReset::request()が無効なメールでエラー通知を送信 | E-08 (L71-78) | ○ |
| C-74 | RequestPasswordReset::request()がレート制限超過時に早期リターン | E-08 (L45-51) | ○ |
| C-75 | RequestPasswordReset::request()がnotify()なしで例外をスロー | E-08 (L58-62) | ○ |
| C-76 | ResetPassword::mount()が認証済みユーザーをリダイレクト | E-09 (L48-52) | ○ |
| C-77 | ResetPassword::mount()がトークンとメールをフォームに設定 | E-09 (L48-59) | ○ |
| C-78 | ResetPassword::resetPassword()が有効なトークンでパスワードをリセット | E-09 (L61-103) | ○ |
| C-79 | ResetPassword::resetPassword()が無効なトークンでエラー通知を送信 | E-09 (L97-102) | ○ |
| C-80 | ResetPassword::resetPassword()がレート制限超過時にnullを返す | E-09 (L63-69) | ○ |
| C-81 | ResetPassword::resetPassword()がPasswordResetイベントを発火 | E-09 (L84) | ○ |
| C-82 | ResetPassword::resetPassword()がHash::makeでパスワードをハッシュ化 | E-09 (L80) | ○ |
| C-83 | ResetPassword::resetPassword()がremember_tokenを再生成 | E-09 (L81) | ○ |

### Http - LogoutResponse

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | LogoutResponse::toResponse()がcustomer.auth.logoutからHomepageにリダイレクト | E-10 (L12-14) | ○ |
| C-85 | LogoutResponse::toResponse()がその他のルートからadmin.auth.loginにリダイレクト | E-10 (L15) | ○ |

### Pages - Homepage

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | Homepage::getNavigationLabel()が"Home"を返す | E-11 (L21-24) | ○ |
| C-87 | Homepage::getRoutePath()が"/"を返す | E-11 (L26-29) | ○ |
| C-88 | Homepage::getTitle()が"Homepage"を返す | E-11 (L31-34) | ○ |
| C-89 | Homepage::getContent()がhomeページのコンテンツを返す | E-11 (L36-41) | ○ |
| C-90 | Homepage::getContent()がhomeページなしで空文字を返す | E-11 (L40) | ○ |

### ServiceProvider

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | WebsiteServiceProvider::configureCustomPackage()がパッケージ名を設定 | E-12 (L22) | ○ |
| C-92 | WebsiteServiceProvider::packageBooted()がプラグイン未インストール時にリダイレクト | E-12 (L49-53) | ○ |
| C-93 | WebsiteServiceProvider::packageRegistered()がLogoutResponseをバインド | E-12 (L58) | ○ |
| C-94 | WebsiteServiceProvider::registerCustomCss()がCSSアセットを登録 | E-12 (L61-66) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全てのテストケースはソースコード内の実装に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのClaimに対して根拠が確認できています
- 認証・認可関連のテストケース（UT-WEB-018〜UT-WEB-043, UT-WEB-048〜UT-WEB-083）はセキュリティに直結するため、実装時に特に注意が必要です
- パスワードハッシュ化のテストケース（UT-WEB-014, UT-WEB-070, UT-WEB-082）はセキュリティクリティカルな機能です

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテスト観点（正常系/異常系/境界値）が適切か
- [ ] 優先度の設定が妥当か（特にセキュリティ関連は高優先度になっているか）
- [ ] 前提条件と期待結果の記述が明確か
- [ ] テストIDの命名規則（UT-WEB-XXX）が一貫しているか
- [ ] SoftDeletesトレイトの論理削除/復元テストが含まれているか
- [ ] 認証フロー（Login, Register, PasswordReset）の網羅性が十分か
- [ ] ポリシーの全メソッド（viewAny, view, create, update, delete, forceDelete, restore等）がカバーされているか
