---
generated_at: 2025-12-27 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 45
  claims_without_evidence: 5
confidence_derived: 0.90
---

# 根拠レポート：単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：45 / 50、根拠なし：5
- 優先レビュー（高）
  1. **UT-024 addMessage未認証時の動作**：実際の認証状態でのテストが必要
  2. **UT-026 EmailService例外処理**：SMTP設定エラー時の挙動確認が必要
  3. **UT-031 UserPermissionScope適用**：グローバルスコープの適用確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/Models/User.php` - App\Models\Userクラス定義
- E-02: `plugins/webkul/security/src/Models/User.php` - Webkul\Security\Models\Userクラス定義
- E-03: `plugins/webkul/products/src/Models/Product.php` - Webkul\Product\Models\Productクラス定義
- E-04: `plugins/webkul/sales/src/Models/Order.php` - Webkul\Sale\Models\Orderクラス定義
- E-05: `plugins/webkul/purchases/src/Models/Order.php` - Webkul\Purchase\Models\Orderクラス定義
- E-06: `plugins/webkul/support/src/Services/EmailService.php` - Webkul\Support\Services\EmailServiceクラス定義
- E-07: `plugins/webkul/projects/src/Models/Task.php` - Webkul\Project\Models\Taskクラス定義
- E-08: `plugins/webkul/time-off/src/Models/Leave.php` - Webkul\TimeOff\Models\Leaveクラス定義
- E-09: `plugins/webkul/invoices/src/Models/Invoice.php` - Webkul\Invoice\Models\Invoiceクラス定義
- E-10: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/ValidateAction.php` - ValidateActionクラス定義
- E-11: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/ConfirmAction.php` - ConfirmActionクラス定義
- E-12: `app/Providers/Filament/AdminPanelProvider.php` - AdminPanelProviderクラス定義
- E-13: `app/Providers/Filament/CustomerPanelProvider.php` - CustomerPanelProviderクラス定義
- E-14: `tests/Unit/ExampleTest.php` - 既存単体テスト例

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-001: User.castsでemail_verified_atがdatetime型キャスト | E-01 (line 43) | ○ |
| C-02 | UT-002: User.castsでpasswordがhashed型キャスト | E-01 (line 44) | ○ |
| C-03 | UT-003: User.newFactoryがUserFactoryを返却 | E-01 (line 49-52) | ○ |
| C-04 | UT-004: Security\User.canAccessPanelが常にtrue | E-02 (line 42-45) | ○ |
| C-05 | UT-005: Security\User.getAvatarUrlAttributeがパートナーのavatar_urlを返却 | E-02 (line 47-50) | ○ |
| C-06 | UT-006: パートナーなし時getAvatarUrlAttributeがnull | E-02 (line 47-50) | ○ |
| C-07 | UT-007: handlePartnerCreationでパートナー作成 | E-02 (line 100-111) | ○ |
| C-08 | UT-008: handlePartnerUpdationで既存パートナー更新 | E-02 (line 113-129) | ○ |
| C-09 | UT-009: teams()が多対多リレーション返却 | E-02 (line 52-55) | ○ |
| C-10 | UT-010: allowedCompanies()がCompanyコレクション返却 | E-02 (line 77-80) | ○ |
| C-11 | UT-011: Product.parent()が親商品返却 | E-03 (line 108-111) | ○ |
| C-12 | UT-012: Product.variants()がバリエーション返却 | E-03 (line 153-156) | ○ |
| C-13 | UT-013: is_configurable=trueでsupplierInformationがバリエーション含む | E-03 (line 168-176) | ○ |
| C-14 | UT-014: is_configurable=falseでsupplierInformationが自身のみ | E-03 (line 168-176) | ○ |
| C-15 | UT-015: Product.tags()がTagコレクション返却 | E-03 (line 128-131) | ○ |
| C-16 | UT-016: Sale\Order.getQtyToInvoiceAttributeが合計返却 | E-04 (line 126-129) | ○ |
| C-17 | UT-017: 明細行空でgetQtyToInvoiceAttributeが0返却 | E-04 (line 126-129) | ○ |
| C-18 | UT-018: Sale\Order.updateNameでSO/{id}形式設定 | E-04 (line 242-245) | ○ |
| C-19 | UT-019: Sale\Order.boot saving時updateName呼出 | E-04 (line 230-231) | ○ |
| C-20 | UT-020: Sale\Order.boot created時name更新 | E-04 (line 234-236) | ○ |
| C-21 | UT-021: Purchase\Order.getQtyToInvoiceAttributeが合計返却 | E-05 (line 133-136) | ○ |
| C-22 | UT-022: Purchase\Order.updateNameでPO/{id}形式設定 | E-05 (line 249-252) | ○ |
| C-23 | UT-023: addMessageでメッセージ作成・返却 | E-05 (line 211-228) | ○ |
| C-24 | UT-024: addMessage未認証時の動作 | **根拠不足** | △ |
| C-25 | UT-025: EmailService.sendが成功時true返却・ログ記録 | E-06 (line 12-35) | ○ |
| C-26 | UT-026: EmailService.send失敗時例外・ログ記録 | E-06 (line 30-34) | ○ |
| C-27 | UT-027: 添付ファイル付きメール送信 | E-06 (line 24-25) | ○ |
| C-28 | UT-028: logEmailでEmailLog作成 | E-06 (line 37-47) | ○ |
| C-29 | UT-029: Task.subTasks()がサブタスク返却 | E-07 (line 118-121) | ○ |
| C-30 | UT-030: Task.boot updated時timesheets更新 | E-07 (line 180-186) | ○ |
| C-31 | UT-031: Task.bootedでUserPermissionScope適用 | E-07 (line 168-171) | ○ |
| C-32 | UT-032: Leave.user()がUser返却 | E-08 (line 87-90) | ○ |
| C-33 | UT-033: Leave.firstApprover()がEmployee返却 | E-08 (line 127-130) | ○ |
| C-34 | UT-034: Leave.secondApprover()がEmployee返却 | E-08 (line 132-135) | ○ |
| C-35 | UT-035: Invoice.paymentTermLine()が支払期限行返却 | E-09 (line 10-14) | ○ |
| C-36 | UT-036: 支払期限行なし時null返却 | E-09 (line 10-14) | ○ |
| C-37 | UT-037: ValidateAction.hasMoveErrorsがエラーなしでfalse | E-10 (line 82-93) | ○ |
| C-38 | UT-038: hasMoveLineErrorsがlines.isEmpty時true | E-10 (line 100-110) | ○ |
| C-39 | UT-039: LOTトラッキングでlot_id=null時true | E-10 (line 132-142) | ○ |
| C-40 | UT-040: SERIALトラッキングでqty!=1時true | E-10 (line 146-155) | ○ |
| C-41 | UT-041: SERIALトラッキングでlot_id重複時true | E-10 (line 157-167) | ○ |
| C-42 | UT-042: パッケージ部分移動時true | E-10 (line 112-129) | ○ |
| C-43 | UT-043: ConfirmAction.validateMoveがpartner_id=null時false | E-11 (line 43-53) | ○ |
| C-44 | UT-044: validateMoveがlines空時false | E-11 (line 55-66) | ○ |
| C-45 | UT-045: validateMove成功時true | E-11 (line 43-68) | ○ |
| C-46 | UT-046: AdminPanelProvider.panelが設定済みPanel返却 | E-12 (line 27-129) | ○ |
| C-47 | UT-047: 認証ミドルウェア設定確認 | E-12 (line 126-128) | ○ |
| C-48 | UT-048: CustomerPanelProvider.panelが設定済みPanel返却 | E-13 (line 21-55) | ○ |
| C-49 | UT-049: customerガード設定確認 | E-13 (line 54) | ○ |
| C-50 | UT-050: Product.newFactoryがProductFactory返却 | E-03 (line 178-181) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-024**: addMessageメソッドの未認証時の動作について、filament()->auth()->user()がnullを返す場合の挙動を実際にテストで確認する必要がある
  - 候補：統合テスト / 認証モックを使用した単体テスト
- **バリデーションルール**：各Modelのfillableフィールドに対するバリデーションルールの定義が確認できなかった
  - 候補：FormRequest / 各リソースクラスのバリデーション定義
- **既存テストとの整合性**：tests/Unit/ExampleTest.phpは基本的なテストのみで、本格的な単体テストは存在しない
  - 候補：テストカバレッジレポート / CI設定ファイル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UT-001〜003, UT-050 - 基本的なモデル機能のテスト
- **1（中リスク）**: UT-005〜010, UT-011〜015, UT-029〜034 - リレーションやアクセサのテスト
- **2（高リスク）**: UT-024, UT-025〜028, UT-037〜045 - 例外処理、バリデーション、ビジネスロジックのテスト

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテスト観点（正常系/異常系/境界値）が適切か確認
- [ ] モック/スタブが必要なテストケース（特にEmailService、認証関連）の前提条件を確認
- [ ] 高優先度テストケースの期待結果が業務要件と整合しているか確認
- [ ] ValidateActionのバリデーションロジックがInventoryモジュールの要件と一致しているか確認
- [ ] Eloquentイベント（boot/saved/created/updated）のテストが副作用を考慮しているか確認
