---
generated_at: 2025-12-27 16:40:00
metrics:
  claims_total: 100
  claims_with_evidence: 92
  claims_without_evidence: 8
confidence_derived: 0.92
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された受入テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：92 / 100、根拠なし：8
- 優先レビュー（高）
  1. **UAT-082 リマインダー機能**：mail_reminder機能の実装詳細が不明
  2. **UAT-096 データ一括インポート**：Importable機能の有効性が不明
  3. **UAT-097/098 パフォーマンス要件**：具体的な性能基準がコードから特定困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/security/src/Filament/Resources/UserResource.php` - ユーザー管理機能
- E-02: `plugins/webkul/security/src/Filament/Resources/RoleResource.php` - ロール管理機能
- E-03: `plugins/webkul/security/src/Filament/Resources/CompanyResource.php` - 会社管理機能
- E-04: `plugins/webkul/security/src/Filament/Resources/TeamResource.php` - チーム管理機能
- E-05: `plugins/webkul/security/src/Enums/PermissionType.php` - 権限タイプ列挙
- E-06: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php` - 販売見積機能
- E-07: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource.php` - 販売受注機能
- E-08: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/CustomerResource.php` - 顧客管理機能
- E-09: `plugins/webkul/sales/src/Enums/OrderState.php` - 販売ステータス列挙
- E-10: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/QuotationResource.php` - 購買見積依頼機能
- E-11: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php` - 発注機能
- E-12: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/VendorResource.php` - 仕入先管理機能
- E-13: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource.php` - 購買協定機能
- E-14: `plugins/webkul/purchases/src/Enums/OrderState.php` - 購買ステータス列挙
- E-15: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/ConfirmAction.php` - 確定アクション
- E-16: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/SendEmailAction.php` - メール送信アクション
- E-17: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/CancelAction.php` - キャンセルアクション
- E-18: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/LockAction.php` - ロックアクション
- E-19: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/UnlockAction.php` - アンロックアクション
- E-20: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/PrintRFQAction.php` - PDF出力アクション
- E-21: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/SendPOEmailAction.php` - 発注書メール送信
- E-22: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource.php` - 入庫機能
- E-23: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/DeliveryResource.php` - 出庫機能
- E-24: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/InternalTransferResource.php` - 内部移動機能
- E-25: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ScrapResource.php` - スクラップ機能
- E-26: `plugins/webkul/inventories/src/Enums/OperationState.php` - 在庫操作ステータス
- E-27: `plugins/webkul/inventories/src/Filament/Clusters/Settings/Resources/WarehouseResource.php` - 倉庫管理
- E-28: `plugins/webkul/inventories/src/Filament/Clusters/Settings/Resources/LocationResource.php` - ロケーション管理
- E-29: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/InvoiceResource.php` - 請求書機能
- E-30: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/BillResource.php` - 仕入先請求書機能
- E-31: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/CreditNotesResource.php` - クレジットノート機能
- E-32: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/PaymentsResource.php` - 入金機能
- E-33: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/TaxResource.php` - 税設定
- E-34: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/PaymentTermResource.php` - 支払条件設定
- E-35: `plugins/webkul/employees/src/Filament/Resources/EmployeeResource.php` - 従業員管理機能
- E-36: `plugins/webkul/employees/src/Filament/Resources/EmployeeResource/Pages/ManageSkill.php` - スキル管理
- E-37: `plugins/webkul/employees/src/Filament/Resources/EmployeeResource/Pages/ManageResume.php` - 履歴書管理
- E-38: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyTimeOffResource.php` - 自分の休暇管理
- E-39: `plugins/webkul/time-off/src/Filament/Clusters/Management/Resources/TimeOffResource.php` - 休暇管理（マネージャー）
- E-40: `plugins/webkul/time-off/src/Filament/Clusters/Management/Resources/AllocationResource.php` - 休暇割当
- E-41: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/JobPositionResource.php` - 求人管理
- E-42: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/ApplicantResource.php` - 応募者管理
- E-43: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/StageResource.php` - 採用ステージ
- E-44: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/RefuseReasonResource.php` - 不採用理由
- E-45: `plugins/webkul/projects/src/Filament/Resources/ProjectResource.php` - プロジェクト管理
- E-46: `plugins/webkul/projects/src/Filament/Resources/TaskResource.php` - タスク管理
- E-47: `plugins/webkul/projects/src/Filament/Clusters/Configurations/Resources/TaskStageResource.php` - タスクステージ
- E-48: `plugins/webkul/timesheets/src/Filament/Resources/TimesheetResource.php` - タイムシート機能
- E-49: `plugins/webkul/products/src/Filament/Resources/ProductResource.php` - 製品管理
- E-50: `plugins/webkul/products/src/Filament/Resources/CategoryResource.php` - 製品カテゴリ管理
- E-51: `plugins/webkul/products/src/Filament/Resources/AttributeResource.php` - 製品属性管理
- E-52: `plugins/webkul/products/src/Filament/Resources/PackagingResource.php` - パッケージング管理
- E-53: `plugins/webkul/contacts/src/Filament/Resources/PartnerResource.php` - 連絡先管理
- E-54: `plugins/webkul/contacts/src/Filament/Resources/AddressResource.php` - 住所管理
- E-55: `plugins/webkul/blogs/src/Filament/Admin/Resources/PostResource.php` - ブログ投稿管理
- E-56: `plugins/webkul/blogs/src/Filament/Admin/Clusters/Configurations/Resources/CategoryResource.php` - ブログカテゴリ管理
- E-57: `plugins/webkul/fields/src/Filament/Traits/HasCustomFields.php` - カスタムフィールドトレイト
- E-58: `plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource.php` - プラグイン管理
- E-59: `plugins/webkul/table-views/src/Policies/TableViewPolicy.php` - テーブルビュー機能
- E-60: `plugins/webkul/full-calendar/` - カレンダー機能
- E-61: `plugins/webkul/chatter/` - チャッター（アクティビティ）機能
- E-62: `plugins/webkul/purchases/src/Livewire/RespondQuotation.php` - 見積回答Livewire
- E-63: `README.md` - プロジェクト概要・機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001 管理者ログイン成功 | E-01, README | ○ |
| C-02 | UAT-002 不正パスワードでのログイン拒否 | Laravel Auth | ○ |
| C-03 | UAT-003 新規ユーザー作成 | E-01 UserResource form定義 | ○ |
| C-04 | UAT-004 ユーザーへのロール割り当て | E-01, E-02 roles relationship | ○ |
| C-05 | UAT-005 ユーザーのマルチ会社設定 | E-01 allowedCompanies, defaultCompany | ○ |
| C-06 | UAT-006 ユーザー削除 | E-01 DeleteAction, canDeleteUser | ○ |
| C-07 | UAT-007 見積書作成 | E-06 QuotationResource | ○ |
| C-08 | UAT-008 見積書から受注への変換 | E-07, E-09 OrderState::SALE | ○ |
| C-09 | UAT-009 受注からの請求書生成 | E-07 ManageInvoicesページ | ○ |
| C-10 | UAT-010 受注からの配送指示生成 | E-07 ManageDeliveriesページ | ○ |
| C-11 | UAT-011 見積依頼作成 | E-10 QuotationResource | ○ |
| C-12 | UAT-012 見積依頼のメール送信 | E-16 SendEmailAction | ○ |
| C-13 | UAT-013 発注書への変換 | E-15 ConfirmAction, E-14 OrderState | ○ |
| C-14 | UAT-014 購買協定の作成 | E-13 PurchaseAgreementResource | ○ |
| C-15 | UAT-015 仕入先価格マスタ登録 | VendorPriceResource | ○ |
| C-16 | UAT-016 入庫処理 | E-22 ReceiptResource | ○ |
| C-17 | UAT-017 出庫処理 | E-23 DeliveryResource | ○ |
| C-18 | UAT-018 内部移動 | E-24 InternalTransferResource | ○ |
| C-19 | UAT-019 在庫スクラップ処理 | E-25 ScrapResource | ○ |
| C-20 | UAT-020 在庫数量調整 | ProductQuantityPolicy | ○ |
| C-21 | UAT-021 顧客請求書作成 | E-29 InvoiceResource | ○ |
| C-22 | UAT-022 請求書の転記 | E-29 会計連携 | ○ |
| C-23 | UAT-023 仕入先請求書登録 | E-30 BillResource | ○ |
| C-24 | UAT-024 クレジットノート発行 | E-31 CreditNotesResource | ○ |
| C-25 | UAT-025 入金消込 | E-32 PaymentsResource | ○ |
| C-26 | UAT-026 従業員登録 | E-35 EmployeeResource | ○ |
| C-27 | UAT-027 従業員スキル登録 | E-36 ManageSkill | ○ |
| C-28 | UAT-028 従業員履歴書管理 | E-37 ManageResume | ○ |
| C-29 | UAT-029 休暇申請 | E-38 MyTimeOffResource | ○ |
| C-30 | UAT-030 休暇承認 | E-39 TimeOffResource | ○ |
| C-31 | UAT-031 休暇割当 | E-40 AllocationResource | ○ |
| C-32 | UAT-032 求人作成 | E-41 JobPositionResource | ○ |
| C-33 | UAT-033 応募者登録 | E-42 ApplicantResource | ○ |
| C-34 | UAT-034 採用ステージ移動 | E-43 StageResource | ○ |
| C-35 | UAT-035 内定・不採用処理 | E-44 RefuseReasonResource | ○ |
| C-36 | UAT-036 プロジェクト作成 | E-45 ProjectResource | ○ |
| C-37 | UAT-037 タスク作成 | E-46 TaskResource | ○ |
| C-38 | UAT-038 タスクステージ変更 | E-47 TaskStageResource | ○ |
| C-39 | UAT-039 タイムシート入力 | E-48 TimesheetResource | ○ |
| C-40 | UAT-040 製品登録 | E-49 ProductResource | ○ |
| C-41 | UAT-041 製品バリエーション作成 | E-49 ManageVariants | ○ |
| C-42 | UAT-042 製品カテゴリ管理 | E-50 CategoryResource | ○ |
| C-43 | UAT-043 取引先登録 | E-53 PartnerResource | ○ |
| C-44 | UAT-044 取引先住所追加 | E-54 AddressResource | ○ |
| C-45 | UAT-045 ブログ記事作成 | E-55 PostResource | ○ |
| C-46 | UAT-046 ブログカテゴリ管理 | E-56 CategoryResource | ○ |
| C-47 | UAT-047 ロール作成 | E-02 RoleResource | ○ |
| C-48 | UAT-048 リソース権限タイプ確認 | E-05 PermissionType Enum | ○ |
| C-49 | UAT-049 会社情報登録 | E-03 CompanyResource | ○ |
| C-50 | UAT-050 会社切替 | E-01 allowedCompanies | ○ |
| C-51 | UAT-051 チーム作成 | E-04 TeamResource | ○ |
| C-52 | UAT-052 カスタムフィールド追加 | E-57 HasCustomFields | ○ |
| C-53 | UAT-053 プラグインインストール | E-58, E-63 README | ○ |
| C-54 | UAT-054 グローバル検索 | getGloballySearchableAttributes定義 | ○ |
| C-55 | UAT-055 高度なフィルタリング | QueryBuilder Filter定義 | ○ |
| C-56 | UAT-056 一覧ソート | sortable定義 | ○ |
| C-57 | UAT-057 データエクスポート | Filament Export機能 | ○ |
| C-58 | UAT-058 一括削除 | DeleteBulkAction定義 | ○ |
| C-59 | UAT-059 通知機能 | Notification::make | ○ |
| C-60 | UAT-060 監査ログ | E-61 Chatterプラグイン | ○ |
| C-61 | UAT-061 税設定 | E-33 TaxResource | ○ |
| C-62 | UAT-062 支払条件設定 | E-34 PaymentTermResource | ○ |
| C-63 | UAT-063 通貨設定 | Currency Model | ○ |
| C-64 | UAT-064 倉庫登録 | E-27 WarehouseResource | ○ |
| C-65 | UAT-065 ロケーション設定 | E-28 LocationResource | ○ |
| C-66 | UAT-066 従業員別休暇レポート | ByEmployeeResource | ○ |
| C-67 | UAT-067 休暇カレンダー | E-60 full-calendar | ○ |
| C-68 | UAT-068 発注確認（仕入先） | E-62 RespondQuotation | ○ |
| C-69 | UAT-069 テーブルビュー保存 | E-59 table-views | ○ |
| C-70 | UAT-070 モバイル対応 | TailwindCSS | ○ |
| C-71 | UAT-071 発注-入庫連携 | Package::isPluginInstalled | ○ |
| C-72 | UAT-072 受注-出庫連携 | Package::isPluginInstalled | ○ |
| C-73 | UAT-073 在庫移動と数量連動 | StockMove連携 | ○ |
| C-74 | UAT-074 発注ステータス遷移 | E-14 OrderState Enum | ○ |
| C-75 | UAT-075 販売ステータス遷移 | E-09 OrderState Enum | ○ |
| C-76 | UAT-076 発注キャンセル | E-17 CancelAction | ○ |
| C-77 | UAT-077 入庫キャンセル | E-26 OperationState | ○ |
| C-78 | UAT-078 発注書ロック | E-18 LockAction | ○ |
| C-79 | UAT-079 発注書アンロック | E-19 UnlockAction | ○ |
| C-80 | UAT-080 発注書PDF出力 | E-20 PrintRFQAction | ○ |
| C-81 | UAT-081 発注書メール送信 | E-21 SendPOEmailAction | ○ |
| C-82 | UAT-082 リマインダー機能 | **根拠なし** | △ |
| C-83 | UAT-083 アクティビティ登録 | ActivityPlanResource | ○ |
| C-84 | UAT-084 アクティビティ完了 | ActivityTypeResource | ○ |
| C-85 | UAT-085 単位管理 | UoM設定 | ○ |
| C-86 | UAT-086 パッケージング設定 | E-52 PackagingResource | ○ |
| C-87 | UAT-087 明細行割引 | discount フィールド定義 | ○ |
| C-88 | UAT-088 税額自動計算 | TaxFacade::collect | ○ |
| C-89 | UAT-089 仕入先価格自動反映 | supplierInformation | ○ |
| C-90 | UAT-090 必須項目チェック | required()バリデーション | ○ |
| C-91 | UAT-091 メール形式チェック | email()バリデーション | ○ |
| C-92 | UAT-092 一意性チェック | unique()バリデーション | ○ |
| C-93 | UAT-093 数値範囲チェック | minValue/maxValue | ○ |
| C-94 | UAT-094 データ復元 | RestoreAction | ○ |
| C-95 | UAT-095 完全削除 | ForceDeleteBulkAction | ○ |
| C-96 | UAT-096 データ一括インポート | **根拠なし** | △ |
| C-97 | UAT-097 大量データ表示 | **根拠なし** | △ |
| C-98 | UAT-098 検索レスポンス | **根拠なし** | △ |
| C-99 | UAT-099 セッションタイムアウト | **根拠なし** | △ |
| C-100 | UAT-100 エラーハンドリング | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **リマインダー機能（UAT-082）**
  - mail_reminder_confirmed フィールドは存在するが、リマインダー送信の実装詳細が不明
  - 候補：ScheduledCommand / Queue / Event Listener を調査

- **インポート機能（UAT-096）**
  - Filament Importable機能の有効性がコードから確認できず
  - 候補：filament-excel / laravel-excel パッケージの導入状況を確認

- **パフォーマンス要件（UAT-097/098）**
  - 具体的な性能基準やベンチマークがコードから特定困難
  - 候補：負荷テストの実施、レスポンスタイム要件の明文化

- **セッション管理（UAT-099）**
  - Laravelデフォルト設定に依存、明示的な設定値が不明
  - 候補：config/session.php の確認

- **エラーハンドリング（UAT-100）**
  - Laravel標準のエラーハンドリングに依存
  - 候補：app/Exceptions/Handler.php の確認

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**: UAT-001〜UAT-095 - コードから直接根拠が確認できる
- **リスク1（中リスク）**: UAT-082, UAT-096〜UAT-100 - 機能の存在は推測されるが、実装詳細の確認が必要
- **リスク2（高リスク）**: なし

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの操作手順が実際の画面遷移と一致するか確認
- [ ] 期待結果が業務要件と整合しているか確認
- [ ] 優先度の設定が妥当か確認（高優先度のテストケースが重要機能をカバーしているか）
- [ ] UAT-082 リマインダー機能の実装有無を確認
- [ ] UAT-096 インポート機能の利用可否を確認
- [ ] パフォーマンス要件の具体的な数値を定義
- [ ] セッションタイムアウト設定を環境設定から確認
- [ ] エラーページのカスタマイズ状況を確認
- [ ] 権限別シナリオテストが網羅されているか確認（管理者/一般ユーザー/マネージャー）
- [ ] マルチカンパニー機能のテストケースが十分か確認
